;;----------------------------------------------------------------------------
;; Name: TEST_INTEGER
;;
;; Purpose: To test the numerical range of a given value, and its
;;     being an integer. 
;;
;; Calling Sequence:
;;     test_integer, keyword, value, min, max
;;
;; Input:
;;     keyword - the PDS keyword name to be tested for
;;     value - a scalar string to be tested for being an integer
;;     min - the minimum the "value" can be
;;     max - the maximum the "value" can be; this is optional input 
;; 
;; Output:
;;     This procedure outputs errors if the value is found to contain 
;;     non-integer chars, and if it falls out of the range supplied by user
;;
;; External routines: Clean
;;
;; Modification history:
;;     Written by Puneet Khetarpal, 30 June 2005
;;
;;-----------------------------------------------------------------------------

; precondition: the value is intended to be an integer, and keyword is
;     the keyword to be tested for; the minimum and maximum are also ints 
; postcondition: the value is tested for integer within max and min
pro test_integer, keyword, value, min, max
    ; error check
    on_error, 1

    ; first check for any alphabetical characters
    if (stregex(value, '[^-\+0-9]', /boolean)) then begin
        message, "Error: "+keyword+" value must be of type integer - " + value
    endif
    ; check whether the value is within the min and max range
    if (long64(value) lt min) then begin   ; if < min, then issue error
        message, "Error: "+keyword+" value must be >= "+ $
            clean(string(min), /space) + " (" + value + ")"
    endif else if (n_params() eq 4 && long64(value) gt max) then begin
        ;; if maximum value supplied and value > maximum, then issue error
        message, "Error: "+keyword+" value must be <= "+ $
            clean(string(max), /space) + " (" + value + ")"
    endif
end
