;;-----------------------------------------------------------------------------
;; Name: REMOVE
;;
;; Purpose: To remove all characters from the given string as specified by
;;          the parameter array
;;
;; Calling Sequence: 
;;    result = remove (text, param)
;;
;; Input:
;;    text - string of characters to be cleaned
;;    param - a string array of characters to be removed from text
;;
;; Output:
;;    result - string characters removed of all unwanted characters
;;
;; Optional inputs: none
;;
;; Example:
;;    To remove all unwanted characters as defined by param:
;;       IDL> param = ['"',',',')','(']
;;       IDL> result = REMOVE ("this, here (contained)",param)
;;       IDL> print, result
;;            this here contained
;;
;; External routines: none
;;
;; Modification history:
;;     Written by Puneet Khetarpal, 15 January 2003
;;     For a complete list of modifications, see changelog.txt file.
;;
;;-----------------------------------------------------------------------------

function remove, text, param
    ; proceed if length of the input is not zero
    if (strlen(text) ne 0) then begin
        ; initialize variables:
        btext = byte(text)                  ; convert input string to bytes
        bparam = byte(param)                ; convert param to remove to bytes
        clength = n_elements(bparam) - 1    ; obtain length of param arr - 1

        ; process string and remove unwanted chars:
        for c = 0, clength do begin         ; loop through each param elem 
            pos = where (btext ne bparam[c], match) ; check pos for unmatch par
            if (match ne 0) then begin      ; if match found
                btext = btext[pos]          ; store wanted string elements
            endif else begin                ; else
                btext = 0B                  ; store null array
                break                       ; break out of for loop
            endelse
        endfor

        text = string(btext)                ; convert from byte to string
    endif
    return, text
end
