;;-----------------------------------------------------------------------------
;; Name: CLEAN
;;     
;; Purpose: To remove all unprintable characters from the given string
;; 
;; Calling Sequence: 
;;    result = clean (text, [/SPACE])
;; 
;; Input:
;;    text - scalar string of characters to be cleaned
;;
;; Output:
;;    result - scalar string removed of all unprintable characters
;;
;; Optional inputs:
;;    SPACE - removes all unprintable characters including all space chars.
;;
;; Examples:
;;    To remove all unprintable chars except space
;;       IDL> word = clean ('the [tab]file is [lf][cr]')
;;       IDL> print, word
;;            the file is
;;    To remove all unprintable chars including space
;;       IDL> word = clean ('the [tab]file is [lf][cr]', /SPACE)
;;       IDL> print, word
;;            thefileis
;;
;; External routines: none
;;
;; Modification history:
;;    Written by Puneet Khetarpal, 15 January 2003
;;    For a complete list of modifications, see changelog.txt file.
;;
;;-----------------------------------------------------------------------------

function clean, text, SPACE = space
    ; error protection:
    on_error, 2

    ; check for SPACE keyword specification:
    space = keyword_set(space)

    ; convert input to string if not
    if (size(text, /type) ne 7) then text = string(text)
 
    ; process the text only if string is not NULL:
    if (strlen(text) ne 0) then begin
        btext = byte(text)           ; convert string into bytes array

        ; find the wanted chars ommitting or including the space char:
        pos = (space) ? where (btext gt 32B and btext lt 127B, match) : $
                        where (btext ge 32B and btext lt 127B, match)

        ; assign processed value of text:
        text = (match ne 0) ? string(btext[pos]) : ""
    endif
    return, text   
end
