;;-----------------------------------------------------------------------------
;; Name: BREAK_STRING
;;
;; Purpose: To separate a scalar string into parts using the ',' delimiter;
;;     to be used for separating a sequence of values for PDS keywords
;;
;; Calling Sequence: 
;;     array = break_string (name, local, values)
;; 
;; Input:
;;     name - the name of the keyword, whose value is to be separated
;;     local - the variable containing the scalar string to be separated
;;     values - the number of separated values one should obtain after 
;;         separation
;; Output:
;;     array - a string array containing the elements of the separated
;;         string
;;
;; External routines: Clean, Remove
;;
;; Modification history:
;;     Written by Puneet Khetarpal, 30 June 2005
;;
;;-----------------------------------------------------------------------------

; precondition: the string to be separated, and the number of values
;     to be extracted from it 
; postcondition: the string is separated into its parts with ',' delimiter
function break_string, name, local, values
    ; error check
    on_error, 1

    ; save string
    str = local
    ; clean string of '"', '(', or ')'
    str = clean(str, /space)
    str = remove(str, ['"','(',')'])
    ; extract the values
    vals = strsplit(str, ',', /extract)
    ; check if the components matched the number of values
    if (n_elements(vals) ne values) then begin
        message, "Error: "+name+" must have "+clean(string(values), /space)+$
            " components - " + local
    endif

    return, vals
end
