FUNCTION ToStr, value, format, size, UTC=utc

    CATCH, error
    IF (error NE 0) THEN BEGIN
    	MESSAGE, !ERROR_STATE.MSG, /CONTINUE
    	RETURN, ''
    ENDIF

    IF (N_PARAMS() LT 2) THEN $
    	MESSAGE, 'Missing parameter.', /NONAME

    IF (N_ELEMENTS(size) EQ 0) THEN size = 0

    utc = KEYWORD_SET(utc)

    CASE (format) OF
    'FILL' : BEGIN
    	IF (size GT 0) THEN $
    	    str = STRING(REPLICATE(BYTE(value), size)) $
    	ELSE $
    	    str = ''
    END
    'TIME' : BEGIN
	ms  = (value*1000D) MOD 1000D
	format = '(C(CYI4.4,"-",CMOI2.2,"-",CDI2.2,"' + (utc ? 'T' : ' ') + $
		 '",CHI2.2,":",CMI2.2,":",CSI2.2))'
    	str = STRING(value/86400D + JULDAY(1, 1, 1970, 0), FORMAT=format) + $
    	      STRING(ms, FORMAT='(".",I3.3' + (utc ? ',"Z")' : ')'))
    END
    'TMIN' : BEGIN
    	format = '(C(CYI2.2,"-",CMOI2.2,"-",CDI2.2,"' + (utc ? 'T' : ' ') + $
    		 '",CHI2.2,":",CMI2.2,":",CSI2.2' + (utc ? ',"Z"' : '') + '))'
    	str = STRING(value/86400D + JULDAY(1, 1, 1970, 0), FORMAT=format)
    END
    'TIM2' : BEGIN
    	format = '(C(CYI2.2,CMOI2.2,CDI2.2,"' + (utc ? 'T' : '.') + $
    		 '",CHI2.2,CMI2.2,CSI2.2' + (utc ? ',"Z"' : '') + '))'
    	str = STRING(value/86400D + JULDAY(1, 1, 1970, 0), FORMAT=format)
    END
    'THMS' : BEGIN
    	format = '(C(CHI2.2,":",CMI2.2,":",CSI2.2' + (utc ? ',"Z"' : '') + '))'
    	str = STRING(value/86400D + JULDAY(1, 1, 1970, 0), FORMAT=format)
    END
    'JULIAN' : BEGIN
    	format = '(C(CYI4.4,"-",CMOI2.2,"-",CDI2.2,"' + (utc ? 'T' : ' ') + $
    		 '",CHI2.2,":",CMI2.2,":",CSI2.2' + (utc ? ',"Z"' : '') + '))'
    	str = STRING(value, FORMAT=format)
    END
    'EPOCH' : BEGIN
    	format = '(C(CYI4.4,"-",CMOI2.2,"-",CDI2.2,"' + (utc ? 'T' : ' ') + $
    		 '",CHI2.2,":",CMI2.2,":",CSI2.2' + (utc ? ',"Z"' : '') + '))'
    	CDF_EPOCH, epoch, 1970, 1, 1, /COMPUTE
    	str = STRING((value - epoch)/86400000D + JULDAY(1, 1, 1970, 0), FORMAT=format)
    END
    ELSE : BEGIN
    	str = STRING(value, FORMAT='(' + format + ')')
    END
    ENDCASE

    IF (size GT 0) THEN $
    	str = STRMID(str + STRING(REPLICATE(32B, size)), 0, size)

    RETURN, str

END ; ToStr