; $Id: escape.pro,v 1.4 2005/09/26 11:42:14 Harald Exp $

FUNCTION Escape, expression, search, esc, UNDO=undo

    CATCH, error
    IF (error NE 0) THEN BEGIN
    	MESSAGE, !ERROR_STATE.MSG, /CONTINUE
    	RETURN, expression
    ENDIF

    IF (N_PARAMS() LT 2) THEN $
    	MESSAGE, 'Usage: result = Escape(str, char [, esc])', /NONAME
    IF (N_ELEMENTS(esc) EQ 0) THEN $
    	esc = '\'
    IF (search EQ '') THEN $
    	MESSAGE, 'Missing characters to escape.', /NONAME

    IF (KEYWORD_SET(undo)) THEN BEGIN
    	regex = '[' + esc + '][' + search + ']'
    	fmtex = '(A,:,""))'
    ENDIF ELSE BEGIN
    	regex = '[' + search + ']'
    	fmtex = '(A,:,"' + esc + '"))'
    ENDELSE

    result = expression

    FOR i = 0, N_ELEMENTS(result) - 1 DO BEGIN
    	pos = STRSPLIT(result[i], regex, /REGEX, LEN=len, /PRESERVE)
	cnt = N_ELEMENTS(pos)
	IF (cnt GT 0) THEN BEGIN
	    IF (cnt GT 1) THEN BEGIN
	    	pos[1:*] = pos[1:*] - 1
	    	len[1:*] = len[1:*] + 1
	    ENDIF
	    format = '(' + STRTRIM(cnt,2) + fmtex
	    result[i] = STRING(STRMID(result[i], pos, len), FORMAT=format)
	ENDIF
    ENDFOR

    RETURN, result

END ; Escape