FUNCTION find_vicar_tag, shdr, tag, DEL=DEL

	ttag = tag + '='

	for i=0, n_elements(shdr)-1 do begin
		if strmid(shdr[i], 0, strlen(tag)+1) eq ttag then begin
			ret = strmid(shdr[i], strlen(tag)+1)
			if keyword_set(DEL) then begin
				shdr[i] = ''
			endif
			return, ret
		endif
	endfor
	return, ''
END

FUNCTION p_strip_quotes, v
	v = strtrim(v, 2)

	if strmid(v, 0, 1) eq "'" then v = strmid(v, 1, strlen(v)-2)
	if strmid(v, 0, 1) eq '"' then v = strmid(v, 1, strlen(v)-2)

	return, v
END


FUNCTION parse_vicar_low, lhdr
	lhdr = string(lhdr)
	len = strlen(lhdr)
	shdr = ['']
	p=0
	pdone = 0
	while p lt len AND NOT pdone do begin
		e = strpos(lhdr, '=', p)

		s = ''
		cc = strmid(lhdr, e+1, 1)
		if cc eq "'" then begin		; text string
			e = strpos(lhdr, "'", e+2)
			s = strtrim(strmid(lhdr, p, e-p+1), 2)
			p = e+1
		endif else if cc eq "(" then begin	; vector
			e = strpos(lhdr, ")", e+2)
			s = strtrim(strmid(lhdr, p, e-p+1), 2)
			p = e+1
		endif else begin	; normal
			e = strpos(lhdr, ' ', e)
			s = strtrim(strmid(lhdr, p, e-p+1), 2)
			p=e+1
		endelse

		if strtrim(s,2) eq '' then begin
			pdone = 1
		endif else shdr = [shdr, s]
	endwhile

	return, shdr

END

PRO p_vicar_rhead, file, h, OK=OK, VERBOSE=VERBOSE, RETAIN_VICAR_LABELS=RETAIN_VICAR_LABELS

	if keyword_set(VERBOSE) then print, 'Reading VICAR file header: ' + file

	; create empty header
	h = p_newhead();

	on_ioerror, handle_error

	openr, unit, file, /GET_LUN

	; verufy vicar file header
	s = bytarr(20)
	readu, unit, s

	if strmid(string(s), 0, 8) ne 'LBLSIZE=' then begin
		close, unit
		free_lun, unit
		if keyword_set(VERBOSE) then print, 'ERROR: Not a VICAR File'
		OK=0
		return;
	endif

	lblsize = long(strmid(s, 8))

	; repoint file pointer to the beginning of the file
	point_lun, unit, 0

	; read header
	lhdr = bytarr(lblsize)
	readu, unit, lhdr

	; convert to string
	lhdr = string(lhdr)


	shdr = parse_vicar_low(lhdr)

	; check for tail header
	if find_vicar_tag(shdr, 'EOL') eq '1' then begin
		NLB = long(find_vicar_tag(shdr, 'NLB'))
		N2 = long(find_vicar_tag(shdr, 'N2'))
		N3 = long(find_vicar_tag(shdr, 'N3'))
	 	recsize = long(find_vicar_tag(shdr, 'RECSIZE'))
	 	img_size = (nlb + n2 * n3) * recsize
		skip_lun, unit, img_size

		lhdr2 = bytarr(20)
		readu, unit, lhdr2
		lhdr2 = string(lhdr2)

		p = strpos(lhdr2, 'LBLSIZE=')
		if p ge 0 then begin
			ls = long(strmid(lhdr2, p+8))

			tmp = bytarr(ls - 20)
			readu, unit, tmp
			tmp = string(tmp)

			lhdr2 = lhdr2 + tmp

			shdr2 = parse_vicar_low(lhdr2)
			x=find_vicar_tag(shdr2, 'LBLSIZE', /DEL)

			shdr = [shdr, shdr2]
		endif

	endif



	p_setvalue, h, 'RECORD_BYTES', 1
	p_setvalue, h, 'LABEL_RECORDS', lblsize

	; now manually build header
	tags = h.tags
	values = h.values

	tags = [tags, '^IMAGE'] & values = [values, strtrim(long(lblsize)+1, 2)]

	; define image object block
	tags = [tags, 'O>'] & values = [values, 'IMAGE']

	tags = [tags, 'INTERCHANGE_FORMAT'] & values = [values, 'BINARY']

	tags = [tags, 'LINE_SAMPLES'] & values = [values, find_vicar_tag(shdr, 'N1', /DEL)]
	tags = [tags, 'LINES'] & values = [values, find_vicar_tag(shdr, 'N2', /DEL)]
	tags = [tags, 'BANDS'] & values = [values, find_vicar_tag(shdr, 'N3', /DEL)]
	tags = [tags, 'FIRST_LINE'] & values = [values, find_vicar_tag(shdr, 'FIRST_LINE', /DEL)]
	tags = [tags, 'FIRST_LINE_SAMPLE'] & values = [values, find_vicar_tag(shdr, 'FIRST_LINE_SAMPLE', /DEL)]

	; determine format
	fmt = find_vicar_tag(shdr, 'FORMAT', /DEL)
	if fmt eq "'BYTE'" then begin
		st = 'UNSIGNED_INTEGER'
		bd = 8
	endif
	if fmt eq "'HALF'" then begin
		st = 'UNSIGNED_INTEGER'
		bd = 16
	endif
	if fmt eq "'FULL'" then begin
		st = 'UNSIGNED_INTEGER'
		bd = 32
	endif
	if fmt eq "'REAL'" then begin
		st = 'REAL'
		bd = 32
	endif
	if fmt eq "'DOUB'" then begin
		st = 'REAL'
		bd = 64
	endif
	if st eq 'UNSIGNED_INTEGER' then begin
		if find_vicar_tag(shdr, 'INTFMT', /DEL) eq "'HIGH'" then begin
			st = 'MSB_' + st
		endif else begin
			st = 'LSB_' + st
		endelse
	endif else begin
	 	if find_vicar_tag(shdr, 'REALFMT', /DEL) eq "'IEEE'" then begin
			st = 'IEEE_' + st
		endif else begin
			st = 'PC_' + st
		endelse
	endelse
	tags = [tags, 'SAMPLE_TYPE'] & values = [values, strtrim(st, 2)]
	tags = [tags, 'SAMPLE_BITS'] & values = [values, strtrim(bd, 2)]

	; terminate image object block
	tags = [tags, 'O<'] & values = [values, 'IMAGE']


	if not keyword_set(RETAIN_VICAR_LABELS) then begin
		; now get rid fo a number of VICAR system tags
		tmp=find_vicar_tag(shdr, 'LBLSIZE', /DEL)
		tmp=find_vicar_tag(shdr, 'BUFSIZ', /DEL)
		tmp=find_vicar_tag(shdr, 'RECSIZE', /DEL)
		tmp=find_vicar_tag(shdr, 'EOL', /DEL)
		tmp=find_vicar_tag(shdr, 'FORMAT', /DEL)
		tmp=find_vicar_tag(shdr, 'BLTYPE', /DEL)
		tmp=find_vicar_tag(shdr, 'BREALFMT', /DEL)
		tmp=find_vicar_tag(shdr, 'BINTFMT', /DEL)
		tmp=find_vicar_tag(shdr, 'BHOST', /DEL)
		tmp=find_vicar_tag(shdr, 'HOST', /DEL)
		tmp=find_vicar_tag(shdr, 'REALFMT', /DEL)
		tmp=find_vicar_tag(shdr, 'INTFMT', /DEL)
		tmp=find_vicar_tag(shdr, 'ORG', /DEL)
		tmp=find_vicar_tag(shdr, 'DIM', /DEL)
		tmp=find_vicar_tag(shdr, 'NB', /DEL)
		tmp=find_vicar_tag(shdr, 'NL', /DEL)
		tmp=find_vicar_tag(shdr, 'NS', /DEL)
		tmp=find_vicar_tag(shdr, 'N1', /DEL)
		tmp=find_vicar_tag(shdr, 'N2', /DEL)
		tmp=find_vicar_tag(shdr, 'N3', /DEL)
		tmp=find_vicar_tag(shdr, '', /DEL)
		tmp=find_vicar_tag(shdr, '', /DEL)
		tmp=find_vicar_tag(shdr, '', /DEL)
		tmp=find_vicar_tag(shdr, '', /DEL)
	endif

	last_prop = ''
	task_no = 1
	for i=0, n_elements(shdr)-1 do begin
		p = strpos(shdr[i], '=')
		if p gt 0 then begin
			tag = strmid(shdr[i], 0, p)
			value = strmid(shdr[i], p+1)

			if tag eq 'PROPERTY' then begin
				value = p_strip_quotes(value)
				if last_prop ne '' then begin
					tags = [tags, 'G<'] & values = [values, last_prop]
				endif
				last_prop = strtrim(value, 2)
				tags = [tags, 'G>'] & values = [values, strtrim(value, 2)]
			endif else if tag eq 'TASK' then begin
				value = p_strip_quotes(value)
				if last_prop ne '' then begin
					tags = [tags, 'G<'] & values = [values, last_prop]
				endif
				taskprop = 'TASK' + strtrim(task_no++, 2) + '_' + value
				last_prop = taskprop
				tags = [tags, 'G>'] & values = [values, taskprop]
			endif else begin
				tags = [tags, strtrim(tag,2)] & values = [values, strtrim(value, 2)]
			endelse
		endif
	endfor

	; close any open property if any
	if last_prop ne '' then begin
		tags = [tags, 'G<'] & values = [values, last_prop]
	endif

	; update header
	h = p_set_struct_tag(h, 'tags', tags, 'values', values)

	close, unit
	free_lun, unit
	OK=1

	return


	handle_error:
	print, 'ERROR: Cannot open file: ' + file
	OK=0
END