; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	FUNCTION p_is_group, header, group
;
; PURPOSE:
;	Check if a tag refers to a valid GROUP or OBJECT structure within a PDS header
;
; CALLING SEQUENCE:
;	Result = p_is_group, header, group
;
; INPUTS:
;	header:	Valid PDS header structure
;   group:  path to be checked
;
; RETURNS:
;		1 if valid structure path  else 0
;
; KEYWORD PARAMETERS:
;	NONE
;
; OUTPUTS:
;	NONE
;
; EXAMPLE:
;   p_read, pickfile(), h, d
;   print, p_is_group(h, 'IMAGE')
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 11/8-2004
;-
FUNCTION p_is_group, header, group
  if p_find_group_range(header, group, istart, iend) eq 0 then return, 0
	return, 1
END