% Matlab Script to initialize ICA workspace
% This script is executed by the PLOT_ICA.M script
%
% See also: IMPORT_L2, READICA_L2, ICAINITIALIZE

if ~exist('rootpath','var')
    rootpath=[];
end
%% Find rootpath of archive where directory DATA is located
if isempty(rootpath) || ...
        ~(exist(fullfile(rootpath, 'CALIB','MASS_LOOKUP'),'dir') && ...
          exist(fullfile(rootpath, 'DATA'),'dir'))
    for jj=1:5
        if (exist(fullfile(rootpath, 'CALIB','MASS_LOOKUP'),'dir') && ...
            exist(fullfile(rootpath, 'DATA'),'dir'))
            break
        else
            rootpath = fullfile('..', rootpath);
        end
    end
end

%% Get path to data
while ~exist(fullfile(rootpath, 'CALIB','MASS_LOOKUP'), 'dir')
    fprintf(['This script is designed to run inside an archive.\n' ...
        'The CALIB/MASS_LOOKUP directory was not found.\n' ...
        'Please provide the path to the root of the archive i.e.:\n' ...
        '/home/user/psa/RO-C-RPCICA-2-ESC1-RAW-V1.0\n' ...
        '\n']);
    rootpath = input('path to the root of the archive:  ','s');
end
local_D=dir(rootpath);
rootpath = local_D(1).folder;
clear local_D

fprintf('rootpath: %s\n', rootpath);


local_cnof='PANIC: Can not find/open file: ';
local_fname_ml = 'mass_lookup.mat';

local_cached = false;
if exist(local_fname_ml,'file')
    local_pac=1;
    local_sw=2;
    local_f1 = dir(fullfile(rootpath,'CALIB','MASS_LOOKUP',sprintf('ICA_MASS_LOOKUP_TABLE%d_V%02d.TAB', local_pac, local_sw)));
    local_f2 = dir(local_fname_ml);
    if datenum(local_f1.date) < datenum(local_f2.date)
        local_tmp = load(local_fname_ml); % load E
        if isfield(local_tmp,'rootpath') && strcmp(rootpath, local_tmp.rootpath)
            load(local_fname_ml); % load LookUp
            LookUp = local_tmp.LookUp;
            local_cached = true;
        end
    end
end
if ~local_cached
    LookUp=nan(3,10,14,96);
    for local_pac=1:3
        for local_sw=2:10
            local_fname = fullfile(rootpath,'CALIB','MASS_LOOKUP',sprintf('ICA_MASS_LOOKUP_TABLE%d_V%02d.TAB', local_pac, local_sw));
            % dir(fname)
            local_fid=fopen(local_fname,'r');
            if local_fid == -1
                disp([local_cnof local_fname]);
            else
                local_LookUp=fscanf(local_fid,'%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d',[14,inf]);
                LookUp(local_pac, local_sw, :, 1:size(local_LookUp,2)) = local_LookUp(:, :);
                fclose(local_fid);
            end
        end
    end
    clear local_LookUp;
    save(local_fname_ml, 'LookUp', 'rootpath');
end

local_fname_e = 'energy.mat';

local_cached = false;
if exist(local_fname_e,'file')
    local_sw=2;
    local_f1 = dir(fullfile(rootpath,'CALIB','ENERGY',sprintf('ICA_ENERGY_TABLE_V%02d.TAB', local_sw)));
    local_f2 = dir(local_fname_e);
    if datenum(local_f1.date) < datenum(local_f2.date)
        local_tmp = load(local_fname_e); % load E
        if isfield(local_tmp,'rootpath') && strcmp(rootpath, local_tmp.rootpath)
            E = local_tmp.E;
            local_cached = true;
        end
    end
end
if ~local_cached
    E=nan(10,2,96);
    for local_sw=2:10
        local_fname = fullfile(rootpath,'CALIB','ENERGY',sprintf('ICA_ENERGY_TABLE_V%02d.TAB', local_sw));
        % dir(fname)
        local_fid=fopen(local_fname,'r');
        if local_fid == -1
            disp([local_cnof local_fname]);
        else
            local_E=fscanf(local_fid,'%d,%f',[2,inf]);
            E(local_sw, :, 1:size(local_E,2)) = local_E(:, :);
            fclose(local_fid);
        end
    end
    local_ix = E == -1; % Replace invalid values with nan's
    E(local_ix) = nan;
    clear local_E local_ix;
    save(local_fname_e, 'E', 'rootpath');
end
% cleanup
clear local_pac local_sw local_cached local_fname_ml local_fname_e local_cnof
clear local_fid local_fname local_f1 local_f2 local_tmp
