; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PRO p_ensure_history, header
;
; PURPOSE:
;	Ensure that the optional history object exists
;   If the object does not already exists then an empty history is created
;
; CALLING SEQUENCE:
;	 p_ensure_history, header
;
; INPUTS:
;	header:	The header structure to be checked and potentially modified
;
; KEYWORD PARAMETERS:
;
; EXAMPLE:
;	h = p_newhead()
;   p_ensure_history, h
;	p_wshead, h.history
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 4/5-2009

PRO p_ensure_history, header

	if p_struct_tag_exists(header, 'history') eq 0 then begin
		history = {type: 'TAGHDR', tags: ['O>', 'O<'], values: ['HISTORY', 'HISTORY']}
		header = p_set_struct_tag(header, 'history', history)
	endif
END