; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PRO p_set_struct, header, tag, value, _EXTRA=_EXTRA
;
; PURPOSE:
;	Write an IDL structure to a PDS header.
;   The tag variable here refers to the root object to be used
;   (Note internal utility routine. Should not be used by normal users.
;    Please use p_setvalue instead)
;
; CALLING SEQUENCE:
;	p_set_struct, header, tag, value
;
; INPUTS:
;	header:	Valid PDS header structure
;   tag:    the path to the containing object
;   value:	The structure input variable
;
; KEYWORD PARAMETERS:
;	NONE
;
; OUTPUTS:
;	NONE
;
; EXAMPLE:
;   h = p_newhead()
;   str = {tag1: 10, tag2: ['This','is','a', 'test']}
;	p_set_struct, h, 'TEST_STRUCT', str		; will write the structure members to a PDS OBJECT called TEST_STRUCT
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 11/8-2004
;-
PRO p_set_struct, header, tag, value, _EXTRA=_EXTRA
	type = size(value, /TYPE)
	if type ne 8 then begin
		print, 'p_set_struct: value must be structure'
		return;
	endif
	names = tag_names(value)
	for i=0, n_tags(value)-1 do begin
	  stag = strupcase(names[i])	  
	  if strmid(stag, 0, 5) eq '_PTR_' then stag = '^' + strmid(stag, 5)
	
		p_setvalue, header, tag + '.' + stag, value.(i), _EXTRA=_EXTRA
	endfor
END