; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PRO p_set_status, status, success, proc, msg
;
; PURPOSE:
;	Fill a std status block (as per osisift)
;
; CALLING SEQUENCE:
;	   p_set_status, status, success, proc, msg
;
; INPUTS:
;	success:	Either 'S' or 'F'	(Success or Failure)
;				if 'F' is specified then an error message will also be printed to the console
;	proc:		The name of the calling procedure
;	msg: 		THe error message
;
; OUTPUTS:
;	status:		on return this variavle will contain a 4 elements string array
;			    the first elements is either 'S' or 'F'
;			    the second elements is either 'SUCCESS' or 'FAILURE'
;			    the third elements contains the value of <proc>
;			    the forth elements contains the value of <msg>
;
;
; EXAMPLE:
; 	p_set_status, status, 'S', 'MY_PROC', 'Hello World'
; 	p_set_status, status, 'F', 'MY_PROC', 'This went wrong!!!!'
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 26/08-2004
;-

PRO p_set_status, status, success, proc, msg

	if n_elements(msg) eq 0 then msg = ''

	status = strarr(4)

	if success eq 'S' then begin
		status(0)= 'S'
		status(1)= 'SUCCESS'
		status(2)= proc
		status(3)= msg
	endif else begin
		status(0)= 'F'
		status(1)= 'FAILURE'
		status(2)= proc
		status(3)= msg

		print, "ERROR:   Failuire in '" + proc + "'  - " + msg
	endelse
END