

FUNCTION ra_aeff_norm, hdr, wave_image, calibration_dir = calibration_dir

aefffile = calibration_dir + 'aeff/RA_AEFF_008.TAB'

; Convert UTC value in header to ET
CSPICE_UTC2ET, sxpar(hdr, 'SCETC'), et

CSPICE_UTC2ET, '2005-06-01T00:00:00', cr2_start_et
CSPICE_UTC2ET, '2006-11-01T00:00:00', pc4_start_et
CSPICE_UTC2ET, '2007-02-01T00:00:00', mars_start_et
CSPICE_UTC2ET, '2007-09-01T00:00:00', pc6_start_et
CSPICE_UTC2ET, '2007-11-01T00:00:00', esb2_start_et
CSPICE_UTC2ET, '2008-07-01T00:00:00', pc8_start_et
CSPICE_UTC2ET, '2008-09-01T00:00:00', ast1_start_et
CSPICE_UTC2ET, '2009-09-18T00:00:00', pc10_start_et
CSPICE_UTC2ET, '2009-11-06T00:00:00', esb3_start_et
CSPICE_UTC2ET, '2010-04-01T00:00:00', pc12_start_et
CSPICE_UTC2ET, '2010-06-01T00:00:00', ast2_start_et
CSPICE_UTC2ET, '2010-09-11T00:00:00', rvm1_start_et
; Values derived from code in ra_effa.pro
CASE 1 OF
                           et LT cr2_start_et:  aeff_correction_file = 'RA_CVP2_PC10_CORRECTION.TAB' ; Use CVP2
   et GE cr2_start_et  AND et LT pc4_start_et:  aeff_correction_file = 'RA_CR2_PC10_CORRECTION.TAB' ; Use CR2
   et GE pc4_start_et  AND et LT mars_start_et: aeff_correction_file = 'RA_PC4_PC10_CORRECTION.TAB' ; PC4 (unreliable)
   et GE mars_start_et AND et LT pc6_start_et:  aeff_correction_file = 'RA_MARS_PC10_CORRECTION.TAB' ; Mars
   et GE pc6_start_et  AND et LT esb2_start_et: aeff_correction_file = 'RA_PC6_PC10_CORRECTION.TAB' ; PC6
   et GE esb2_start_et AND et LT pc8_start_et:  aeff_correction_file = 'RA_ESB2_PC10_CORRECTION.TAB' ; ESB2
   et GE pc8_start_et  AND et LT ast1_start_et: aeff_correction_file = 'RA_PC8_PC10_CORRECTION.TAB' ; PC8
   et GE ast1_start_et AND et LT pc10_start_et: aeff_correction_file = 'RA_STEINS_PC10_CORRECTION.TAB' ; AST1 (Steins)
   et GE pc10_start_et AND et LT esb3_start_et: aeff_correction_file = '' 
   et GE esb3_start_et AND et LT pc12_start_et: aeff_correction_file = 'RA_ESB3_PC10_CORRECTION.TAB' ; ESB3 
   et GE pc12_start_et AND et LT ast2_start_et: BEGIN
      aefffile = calibration_dir + 'aeff/RA_PC12_AEFF_001.TAB'
      aeff_correction_file = ''                                           ; PC12
   END
   et GE ast2_start_et AND et LT rvm1_start_et: BEGIN
      aefffile = calibration_dir + 'aeff/RA_PC12_AEFF_001.TAB'
      aeff_correction_file = 'RA_LUTETIA_PC12_CORRECTION.TAB' ; AST2 (Lutetia)
   END
ENDCASE

readcol, aefffile, aeff_wave, aeff, format = 'F,F', /silent
aeff_image = interpol(aeff, aeff_wave, wave_image) > 0.

sxaddpar, hdr, 'AEFFFLAG', 'T', ' Effective area correction applied?'
sxaddpar, hdr, 'AEFFFILE', /savecomment, file_basename(aefffile)

IF keyword_set(aeff_correction_file) THEN BEGIN
   readcol, calibration_dir + 'aeff/' + aeff_correction_file, correction_wavelen, correction, /silent
   aeff_correction = interpol(correction, correction_wavelen, wave_image) > 0.

   sxaddpar, hdr, 'TVAEFLAG', 'T', /savecomment
   sxaddpar, hdr, 'CORRFILE', aeff_correction_file, /savecomment
   aeff_image *= aeff_correction
ENDIF

return, aeff_image 
END
   
