function pixellist_table, PLin, hacks = hacks, Wave_Image=Wave_Image
;   Version Date: 2007 Feb 20 AJS

;+
;   Convert a "raw" (hex values with hash marks) pixel list array into an
; array with columns = X, Y, Wavelength, TimeStep
;   If wave image is passed, then PLout[3,*] contains the value of the
; wavelength, otherwise it is zero.
;-

Xsize = 1024
HackVal = 'ffff'xu

NumData = n_elements(PLin)
if (PLin[0] ne HackVal) then PLin = [HackVal, PLin]
if (PLin[NumData-1] ne HackVal) then PLin = [PLin, HackVal]

hacks = where(PLin eq HackVal, NumHacks)


;mike_log, 'File contains ' + strtrim(NumHacks-1,2) + ' PixelList time steps'

PLout = fltarr(4)

;;;
;   Construct things.
;     I1 and I2 are the index positions of two consecutive hacks
;     timestep is the running counter of time steps
;     X,Y = positions on the detector
;     P is the associated position (1-D vector) of X,Y
;     W = the wavelength at X,Y
for N=0,(NumHacks-2) do begin
   I1 = hacks[N]
   I2 = hacks[N+1]
   if ((I1 + 1) lt I2) then begin
      events = plin[i1+1:i2-1]
      x = events MOD xsize
      y = events/xsize
      wave = fltarr(i2-1-i1) 
      timestep = fltarr(i2-1-i1) + n
      PLout = [[PLout], [transpose([[X],[Y],[wave],[timestep]])]]
   ENDIF
endfor

IF n_elements(events) GT 0 THEN plout = plout[*, 1:*]

IF keyword_set(wave_image) THEN plout[2,*] = wave_image[[plout[0,*]], [plout[1,*]]]

return, PLout
end
