pro mike_log, Mess, ErrNum=ErrNum, VerboseLevel=VerboseLevel, $
   StartFlag=StartFlag, TimeFlag=TimeFlag, InitFlag=InitFlag
; Version Date: 2005 Jun 26

;+
;   Simple procedure to write status to message log and to screen if desired.
; The message (Mess) may be a string array if multi-lines are desired.
;   ErrNum = 0 [no error]
;            1 [warning]
;            2 [fatal error]
;   Verbose = indicates the level of verbosity for the particular message,
;      to be compared to the global MikeFlags.Verbose value.  Typically:
;             0 [no output]
;             1 [filename being processed and fatal errors]
;             2 [same as 1 plus warnings]
;             3 [everything]
;   StartFlag = if set, indicates the start of a procedure, so will print
;      out the calling procedure's name.
;   TimeFlag = if set, prints out time of log entry
;   InitFlag = if set, initializes/clears the log.
;-
COMMON MIKE_DATA

if (MikeFlags.Log eq 0) then return


if keyword_set(InitFlag) then begin
   LogMessages = ''
   MikeFlags.Error = 0
endif

;;;
;   If VerboseLevel is not set, assume it is an UNimportant message,
; and set the VLevel to 3.
;
if keyword_set(VerboseLevel) then VLevel = VerboseLevel else VLevel = 3

;;;
;   Is there an error number?
;   If so, then the VerboseLevel of the message is at most a 2 for warnings
; and 1 for fatal errors.
;
if (n_elements(ErrNum) eq 0) then ErrNum = 0
case ErrNum of
   0 : A = ''
   1 : A = '# WARNING: '
   2 : A = '## FATAL ERROR: '
endcase

if (ErrNum ne 0) then MikeFlags.Error = ErrNum > MikeFlags.Error
if (ErrNum eq 1) then VLevel = VLevel < 2
if (ErrNum eq 2) then VLevel = VLevel < 1

;;;
;   Process the StartFlag, TimeFlag, and Mess{age}
;
if keyword_set(StartFlag) then begin
   help, calls=P
   A = A + 'Starting: ' + (strsplit(P[1],/extract))[0] 
endif

if keyword_set(Mess) then A = A + Mess

if keyword_set(TimeFlag) then A[TimeFlag-1] = A[TimeFlag-1]+'  {'+systime()+'}'

;;;
;   Put it all in the log file.
;
LogMessages = [LogMessages, A]


;;;
;   Level of verbosity.  If VLevel is low enough, it gets printed.
;
if (MikeFlags.Verbose ge VLevel) then print, A, format='(A)'

return
end
