;+
; NAME: adderr.pro
;
; PURPOSE: Add or subtract two arrays and propagate their statistical
; errors.
;
; CATEGORY: Statistics, error propagation
;
; CALLING SEQUENCE: 
;   sum = adderr(array1,errarray1,array2,errarray2,[err=sumerr,[subtract=subtract]])
;
; INPUTS: 
;   array1 -- Array to add to or subtract from
;   errarray1 -- Array containing the statistical errors of array1
;   array2 -- Array to add to or subtract from array1 
;   errarray1 -- Array containing the statistical errors of array1
;     
; KEYWORD PARAMETERS:
;   subtract --  set this keyword to perform subtraction instead of addition
;
; OUTPUTS:
;   The function returns the sum (or difference, if the subtract
;   keyword is set) of the two input arrays
;
; OPTIONAL OUTPUTS:
;   err -- Set this keyword to a varaible that will contain the
;          statistical error associated with the sum (difference) array
;
; COMMON BLOCKS: None
;
; SIDE EFFECTS: None
;
; RESTRICTIONS: None
;
; MODIFICATION HISTORY:
;  2007-02-19 AJS Added documentation
;-

function adderr, array1, errarray1, array2, errarray2, err = sumerr, subtract = subtract

if not keyword_set(subtract) then sum=array1+array2 else sum=array1-array2
sumerr=sqrt(errarray1^2+errarray2^2)

return,sum
end
