
; ra_wavelen.pro
; v. 2   AJS  2009-10-29
; v. 3   AJS  2010-03-09  Added dwavelen keyword
  
FUNCTION ra_wavelen, wavesoln, poly2, poly1 = poly1, wavefile = wavefile, index = index, linear = linear, dwavelen = dwavelen

IF NOT keyword_set(index) THEN index = findgen(1024)

IF keyword_set(linear) THEN BEGIN
   IF NOT keyword_set(poly1) THEN BEGIN
      IF NOT keyword_set(wavefile) THEN wavefile = $
        '~/data/ralice/data/cal/wavelength/RA_WAVE_006.FIT'

      rdfits_struct, wavefile, wave, /silent
      poly1 = wave.im2
   ENDIF
   wavelen = poly(index, poly1)
ENDIF ELSE BEGIN
   IF NOT (keyword_set(wavesoln) AND keyword_set(poly2)) THEN BEGIN
      IF NOT keyword_set(wavefile) THEN wavefile = $
        '~/data/ralice/data/cal/wavelength/RA_WAVE_006.FIT'

      rdfits_struct, wavefile, wave, /silent
      wavesoln = wave.im0
      poly2 = wave.im1
      poly1 = wave.im2
   ENDIF

   wave2 = poly(index, poly2)
   wave = poly(index, wavesoln)

   wavelen = [wave2[0:89, *], wave[90:916, *], wave2[917:*, *]]
ENDELSE

dwavelen = shift(wavelen, 1) - wavelen
dwavelen[0] = dwavelen[1]

return, float(wavelen)
END
