

FUNCTION ra_lyafit, im

; Ready parinfo structure for mpfitpeak
nterms = 5
parinfo = replicate({limited:[0, 0], limits:[0d, 0d]}, nterms)
parinfo[0].limited = [1, 0]

parinfo[1].limited = [1, 1]
parinfo[1].limits = [595., 620.]

parinfo[2].limits = [1, 1]
parinfo[2].limited = [2., 8.]

index = findgen(61) + 580.
gfit13 = mpfitpeak(index, im[index, 13], fitpar13, weights = 1d/(im[index, 13] > 1.), $
                   nterms = nterms, perror = err, /positive, parinfo = parinfo, $
                   estimates = [max(im[600:620, 15]), 610., 5.])
;gfit15 = mpfitpeak(index, im[index, 15], fitpar15, weights = 1d/(im[index, 15] > 1.), $
;                   nterms = nterms, perror = err, /positive, parinfo = parinfo, $
;                   estimates = [max(im[600:620, 15]), 610., 5.])
gfit18 = mpfitpeak(index, im[index, 18], fitpar18, weights = 1d/(im[index, 18] > 1.), $
                   nterms = nterms, perror = err, /positive, parinfo = parinfo, $
                   estimates = [max(im[600:620, 15]), 610., 5.])


;return, [fitpar13[1], fitpar15[1], fitpar18[1]]
return, [fitpar13[1], fitpar18[1]]
END
