; Revision date 2010-07-15

PRO ra_mike_skysubtract,  primary_header, image, error_image, sky_image, sky_image_err, skyfile, $
                          wavelength_indices, skyindex = skyindex

IF NOT keyword_set(skyindex) THEN skyindex = [6, 7, 8, 20, 21, 22]

; Interpolate sky to data image
yindex = (fltarr(1024) +1.) # findgen(32)
sky = interpolate(sky_image, wavelength_indices, yindex, cubic = -0.5)
skyerr = interpolate(sky_image_err, wavelength_indices, yindex, cubic = -0.5)

im_sky_tot = total(image[585:625, skyindex])
sky_tot = total(sky[585:625, skyindex])
skynorm = im_sky_tot / sky_tot

image = adderr(image, error_image, sky*skynorm, skyerr*skynorm, /subtract, err = imerr)
error_image = imerr

opentime = sxpar(primary_header, 'OPENTIME')
sxaddpar, primary_header, 'SKYFILE', /savecomment, file_basename(skyfile)
sxaddpar, primary_header, 'SKYNORM', skynorm/opentime, /savecomment
sxaddpar, primary_header, 'SKYFLAG', 'T', /savecomment

END
