; Algorithm taken from Wilkenson et al. 2001

; Fiducial points taken from R-ALice observation of Mars used in
; wavelength calibration ra_070224182814_his0_eng.fit
;
; position of stim pulse and lyman alpha in row 16

FUNCTION ra_stim_lya_correction, im, hdr, stimpos = stimpos, lyafit = lyafit, inverse = inverse, $
                                 stimflag = stimflag, lyaflag = lyaflag, dark = dark
              
S_x1 = 14.4485
                   
IF keyword_set(dark) THEN BEGIN
   Sp_x1 = ra_stimpos(im)
   correction = Sp_x1 + (dindgen(1024) - S_x1)
ENDIF ELSE BEGIN
   CASE n_params() OF

      0: BEGIN
         message, 'ra_stim_lya_correction, im, hdr, stimpos = stimpos, ' + $
                  'lyafit = lyafit, stimflag = stimflag, lyaflag = lyaflag'
         return, -1
      END
      1: BEGIN
         stimflag = 1
         stimpos = ra_stimpos(im)
      END
      2: BEGIN 
         stim = sxpar(hdr, 'DETSTIM')
         IF stim EQ 'stim' THEN BEGIN
            stimflag = 1 
            stimpos = ra_stimpos(im)
         ENDIF ELSE stimflag = 0
      END
   ENDCASE
   
   lyafit = ra_lyafit(im)
   goodfit = where(finite(lyafit) EQ 1, ngoodfit) 
   
   IF ngoodfit EQ 0 THEN lyaflag = 0 ELSE BEGIN
      lyaflag = 1
;   S_x2 = [607.57894d, 608.31806d, 607.92402d]
      S_x2 = [607.57894d, 607.92402d]
      
      IF ngoodfit EQ 1 THEN BEGIN
         Sp_x2 = lyafit[goodfit]
         S_x2 = S_x2[goodfit]
      ENDIF ELSE BEGIN
         Sp_x2 = avg(lyafit[goodfit])
         S_x2 = avg(S_x2[goodfit])
      ENDELSE
      
   ENDELSE
   
   CASE 1 OF 
      (lyaflag EQ 1) AND (stimflag EQ 1): BEGIN
         Sp_x1 = stimpos
         
         IF keyword_set(inverse) THEN correction = S_x1 + (dindgen(1024) - Sp_x1) * (S_x2 - S_x1) / (Sp_x2 - Sp_x1) ELSE $
           correction = Sp_x1 + (dindgen(1024) - S_x1) * (Sp_x2 - Sp_x1) / (S_x2 - S_x1)
; This is the older (incorrect) version
;      correction = S_x1 + (findgen(1024) - Sp_x1) * (S_x2 - S_x1)/ (Sp_x2 - Sp_x1)
      END
      (lyaflag EQ 1) AND (stimflag EQ 0) AND keyword_set(hdr): BEGIN 
         detetemp = sxpar(hdr, 't_delecc')
         stimvstemp = [3.54635269536d, 0.701213748697d, -0.00963268591067d, 0.000462857127681d] 
         Sp_x1 = poly(detetemp, stimvstemp)
         IF keyword_set(inverse) THEN correction = S_x1 + (dindgen(1024) - Sp_x1) * (S_x2 - S_x1) / (Sp_x2 - Sp_x1) ELSE $
           correction = Sp_x1 + (dindgen(1024) - S_x1) * (Sp_x2 - Sp_x1) / (S_x2 - S_x1)
      END
      ELSE: correction = -1
   ENDCASE
ENDELSE   

return, correction
END


