PDS_VERSION_ID      = PDS3
LABEL_REVISION_NOTE = "SE-MTC, 11/12/2015"

     /* File format and length */
PRODUCT_ID    = "T1_00367987090.GEO"
ORIGINAL_PRODUCT_ID = "PTE8U229.QUB"
RECORD_TYPE   = FIXED_LENGTH
RECORD_BYTES  = 512
FILE_RECORDS  = 165
LABEL_RECORDS = 10
FILE_STATE    = CLEAN

     /* Pointers to data objects */
^QUBE      = 11
 
     /* Producer information */
PRODUCER_ID               = ROSETTA_VIRTIS_TEAM
PRODUCER_FULL_NAME        = "CAPACCIONI"
PRODUCER_INSTITUTION_NAME = "OBSERVATOIRE DE PARIS-LESIA"
PRODUCT_CREATION_TIME     = 2016-11-24T09:48:41.00
TELEMETRY_SOURCE_ID       = "VIRTIS_EGSE3"
SOFTWARE_VERSION_ID       = {"VirtisRos SW v.4.10", "EGSE_SOFT_7.3", 
"PDS_CONVERTER_7.3","EGSE2PSA_LBL_1.2.2", "GEOROS_6.2", "V_GEOLABEL_6", 
"GEOROS_6.2", "V_GEOLABEL_6", "GEOROS_7.1", "V_GEOLABEL_6"}

     /* Data description parameters */
DATA_SET_NAME        = "ROSETTA-ORBITER 67P VIRTIS 3 PRELANDING MTP006 V1.0"
DATA_SET_ID          = "RO-C-VIRTIS-3-PRL-MTP006-V1.0"
PRODUCT_TYPE         = EDR
PROCESSING_LEVEL_ID  = 2
STANDARD_DATA_PRODUCT_ID = "VIRTIS GEOMETRY"
MISSION_NAME         = "INTERNATIONAL ROSETTA MISSION"
MISSION_ID           = ROSETTA
INSTRUMENT_HOST_NAME = "ROSETTA-ORBITER"
INSTRUMENT_HOST_ID   = RO
MISSION_PHASE_NAME   = "PRELANDING MTP006"
PI_PDS_USER_ID       = CAPACCIONI
INSTRUMENT_NAME      = "VISIBLE AND INFRARED THERMAL IMAGING SPECTROMETER"
INSTRUMENT_ID        = "VIRTIS"
INSTRUMENT_TYPE      = "IMAGING SPECTROMETER"
^INSTRUMENT_DESC     = "RO_VIRTIS_EAICD.ASC"
ROSETTA:CHANNEL_ID   = "VIRTIS_H"
DATA_QUALITY_ID      = 1
DATA_QUALITY_DESC    = "0:INCOMPLETE ; 1:COMPLETE"

     /* Science operations information */
TARGET_TYPE            = "COMET"
TARGET_NAME            = "67P/CHURYUMOV-GERASIMENKO 1 (1969 R1)"
START_TIME             = 2014-08-30T02:31:40.758
STOP_TIME              = 2014-08-30T03:54:01.376
SPACECRAFT_CLOCK_START_COUNT = "1/0367986631.48269"
SPACECRAFT_CLOCK_STOP_COUNT  = "1/0367991572.23145"
ORBIT_NUMBER           = "N/A"
OBSERVATION_TYPE       = "NULL"
SC_SUN_POSITION_VECTOR        = (-200482657.307, 412360316.859, 240382251.180)
SC_TARGET_POSITION_VECTOR     = ( -5.989, -26.728, -48.782)
SC_TARGET_VELOCITY_VECTOR     = ( -0.000, -0.000, -0.000)
COORDINATE_SYSTEM_ID          = "-1000012000"
COORDINATE_SYSTEM_NAME        = "67P/C-G_CK"
DECLINATION                   = -999.999
RIGHT_ASCENSION               = -999.999
MAXIMUM_LATITUDE              = 79.210
MINIMUM_LATITUDE              = 78.898
EASTERNMOST_LONGITUDE         = 100.621
WESTERNMOST_LONGITUDE         = 57.794
SPACECRAFT_ALTITUDE           = 54.554
PHASE_ANGLE                   = 41.976
SUB_SPACECRAFT_LATITUDE       = 82.182
SUB_SPACECRAFT_LONGITUDE      = 47.856
SLANT_DISTANCE         = 55.349270
SOLAR_DISTANCE         = 517704552.013
SOLAR_LONGITUDE        = 119.96881
SUB_SOLAR_LATITUDE     = 34.206
SUB_SOLAR_LONGITUDE    = 64.367
NOTE = "The values of the keywords SC_SUN_POSITION_VECTOR, 
SC_TARGET_POSITION_VECTOR and SC_TARGET_VELOCITY_VECTOR are related to the 
J2000 frame. The values of SUB_SPACECRAFT_LATITUDE and 
SUB_SPACECRAFT_LONGITUDE are northern latitude and eastern longitude in the 
planetocentric frame defined by the shape model. All values are computed at 
mid-session. Distances are given in <km>, velocities in <km/s> angles in 
<deg>"


     /* Instrument status */
INSTRUMENT_MODE_ID    = 10
^INSTRUMENT_MODE_DESC = "RO_VIRTIS_EAICD.ASC"

     /* Pointer to navigation data files*/
SPICE_FILE_NAME = {"NAIF0011.TLS","PCK00010.TPC","DE405.bsp","JUP263.bsp",
"ROS_160929_STEP.TSC","ROS_V26.TF","ROS_CHURYUMOV_V01.TF","ROS_VIRTIS_V13.TI",
"cg-spc-shap5-v1.1_Cedric.TPC","RORB_DV_145_01___T19_00216.bsp",
"CORB_DV_145_01___T19_00216.bsp","RATT_DV_145_01_01____00216.bc",
"RATT_DV_145_01_01____00216.bc","CATT_DV_145_01_______00216.bc",
"cg-spc-shap5-v1.1-cheops.bds"}

     /* Cube keywords */
OBJECT = QUBE
 AXES                       = 3
 AXIS_NAME                  = (BAND,SAMPLE,LINE)
 CORE_ITEMS                 = (31,64,10)
 CORE_ITEM_BYTES            = 4
 CORE_ITEM_TYPE             = MSB_INTEGER
 CORE_BASE                  = 0.0
 CORE_MULTIPLIER            = 1.0
 CORE_VALID_MINIMUM         = -2147483648
 CORE_NULL                  = -2147483648
 CORE_LOW_REPR_SATURATION   = -2147483648
 CORE_LOW_INSTR_SATURATION  = -2147483648
 CORE_HIGH_REPR_SATURATION  = 2147483647
 CORE_HIGH_INSTR_SATURATION = 2147483647
 CORE_NAME                  = "GEOMETRIC PARAMETERS"
 CORE_UNIT                  = "UNK"
 CORE_DESC                  = "PARAMETERS ARE DEFINED IN EAICD"

 SUFFIX_BYTES               = 4
 SUFFIX_ITEMS               = (0,0,0)
END_OBJECT = QUBE

END
                                                                                                                                                                                                                                                                                                                                                                   5 I[ ( 6n   -{  Z & 

o 9 [ .   ~    6 o 'u#N  }9  n'R -  	H   3} F & 4F x  -  X, $ 
 	 [    ~    7 8 'u W  5  o W i  	F   1 Dv $V 2 a  -  U ! 
  [ 	   ~  '  7  't`  =1  p[   	E   . B "$ / J  -  S}  
C  [    ~  3  8  'ti  -  qa   	D   ,b ?  - 3  -  Q$  
 y [   
 ~  >  9 u 'tr  )  rg  
 	C   * =  +   -  N  
	 H [     ~  I  9 > 'tt{  ]%  sm X  	Bc   ' :  )|   -  Lv  
	  [ ۿ  4 ~  U  :  'tQ  !  sr   	AA  % %G 85 [ 'S  { -  J  
\  [ ۭ  G ~  `  ; ~ 't.    tw  ! 	@  .   3P  #  c -  Ep  
  [ ۉ  m ~  w  < ~` 's
    v| F 0 	=  > - 0     W -  C  
- W [ w   ~  ނ  = ~( 's  <  w  7 	<  G  .i    K -  @  
r & \ f   ~  ލ  > } 's    xڇ  ? 	;  O s + b  | > -  >h    \
 T   ~  ޙ  > } 's     yӍ  G 	$  W  ) 0 c f 3 -  <  Q  \ B   ~  ޤ  ? } 's\'  \  z̒ 3 N 	#  `  ' 	 9 P ' -  9   P \ 1   ~  ް  @ }J 's9-    {Ř n V 	"h w h \ $   :  -  7b     \&    ~  ޻  @ } 's4    |  ] 	!L n q  "+   $  -  5	    \/    ~    A | 'r:  |  }  e 	 / f y F G 8    -  0\    \?    ~}    B |l 'rG  ;d  v [ t 	 U     
k   .  .   Z \H   / ~z    C | 'rM  h  }  { 	 M   a  B   .
  +   ( \P   C ~v    D { 'rgS  k     	 D  /   	   . ؾ )T  W  \X ڷ  V ~s    E { 'rD
Z  [o     	 <   | s    . غ &    \a ڦ  j ~p  
  E {r 'r!`  s   F  	 4  v 
 B    ." ط $    \i ږ  } ~l    F {: 'qg  v     	k +      t  .) ص "K   b \r څ   ~i  $  G { 'q)m  {z   ~  	P #   "   v ^  .0 ز   V 0 \z t   ~e  0  G z 'q2s  }  x {  	5    < z # 1  .> خ C    \ S   ~_  G  I z\ 'qsD    j vk  	 
    I   ~ .D ث     \ B   ~[  S  I z$ 'qPM    c s  	   G W    r .K ة   Q i \ 2   ~X  ^  J y 'q-V  \  \ p  	    
    g .R ا =   7 \ "   ~T  j  K y 'q
_    U n  	    
s    Z .Y ؤ     \    ~Q  v  L y~ 'ph    N kT  	   2 
  V  N .` آ     \   . ~M  ߁  L yF 'pr  |  G h  	|    
 V -  B .g ؠ 
7  J  \   A ~J  ߍ  M y 'p{    @ e  	
b   y 
 %   6 .m ؝ 
   o \   U ~G  ߙ  N x 'p~  <  9 c  	H    
8   i  .{ ؘ 1    \   } ~?  ߱  O xL 'p8    , ]w  	
  ! d 
 ד  S  . ؖ   @  \ ٲ   ~<  ߼  P x 'p  \  % Z  	  )  
T c a =  . ؓ   }  \ ٢   ~9    P w 'o     W 	 	  1 ٬ 
 1 8 &  . ؑ +  ߺ t \ ٓ   ~5    Q w 'o    " U$  	  : P 
p     . ؎    B \ ك   ~1    R wn 'o  |  ' R^  	  B  
     . ؋ |  4  ]  t   ~.    R w6 'o  ܅  	- O  	  K җ 
 ̜ ۿ   . ؈ %  
 
 ]	 d   ~*    S v 'of  <  2 L & v  S = 
 k ٗ   . ؅   E  ] U   ~'    T v 'oD  ~  8 J . ^  [ ˉ 
5  G   .    ޺ u ]" 7  / ~    U vX 'n  \  D D~ < - s l / 
      . {    C ]* (  C ~  '  V v  'n  {  J A D  j u  
Q     . x q  /  ]2   W ~  3  W u 'n	   w  O > K  b } { 
 y  m  . u   i  ]; 
  k ~  ?  W u 'n	  |s  T <+ R  Z  ! 
l J ̧ Z  . r   ۣ  ]C    ~  K  X uz 'nr
	  o  Z 9d Z  Q   
   F s . n k   x ]L    ~
  W  Y uB 'nO	  <l  _ 6 a  I  n 
̈  W 3 g . k    E ]T    ~	  c  Y u 'n,	  h  e 3 h  @   
  /  Z . h   O  ]\    ~  o  Z t 'n	(	  d  j 1 p  8  ^ 
0 Z   A . a     ]m ز   }    \ td 'm;	,  H  $ + ~ Z '   
¾ )   5 . ^ ٵ   y ]v ؤ   }    \ t 'mD	3  e  - (  D    
L    ) /  [ ^  3 F ]~ ؖ   }    ] s 'm~M	9  z  9 %  .   Q 
  g   / W   k  ] ؈   }    ^ s 'm[V	?  ڠ  C #.      
i  @   / T Ұ ~ Ԥ  ] z  3 }    ^ sj 'm8_	F  :  N  g      
 b    / Q X z   ] l  G }    _ s2 'mh	L    W      C 
 1    / M  w  y ] ^  [ }    ` r 'lq	R    c       
    k  /# J ˪ s K F ] P  o }    ` r 'l{	Y  [  }m      5 
1  x C  /1 C  l к  ] 5   }    b rT 'l	f    o       
 k P /  /8 @ ĥ i   ] '   }     c r 'lg	l  |  h       
N 9 )   /? < M f ( x ]    }    c q 'lD	r  ܢ  a   l   ' 
     /F 9  b _ E ] 
   }    d q 'l!	y  <  Z 
+  X    
l     /M 5  _ ͖  ]    }  %  e qv 'k	  n  S c  D  % t 
     /T 2 I [   ]    }  1  e q> 'k	  T  L   0  -  
 t    /[ .  W  l ]    }  =  f q 'k	  \:  E   º  6  
 C d  } /b *  T 9 8 ]   % }  J  g p 'k	     > 

    >  
7    e /o #  L   ^ ׾  M }  b  h p` 'kP	  zZ  0 
~     O  
   w Y /v   I   ^
 ױ  b }  o  i p) 'k-	  X  ) 
    W [ 
T   c L /}  @ E   f ^ פ  v }  {  j o 'k	  :V  " 
  u  `  
 M  N @ /   A 2 1 ^ ט   }    j o 'j	  T   
&  g w h  
s  z : 4 /   > c  ^& ׋   }    k o 'j	  Q   
^  Z n p O 
  R & ' /  ; :   ^.    }    l oJ 'j
	  ZO  
 
 $ M f y } 
 } +   /   6   ^7 r   }    l n 'j	  M   
 + @ ^  { 
 {    /   2  _ ^? f   }    m n 'j\	  K   
 2 4 U  v 
= w)    /   + V  ^P N   }    o nP 'j2	     
u A  D  t 
 t    /   '   ^Y B   }    o n 'i;	  9   
ݭ H  <  r> 
~[ r h   /  2 #    ^a 6  - }    p m 'iD	     
 O v 4  o 
{ p ?   /     8  ^i *  A }    q m 'iM	     
 V d +  m 
yv ne    /    p  ^r   V }    q mr 'iV	  Y   
S ] R #  k3 
w l4 | }  /  *   M ^z   j }    r m; 'ii_	     
ҋ d A   h 
t j z j  /      ^   ~ }{    s m 'iFi	     
 k 0   f 
r# g x W  /  |    ^    }w  '  s l 'i#r
  y   
 r  	  a 
mA cr tV 1  /      ^    }p  @  u l\ 'h
  <A  ųJ 
g     _y 
j aB r/  y /  w   K ^    }l  L  v l% 'h
  5  ƬM 
Ğ     ]! 
h_ _ p  l /       ^    }h  X  v k 'h
  (  ǥR 
     Z 
e \ m  ` /     *  ^    }d  d  w k 'hu
%  \  ȞV 

     Xr 
c~ Z k  S /  ~s  # Q ^ ֻ   }`  p  x k~ 'hR
+    ɗZ 
D  Ө   V 
a X i  G 0  |  W  ^ ְ   }\  }  x kG 'h0
2    ʐ^ 
{  җ   S 
^ VP gj  : 0  y    ^ ֦  3 }X    y k 'h

8  {  ˉb 
  ц   Qi 
\+ T  eB  . 0  wo    ^ ֛  H }T    z j 'g
>    ̂g 
  v  ! L 
WJ O `   0 ׽ r  ' L ^ ֆ  p }L    { jh 'g
K  _  t 
V  U  2 Jb 
T M ^ q  0& ׺ pk  Z  ^ |   }H    | j1 'g
Q  O  m 
  E  : H
 
Ri Ka \ ^  0, ׷ n    ^ r   }D    } i 'g_
X  \@  f 
  5  C E 
O I1 Z| J  02 ״ k    _ h   }@    } i 'g<
^  0  _ 
  %  K CZ 
M G XT 6  09 װ ih   { _	 ^   };    ~ in 'g
e     X 
1    T A 
K D V, #  0? ׭ g  & F _ T   }7     i7 'f
k  |  Q 
h    \ > 
H B T   0E ת d  Y  _ J   }3     h 'f
q    J 
   z d <R 
F8 @r Q   0L ק bd    _" @   }/    ׀ h 'f
x  ;  C 
   r m 7 
AY < M   0X נ ]   u _3 -  ' }'    ׂ hY 'fl)
    5 
B   a ~ 5J 
> 9 Kg   0_ ם [a  ! @ _< #  < }#  *  ׂ h! 'fI2
  [  . 
x  ý Y  2 
<y 7 I?   0f י Y
  S  _D   P }  7  ׃ g 'f&<
    ' 
  ® P  0 
:	 5~ G   0l ז V    _M   e }  C  ׄ g 'fE
  {    
   H  .B 
7 3M D  t 0s ד T]    _U   y }  P  ׄ gz 'eN
  {m   
   @  + 
5+ 1 B r h 0y ׏ R  '  _]    }  \  ׅ gC 'eW
  ^   
Q !  7  ) 
2 . @ ^ [ 0 ׌ O  \ [ _f    }  i  ׆ g 'e`
  ;P   
 (  /  '9 
0I , >w K O 0 ׈ MV   ' _n    }
  u  ׇ f 'eyj
  B   
 /  &  " 
+j (X :) $ 6 0 ׁ H    _    }    ׈ fe 'e3|
  \   
|( =     3 
( &' 8  * 0 ~ FR  /  _    |    ׉ f- 'e
     
y^ D ּ 
   
& # 5   0 z C  c V _    |    ׉ e 'd
     
v J խ    
$ ! 3   0 w A   " _    |    ׊ e 'd
  {   
s Q Ԟ   - 
!  1   0 s ?N    _ չ  0 |    ׋ e 'd
  ۵   
q  X ӏ    
= f /d   0 o <    _ ձ  D |    ׋ eO 'd
  ;   
n5 _ Ҁ   ~ 
 5 -=   0 l :  3  _ թ  X |    ׌ e 'dc
     
kk f q   ' 
^  +   0 h 8L  f P _ ա  m |    ׍ d 'd@
  m   
h m c   
x 
  & u  0 a 3    _ Ց   |    ׎ dq 'c
     
c z G   " 
 t $ b  0 ] 1I ~    _ Չ   |  
  ׏ d9 'c
  g   
`A  9    
 C "y N  0 Y . z 3 ~ _ Ղ   |    א d 'c  {J  	 
]w  +  & s 
2   R :  0 V , v e J _ z   |  #  א c 'c
  .   
Z    /  
  , '  0 R *E s   _ s   |  /  ב c 'cp  ;   
W    7  
	T 	    0 N ' n   _ k   |  <  ג c? 'cN     
U    ? 
n 
     } 0 J % j   _ d   |  H  ד c 'c+     
RL    H 
 
u R   q 0 F #B g . w ` ]  $ |  U  ד b 'c$  Z   
O    P 
h 	   i  X 1 ?  _  
 ` N  L |  n  ו ba 'b!1  <  y
 
I   ~ a 
 	(  B  L 1 ; > Z    ` G  a |  {  ו b) 'b+7  z*  r
 
G   D u j 
 	    ? 1 7  W W  `( A  u |    ז a 'b~4=    k 
DU  / m r 
c 	J _   3 1 3  S Ώ N `0 :   |    ח a 'b[=D  :  d 
A   d z 
 	 / 
 u & 1 / ; O   `8 3   |    ח a 'b8FJ    ] 
>   \  
 	l   b  1% ,  K   `A -   |    ט aK 'bOP    V 
;   T  
^ 	   N 
 1+ (  G 4  `I '   |    י a 'aYW  Y  O 
9)   K  
 	  X :  11 % 9 C k ~ `R     |    ך ` 'ab]    H  
6]   C  
W 	 <     1>  	 ;   `c    |    כ `m 'atj  {	  :_ 
0   2  
  	?     1D  2 7   `k    |    ל `5 'ah}p    3f 
-   )  
ީ 	     1J   3   `s   + |    ל _ 'aFw  ;
  ,l 
+/   !  
R 	a     1P   . "  `|   @ |    ם _ 'a#}    %r 
(d     
 	 } j   1V   1 * O ̛ `   U |    מ _ 'a    y 
%  q   
ץ 	݄ M C   1]  
 % { f `   i |{    ן _W '`  [   
"  \   
N 	     1c 	 
   ӧ 1 `   ~ |v  ,  ן _  '`      
   G   
 	ئ     1i  
0    `    |q  9  נ ^ '`    	 
5 # 3   
K 	 َ  _ w 1u  
  * ˑ `    |g  S  ס ^y '`S  ڂ   
 1 
   
 	\ ^  K k 1{  
/ 
 U \ `    |b  a  ע ^A '`1  :   
 7     
ɞ 	 . Y 7 _ 1  
 	 π & `    |]  n  ף ^
 '`     
 >    
 
G 	́  1 # R 1  
  Ϋ  `    |X  {  פ ] '_     
: D     
 	    F 1  
-   ʻ `    |S    פ ] '_  Z  ߜ 
n K     
 	Ǥ Ο   : 1  
    ʆ `   $ |N    ץ ]c '_    أ 
	 R    # 
D 	7 o ߾  . 1  
  + P ` Ի  9 |I    צ ], '_    ѩ 
 X    , 
 	 @ ݘ  " 1  
,  U  ` Զ  N |D    צ \ '_a  z  	ʰ 
	 _    4 
@ 	  K  	 1  
߀  ɩ ɯ ` Ԭ  x |:    ר \ '_  :   q l ^   E 
 	 ð %   1  
+   z a ԧ   |5    ש \M '^#      s L   M 
 	     1  
   D a Ԣ   |0    ש \ '^,    
  y :   V 
= 	 O  o  1  
  &  a ԝ   |+    ת [ '^6  [     (   ^ 
 	6  в [  1  
)  O  a Ԙ   |&     ׫ [ '^?  	   ?   x  g 
 	  Ό G  1  
  x Ȣ a% Ԕ   |!    ׫ [o '^oH     r   p  o 
: 	Z  f 3  1  
~  ġ m a- ԏ   |    ׬ [8 '^LQ  {      g  x 
 	  @   1 ּ 
(   7 a6 ԋ  	 |  )  ׭ [  '^*[	        _   
7 	 -    1 ֳ 
}    aF Ԃ  3 |
  C  ׮ Z ']m    ~$ ?   N   
 	     1 ֮ 
'  C Ǖ aO ~  H |  Q  ׯ ZY ']v    w* s   F   
 	6     1 ֩ 
  k _ aW z  ] |  ^  װ Z" ']#  [  p0 ߦ   =   
2 	    v 1 ֥ 
y   ) a` v  q {  l  װ Y ']})    i6    5   
 	X i [  i 1 ֠ 
#    ah r   {  y  ױ Y '][0    b;    ,   
 	 9 5  ] 2 ֜ 
    aq n   {    ײ Y{ ']86  {  [A ?   $   
0 	~ 
  } Q 2 ֙ 
y  L  ay j   {    ׳ YD ']<    TG r  t    
 	   i D 2 ֕ 
$  } ̪ a g   {    ׳ Y '\C  ;  MM ѥ  Z    
. 	6 z  @ , 2 ֏ 
x   @ a a   {    ׵ X '\O    ?O   &    
 	 K q ,  2  ֌ 
#    a ^   {    ׵ Xe '\V  [  8U >  
    
 	]  J   2& ֈ 
  ?  a [   {    ׶ X. '\i\    1[ q      
- 	  "   2, օ 
x  o ˢ a X  * {    ׷ W '\Fc     *a ã      
 	     22 ւ 
# {  n a U  ? {    ׸ W '\$i  {  !#g       
 	     28  
 w  9 a R  S {    ׸ Wk '\o  ۢ  "m 	    ! 
, 	 [    2> | 
x r   a O  h {  
  ׹ W4 '[v  ;  #s ; 	   ! 
~ 	; +    2D x 
" m .  a M  | {    ׺ V '[|    $y n  w  ! 
z- 	|a  6   2P r 
y b  s a G   {  3  ׻ V '[w  Y  & A   eU  !) 
w 	y   v  2V n 
$ \  < a D   {  A  ׼ VV '[U    &I  " d;  !1 
u 	w m  b  2\ k 
 W   a A   {  O  ׽ V '[2&    'R 8 ) c"  !: 
s+ 	u <  N  2b h 
y Q   a >   {  ^  ׽ U '[/  z  ([ k / b	  !B 
p 	r   9  2i d 
$ K B  b  ;   {  l  ׾ U 'Z8  '  )d  6 `  !K 
n 	p@  q %  2o a 
 E e c b	 9   {  z  ׿ Uw 'ZA  :9  *m  < _  !S 
l* 	m } J  r 2u ] 
z @  - b 6  % {     U@ 'ZK  L  +u  B ^  !\ 
i 	kf {y #  f 2{ Z 
% :   b 4  : {     U 'ZT  ^  ,~ 3 I ] { !d 
e) 	f w   M 2 S 
y .   b+ /  e {     T 'Z@f    .  V [x j !u 
b 	d t   A 2 O 
% )  S b3 -  z {y     Tb 'Zp  w  /  \ Z` a !} 
`} 	a r   4 2 L 
 # 6  b< +   {s     T* 'Yy  |i  0  b YI Y ! 
^( 	_D p `  ( 2 H 
{  X  bD )   {m     S 'Y  [  1 , i X2 P ! 
[ 	\ nU :   2 C 
%  z  bL '   {h     S 'Y  <M  2 ^ o W H ! 
Y{ 	Zh l!  l  2 > 
   y bU %   {a     S 'Y  ?  3  u V @ ! 
W& 	W i ~ X  2 9 
}y  ߽ B b] #   {\     SL 'Yr  1  4  | T 7 ! 
T 	U g | D  2 4 
{%    bf "   {V     S 'YO  \#  5   S / ! 
P' 	P ca x~   2 + 
v|  "  bw   # {J  2   R 'Y
    7 W  Q  ! 
M 	NN a1 vY   2 & 
t'  C h b   8 {D  A   Rn 'X
  {*  8{ }  P  ! 
K| 	K _  t4   2 ! 
q  c 1 b   M {>  O   RR 'X
  >  9t z  O 
 ! 
I( 	Iw \ r   2  
o~  ڄ  b   b {8  ]   R 'X
  ;S  :m w  Nl  ! 
F 	G Z o   2  
m*  ٤  b   w {2  l   Q 'X
  g  ;g u  MW  ! 
D} 	D Xp m   2  
j    b    {,  z   Q 'X^
  |  <`
 rN  LB  ! 
B( 	B4 V@ k   2 
 
h   U b    {&     Qt 'X;
"  [  =Y o  K.  ! 
? 	? T iz   2  
f,    b    {      Q< 'X
(    >R l  J  ! 
;* 	: O e1 a r 2  
a  E  b    {     P 'W

5  zu  @C g  G  "
 
8 	8 M c L f 2  
_/  d y b    {     P 'W
;  t  A=  dE  F  " 
6 	6 KO ` 7 Z 3  
\   W b    {     P^ 'W
B  :s  B6 av  s  " 
4* 	3 I ^ " N 3	  
Z  	 ! b    {     P& 'Wm)
H  q  C/ ^  r  "' 
1 	1C F \ 
 B 3  
X1  /  b   4 z     O 'WJ2
N  p  D( [  q  "/ 
/ 	. D Zx  6 3  
U  T  b   I z     O 'W(;
U  Zo  E! Y	  p  "8 
-+ 	,l B XP  ) 3  
S  z  b   ^ z  	   O 'WD
[  m  F V:  o{  "@ 
* 	*  @[ V)   3"  
Q3   H b   s z     OH 'VN
b  l  G# Sk  n`  "I 
&- 	%) ; Q   3.  
L    c    z  3   N 'V`
n  k  I/ M  l+  "Y 
# 	" 9 O   34  
J4  
  c    z  B   N 'V|i
u  :j  I5 J  k } "b 
! 	 R 7 M {  3;  
G  1 o c     z  P   Nj 'VYs
{  i  J: H.  i t "j 
. 	 5e Kb f  3A  
E } U 9 c)    z  ^   N2 'V7|
  g  K@ E^  h l "s 
 	{ 35 I; S  3G  
C6 w z  c1    z  l   M 'V
  Zf  LF B  g d "{ 
 	 1 G ?  3M  
@ q   c9    z  {   M 'U
  e  ML ?  f [ " 
2 	 . D ,  3S  
> j  
G cB    z     M 'U
  c  NR < $ E S " 
 	9 , B   3Z  
<9 d  
 cJ   / z     MT 'U
  zb  OX :! * D J " 
5 	` (? >w   3f պ 
7 W   c[   Y z     L 'Ui
  :a  Qd 4 7 BU 9 " 
 	 & <P   3l ն 
59 Q = k cd   n z     L 'UF
  `  Ri 1 = A; 1 " 
 	
 # :)   3r ճ 
2 J \ 4 cl    z     Lv 'U$
  ^  So . C @" ( " 

: 	 ! 8  r 3x կ 
0 D z  cu    z     L> 'U
  Z]  Tu , I ?	   " 
 	 ~ 5  f 3 ի 
.= =   c}    z     L 'T
  \  U{ )B O =  " 
 	H L 3  Z 3 ը 
+ 7   c     z     K 'T
  Z  V &s U <  " 
> 	   1 | N 3 դ 
) 1  X c !   z     K 'T
  zY  W # [ ;  " 
  r  /i h B 3 ՠ 
'A *    c #   z|     K` 'Tx
  X  X   a :  " 	D   + A ) 3 ՙ 
"  - 
 c &   zo  :   J 'T3
    Zz 3 m 8x  " 	 1 X ( -  3 Օ 
 D  J 
{ c (  + zi  I   J 'T
    [ c t 7`  " 	  ' &   3 Ց 
  h 
D c )  @ zb  X   J 'S
  Y  \y  z 6I  # 	I [ 
 $   3 Ս 
 	  
 c +  U z\  f   JJ 'S#
    ]r   52  # 	   "   3 Չ 
H   	 c -  j zU  u   J 'S,
    ^k   4  # 	  	  Z   3 Յ 
   	 c /   zO     I 'S5  y  _d 
"  3  # 	O  c 4   3 Ղ 
   	f c 1   zH     I 'Se?  ٥  `] 
R  1  #% 	  3    3 ~ 
L   	/ c 4   zB     Il 'SCH  9  aV   0  #- 	T       3 v 

  .  c 8   z5     H 'RZ  E  cI   .  #> 	  n   |  3 r 
O  I  c ;   z.     H 'Rd!  \5  dB   -  #G 	  o t h  3 n 
  e Q d >   z(     H 'Rm'  %  e;! >  ,  #O 	Z ܙ ? N U  3 j 
  ܀  d
 @   z!     HV 'Rv.    f4$ n  +l  #X 	 /  ( A  3 f 
U  ۜ  d C  ' z     H 'Ru4  |  g-(   *W  #` 	۴   
 - } 3 b 
  ڷ  d F  < z  
   G 'RR:    h&+   )B v #i 	a Z  
  q 3 ^    r d' I  Q z     G 'R0A  ;  i/   (. n #q 	  |   e 4  Z Y   : d/ L  f z  (   Gx 'RG    j3 +  ' e #z 	i   i  M 4 S   !  d@ R   y  F   G% 'QT  Y  l	   $ T # 	 ˱  =  A 4 Q \  <  dI U   y  U   F 'QZ    m   # L # 	 G     5 4 N 	  V [ dQ Y   y  d   F 'Qa    m   " C # 	n     ) 4 L   o  dZ \   y  t   F~ 'Qbg  y  n    ; # 	 s X    4$ I b  n  db _   y     FF 'Q@m    o G   2 # 	 	 (  z  4* F   m O dk b   y     F 'Qt  9  p
 v   * # 	t   u f  40 D  z l  ds e   y     E 'Pz    q ץ   ! # 	! 5  M R  46 A h r k  d| h  $ y     E 'P    r     # 	{ a f  *  4B <  c i d d o  O y     E1 'P  h  td 0    # 	'  5    4H 9 n [ h * d r  d y     D 'Pr  S  ug _    # 	      4N 6  S g  d v  z y     D 'PP  {>  vj Ɏ    # 	 "     4T 3  M A`  d z   y     D 'P-  )  wm Ƽ ! 3  # 	/  Ф ]   4Z 0 s F @v  d    y     DR 'P'  ;  xp  & D  # 	 N t 6   4` .  @ ?  d Ԅ   y     D 'O0     ys  , U  $ 	  C 
   4e +  : > F d ԉ   y  -   C 'O9    zu H 2 f  $
 	: z     4k ( x 4 =  d Ԏ   y  ;   C 'OC  Z  {x w 8 
w  $ 	  Ű ݖ  r 4x "  ' ;  d ԙ   y  X   C= 'O`U    }z  D   $# 	E = À o m f 4~  | ! : _ d Ԟ   yy  f   C 'O=^  z  ~  J 
  $, 	  O H [ Z 4  )  : % d Ԥ  / ys  u   B 'Oh  w  ~ 0 O 	  $4 	 j  ! H M 4    9  d Ԫ  C ym     B 'Nq  :e  w ^ U   $= 	P     6 A 4  Ł  8/  d ԯ  W yf      B^ 'Nz  R  p  [   $E 	    $ 5 4  .  7C x e Ե  k ya      B' 'N  @  i  a   $N 	 -  Ъ  ) 4    6W > e Ի   yZ     A 'N  Z-  b  g   $V 	\  Z ΃   4    5j  e    yT     A 'Np    [  l   $_ 	   4   4    3  e%    yH     Ad 'N+   zk  M s x H o $p 	h   
  
 4    2 W e.    yB     A- 'N	  o  F  ~ \ g $x 	     
 4  8  1  e6    y<     @ 'M
  :s  ?   q ^ $ 	  e þ  
 4    0  e?    y5     @ 'M  x  8     V $ 	r I 1   
 4    /  eG    y/     @ 'M  |  1 *   M $ 	     n } 
 4  ;  . o eP     y)  #   @O 'M   Z  * X   E $ 	 ~u  F k 
 4    . 5 eX   3 y#  2   @ 'M^&    #    < $ 	} |
   X 
 4    -  ea   G y  @   ? 'M<-        4 $ 	~ w9 :  3 
 4    +7  er   o y  ]  
 ?p 'L9  ۤ     	 # $ 	| t 	    
 4    *I L ez    y
  l   ?9 'L@  ;   <     $ 	z6 rf   
 
| 4  E  )Z  e    y  z   ? 'LF     }i  7  $ 	w o  \  
o 4    (k  e    x     > 'LL    ! z  N 	 $ 	u m u 3  
c 5     '}  e %   x    
 > 'Ln"S  [  ' w  f  $ 	sC k+ E   
W 5  K  & d e -   x    
 >[ 'LL+Y    - t  ~ 
 $ 	p h    
J 5
    % ) e 4   x     ># 'L*4`    3 r   
 $ 	n fX    
> 5    $  e <   x     = 'L>f  {  9 oL   
 $ 	i a  j  
% 5   z " z e K  " x     =| 'KPs  9z   i   
 %	 	g _ O A v 
 5%   s ;  e S  5 x     =E 'KZy     f  l 
 % 	e[ \   d 
 5+  W l > l e [  I x     =
 'Kc     d   
 % 	c	 ZK   P 
  51   e A 0 e b  ^ x     < 'K]l  Y  	 a/   
 %" 	` W   >  58   ^ D  e j  r x     < 'K;v     ^\   
 %+ 	^h Uy   +  5>  ^ W G  e r   x  ,   <g 'K     [  , 
 %3 	\ S }Z x   5D   P J | e z   x  <   <K 'J  y   X   ] 
 %< 	Y P {* Q   5J   I L @ e Ղ   x  K   < 'J    ' U   
 %D 	U# K v     5V Կ { ; Q  f Ւ   x  i   ; 'J  K  ! P=   
 %U 	R In t    5\ Լ x 3 S  f ՚   x  y   ;m 'Jn  Y  ) Mi  # 
 %^ 	P G re    5b Ժ vm , U P f բ   x     ;5 'JK  Yf  1 J  U 
y %f 	N1 D p5    5h Է t ' G d f$ լ   x     : 'J)  t  |9 G "  
p %o 	K B5 n `   5n Ե q " m + f- շ  " x     : 'J    uA D (  
h %w 	I ? k 8  y 5t Բ op    f5   4 x     : 'I  y  nI B -  
_ % 	G> =b i  q l 5z ԰ m   Ը f>   F x{     :W 'I  ٝ  gQ ?I 3 G 
W % 	D : go  ^ ` 5 ԭ j    fF   X xw     : 'I  9  `Y <u 8 w 
N % 	@M 6) c
 | : H 5 Ԩ f  *  fW   { xo     9 'I\  F  RV 6 C  
= % 	= 3 ` zo ( < 5 ԥ c  P  f`    xk     9y 'I:  YW  K_ 3 I 
 
5 % 	; 1Y ^ xG  0 5 ԣ at  u ә fh    xf     9A 'I  i  Dh 1' N < 
, % 	9\ . \| v  # 5 Ԡ _   ` fq    xb      9
 'H  z  =p .S T n 
$ % 	7 , ZK s   5 ԝ \   & fy    x^      8 'H  y  6y + Y  
 % 	4 *  X q   5 ԛ Zv    f &   xZ     ! 8 'H'  ٝ  / ( _  
 % 	2k ' U o   5 Ԙ X#   ҳ f 2   xU  -  " 8c 'H0  9  ( % d  
 % 	0 %Q S m   5 ԕ U  - y f >   xQ  :  " 8+ 'Hm:    ! # j 7 
 % 	+y   OW i0   5 Ԑ Q%  u  f U   xH  S  $ 7 'H)L  [z   [ u   % 	))  M& g   5 ԍ N    f a  , xD  `  $ 7 'HV%  {    z   % 	&  J d q  5 Ԋ L|   ѓ f m  > x@  l  % 7M 'G_,  |       % 	$ H H b _  5 Ԉ J(   Y f y  P x;  y  & 7 'Gh2  {}     8  & 	"9  F ` M  5 ԅ G    f ֆ  a x7    ' 6 'Gr8  ~     l  & 	 x D` ^i :  5 ԃ E  (  f ֒  s x3    ' 6 'G{?  ;    7    & 	  B/ \B (  5 Ԁ C,  K Ь f ֞   x/    ( 6o 'G\E     c    &! 	H  ? Z   5 } @  n r f ֫   x*    ) 67 'G:K     	  
  &* 	 
 ; U  l 5 x </    f    x"    * 5 'FX       u  &; 	Y r 9j S  ` 5 w 9    f    x    + 5 'F_         &C 		 
 78 Qw  S 6 v 7   ϋ g    x    , 5Y 'Fe  z1   
>    &L 	  5 OM  G 6 t 53   Q g
    x    , 5" 'Fk  J   
j    &T 	
h : 2 M#  : 6 s 2  >  g    x    - 4 'Fnr  :d   
  M  &] 	  0 J  . 6 r 0  `  g    x    . 4 'FLx  }   
   y &e 	 k .s H  " 6 p .7   Σ g$   ! x    . 4{ 'F*~     
   q &n 	x  ,B F n  6# o +   i g,   3 x    / 4C 'F  Z  # 
   h &v 	 2 ' BS H 
 6/ l '9  @  | g= :  U w  9  1 3 'E    Ö 
o  % W &   % @( 5 
 65 k $  ?1 @ gF G  g w  F  1 3 'E  y  ď 
  %) O & 7 c #{ = " 
 6; i "  >B  gN T  y w  T  2 3 'E  /  ň( 
  ${ F &   !K ;  
 6A h  > | =S  gW a   w  a  3 3I 'E]  :w  Ɓ9 
  # > &    9  
 6G f  w <d ό g_ o   w  n  3 3 'E;    zJ 
  # 5 & G -  7  
 6M e  q ;t P gh |   w  |  4 2 'E#    sZ 
F  "q - &    5Z  
 6S c C l :  gp ׊   w    5 2 'D,  [N  ll 
q  ! $ &  ^  31  
 6Y b  g 9  gy ח   w    6 2k 'D6    e} 
֜  !  &  ߏ $ .  
 6e _ H \ 51 UN g ׳   w    7 1 'DH  {  W 
  q  &  )  ,  
 6k ]  X 4] U g    w    8 1 'DoR    P 
    & h   * x 
v 6q \ 
 T 3 T g    w    8 1 'DM[  ;  I 
H    &  [ 
 (c e 
j 6v Z K P 2 T g   % w    9 1U 'D+d    B 
s  P  &   a &9 S 
] 6| X  M 1 Tg g   5 w    : 1 'D	n    ; 
ŝ    & y ӌ 	0 $ A 
Q 6 W  I 1 T- g    E w    ; 0 'Cw  [  4 
     & * %  ! / 
D 6 U L E 0; S g   V w    ; 0 'C    - 
 % 1  '  ξ    
8 6 S  A /g S g   f w    < 0w 'C    & 
 + }  ' >   n m  
  6 P P 9 - SE g ?   w    = 0 'C^    S 
t 5   '!  Ǌ = D  
 6 N  6 , S g O   w  '  > / 'C<  8  Y 
 : a  ') Ӡ #    
 6 L  2 , R g _   w  3  ? / 'C    
a 
 @   '2 R ¼    	 6 K S . +A R g o   w  ?  ? /a 'B    i 
 E   ':  U    	 6 I  * *m R] g ؀   w  K  @ /* 'B  X  p 
 J G  'C ̴  z   	 6 G  & ) R# h ؐ   w  W  A . 'B$    w 
I O   'K e  I w  	 6 E U " ( Q h
 ؠ   w  c  B . 'B+    ~ 
s T   'T  !  N ~ 	 6 C    ' Q h ر   w  n  B . 'Bp1  y   
 Y /  '\ y U   [ 	 6 @ X  &B Q: h#    w    D . 'B,>  9  ٭ 
 d  q 'n *    I 	 6 >   %l Q  h,   % w    D - 'B
D    ҵ 
 i  i 'v   S  7 	 6 <   $ P h4   5 w    E - 'AJ    ˼ 
F n h ` '    "  % 	 6 : X 
 # P h=   E w    F -m 'A
Q  Y   
p s ܷ X ' <   Y  	 6 8   " PQ hE   U w    F -6 'AW     
 x  O '  U  1  	v 6 6 ܱ  " P hN '  e w~    G , 'A ^     
 ~ U G '   ߒ   	j 6 4 \  !> O hV 8  u wz    H , 'A`)d  y   
  ڤ > ' P  a   	^ 6 1    g O h_ I   ww    I , 'A>2j     
   6 '       	F 7 - `   O- hp l   wp    J ,  '@Ew     
l  ؔ % ' e W  g  	: 7 +    N hy ~   wl    K + '@N}     
    '   ԟ >  	. 7
 ) η   N h ُ   wi  	  K + '@X  Z    
~  5  '   o   	" 7 ' c  4 N} h ١   we    L +y '@a    % 
{  ֆ  ' { % >  v 	 7 %   
 O< h ٳ   wa  !  M +B '@sk    + 
y    ' ,  
  d 	
 7 # Ǻ  
 O  h    w]  .  M +
 '@Qt  z  x1 
v=   
 '  Y   S  7# ! g  
- N h    wY  :  N * '@/}    q7 
sf  [ 
 '   ɭ s A  7)    
G N h    wU  F  O * '@
  :  j= 
p   
 '  ) N #   74  l  
{ N h   2 wN  _  P *H '?  2  \ 
j   
 (     
  7:    
ϕ M h   B wJ  k  Q * '?  Y>  U
 
h
   
 ( X ^     7?    
ή M h /  R wE  x  R ) '?  J  N 
e7  i 
 ( 
   ڪ   7D  q  
 MZ h A  b wA    R ) '?c  V  G 
b`  ~ 
 (!    ؁   7J    
 M h T  q w>    S )j '?A  yb  @$ 
_  ~= 
 () n }- _ Y   7O    
 L h f   w:    T )2 '?  m  9, 
\  } 
 (2   z 0 1   7U  v  
 L h x   w6    U ( '>  9y  24 
Y  } 
 (:  xb  	   7Z 
 "  
 B h ڋ   w2    U ( '>    +< 
W  ; 
 (C 6 s  ͷ  n 7e  x  
9  i
 ڲ   w,    W (T '>  [%   
QW   
 (T  q1 q ˏ o b 7j  $  
d  i    w)    W ( '>u  !   
N  e 
 (\  n A g ^ V 7p    
ɏ V i    w&    X ' '>S     
K   
z (e ~L lf  > L J 7u  {  
ȹ  i#    w#    Y ' '>2
  {   
H  - 
q (n { i   : > 7z   $  
   i,     w     Y 'v '>     
E    
i (v y g   ( 2 7    
   i4    w    Z '> '=
  ;   
C%   
` ( w` e3    & 7  {  
9  j i= (   w    [ ' '=&     
@N 
 \ 
X ( u b O    7  '  
c  / iE <  % w    \ & '=/  
   
=w   
O ( pw ^  J   7  ~  
÷  iW d  C w  4  ] &` '=fB#      
7   
> ( n* [  "   7  *  
 } i_ y  Q w
  ?  ^ &( '=DL*     
4   
6 ( k Y9     7   } 

 B ih ۍ  ` w
  K  ^ % '="U0  {{   
2 # X 
- ( i V `    7   y 
4  ip ۡ  o w  W  _ % '= ^6  n   
/C (  
$ ( gB Tn 1    7  - u 
]  iy ۶  } w  b  ` % '<h=  ;a   
,l - & 
 ( d R	     7   r 
  i    w   n  ` %J '<qC  T   
) 2  
 ( b O  Y   7   n 
 U i    v  y  a % '<{I  G   
& 6  
 ( `[ M?  2 o  7  1 j 
  i    v    b $ '<yP  [:   
# ; [ 
 ( [ Hu D  M  7   c 
*  i    v    c $l '<5]    	 
7 E + 	 ( Ys F   =  7  }4 _ 
S g i 3   v    d $4 '<c  {  
 
_ J  	 ( W& C   , | 7  z [ 
{ , i H   v    e # ';i     
 O  	 ( T AF  i  p 7  x W 
  i ]   v    e # ';p  :   
 T d 	 ) R >  B 
 d 7  v7 S 
  i r   v    f # ';v    
 
 X  	 ) P? <| X   X 7  s P 
 z i ܇   v    g #V ';|    } 
 ] 6 	 ) M : })   L 7  q L 
 > i ܝ   v    g # ';j  Z  v 

* b  	 )! K 7 z   @ 7  o< H 
D  i ܲ  * v    h " ';H    o 

R g 	 	 )* G 2 v |  ' 7  j A 
  i   G v    j "x ';  z  a 
 p  	 ); D 0 tm T   7  h@ = 
e   i   U v    j "@ ':    Z  
 u  	 )C Bq .  r= ,   7  e 9 
  j 	  d v    k "	 ':  :  S% 	 z  	 )L @$ + p    8  c 5 
  j
   r v  (  l ! ':    L* 	   	 )T = )W m  s  8  aE 0 
~ j j 4   v  4  l ! ':}    E/ 	C   	 )] ; & k  b  8
 ӽ ^ , 
} . j J   v  ?  m !~ ':[  Z  >3 	k   	y )e 9< $ i~  Q  8 ӻ \ ( 
|  j$ `   v  L  n !* ':9$    79 	   	q )n 6 "% gO e @  8 Ӹ ZF $ 
|  j, v   v  W  n ! ':-    0> 	   	h )v 2V ] b    8! Ӳ U  
zO ; j= ݢ   v  o  p   '9@  ل  "  	  y 	W ) 0	  ` } 
  8& Ӱ SK  
yk  jF ݹ   v  {  q  h '9I  9  & 	3   	O ) -  ^ {   8+ ӭ P  
x  jN    v    q  0 '9S    , 	[  s 	F ) +o 0 \d y   80 Ӫ N  
w  jW    v    r  '9n\  }  
1 	   	> ) )"  Z5 wy   85 ӧ LP  
v I j`     v    s  '9Lf  Yz  7 	ߪ  o 	5 ) & h X uR  ~ 8: Ӥ I  
u  jh    v    s  '9+o  x  < 	   	- ) $  U s*  r 8? Ӣ G  
t 
 jq )   v    t R '9	x  u   B 	   	$ ) "<  S q  f 8D ӟ ET 
 
s  jy @  * v    u  '8  ys  !H 	!  $ 	 )   OJ l  N 8N ә @ 
 
q Y j o  E v    v  '8	  8  #5 	q   	
 ) W t M j t B 8S Ӗ >Y 
 
q  j ކ  S v    w t '8    $< 	Θ   	 ) 
  J hf b 6 8X ӓ < 
 
p<  j ޞ  ` v    x < '8`    %B 	    )    H f@ Q * 8] Ӑ 9 
 
o` Ф j ޵  n v    x  '8>  X  &H 	    ) q I F d @  8b Ӎ 7] 
 
n g j   { v    y  '8"    'N 	    ) $  D_ a /  8g ӊ 5	 
 
m + j    v    z  '7)    (T 	6    )   B0 _   8l Ӈ 2 
 
l  j    v    z ^ '7/  x  )[ 	^    * 
  @ ] 
  8q ӄ 0a 
 
k ϲ j    v  *  { ' '75  س  *a 	    *  U ; YU   8{ ~ + 
 
j7 : j D   v~  B  }  '7sB  b  , 	  }  *"   9s W.   8 { )e 
 
iZ  j \   v{  M  }  '7QH  Y  - 	    ** Y  7D U   8 x ' 
 
h}  j t   vx  X  ~ H '70O  ZP  . 	!  y  *3 
 * 5 R   8 u $ 
 
g ΄ j ߌ   vt  d    '7U  H  / 	H    *;   2 P   8 r "i 
 
f H j ߥ   vq  p    '6\  ?  0 	o  v  *D u c 0 N   8 o   
 
e  k ߽   vn  {  ؀  '6b  z6  1 	    *L )  . Ll   8 l  
 
e	  k    vk    ؁ j '6"h  .  2z 	 
 u  *U   ,Z JF w  8 i o 
 
d, ͓ k    vh    ؁ 3 '6+o  :%  3s 	    *] D  ' E W w 8 c  
 
bp  k$   6 va    ؃  '6C>{    5e 	2   p *o  n % C G k 8 _ o 
 
a  k- 8  C v^    ؄  '6"G  Z  6^ 	Y  t h *w   # A 7 _ 8 \  
 
` ̡ k5 Q  P v[    ؄ T '6 Q  }  7W 	 !  _ * a ը !l ? ( S 8 Y  
 
_ d k> j  ] vX    ؅  '5Z  p  8P 	 & u W *  E = =[  H 8 V 
u 
 
^ ' kG   j vU    ؆  '5d  zd  9I 	 *  N *    ;4  < 8 S ! 
 
^  kO   w vQ    ؆  '5m  W  :C 	 / x E * ~ }  9  0 8 O  
 
]< ˮ kX    vN    ؇  '5yw  :K  ;< 	 3  = * 3   6  $ 8 L z 
 
\^ r k`    vK    ؈ Z '5W  >  <5	 	B 8 { 4 * ߛ S R 2   8 F  
 
Z  kq    vE    ؉  '5  [  >'4 	 A ׀ # * O  # 0s    8 B 
~ 
 
Y ʼ kz    vA    ؊  '4    ? 6 	 E   *    .M   8 ? 
+ 
 
X  k 4   v>  *  ؋ | '4    @9 	~ J օ  * ظ ( 
 ,%   8 < 
 
 
X B k N   v;  5  ؋ E '4  z  A< 	| N  	 * n   )   8 9 
 
 
W$  k h   v8  A  ، 
 '4  ڰ  B? 	y) R Ջ  * " b 	g ' {  8 6 
/ 
{ 
VE  k    v5  M  ؍  '4k  :  CA 	vO W   *    9 % l  8 3 
 
w 
Uf Ɍ k    v1  X  ؍  '4I    CD 	sv [ ԓ  * ό   # \  8 0 
 
s 
: t k    v.  d  ؎ f '4(  o  DG 	p `   *     ; =  9 * 
 
j 
9  k    v'  |  ؏  '3  /  Fp 	j i   +	 Ȫ s }  .  9 ' 
 
f 
89 Ƚ k   * v$    ؐ  '3    Gq 	h m .  + _  O    9 $ 
: 
b 
7T  k   7 v!    ؑ  '3  z  Hq 	e5 q   +   "   | 9 ! 
 
^ 
6o B k 8  C v    ؒ Q '3    Ir 	b\ v J  +#  J    p 9  
 
Z 
5  k R  P v    ؒ  '3]
  :  Jq 	_ z   ++ ~   {  d 9  
@ 
V 
4  k m  \ v    ؓ  '3<  z  Kr 	\  g  +4 3   T  X 9  
 
R 
3 ǋ k   i v    ؔ  '3   V  Ls 	Y    +<  # h .  L 9#  
ܚ 
M 
2 N k   u v    ؔ r '2*  Z2  Mt 	V    +E R ] 
   3 9,  
 
E 
0  l    v	    ؖ  '2=(  V  O 	Q@  ρ  +V    	  ' 91  
՝ 
A 
/  l    v    ؗ  '2F.  z"  P 	Nf    +_       96  
J 
= 
/ D l 
   v    ؗ  '2rO4    Q 	K  Ξ x +g p 3 | j   9:  
 
9 
.1  l% (   u  	  ؘ ] '2PY;  9  R 	H  , o +p %  N D s  9?  
Σ 
5 
-O  l. C   u    ؙ A '2.bA    S~ 	E  ͻ g +x  m   c  9D  
O 
1 
,m  l7 ^   u  !  ؙ 	 '2
lG  S  T| 	B  K ^ +    
 S  9I  
 
- 
+ P l? z   u  ,  ؚ  '1uN  Y  Uz 	@$   U + D   
 D  9M  
ǩ 
) 
*  lH    u  8  ؛  '1T    Vxx 	=J  j M +   f 
 %  9W  
 
! 
(  lY    u  O  ؜ + '1a  z  Xj 	7  ˊ < + c  7 
\   9[  
 
 
' [ la    u  [  ؝  '1dg    Yc 	4   3 +   	 
6   9`  
Z 
 
'  lj    u  g  ؞  '1Cn  :  Z\ 	1  ʫ + +    
   9e  
 
 
&9  ls    u  r  ؞  '1!t    [U 	/  < " +  }X Ь 
   9i  
 
 
%U  l{ ;  + u  ~  ؟ M '0z    \N 	,+    + 8 z ~ 
   9n  
` 
 
$r g l W  7 u    ؠ  '0  Z  ]G 	)Q  _  +  x P 
  ~ 9r  
 
 
# ) l s  C u    ؠ  '0    ^@ 	&v    +  v/ ! 
v  r 9w  
 
 
"  l   O u    ء  '0    _9 	#  ȃ   + 
 ql  
*  Z 9  
  
  r l   f u    آ 7 '0W  Q  a+ 	  ǩ  +  o	 Ø 
  N 9  
  
 5 l   r u    أ   '05  9P  b$ 	
  ;  + w l j 
 x B 9  
l  
  l    ~ u    ؤ  '0  O  c 	2    , - jF < 
޸ h 7 9  
  
7  l    u    إ  '/  N  d 	W  b  ,
  g  
ܑ Y + 9  
  
R } l 9   u    إ Y '/  YN  e 	}    ,  e  
k I  9  
r  
n @ l V   u    ئ ! '/  M  f 	  Ŋ  , N c   
F ;  9 Ҿ 
  
  l s   u    ا  '/  L  g 	    ,$ } `  
  ,  9 һ 
  
  l    u    ا  '/l)  yK  g 		  ĳ  ,, xo [ ) 
   9 Ҵ 
&  
 J l    u  "  ة _ '/(<  :"  i 	6    ,> v% Y  
ϭ    9 ұ 
  
 
 l    u  .  ت ' '/E    j% 	[  r  ,F s W4  
ͅ   9 ҭ 
}  
  m    u  :  ت  '.O    k+     ,O q T  
_   9 Ҫ 
*  
+  m
     u  F  ث  '.X  Z  l0     ,W oE Rq p 
9   9 Ҧ 
  
F U m =   u  Q  ج  '.a    m5   4  ,` l P A 
   9 ң 
  
a  m Z   u  ]  ج I '.k  	  n:    v ,h j M  
   9 ҟ 
0  
{  m' x   u  i  ح  '._t  z  o@   a n ,q hh KL  
   9 Ҝ 
  
  m/    u  u  خ 
 '.=~     pE 9    e ,z c F  
z   9 ҕ 
7  	z  mA   4 u    د 
k '-
    r|  ( , T , a D& ] 
S { x 9 ґ 
  	  mI   ? u    ذ 
3 '-    s  ,  K , _? A 1 
. l l 9 Ҏ 
  	 \ mR   J u    ر  '-  [   t  0  C , \ ?c  
 ] ` 9 Ҋ 
}=  	  mZ *  U u    ر  '-     u  4 : : , Z =  
 N T 9 ҇ 
z  	  mc H  ` u    ز  '-t'    v  8  2 , Xb :  
 @ H 9 ҃ 
x  	  ml f  k u    س U '-R-  z  w : <  ) , V 8> z 
 1 < 9  
vC  	 d mt   v u    س  '-13    x _ @ J   , S 5 M 
p " 0 9 | 
s  		 & m}    u}    ش  '-:  :  y} ք D   , O: 1  
$   9 u 
oJ  	1  m    uv    ض w ',F    {o  L ]  , L .  
   9 r 
l  	E m m    us    ض ? ',M  Z  |h  P   , J ,V  
    :  n 
j  	Y / m    up  
  ط  ',S    }a  T   , H\ ) i 
   : k 
hP ~ 	l  m :   ul    ظ 
 ',gZ    ~Z : X r  , F ' < 
   : g 
e z 	  m X   ui  $  ظ 
 ',F`  z  S _ \ $  , C %2  
f   :
 d 
c v 	 u m w   uf  0  ع 
} ',$f    L  `   - A " } 
@   : ` 
aX r 	 Sv m    uc  <  غ 
E ',m  :  E  d U  - ?6  p { 
   : ] 
_ n 	 S9 m    u`  G  غ 
 '+(s    >  h   - :  wX 
   : V 
Z] g 	 R m    uZ  ]  ؼ 	 '+;  Z  0  p ^  -% 8X L u+ 
 p  :" R 
X
 c 	 R m    uX  i  ؽ 	g '+|E    ) 9 t   -. 6  r 
 a  :& O 
U _ 	 RB m 3   uU  t  ؽ 	0 '+[N    " ] x   -7 3  p 
\ R  :+ K 
Sc [ 	K W m R   uR    ؾ  '+9X  z    | 	  -? 1y % n 
3 C | :/ G 
Q W 	b Wg m q   uO    ؿ  '+a  ڱ       -H /0  lq 

 4 p :3 D 
N S 	y W) n   ' uL    ؿ  '*j  :  
   ~  -P , 
c jC 
 % d :7 @ 
Le O 	 V n   1 uI     Q '*t       8  -Y *  h 
  X :< < 
J L 	 V n   ; uF      '*}  x      } -b &	 @ c 
u  @ :D 5 
Ek D 	 V1 n)   O u@      '*p     Z  j l -s #  a 
P  4 :H 1 
C @ 	 U n1 0  X u=     s '*O     ~  % c -{ !v } _` 
*  ( :M . 
@ < 	 U n: P  b u:     < '*-£  y      [ - -  ]2 
~   :Q ) 
>q 8 	 Ux nB p  l u7      '*­       ՝ R -   [ 
{   :U % 
< 4 	. U: nK   v u4      ')¶  9     Z J -  Z X 
y   :Y ! 
9 0 	D T nT    u1      ')    
    A - Q  V 
w    :]  
7x , 	Z T n\    u.     ] ')    
 2   8 -   T~ 
us    :b  
5% ( 	p T ne    u,     & ')  Y   V  ԑ 0 - u  P# 
q* s   :j  
0   	} T nv 2   u&  +    ')C       
  - , w M 
o e   :n 
 
.,  	| S n R   u#  6    ')!  y   	     -   K 
l V   :r  
+  	{ S n s   u   A   c ')      }  Ӊ 
 - 
  I 
j G   :v  
)  	z SJ n    u  M   , '(  9   {  H  - R U Gq 
h 9   :{  
'4  	y S
 n    u  X    '(     x,    - 	  EC 
fu *   :  
$ 
 	y R n    u  d    '(    $ uP    -   C 
dP    :  
" 	 	x R n    u  o    '(z  Y  + rs  ҆  - w 4 @ 
b,    :  
 <  	w0 RS n    u  z   N '(X(  "  2 o  E  -  r < 
]   g :  
  	uY Q n Y   u      '(;,  {5  t i    .   :d 
[   [ :  
B  	tn Q n z   u      ''E2  1  m g   ц  . R ֱ 88 
Y   O :  
  	s Q[ n   
 u     o ''N9  ;-  f d$  G  . 
 Q 6
 
Wv   C :  
  	r Q n    u     8 ''X?  )  _ aG    .'   3 
UP   7 :  
I  	q P n     t       ''aE  %  X ^k    .0 x ϐ 1 
S-   + :  
  	p P n    ) t      ''nkL  [!  Q [  Ћ  .9 , - / 
Q    :  

  	o Pc n !  2 t      ''MtR    J X  M  .A   -Z 
N    :  
N  	n P% o  C  ; t     Z ''+~Y    C U    .J S 
 ) 
J l  : ѿ 
  	m O o   M t      '&Ðe  !  5M P  ϕ  .[ 
 ì & 
Hs ]  : Ѻ 
U  	l$ Ol o   U t      '&Úl  8)  .T M?  X { .d  L $ 
FO O  : Ѷ 
  	k7 O. o"   ^ t     { '&ãr  2  '\ Jc   s .l w  " 
D* @  : ѱ 	  	jK N o+   g t     ` '&íx  :   c G   j .u /   V 
B 2  : ѭ 	\  	i^ N o3 
  p t  &   ( '&cö  XB  i D 	 Σ a .}  * + 
? #  : Ѩ 		  	hr Nt o< /  y t  2     '&A  K  r A 
 g Y . ڝ   
=   : Ѥ 	  	g N6 oD Q   t  =     '&   S  y >  , P . T j  
;   : Ѡ 	c  	f M oM t   t  I     '%  x[   <   H .   | 
7N   : і 	  	d M} o^    t  `     '%  :[   6W  { 6 . z H R 
5*   : ђ 	j  	c M? og    t  k    '%  Z   3z  A . . 1  ( 
3  u : э 	  	c r op    t  v    '%y  Y   0 # 	 % .    
0  h : щ 	  	c
 4 ox     t     l '%W  ZX   - & 	y  . ʠ (  
.  \ : ф 	q  	b(  o C   t     4 '%6  W   * * 	8  . W  
 
,  P : р 	  	aF  o f   t      '%  U   ( - 	  .  g { 
*u  C : { 	  	`d { o    t      '$  zT   %( 1 	  .   Q 
(Q  7 : w 	w  	_ = o    t      '$(  S   "K 5 	y  . 6 H  
$
 e  : k 	  	]  o    t      '$;      < 	  .   
 
! W  : e 	  	\  o    t      '$nE      ? 	  .   
 
 H  : _ 	,  	[ F o 9   t      '$LN  Y    C 	}  / ] ) 
{ 
 :  : Y 	  	[  o ]   t     x '$+X  $    G 	>  /   
Q 
 +  : S 	Ӈ  	Z2  o    t     \ '$	a  +    J 	   /  i 
% 
b   : M 	3  	YO  o    t     $ '#k  y1   > N 	  /!  	 
 
@   ; G 	 } 	Xl N o    t      '#u  7   a Q 	  /* 9  
 
   ; A 	̉ y 	W  o    t      '#~  9=    U 	H  /2   
v 
   ; 5 	 r 	/ q o 3  * t  '   F '#bđ    ya  \   /D `  
K 
   ; / 	Ő n 	.3 3 p W  2 t  2    '#Aě  [   re  _   /L  ' 
  
   ; ) 	= j 	-I  p z  9 t  =    '# Ĥ    kk 
 c   /U  ~ 
 
p   ; " 	 g 	,_  p   A t  H    '"Į%    dp / f   /]  |g 
 
O   ;  	 c 	+u z p   H t  S   h '"ķ+  z  ]u Q j ^ y /f > z 
 
,  r ;  	C _ 	* < p$   P t  ^   0 '"1    Vz t m 0 p /o  w 
t 
  f ;  	 [ 	)  p- 
  W t  i    '"8  :  O~  q  h /w  uH 
J 
 { Z ;" 
 	 W 	(  p6 /  ^ t  t    '"y>    H  t  _ /  p 
  ] A ;(  	 P 	& D pG w  m t     R '"6K  Z>  :y  { y N /  n) 
  O 4 ;,  	 L 	%  pP   t t      '"Q  =  3~  ~ K E /  k 
֞ a @ ( ;/  	R H 	%
  pX   | t      '!X  <  , B   < / E ij 
s ? 1  ;2  	 D 	$"  pa    t      '!^  z:  % d   4 /  g
 
H  #  ;6  	 A 	#7 M pi 	   t     t '!
d  9   ݆   + /  d 
    ;9  	Y = 	"L  pr .   t     < '!k  :8   ڨ   # / m bK 
    ;=  	 9 	!a  p{ R   t       '!n q  6     n  / % _ 
    ;A  	 5 	 v  p w   t}      '!M)w  5  	   B  /  [. 
i t   ;I  	 - 	  p    tx     z '!
<    Y 1     / N X 
= R   ;M  	 ) 	  p    tu     B ' F  /  d S    / } Vo 
 1   ;P к 	j & 	  p    tr      ' O  xP  o u    / z T 
    ;T е 	 " 	 _ p 0   tp      ' Y  q  z Ɨ  m  / xv Q 
    ;X Ю 	  	 ! p U   tm      ' b  8  ߅ ù  C  0 v/ OR 
    ;\ Ш 	q  	  p z   tj  '   d ' dl    ؏     0
 s L 
` ݩ   ;` У 	  	  p    th  2   , ' Bu    ћ     0 q J 
4 ۇ t | ;d Н 	  	. h p    te  =    ' !  X  ʧ     0 m E 
 @ X b ;k Б 	$  	V  p    t`  T    'Œ  d  ۼ b  u  0, j Ct 
  J V ;o Ћ 	  	j  p 5   t]  _   N 'Ŝ  x  ܵ   M  05 h~ A 
  < J ;r Ѕ 	~  	~ q p Z   tZ  j    'ť    ݮ   %  0> f7 > 
T  . = ;v } 	, 
 	 3 p    tW  u    '{ů  9!  ާ     0F c <V 
( μ   1 ;y u 	 
 	  q    tU      'YŸ  `  ߠ     0O a 9 
 ̝  % ;} m 	} 
 	  q
    tR     p '8     
    0X _` 7 
 }   ; e 	{3 
 	 z q    tO     8 '  Y   ,    0` ] 59 
 _   ; ^ 	x 
 	 < q    tM       '    
 M  ` v 0i X 0z 
M     ; N 	t; 
 	 
 q0 b  $ tG      '  {  ~9    e 0z VB . 
!    ; E 	q 
 	
 
 q9   * tE     v '    w=    \ 0 S + 
    ; = 	o 
 	+ 
E qA   0 tB     > 'p  :  pC    T 0 Q )\ 
    ; 5 	mA 
 	> 
 qJ   6 t?      'O
    iG    K 0 Ol & 
    ; - 	j 
 	
q c qR   < t=      '.    bL   	H B 0 M# $ 
r    ; % 	h 
 	 % q[ !  B t;      '
  Z  [P 7  	H : 0 J "@ 
G f   ;  	fI 
 	  qd H  H t9     ` '!    TU Y  	Hr 1 0 H  
 F y  ;  	c 
 	
 Ǫ ql o  M t7     ) '+$    MZ z  	HD ( 0 D $ 
 	 ]  ;  	_P 
 		 . q~   X t3      '>0    ?h   	G  0 A  
  P v ;  	\ 
 	7  q   ] t1  $    'fG7  :  8m ~  	G  0 ?w f 
l  A i ;  	Z 
 	X Ʋ q   c t.  /  	 J 'EQ=    1r |   	G  0 =0  
B  3 ] ;  	XV 
 	x u q 2  h t,  9  
  '$ZC    *v y!  	Gd  0 :  
  & P ;  	V 
 	 7 q Y  n t*  D  
  'dJ  Z  #{ vB  	G8  0 8 J 
 o  D ;  	S 
 	  q   s t(  O    'mP     sc  	G  0 6[  
 Q 
 7 ;  	Q^ 
 	 ż q   x t&  Y   l 'wW     p  	F  0 4 
 
} 1  * ;  	O	 
 	 ~ q   } t$  d   5 'ƀ]  z   m 	 	F  1 /  
y>    ; ϻ 	Je 
 	;  q    t   y    ']Ɠj  8G   ; g  	F`  1 -< n 
w    ; ϳ 	H 
 	 [  q E   t      ';Ɲp  H  A e
  	F5  1 *  
t    ; Ϫ 	E 
 z ć q l   t     r 'Ƨv  I  G b+  	F  1' (  
r    ; Ϣ 	Ch 
  I q    t     ; 'ư}  XK  M _L  	E  1/ &g R 
p y   ; Ϛ 	A 
   q    t      'ƺ  L  T \m  	E  18 $   
na Z   ; ϑ 	> 
   q    t      '  M  Z Y  	E  1A !  
l6 ;   ; ω 	<o 
  Ð q    t      '  xN  ` V ! 	Ed  1I  8 
j  ~  ; ρ 	: 
  R r 3   t     \ 't  P  f S $ 	E;  1R  z 
e  b  ; p 	5v 
 W  r    t
      '2     N + 	D | 1c   
c  T  ; h 	3# 
 v  r"    t      '     K2 . 	D s 1l u  
a]  F  ; _ 	0 
  \ r*    t	     ~ '  Y    HS 1 	D j 1u . _ 
_2  9 { ; W 	.~ 
   r3    t     G '     Et 4 	Dr b 1}   
] g + n ; N 	,* 
}   r< "   t      '     B 7 	DJ Y 1   
Z H  a ; F 	) 
z   rD J   t  
    '  y   ? : 	D# P 1 
Z E 
X ~+  U ; = 	' 
v  e rM s   t      'k#     < = 	C H 1   
V |
  I ; 5 	%2 
s 0 ' rV    s  #   h 'I,  9   9 @ 	C ? 1  + 
R* w  0 < # 	  
l m  rg    s  8    '?  t   49 F 	C . 1 @  
O u  # <  	; 
i ͡  ro    s  B    'I  Ym  { 1Z I 	,H % 1  p 
M s   <  	 
e ̹  rx <   s  M    'R  f  	t .z L 	,.  1   
K q{  
 <  	 
a  Š r e   s  X   n '\  _  
m + O 	,  1 l Ѵ 
Iq o_   <  	C 
^  b r    s  c   7 'f  yX  f ( R 	+  1 % V 
GC mB   <  	 
Z  % r    s  m    'ao  Q  _ % U 	+  1   
E k%   <!  	 
W   r    s  x    '@y  9J  
X " X 	+   1  ʛ 
B i   <&  	K 
S 2 Ī r    s      'ǂ	  C  Q   [ 	+   1 
  
> d j  <.  	 
L b / r Y   s    ! ! 'Ǖ  Y4  D _ ` 	+   1  Á 
<Z b \  <2  		R 
I y  r    s    !  'ǟ  -  =  c 	+f   2 } # 
:, ` N  <7 ν 	 
E đ ô r    s    "  'ǩ#  &  6  f 	+O   2 4  
7 ^t ?  <; δ 	 
A é w r    s    # z 'yǲ)  y  /  i 	+7   2  e 
5 \W 2  <@ Ϊ 	V 
>  9 r    s    $ C 'XǼ/    (  l 	+    2!   
3 Z; $  <D Ρ 	  
:   r %   s    $  '76  9  !  o 	+	   2* `  
1o X  u <H Θ  
7  ¾ r N   s    %  '<     	! r 	*   23  L 
/A V  h <M Ύ _ 
3   r w   s    &  'B    $ B u 	*   2; ݌  
* Q  O <U {  
, 4  s   % s    ' - 'O    m   z 	*   2M F 2 
( O  C <Y r f 
( K  s   ) s    (  'V  r  n  } 	*   2U   
& M  6 <^ h  
$ b  s   , s    (  'p\  zR  o   	*   2^ ֹ w 
$Y Kq  * <b _  
! y N s E  0 s    )  'Ob  1  p   	*o  x 2g s  
", IV   <f U o 
 6  s% o  3 s  $  * k '.i  :  q   	M  p 2o ,  
 G8   <j L  
 S  s.   7 s  /  + 3 '
o    s #  	L  g 2x  _ 
 E   <o B  
 p E s6   : s  9  +  '%u    s D  	L  ^ 2 ͠  
 C    <r 9 v 
   s?   = s  D  ,  '.|  Y  u d  	L  V 2  H 
J > t  <z %  
   sP  ?  D s  Y  - U 'B    !4   	L  D 2   
 < f  <~   
	  P sY  i  G s  c  .  'gK  w  ">   	Lj  < 2 Ĉ  
 : Y  <  - 
   sb    J s  n  /  'FU    #I   	LQ  3 2 B 0 
 8s K  <   
   sj    M s  x  /  '%^  8  $T   	L9  * 2   
 6W >  <  ؇ 	 8  ss    P s    0 w 'h  /  %^ %  	L!  " 2  u 
i 4< 0  <  5 	 T Z s|   S s    1 ? 'q  M  &i E  	L	   2 p  
< 2 #  <   	 p  s ;  V s    2  '{  Xk  's e  	K   2 *  
 0   <  ѐ 	   s e  Y s    2  'ȅ    (~ ҅  	K   2