PDS_VERSION_ID      = PDS3
LABEL_REVISION_NOTE = "SE-MTC, 11/12/2015"

     /* File format and length */
PRODUCT_ID    = "T1_00367974791.GEO"
ORIGINAL_PRODUCT_ID = "PTE8TN04.QUB"
RECORD_TYPE   = FIXED_LENGTH
RECORD_BYTES  = 512
FILE_RECORDS  = 336
LABEL_RECORDS = 10
FILE_STATE    = CLEAN

     /* Pointers to data objects */
^QUBE      = 11
 
     /* Producer information */
PRODUCER_ID               = ROSETTA_VIRTIS_TEAM
PRODUCER_FULL_NAME        = "CAPACCIONI"
PRODUCER_INSTITUTION_NAME = "OBSERVATOIRE DE PARIS-LESIA"
PRODUCT_CREATION_TIME     = 2016-11-24T09:48:11.00
TELEMETRY_SOURCE_ID       = "VIRTIS_EGSE3"
SOFTWARE_VERSION_ID       = {"VirtisRos SW v.4.10", "EGSE_SOFT_7.3", 
"PDS_CONVERTER_7.3","EGSE2PSA_LBL_1.2.2", "GEOROS_6.2", "V_GEOLABEL_6", 
"GEOROS_6.2", "V_GEOLABEL_6", "GEOROS_7.1", "V_GEOLABEL_6"}

     /* Data description parameters */
DATA_SET_NAME        = "ROSETTA-ORBITER 67P VIRTIS 3 PRELANDING MTP006 V1.0"
DATA_SET_ID          = "RO-C-VIRTIS-3-PRL-MTP006-V1.0"
PRODUCT_TYPE         = EDR
PROCESSING_LEVEL_ID  = 2
STANDARD_DATA_PRODUCT_ID = "VIRTIS GEOMETRY"
MISSION_NAME         = "INTERNATIONAL ROSETTA MISSION"
MISSION_ID           = ROSETTA
INSTRUMENT_HOST_NAME = "ROSETTA-ORBITER"
INSTRUMENT_HOST_ID   = RO
MISSION_PHASE_NAME   = "PRELANDING MTP006"
PI_PDS_USER_ID       = CAPACCIONI
INSTRUMENT_NAME      = "VISIBLE AND INFRARED THERMAL IMAGING SPECTROMETER"
INSTRUMENT_ID        = "VIRTIS"
INSTRUMENT_TYPE      = "IMAGING SPECTROMETER"
^INSTRUMENT_DESC     = "RO_VIRTIS_EAICD.ASC"
ROSETTA:CHANNEL_ID   = "VIRTIS_H"
DATA_QUALITY_ID      = 1
DATA_QUALITY_DESC    = "0:INCOMPLETE ; 1:COMPLETE"

     /* Science operations information */
TARGET_TYPE            = "COMET"
TARGET_NAME            = "67P/CHURYUMOV-GERASIMENKO 1 (1969 R1)"
START_TIME             = 2014-08-29T23:06:41.495
STOP_TIME              = 2014-08-30T01:54:08.475
SPACECRAFT_CLOCK_START_COUNT = "1/0367974332.31312"
SPACECRAFT_CLOCK_STOP_COUNT  = "1/0367984379.29782"
ORBIT_NUMBER           = "N/A"
OBSERVATION_TYPE       = "NULL"
SC_SUN_POSITION_VECTOR        = (-200411513.593, 412486028.379, 240441380.214)
SC_TARGET_POSITION_VECTOR     = ( -3.201, -25.630, -48.637)
SC_TARGET_VELOCITY_VECTOR     = ( -0.000, -0.000, -0.000)
COORDINATE_SYSTEM_ID          = "-1000012000"
COORDINATE_SYSTEM_NAME        = "67P/C-G_CK"
DECLINATION                   = -999.999
RIGHT_ASCENSION               = -999.999
MAXIMUM_LATITUDE              = 79.414
MINIMUM_LATITUDE              = 77.207
EASTERNMOST_LONGITUDE         = 214.794
WESTERNMOST_LONGITUDE         = 125.825
SPACECRAFT_ALTITUDE           = 53.664
PHASE_ANGLE                   = 40.969
SUB_SPACECRAFT_LATITUDE       = 71.780
SUB_SPACECRAFT_LONGITUDE      = 177.401
SLANT_DISTANCE         = 54.358114
SOLAR_DISTANCE         = 517804601.717
SOLAR_LONGITUDE        = 119.95551
SUB_SOLAR_LATITUDE     = 17.921
SUB_SOLAR_LONGITUDE    = 170.350
NOTE = "The values of the keywords SC_SUN_POSITION_VECTOR, 
SC_TARGET_POSITION_VECTOR and SC_TARGET_VELOCITY_VECTOR are related to the 
J2000 frame. The values of SUB_SPACECRAFT_LATITUDE and 
SUB_SPACECRAFT_LONGITUDE are northern latitude and eastern longitude in the 
planetocentric frame defined by the shape model. All values are computed at 
mid-session. Distances are given in <km>, velocities in <km/s> angles in 
<deg>"


     /* Instrument status */
INSTRUMENT_MODE_ID    = 10
^INSTRUMENT_MODE_DESC = "RO_VIRTIS_EAICD.ASC"

     /* Pointer to navigation data files*/
SPICE_FILE_NAME = {"NAIF0011.TLS","PCK00010.TPC","DE405.bsp","JUP263.bsp",
"ROS_160929_STEP.TSC","ROS_V26.TF","ROS_CHURYUMOV_V01.TF","ROS_VIRTIS_V13.TI",
"cg-spc-shap5-v1.1_Cedric.TPC","RORB_DV_145_01___T19_00216.bsp",
"CORB_DV_145_01___T19_00216.bsp","RATT_DV_145_01_01____00216.bc",
"RATT_DV_145_01_01____00216.bc","CATT_DV_145_01_______00216.bc",
"cg-spc-shap5-v1.1-cheops.bds"}

     /* Cube keywords */
OBJECT = QUBE
 AXES                       = 3
 AXIS_NAME                  = (BAND,SAMPLE,LINE)
 CORE_ITEMS                 = (31,64,21)
 CORE_ITEM_BYTES            = 4
 CORE_ITEM_TYPE             = MSB_INTEGER
 CORE_BASE                  = 0.0
 CORE_MULTIPLIER            = 1.0
 CORE_VALID_MINIMUM         = -2147483648
 CORE_NULL                  = -2147483648
 CORE_LOW_REPR_SATURATION   = -2147483648
 CORE_LOW_INSTR_SATURATION  = -2147483648
 CORE_HIGH_REPR_SATURATION  = 2147483647
 CORE_HIGH_INSTR_SATURATION = 2147483647
 CORE_NAME                  = "GEOMETRIC PARAMETERS"
 CORE_UNIT                  = "UNK"
 CORE_DESC                  = "PARAMETERS ARE DEFINED IN EAICD"

 SUFFIX_BYTES               = 4
 SUFFIX_ITEMS               = (0,0,0)
END_OBJECT = QUBE

END
                                                                                                                                                                                                                                                                                                                                                                  $L " 8 5 d '  i  & 
D  
 e  RY K  u  A 	 (\o  :  1\ " | 1 S X { a $ " I 5  '  =  ' 
DT   e  Rm K  \  B  (4o    1 b "V  0# S _ I  # "՛ Y 5  (   1 ( 
D   f  R K  B  B  (o    1h "  . Sx f   # "q j 5  (:   X * 
D  $ f6  R K  )  B  (o  Z  1m "
  -h Sq n   # "H { 5  (]   ~ 1 
F  + fl  R L    B  (o    1s "/  #  Sj u  B #Z " ׋ 6   (   ȥ 2 
FZ  2 f  R L8    B ~ (o    1w "  ! Sb }   #) " ל 6  (  a  3 
F  : f  R LX    B c (jo  z  1} "j   A S[ ߄ M ߲ # " ׬ 6 + (  5  5" 
F  A g  R Lx    C G (Bo    1փ "   SS ߋ   # "v  6+ d )   > 7| 
G  P gu  S
 L  ֏  C  (o  1  1L !C   SE ߚ   #i "K  65  )2   e / 
e  W g  S L  u  C  (o  5  1S !  au S= ߢ  ֋ #: ""  6@  )V   ɕ n 0j  _ g  S4 M  Q  C  (o  Y9  1Z !} & N8 S6 ߩ S B #
 "  6J  )y  o   0  f h  SJ M.  -  C  (xo  =  1` ! 5 L S/ ߰ !  # "  6T  )  M   1  n hT  S` MX  
  C  (Po  A  1g ! E K S' ߸  Ϯ # "   6_  )  ) '  1O  u h  Sv M    C  ('o"  yD  1m !U T I~ S  ߿ ׼ d #y "z 1 6i  )   W ? 1  | h  S M    D  (p(  H  1t ! c G S  Ո  #I "P @ 6t + *	   ʇ s 1   h  S M  ՞  D i (p/  9L  1{ ! s FW S   ƃ # " _ 6 d *R      2   im  S N,  W  D 1 (p;  %  1Z !  C/ S   7 #ٹ " o 6  *v  ~  "
 2   i  S NV  3  D 1 (]p$B  X/  1` !g  A R  ̵  #׈ "  6  *  [ I #A 3   i  S N    D  (5p,H  8  1{i !  @ R  ʁ  #Y "~ ؏ 6  *  8 y $t 3e   j  T N    D  (
p3O  B  1to !ߠ  >q R  M Q #) "T ؞ 6  *   ˩ % 3   jK  T* N    D  (p;U  xL  1mx !=  < R    # "* خ 6  +    & 3   j  TA N  ԥ  D  (pB[  U  1f~ !  ;G R    # " ؾ 6  +,   	 ( 4I   j  TW O)  ԁ  D  (pJb  8_  1_ !w  9 R 	  j #̘ "  6 * +P   9 )? 4   j  Tn OS  ^  D  (kpQh  i  1X !  8 R  H  #9 "  6 c +  h ̚ + 5-   k_  T O    D o (p`u  X  1J !M  4 R    # "V  6  +  E  ( Lf   k  T O    D S (pg{    1C ! + e R '  6 # "- 
 6  +  %  *$ L   k  T O    D S (po؂    1< !̆ ; d9 R .   # "  6  ,   . +[ L   l  T P)  Ө  E 7 (pv؈  x  15 !# J b R 6 u  #w " - 7	  ,*   ` , MK   l<  T PU  Ӄ  E  (zp~؎    1. !ǿ Y a
 R = @ M #G " < 7  ,O   ͙ Ѫ >   lv  U P  V  E  (Qpؕ  9  1' !\ i >P R D   # " L 7  ,s     ݉ ! l  U, P  %  D   ()p؛  	  1  ! x < R L   # "X [ 7' * ,  }    !	 l  UG P    D   (pء    1 !  : R S k  # " { 7; c ,  yi Ό օ k ! mb  U{ Qc  Ҕ  D  (pخ    1
 !  7~ R} b 6  #U " ي 7D  -  wQ  ׼ ޶ ! m  U Q  c  D  (pص    1 !i  5 Ru i   w ## " ٚ 7N  -*  u9    !' m  U Q  3  D  (_pػ  y  1 !  4 Rn q  ( # " ٩ 7X  -Q  s! B ( L !. n  U R    D  (7p    1 !  2` Rg x   # "W ٹ 7a  -w  q
  ^ ߗ !5 nM  U R>    D  (p  9  1% !>  0 R_  a  # "+  7k  -  n ϻ ܔ  != n  U Ru  ѣ  D  (p    1, !  . RX  + 9 #_ "~  7u 
 -  l  g å !D n  V R  s  D u (p    12 !v  / RP    #. "|  7~ ) -  j 1   !L n  V4 R  F  D u (p  Y  18 !  | RI   L # "x|  7 b .:  f У  ă ![ ok  Vh SD    D Y (Fp    1a !J 0  R:  O  # "vQ  7 ~ .`  dj  $  !b o  V Sv    D = (p  z  1g ! ? a R3    #l "t% $ 7  .  bN  R  !i o  V S  Д  D ! (p  ڰ  1ƿl ! N  R+   ^ #< "q 3 7  .  `3 L / : !q p  V S  i  C ! (p  :  1Ǹp ! ^ = R$    # "o B 7  .  ^ т ]  !x pK  V T  ?  C  (q    1ȱv ! m  R  t | # "m Q 7  .  [ Ѹ ŋ  ! p  V T;    C  (|q    1ɪ{ !U |  R  = zq # "kx ` 7  /"  Y  ƹ  ! p  W Tk    C  (Tq  Z  1ʣ !  2 R   x! #z "iL o 7 ( /K  W $  b ! p  W T    C  (,q    1˜ !   R   s # "d ڍ 7 ` /  S~ ҏ A  ! q\  WO T  q  C  (q*!  xE  1͎7 !  & Q  a q2 # "b ڜ 7 | /  Q`  n ? ! q  Wi U*  G  C  (q1'  b  1·A !a  w Q  }) n # "` ګ 7  /  OA  ̲  ! q  W UZ    C { (q9.  8  1πL !   Q  z l # "^q ں 8  0  M" 0   ! q  W U    C { (cq@4    1yW !   Q  x j7 #V "\E  8  0?  K f  $ ! r5  W U    C _ (:qH:    1ra !3  ; Q  v g #% "Z  8  0h  H ӛ 9 m ! rk  W U  Σ  C C (qOA  X  1kl !  ݋ Q 
 tL e # "W  8 
 0  F  f  ! r  W V  z  C ' (qWG    1dv !j   Q  r c; #} "U  8& & 0  D  Ғ  ! r  X VH  P  C ' (q^N    1] ! % , Q  m ^ #ya "Qg  88 _ 1  @i q   ! sB  X9 V    C  (qqmZ  ڡ  1O !{; C  Q * kp \= #w1 "O< # 8A { 13  >J ԧ   ! sw  XS V    C  (Iqua  :  1H !x R  Q 2 i9 Y #t "M 2 8I  1\  <+  C & ! s  Xm W  ͭ  C  (!q|g  {  1A !vr b j Q 9 g W #r "J B 8R  1  :  n p ! s  X W5  ̈́  C  (qm  h  1: !t
 q Ѻ Q A d U@ #p "H Q 8[  1  7 I t о ! t  X Wf  Y  C  (qt  ZT  13 !q   Q H b R #nm "F ` 8d  1  5 Ձ   " tN  X W  -  C  (qz  A  1, !oC  H Q P `` P #l; "D] p 8l  1  3 պ  O "
 t  X W    C  (qف  .  1% !l   Q W ^) NA #j
 "B1  8u $ 2'  1   ј " t  X W    C  (Xqه  z  1 !jy   Q ^ Y I #e "= ۜ 8 ] 2x  -` b 
L * "# u%  Y) Xb  ~  C I (qٔ  8^  1 !e  l Qr m W GC #cw "; ۫ 8 y 2  +C ֛  ֏ "* u[  YE X  Q  C I (qٚ  e  1	 !cK   Qj u UI D #aE "9 ۺ 8  2  )'    "2 u  Y` X  %  C - (q٠  l  1 !`    Qc | S B #_ "7S  8  2  ' 
  ! "9 u  Y{ X    C  (q٧  Xs  1 !^  I Q[  P @D #\ "5'  8  3  $ F ' k "A u  Y Y.    C  (gq٭  z  1 !\ 	  QT  N = #Z "2  8  3C  "  U ״ "H v1  Y Ya  ˟  B  (>qٴ    1 !Y   QL  Lg ; #X "0  8  3l    ׸   "P vf  Y Y  s  B  (qٺ  x  1 !WQ ( $ QE  J. 9A #VN ".  8 # 3      F "W v  Y Y  G  B  (q  ؎  1 !T 7 m Q>  E 4 #Q "*F ! 8 \ 3  _ a   "f w  Z! Z+    B  (q    1 !P! V  Q/  C 2C #O "( / 8 x 4  D ؚ 9 ! "m w:  Z= Z^    B  (vq    1 !M e F Q'  AM / #M "% > 8  4?  &  f j "u wo  ZX Z  ʖ  B  (Mr  W  1 !KV t Տ Q   ? - #KX "# M 8  4p  
  \ # "| w  Zu Z  g  B  (%r    1 !H  L Q  < +B #I' "! [ 8  4   N ]< #Z " w  Z [   3  B k (r    1 !F   Q  : ( #F "^ j 9   4   َ ^h # " x  Z [;    B k (r  w  1 !D&   Q
  8m & #D "/ y 9  5  
  _ # " xJ  Z [u    A O (r"  	  1 !A   Q  66 $A #B "  ܈ 9 # 54    ` $2 " x  Z [  ɘ  A O (r)  8  1 !?Z  ? P  1  #>/ " ܦ 9" \ 5   ڎ c $ " x  [( \#  0  A 3 (4r8    1 !:   P  / ? #; "r ܵ 9* x 5  u  dD %	 " y%  [F \]    A  (r@
  X  1" !8)   P  -X  #9 "D  92  5  ` 
 ep %Q " y[  [d \    A  (rG    1) !5  1 P  +!  #7 "  9:  6(  J M f % " y  [ \  Ȗ  @   (rO    1~0 !3]  n P 	 ( 0 #5i "
  9B  6X 4 ۍ g % " y  [ ]
  c  @   (rV   x  1w8 !0   P  &  #38 "  9J  6   h &( " y  [ ]D  /  @   (lr^&  ز  1p? !. *  P  $y z #1 "	  9Q  6   j &p " z3  [ ]~    @   (Cre-  8  1iF !,+ : " P   "A  #. "W  9Y # 6  K kG & " zi  [ ]    @   (rm3    1bN !) I ^ P '  
g #*o " . 9h \ 7J     " z  \7 ^(  e  ?   (r|@  Z?  1T !$ g  P 6   #(> "  = 9p x 7z     " {  \R ^W  <  ?   (rF  ?  1M !" v  P > b  #& ! L 9w  7  2 S @ " {7  \n ^    ?   ({rM  ?  1F ! ,  ?  P E * U ## !k [ 9  7 ` h U  ݆ # {i  \ ^    ?  q (SrS  z?  1? !  =c P L    #! !: i 9  8 ? ݞ V  #
 {  \ ^    ?  q (+rY  ?  18 !`  ; P T   #u ! x 9  8;    W<  # {  \ _  Ƙ  ?  U (r`  :?  11 !  9 P [  A #D ! ݇ 9  8k   	 XZ W # {  \ _F  n  ?  9 (rf  ?  1* !  8+ P| c J  # ! ݖ 9 # 8  ? Yx ޝ #  |/  \ _v  E  ?   (rl  ?  2 # !-  6n Pu j 	 - # !N ݴ 9 \ 8  ު [ ( #/ |  ]/ _    ?   (bry    2 !`  2 Pf y   #} !  9 x 9, ߁  \ n #6 |  ]K `    ?  (:rڀ    2 !  15 P^  k u #K !  9  9\ `  ] ߳ #> |  ]g `5  Š  ?  (rچ  y  2 !
  /x PW  5  # !  9  9 @ K _	  #E }$  ] `d  w  ?  (rڌ  ٻ  2  !-  - PO     #
 !  9  9   ߀ `& > #M }U  ] `  N  ?  (rړ  9  2 ! , + PH   a # !_  9  9  ߶ aB  #T }  ] `  &  ?  (rڙ    2 !_ ; *> P@    #	 !/  9 
 :%   b^  #\ }  ] `    >  (rrڟ    2 !  K ( P9  X  #I !   9 ( :Y Ҽ ! cz  #c }  ] a"    > w (Jrڦ  Y  2   Z & P1    # !ۛ ? 9 c : y   7P #r ~F  ^( a  Ą  > ? (~sڳ    2
   x O P#   ݐ #  !h N 9  : N   7 #y ~s  ^A a  g  > $ (~sڹ  y  2  ^  M P  } 3 "} !4 ] 9  ;6 #   7 # ~  ^Y a  I  >  (~sڿ    2    LE P  F  "J ! m :  ;s    8$ # ~  ^r a  +  ?  (~s  9  2
    J P   z " ! | :
  ;  2  8k # ~  ^ b  
  ?  (~Ys"    2  )  H P    " !Л ތ :  ; â ] . 8 # "  ^ b5    ?  (~1s*    2    GX O    " !g ޛ :  <' v   , # N  ^ bY    ?  (~	s1  Y  2  [   O  j b "~ !3 ު :# 1 <d G   p # y  ^ bz  ø  ? } (}s9    2      O   ʩ " !  :2 k <     #   _ b  Ã  ? E (}sH  wq  2  &    O   K " !ř  :9  =  $  ; #   _ b  h  ? * (}isP  מ  2    % O  ݌  " !f  :@  =T  K  ~ # "  _2 c   N  ?  (}AsW  7  2  X   O  S È "} !2  :F  = a r   # L  _J c!  3  @  (}s_    2   -  O   ( "I !  :M  = 3    # v  _a cB    @  (|sf  %  2{  ډ = 4 O    " !  :S  >    I #   _y cd    @  (|sn  XQ  2u	  " L  O % Ԭ d " ! $ :Z  >D     #   _ c    @  (|su  ~  2n  պ [  O , v  "߮ !c 4 :a < >     #   _ c    @  (|ys}    2g#  S j A O 4 
 @ "F ! S :n x > J ] - U # F  _ c    @ 0 (|)s%    2Y  ΄   O C   " ! c :t  ?4   4  $  p  _ d
  z  @  (|s,  8.  2R!    N O J ɞ | " ! s :{  ?t   ;  $   ` d+  `  @  ({s2    2K5  ɵ   O R h  "Ԫ !\ ߃ :  ?   B  $   ` dL  F  A  ({s8    2DI  M    O Y 1  "u !' ߒ :  ?   I a $   `6 dm  ,  A  ({s?  Y6  2 =\    Z O~ a  W "B ! ߢ : 
 @4 _   O  $   `M d    A  ({asE    2!6o  }   Ow h   "
 ! ߲ : + @s / G U  $% =  `e d    A  ({9sL    2"/     Oo o   " !  : I @   n \ * $- f  `} d    A m ({sR  z?  2#(    d Oh w "  "r !  :  A3    	 $;   ` e
    A 6 (zs_  8  2%p    7 OY   m "> !  :  Au h  & 	 $C   ` e&    B  (zse    2&v  v   OQ    "
 !  :  A 1  - 	4 $J    ` e>    B  (zqsk    2'|   . X OJ    " !t  :  B   3 	z $R %  ` eW  x  B  (zIsr  X  2(   =  OC  H F " !:   :  B\  1 : 	 $Y K  ` ep  g  B  (z!sx    2(  > L x O;    "n ! 0 :  B  P @ 	 $a p  a e  U  B s (ys    2)   [  O4    ": ! @ : 7 B T n 
 	 $h   a( e  D  C W (ysۅ  x  2*  n j R O,    " ! P : U CB    	 $p   a< e  4  C < (ytۋ    2+   y  O%  7 W " ! o :  C    	͉ $   ad e    C  (yYtۘ  k  2-j  6   O    "h !  :  D' }m  ӻ 	 $ %  ax e    D  (y1t۞  o  2.q    u O    "3 !  :  Dt {4  Ԧ 	 $ I  a f    D  (y	t$ۥ  Ws  2/x  f   O   , " !k  :  D x  Ց 	L $ m  a f'    D y (xt+۫  w  20~     N  c  " !0  :  E v 5 | 	Ό $   a f=    E ] (xt3۲  {  21    
 N  - ~c " !  ; % E` t Q f 	 $   a fT    E & (xt;۸  w  22  -   N   { "b !~  ; C E rM m P 	 $   a fj    E 
 (xitB۾  ׃  23     N   y ". !|  ;
 a E p  : 	N $   a f    E  (xAtJ  7  24  \    N  T t " !x   ;  F k   	 $ A  b f    F  (wtY    26    ߳ N 
  rj " !u  ;  F if   	 $ d  b- f  |  F  (wta  Y  27  ! . : N   p "[ !s   ;$  G8 g,   	P $   bA f  l  F H (wth    28    =  N   m "& !qW 0 ;*  G d   	А $   bU f  ]  G , (wytp    29  P L H N # | k3 " !o @ ;/  G b 3 ޲ 	 $   bi g  N  G  (wQtw  y  2:   [  N + E h " !l P ;5 4 H. `} O ߛ 	 $   b| g  ?  G  (w)t  ك  2;z  ~ j U N 2  fb " !j ` ;: T H ^D k  	Q $   b g3  /  G  (wt  9}  2<s   y  N 9  c "M !h_ p ;@ s H \	  l 	ё $ 5  b gI     H  (vt  w  2=l  |  b N A ~l _* " !c  ;J  I W  ; 	 % z  b gu    H N (vt  Y  2?^,  w  n N P |6 \ " !a  ;P  I U\  # 	Q %
   b g    H  (vbt    2@W0  ur   N W y ZY "r !_`  ;U  JR S!  
 	Ґ %   b g    I  (v:t    2AP5  s	  z N _ w W "; !]   ;[  J P   	$ %   c g    I  (vt  y  2BI9  p  2R Nx f u U " !Z  ;` 3 K N 0  	g %#   c g    I  (ut$  z  2CB?  n7  0 Nq n s^ S  " !X  ;e T Kp Ls L  	 %+ $  c/ g    I  (ut+  9r  2D;D  k  /s Ni u q) P "~ !V\  ;k t K J8 h  	 %2 F  cB g    J o (ut1  k  2E4H  id  . Nb } n NN "|] !T  ;p  L. G   	- %: g  cV h    J 8 (urt7  c  2F-N  f  , NZ  j I} "w !O " ;z  L C   	 %I   c} h=  y  K   (u#tD    2H  b) , ) NK  hV G "u !MW 2 ;  MJ AP   	 %P   c hT  i  K  (ttK    2I"  _ ; (C ND  f! D "s !K C ;  M ?   	5 %X   c hj  Z  K  (ttQ  w  2J(  ]V J & N<  c BB "qH !H S ; 6 N	 <  . 	I %_   c h  L  K u (ttW    2K
/  Z Y  N5  a ? "o !F c ; V Nu : +  	 %g /  c h  >  L Z (tu ^  7  2L6  X h  N-  _ =p "l !DF s ; v N 8c F  	 %n P  c h  0  L > (t[ud    2L<  V w  N&  ]G ; "j !A  ;  O] 6% _ 
  %v o  c h  $  L  (t3uj    2MC  S   N  [ 8 "hh !?  ;  O 3 w 
  %}   d h    L  (tuq  W  2NJ  QG   N  V 3 "c !;  ;  P /j  
  %   d' h    M  (su'~  @  2P=  Lt   N  Ti 1f "a !8  ;  Q8 -,  
  %   d: i     M ` (su.܄  wK  2QD  J
   N   R1 . "_ !6  ; 7 Q *  
o  % 
  dL i     N D (slu6܊  V  2RL  G  N M  O , "]S !4?  ; W R" (  
R V % ,  d^ i,     N ( (sDu=ܑ  7b  2ST  E6   M  M *1 "[ !1  ; w R &q 
 
5  % K  dp i>     N  (suEܗ  m  2T[  B   M  K ' "X !/   ;  S $3 " 
  % j  d iQ     O  (ruMܝ  x  2Uc  @c  h M  IT %e "V !-`  ;  S ! ; 
  %   d ic     O  (ruTܤ  W  2Vk  = 
  M  G " "Tv !+  ;  T   S 
 [ %   d iv    O  (ru\ܪ    2Ws  ;   M  B , "P !&u ? ;  U ;  
  %   d i    P . (rUukܷ  y  2Y  6 : 3 M  @x  "M !$& O ; 6 U   
  %   d i    P  (r-usܽ    2Z  4P H  M " >B Z "K !! _ ; V V
   
g ^ % "  d i    Q  (ruz  9  2[  1 W  M ) <  "I` ! o ; v V   
H  % @  e i  x  Q  (qu    2\  /| f J M 1 9  "G( !6  ;  W A  
*  % ^  e i  l  Q  (qu    2]  - u  M 8 7  "D !  ;  W   
   % |  e% i  a  Q l (qu  Yg  2^~  *   M @ 5h  "B !  ;  X 
  
 a %   e7 j
  U  R 4 (qfu  O  2_w  (=  _ M G 32 
G "@ !M  <   X  . 
  &   eI j  J  R  (q>u  6  2`p  %   M O . t "< !  <
 5 Y| 
 _ 
 " &   el jA  3  S  (pu    2bb     r M ^ , 
 "9 !f  < U Y  w 
o b &   e~ jT  (  S  (pu  8  2c[    # My e *W  "7 !
  < w Zp   
O  &" /  e jf    S r (pu    2dT  )   Mr m (  4 "5h !
  <  Z  N  
/  &* L  e jx    T : (pwu     2eM     Mj u %  "3/ !}  <  [b   
 # &2 j  e j    T  (pOu
  X.  2fF  T  5 Mc | # _ "0 !0  <#  [   
  &9   e j    T  (p'u  =  2g?   
  M[  !{  ". ! / <(  \T   
l  &A   e j    U  (p u  K  2h8    L MT  A  ", ! > <-  \ R 	 
L ` &H   e j    U  (ou  xZ  2i1   (  ML    "(   \ <6 ] ]  9 

  &W   f j    U \ (ou*  7  2k#  ? F \ M=   I "%   k <; ~ ^(  Q 
   &_   f j    V $ (o`u0    2l   U  M6  ]  "#  c z <@  ^ X j   ` &f 5  f/ k    V  (o9v6  #  2m  j c  M.  % s "!c    <E  _     &n Q  f@ k    V  (ov=  W(  2n   r j M'    "(    <J  _     &u n  fR k1    W  (nvC  .  2o     M    "  |  <O  _   m   &}   fc kC    W ~ (nvJ  3  2p  )   M  
~ 2 "  .  <S . `p \  L ` &   ft kU    W b (nv#P  w8  2p   w M  D  "q    <Y R `   +  &   f kh  ~  X * (nrv*V  =  2q	 S  % M	    "  @  <f  a ޜ    &   f k  g  X  (n"v:c    2sz {   L   ڢ "    <l  bL ] +  _ &   f k  \  Y  (mvAi    2tހ   0 L  e ? "    <s  b  C   & 3  f k  Q  Y  (mvIp  Y  2uׅ    L   -  "
E  U  <y  c9  [ 	  & O  f k  F  Y h (mvQv    2vЊ :   L   { "
   ' < ' c ա t 
b  & j  f k  ;  Z L (mvX}    2wɏ   9 L    "  ܷ 6 < J d% a  @ ] &   f k  /  Z  (m[v`݃  y  2x c   L   ζ "  i F < n d "    &   g k  $  Z  (m3vh݉  ٶ  2y  %  L  N Q "V   V <  e     &   g! l
    Z  (mvoݐ  9  2z  3 A L   ǁ !  ~ u <  e d   Z &   gC l1    [ n (lvݜ    2| ߵ Q  L )   !  /  <  fi $    &   gT lD    [ R (lvݣ  Y  2} J ` H L 1 o ° !d    <  f   n  & )  ge lV    \  (lmvݩ    2~  o  L 8 7 G !(  ̓  < B gM å 4 K  & D  gv lh    \  (lEvݰ  |  2 s ~  L @   !  E  < e g f L ' V & _  g lz    \  (lvݶ  yw  2   M L G  w !    <  h0 ' d   ' z  g l    ]  (kvݼ  r  2 ӛ   L O   !s  Ũ  <  h  |   '   g l    ] t (kv  9m  2| 0   L V W  !7  Z  <  i   
 a '   g l    ] X (kv  h  2u   m L ^   !    <  i %  
H bq '"   g l    ^  (kWv  W   2g}   k{ Lr m ܰ l !  o  < ; je   
 b '*   g l  	  ^  (k/v  (  2` ǁ  jB Lk t y  !C  ! # < ` j   
 b '1   g l  	  _  (kv  1  2Y   i	 Lc | A  !   3 <  k< a  
 c. '9 /  h m  	  _ z (jv  w9  2R ©  g L[  	 0 !   B <  k   
 cn '@ H  h m  }	  _ ^ (jv  A  2K =  f LT    !  B R <  l  0 
y c 'H b  h+ m$  s	  ` & (jv  7J  2D    e] LL  ї ^ !L   a <  le  F 
O c 'O {  h; m5  j	  `  (jhv  R  2= e / d# LE  ^  !   q <  l \ \ 
% d+ 'W   hK mF  a	  `  (jAv  Z  26  > b L=   " !ג    < ^ m   
 d 'f   hk mg  N
  a  (iw	    2(   \ `u L.  ȳ  !U    =   m   
 d 'n   h{ mw  D
  a d (iw    2!  j _; L'  y P !    =  n@ V  
z e& 'u   h m  ;
  b , (iw  w  2 G y ^  L  @  !  C  =
  n   
O ee '}   h m  2
  b  (izw "    2   \ L   } !Μ    =  n   
$ e ' )  h m  (
  b  (iSw()  7   2 o  [ L    !^    =  o[   
 e ' A  h m    c  (i+w//  ,  2   ZP L	    !  g  = 9 o O  
 f! ' Z  h m    c  (iw75  8  2   Y L  X Y !    =# ] p 
 $ 
 f_ ' r  h m    c N (hw?<  WD  2 )  W K    !d    =1  p  Q 
J f '   h m    d  (hwNI    2K O  Ua K   ? !%  Y ' =8  p H g 
 g '   i
 n    d  (hdwVO  y  2O   T% K  p  !   6 =?  q6  } 
 gY '   i n    e  (h=w^U  ى  2R v  R K  7  !   E =F  qw   
 g '   i) n,    e  (hwe\  9~  2X 	 
 Q K   }" !g   T =M : q   
 g '   i9 n=    e T (gwmb  s  2[   Pq K   z !'  ` d =S a q A  
j h '   iH nM    f 8 (gwuh  g  2` / * O4 K   xZ !  ! s =Y  r9   
= hR ' 1  iX n^    f  (gw|o  Y\  2d  9 M K " N u !    =_  rz }  
 h ' H  ig nn    f  (gvwu  Q  2i U H L K )  q, !  h  =k   r y9  
 i ' w  i n    g v (g'wނ  x  2Y | e J@ K 8  n !  +  =q ' s2 v . 
 iI '   i n  
  g Z (g wވ  ؗ  2_  t I K @ i la !  |  =w O sn t D 
 R* '   i n  
  h # (fwޏ  8  2e    K G / i !X  z  =| v s rq Y 
 Re (   i n  
  h  (fwޕ    2j 4  w K O  g !  xt  =  s p. n 
 R (   i n  
  i  (fwޛ    2p ~  6 K W  e1 !  v7  =  t! m  
W R (   i n  {
  i  (fawޢ  X  2v |Z   K ^  b !  s  =  t] k  
 S (   i n  r
  i | (f9wި    2| y   Ky f I `e !J  q  =  t ie  
 SQ (#   i n  j
  j D (fwޯ    2z w  t Kr m  [ !  mC + = k u d  
d S (2 A  j o  Y  j  (ew޻  ؍  2l r   Kc |  Y3 !  k : =  uK b  
' T (9 W  j o,  Q  k  (ew  8  2e p7  ް K[  d V !<  h I =  u `Z  
 T= (A m  j+ o<  H  k  (esw    2^ m  n KS  * Th !  f Y =  u ^  
 Tw (H   j: oK  @  k  (eLw    2W k\  , KL   R !  dO h =  u [ . 
n T (P   jI o[  7  l J (e$w  X  2P h $  KD   O !q  b w = 7 v8 Y C 
0 T (W   jX ok  /  l / (dx     2I f 3 ٨ K=  | M5 !,  _  = _ vg WM Y 
 U' (_   jf oz  '  l  (dx    2B d B f K5  B J !  ]  =  v U	 n 
 Ua (g   ju o    m  (dx  x  2; a Q $ K.  z F !b  Y3  =  v P  
7 U (v   j o  
  m l (d^x  6  2- \ n ԟ K  x C !  V  =  w NA  
 V (}   j o    n P (d6x&    2& Z] } \ K  vT AB !  T  = + wJ K  
 VJ ( .  j o    n  (dx.    2 W   K  t > !  R  = T wx I  
y V ( C  j o    o  (cx6  W  2 U   K  q < !}Q  PS  = | w Gv  
: V ( X  j o    o  (cx=    2 S  ϓ K   o :2 !{  N  =  w E4  
 V ( m  j o    o  (cxE    2
 P  P J  ma 7 !x  K 
 =  w B  
 H% (   j p    p r (cpxM  w"  2 N7  ' J  k& 5x !v  I  >  x, @ - 
 Hb (   j p    p ; (cIxU!  '  2 K  & J  f 0 !q  E: 5 > H x <$ X 
t H (   k p5    q  (bxd.  <  2 F  $3 J  dq .d !o  C D > q x 9 m 
@ I (   k# pE    q  (bxl4  =  2 D~  " J  b7 , !mr  @ S >%  x 7  
 IU (   k1 pU    q  (bxt;  X?  2 B  ! J  _ ) !k-  > b >-  y 5Y  
 I (   k@ pe    r \ (bx{A  @  2 ?    J  ] '] !h  <[ r >5  y9 3  
 8# (   kN pt    r A (b[xH  A  2 =4 -  J # [ % !f  :#  >>  ye 0  
 8] ( %  k\ p    r 	 (b4xN  xC  2 : ;  J * YO " !db  7  >F ; y .  
y 8 ( 8  kj p    s  (bxT  D  2 8W J փ J 2 W  T !b  5  >N f y ,K  
v  ( L  kx p    s  (ax[  8E  2 5 X zs J 9 R  !]  1C  >^  z '  
x   ( r  k p  y  t b (axg  q  2°, 1 v x J H Pg L ![<  /
  >f  zD %~ ' 
x C )   k p  r  t + (anxn  Xr  2é2 .  v J P N-  !X  ,  >n  zq #9 ; 
yf z )
   k p  k  u  (aGxt  r  2Ģ8 ,.  u J X K  !V  *  >w L z   O 
z  )   k p  d  u  (ax{  s  2ś> )  ta J _ I B !T\  (b  > z z  c 
z  )   k p  ]  u  (`x߁  xs  2ƔD 'Q  s* Jx g G|  !R  &* 	 >  z k w 
{ " )$   k q  V  v  (`x߇  t  2ǍJ $  q Jq n EB 
 !O  #  >  {# &  
|1 Z )+   k q  O  v M (`xߎ  8u  2ȆP "s  p Ji v C  !M}  ! ( >  {O   
|  )3   k q#  H  v 1 (`xߔ  u  2V    o Ja } > O !H  I F > _ { W  
~G   )B   l q?  :  w  (`2xߡ  W"  2q/ '  m JR  <W  !F   U >  {   
  )J -  l qM  3  x  (`
xߧ  +  2j6    JK  :  !DR   d >  |   

 & )Q ?  l' q[  ,  x n (_x߮  3  2c= I   JC  7  !B   s >  |-   
J ` )Y Q  l4 qi  &  x S (_yߴ  w<  2\E  %  J<  5  !?  h  >  |Y 
B  
   )` b  lA qw    y  (_yߺ  D  2UL k 4  J4  3i R !=p  0  > C |  ' 
  )h t  lN q    y  (_ly  7M  2NS  B h J,  1.  !;&    > q |  ; 
k  )o   l[ q    y  (_Ey  U  2G[  Q E J%  .  !8  
  >  | q N 
! E )w   lh q    z ߐ (_y&  ^  2@b 
 ` " J  *z  !4D  	X  >  }  u 
  )   l q    { = (^y5    22 > }  J  (> S !1  "  > ' }B   
@  )   l q    {  (^y=    2+    J  &  !/    > U }h Z  
  )   l q    {  (^yE  y  2$  _  O I  #  !-d    >  }   
 2 )   l q    | ޲ (^XyM    2   ~, I  !  !+     >  }   
r X )   l q    | z (^0yT  9w  2    I  R  !( H  >  }   
(  )   l r     } _ (^	y\  o  2    I   N !&|  ' >  ~  @  
  )    l r    } ' (]yd   h  2   } I    !$0  7 > < ~%   
  ) 1  l r    }  (]yl  Y`  2 2  Y I  q > ! p W ?	  ~q p # 
  v ) R  l r7    ~ ݜ (]ky{    2 S    I  9  !M : g ?  ~ + 7 
  ) b  m rE    ~ e (]Cy  w"  2    I    ֌ !  w ?  ~  J 
k  ) r  m
 rS     I (]y   1  2 t   I $  4 !   ?! # ~  ] 
  ! )   m ra      (\y'  7@  2޲  +  I , 
  !h   ?) Q  Y p 
 Y )   m& ro    Ӏ  (\y-  P  2׺  :  I 3 V ρ ! a  ?1  .   
  )   m2 r|    Ӏ ܾ (\y3  _  2 $ I \ I ; 	 ) ! +  ?9  T   
>  )   m? r    Ӏ ܆ (\~y:  Wn  2  W 7 I B   !n   ?A  y ڈ  
  )   mK r    Ӂ k (\Wy@  }  2 D f  I J q  !
   ?Q X    
[ u *   md r    Ӂ  (\yM  x  2 d  | I Y  8  !p R  ?Y   ӵ  
  *   mp r    ӂ  ([yS  ؽ  2   { I~ a  i !   ?a   p  
  *   m| r  |  ӂ ۨ ([yZ  8  2 ԃ  z| Iv h   !   ?i  6 )  
v  *%   m r  u  Ӄ q ([y`    2!   yW Io p   !s د & ?q + [   
 ) V *-   m r  o  Ӄ U ([jyf    2' ϣ  x1 Ig x R W   x 5 ?x _  ʜ 1 
   *5 /  m r  h  Ӄ  ([Cym  X  2, 3  w I`      A E ?   V D 
!  *< >  m s  b  ӄ  ([ys    22   u IX     v  U ?    X 
"B  *D M  m s  [  ӄ  (Zyz    27 R  t IP  l    ͞ t ? 3   } 
l { *S j  m s.  O  Ӆ w (Zz  ְ  2u r  V IA  2   w h  ? h ? =  
  *[ y  m s<  I  Ӆ ? (Z}z  6  2o   U~ I:        0  ?  d   
  *b   m sI  C  ӆ  (ZVz  9  2h  " TY I2        ?     
v ! *j   m sW  =  ӆ  (Z/z  ~  2a'   1 S5 I*  { a  v   ?   i  
# X *q   n  sd  6  ӆ ٴ (Zz&  W  2Z8  ? R I#  >       ? <  "  
  *y   n sq  0  Ӈ } (Yz.    2SH > N P I      V  ? q    
  + *   n s  *  Ӈ a (Yz6  K  2LX  \  I   C  u   ?  !   
  ` *   n# s  $  ӈ ) (Yz>  x  2Ei ] k  I  J      ?  m  & 
"  *   n: s    ӈ  (YBzM  8k  27p {  q H  
 $  t z  ? E   9 
"   *   nE s    Ӊ ؞ (YzU  g  20u 
  J H      C  ? z  x K 
#M 5 *   nP s  
  Ӊ g (Xz]  c  2){   # H  Ӓ c    # ?   1 ^ 
# j *   n\ s    ӊ K (Xze  X_  2" (   H  V   n  1 ?    p 
$  *   ng s    ӊ  (Xzl  [  2    H        @ ? * )   
%:  * -  nr s    ӊ  (X}zt  W  2 F   H   E  ҡ e N ? k O Y  
% 	 * :  n} s    Ӌ  (XVz|  xR  2
    H  ʝ   = / ] @  t   
& = * G  n t    Ӌ ׉ (X.z  N  2 d  ^ H  # *  t  z @ /    
'  * a  n t    ӌ 5 (Wz    2  
  H &       @ r  <  
(n  * m  n t(    ӌ  (Wz    3     H .  l  Ʀ V  @     
)  * z  n t5    Ӎ  (Wz  X  3  '  H 6 j   >    @&  %   
) E *   n tB    Ӎ ֪ (Wjz    3 - 5  H = - |     @- : H g  
*W y *   n tO    ӎ s (WBz    3  D 
m H E  zO  p   @4 } l  ) 
8  +   n t\    ӎ ; (Wz  x  3 K R (S H L  w  
 ~  @;    ; 
9l  +	   n ti    ӎ   (Vz    3  a '( H T t u   H  @B    N 
: 	 +   n tv    ӏ  (Vz&  8y  3 h o % H \  p     @P    s 
;_ s +    o t    ӏ Օ (V}z2    3   # Ht k  np  m  	 @V     
<  +(   o
 t    Ӑ ] (VVz9  X  3	   "z Hl r z l   n  @]  ? s  
<  +/   o t    Ӑ % (V/z?    3
 |  !N He z : i   8 $ @d M b },  
=P  +7   o" t    ӑ 
 (VzF    3 z/   " H]   gP  7  1 @k   z  
= F +?    o- t    ӑ  (UzL  x  3  w   HV   d    > @q   x  
> z +F   o8 t    ӑ ԛ (U{R  د  3
 uK   HN  y b  Y  L @x    vV  
??  +N   oB t    Ӓ  (U{	Y  8  3
 r   HF  8 `/   ^ Y @ x  t  
?  +U "  oM t    Ӓ G (Uj{_    3 ph  q H?   [n   } t @ ' 5 o~  
H 2 +e 9  ob u  }  ӓ  (U{ l  XE  3{ k  q H0  w Y
  R {  @ ~ Y m6 , 
I c +l D  ol u  x  ӓ Ӽ (T{(r  ?  3t i  B H(  7 V   y  @  | j = 
I  +t O  ow u  s  Ӕ Ӆ (T{0y  9  3m f +  H    TL  O wN  @ +  h O 
JE  +| Y  o u+  n  Ӕ i (T{7  x3  3f d- 9  H   Q   u  @   f^ a 
J  + d  o u8  i  ӕ 2 (T~{?  -  3_! a G  H  u O  M r  @   d s 
Km & + n  o uD  c  ӕ  (TW{G  8'  3X& _I V  H	  4 M)   p  @ .  a  
L W + y  o uQ  ^  ӕ  (T0{O  !  3Q* \ d W H   J  J ns  @  + _  
L  +   o u]  Y  Ӗ ҧ (T{W    3J0 Zd r ( G  q F  F j  @ 0 q Z  
M  +   o uv  O  ӗ 7 (S{f    3<T U   G  . C   g  @   X  
NN  +   o u  J  ӗ  (S{n    35Y S
   G   A@  G e  @   Vc  
N I +   o u  E  ӗ  (Sk{v  x  3.] P  i G   >   cb  @ )  T  
v'  +   o u  @  Ә ѭ (SD{~  ؗ  3'a N(   G  d <x  P a)  @ y  Q  
v  +   o u  :  Ә ё (S{  8  3 f K   G  ~! :  | ^ ) @  ! O  
wd 6 +   o u  4  ә Y (R{    3j IC   G  { 7  z\ \ 5 @  D MA ' 
x h +   o u  .  ә " (R{  w  3 o F  T G " y 5O  w Z A @ f g J 9 
x ̚ +   p u  )  ә  (R{  Xl  3!s D]   G ) u 0  r V Z A    Fi ^ 
y  +   p u    Ӛ З (RX{  j  3" ?x   G 8 r .&  pt S f A R  D! q 
zz 1 +   p! u    ӛ { (R1{  x^  3# =  v G @ p +  m Q s A ß  A  
{ c +   p+ v    ӛ D (R
{  S  3$ : - > G H nK )^  k Or  A   ?  
{ ͔ ,   p5 v    ӛ  (Q{  8G  3% 8 <  G O l &  i M;  A 4 8 =I  
|Q  ,   p? v    Ӝ  (Q{  <  3& 5 J  G W i $  f K  A ~ [ ;  
|  ,   pI v+     Ӝ Ϲ (Q{  0  3'ړ 39 X  G _ g "3  d& H  A$  ~ 8  
} ) , '  pR v8    ӝ ρ (Qm{  X$  3(Ә 0 g ^ Gy f e;   a F  A*   6p  
~' [ ,# 0  p\ vE    ӝ J (QE{    3)̜ .S u & Gq n `   \ B*  A6 ť  1  
_ ξ ,2 B  po v_    Ӟ  (P{  v  3+p )m   Gb } ^p   ZY ?  A<  	 /  
  ,: J  py vl    Ӟ ο (P{  ֳ  3,x &  } GZ  \, =  W =  AB 1 , -O ( 
Z f ,B S  p vx    ӟ Σ (P|%  6  3- $  ^Q GR  Y   Uv ;  AH w N + 9 
  ,I [  p v    ӟ k (P|+    3. "  ] GK  W s  S 9M  AN ƿ q ( J 
h  ,Q c  p v    ӟ 4 (PZ|1    3/   [ GC  U_   P 7  AS   &t \ 
  ,Y k  p v    Ӡ  (P3|8  V  30 ,  Z G<  S   N 4  AY X  $+ m 
t  ,` r  p v    Ӡ  (P|#>    31   Yf G4  P 
C  K 2  A_ ǥ  !  
 E ,h z  p v    ӡ ͩ (O|*E    32 E  X+ G,  LM x  F .9 3 Aj >  O  
  ,w   p v    ӡ V (O|:Q  s  34 ^  } G  J   D+ , ? Ap Ȋ A   
x / ,   p v    Ӣ  (On|BX  6  35x  ! ; G  G    A ) K Av  d   
 ^ ,   p v    Ӣ  (OG|J^    36q v /  G  E G  ?4 ' W A{ %  u  
  ,   p v    ӣ  (O |Rd    37j  =  G  C:   < %\ b A r  ,  
-  ,   p v    ӣ ̓ (N|Zk  V  38c 	 K t F  @ {  :< #% n A     
  ,   p w    ӣ \ (N|aq    39\  Z 2 F  >   7   y A     
N  ,   p w    Ӥ $ (N|ix  *  3:U  h  F  <h   5=   A a  
R   
 F ,   q w&    Ӥ  (N|q~  wI  3;N 3 v  F  7   0 G  A $ V  D 
  ,   q w?    ӥ ˙ (N5|  7  3=A  K  ' F  5   -z   A ˅ x w V 
  ,   q wL    ӥ } (N|    3>:    F  3O   *   A   / g 
  ,   q% wX     Ӧ F (M|    3?3 c   F  1   (K   A G   y 
 , ,   q. we  }   Ӧ  (M|  W  3@,   ^ F  . L  % h  A ̨    
> Z ,   q7 wr  x   ӧ  (M|    3A% z   F % ,z   # 1  A   Q  
  ,   q? w~  r   ӧ ʻ (Mq|    3B    F - *3       A i #   
\  ,   qH w  m   ӧ ʃ (MJ|  w  3C#    F 4 '    
  A  E   
  ,   qQ w  h   Ө L (M"|  ׊  3D)   Q F < #_ N   S  A ΋  -  
 > -   qb w  ]   ө  (L|  J  3FS 4   F K !   ,  
 A     
 l -   qj w  X   ө  (L|  E  3FX  !  F S  Հ     A I   	 
#  -   qs w  S!  ө ɉ (L|  XA  3G\ K 0 B F [        A ϧ  Q  
  -   q{ w  M!  Ӫ n (L_|  <  3Hb  >  F} b C г  | u , A    , 
X  -   q w  H!  Ӫ 6 (L7|  8  3Ih b L q> Fu j  L   = 6 A O 5  > 
  -' "  q w  C!  ӫ  (L|  x3  3Jm  Z o Fm r    	l  A A Ф W v P 
j  -. '  q w  >!  ӫ  (K|  /  3Kq y i n Ff y m }    L A  y + a 
  -6 -  q x  9!  ӫ ȫ (K|  8*  3Lw  w mq F^   į   _ b B џ  ߙ  
 ] -E 7  q x!  /!  Ӭ < (Kt}  "  3Nê   j FO   G J & m B   O  
Ì  -M <  q x.  *!  ӭ   (KL}  Y  3O Υ  i FG  
P    x B F    
  -U A  q x:  %"  ӭ  (K%}
    3P 0  h] F?   v :   B Қ $ ؼ  
ě  -\ F  q xF   "  ӭ Ǳ (J}&    3Q ɻ  g F8   
    B  G r  
# 
 -d K  q xS  "  Ӯ Ǖ (J}.  x  3R F  e F0  y  * G  B @ i (  
Ū 8 -l O  q x_  "  Ӯ ^ (J}6    3S   d F(  2 ;    B  Ӈ    
1 d -s T  q xk  "  ӯ & (J}>$  8  3T \  cI F!    F   B%   ϔ   
Ƹ  -{ Y  q xx  "  ӯ  (Jb}F*    3U   b F  ]  r i  B. >   # 
  - a  q x  "  Ӱ ƛ (J}V7  V.  3Wl   _y F
     1  B3 z  ȹ 4 
C < - e  q x  "  Ӱ d (I}]=  4  3X}s  ! au F   +    B8 Է 4 m E 
 h - j  r x  "  ӱ , (I}eD  :  3Yvz  / `1 E    2   B>  U $ W 
P  - n  r x  #  ӱ  (I}mJ  v@  3Zo  > ^ E  ? ]  Չ  BC 0 w  h 
  - q  r x  #  Ӳ  (Iw}uP  F  3[h ( L ] E    ` R  BH j   z 
\  - u  r x  #  Ӳ š (IP}}W  6L  3\a  Z \f E       BN դ  F  
  - y  r# x  #  Ӳ ņ (I)}]  R  3]Z = h [" E  g ' ڑ   BS     
g A - }  r* x  #  ӳ N (I}c  X  3^S  v Y E   W  r & B^ O  g  
q  -   r9 x  #  Ӵ  (H}p    3`F   WV E    [ : 0 Bc ։ ?   
  -   rA y
  #  Ӵ  (H}w    3a? f  V E " D    ; Bh  a   
{  -   rH y  #  Ӵ Č (He}}  x  3b8   T E )   ΋  F Bm     
  -   rO y"  $  ӵ T (H>}  ؁  3c1 z  S E 1 ܴ  %  P Br 4  <   
 D -   rW y/  $  ӵ  (H}  8w  3d*   ٱ E 9 l L ɾ X [ Bw m      @ D -   r_ y=  $  Ӷ  (G}  l  3e#   b E @ #  W   e B} ץ    +   E -   rf yJ  $  Ӷ  (G}  a  3f   ڈ E H  {   p B   a  =  E .   rn yX  $  Ӷ Ñ (G}  XV  3g!   8 E P J  # y  B O I   b O F6 .   r} yr  $  ӷ > (GT}  \  3i   ֙ E _  B  A  B ؅ l   u  Fd .   r y  $  Ӹ  (G-}  ve  3i A   I Ex f ̹ ~ m 	  B ذ  <   @% c .#   r y  %  Ӹ  (G}  m  3j  . a Eq n p |p    B      @ d .+   r y  %  Ӹ ³ (F}  6v  3k U < _ Ei v ' z    B      A1 d0 .3   r y  %  ӹ | (F~    3l  J ^Z Ea }  w n _  B 2  _   A dZ .:   r y  %  ӹ D (F~    3m h Y ]  EZ  Ö u0  &  B ]     B= d .B   r y  %  Ӻ 
 (Fi~  V  3n  g [ ER  N r    B و 8    B d .J   r y  }%  Ӻ  (FB~    3o }| u ZK EJ   m  }  B  z 6  C e .Y   r y  r%  ӻ  (E~+  vW  3q x  W E;  x ky  E  B     DQ e* .a   r y  m%  ӻ f (E~3  e  3r v  V; E3  2 i
 y 
  B /   ) D eT .h   r z   g&  Ӽ . (E~;  6s  3s& s  T E,   f (   B W  Y ; EY e} .p   r z
  b&  Ӽ  (E~C    3t. q+  S E$   d-    B    M E e .x   r z  ]&  Ӽ  (EX~K    3u6 n  R* E  ^ a  c  B ڧ    _ Fa e .   r z&  W&  ӽ  (E1~S  V  3v> l>  P E   _T 4 + ) B  B z p F e .   r z3  R&  ӽ l (E
~Z	    3wF i  Ot E
   \   4 B  c }/  Gh f" .   r z@  M&  Ӿ 4 (D~b    3xN gP  N E  C X @  J B H  x  Hn ft .   r zY  B&  Ӿ  (D~r  ֖  3zU bc  Kb D   U  H V B p  vP  H f .   s zf  =&  ӿ  (Dn~z#  6  3{_ _  J D   S4   a B ۘ  t  Is f .   s
 zr  7'  ӿ r (DG~)    3|{h ]u , H D  m P K  l B  	 q  I f .   s z  2'   : (D ~/    3}tr Z : GO D   & NY   w B  + op  Jw g .   s z  -'    (C~6  V  3~m{ X H E D   K  f  B  L m&  J g@ .   s z  ''    (C~<    3f V V D D   I~ X -  B 8 m j  Kz gi .   s$ z  "'    (C~C      ǎ S d C< D  P G  ~  B `  h " K g .   s* z  '   x (C~I  w4    Q! r A D   B4 d z  B ܯ  c F H p .   s7 z  '   % (C6~V  7    L2  u D . v ?  xI  C   a X I p .   s> z  
(    (C~\      I  t9 D 6 / =U | v  C   _e j J q .   sD z  (    (B~b      GC  r D =  : zn s  C ' 3 ] | J q5 .   sJ z  (    (B~i  W    D  q D E  8w x q  C N T Z  K  q_ /   sQ z  (   b (B~o      BU  p% D M V 6
 u og  C v t X  K q /
   sW {  (   + (Bs~v      ?  n D T 
 3 sy m-  C ݞ  V;  L0 q /   s] {  (    (BL~|  w   	 =e  mm D \  1+ q) j  C   S  L q /   sc {%  (    (B%~  ~   
 :  l D{ d 5 ,K l f  C!   O\  M r0 /(   sp {?  )   h (A     t 5 
 iX Dl s | ) j4 dK  C$ <  M  NN rY /0   sv {L  )   1 (A	     
m# 3  g Dd { z 'k g b % C( c 8 J  N r /8   s| {Y  )    (A  X   f( 1 ) f D\  x\ $ e _ 0 C+ ރ Y H|  O[ r /?   s {f  )    (Ab     _- . 7 eB DU  v " cT ] ; C/ ޤ z F1 0 O r /G   s {s  )    (A;!     X2 , E c DM  s   a [h F C2   C B Ph r /O   s {  )   n (A)  x   Q7 ) S b DE  q  ^ Y/ P C6   A S p  /W   s {  )   R (@1     J; '/ a # D>  o: 6 \} V [ C9   ?Q e p  /^   s {  )    (@9  8   C@ $ o "{ D6  j L W R p C> G  :  q Q /n   s {  *    (@xH     4    D'  h`  U PK { C@ g @ 8p  r x /u   s {  *    (@QP  U   - O  V D  f a S] N  CC ߈ ` 6%  r  /}   s {  *   X (@*X     &    D  c  Q K  CE ߨ  3  r  /   s {  *   ! (@`      _   D  a v N I  CH   1  su  /   s {  *    (?h  u      / D  _= 
  L Gi  CJ   /D  s  /   s {  *    (?p      n   D   \  J> E/  CL 
  ,  ti 8 /   s {  *    (?x  6      k C  Z  G B  CO *  *  t ^ /   s |	  *   ^ (?h  
   
 }   C  V  ' Cf >  CS k A & & u  /   s |"  +    (?  X   i 	 	 C C  S  A <K  CU  a # 7 vP  /   s |.  ~+    (>     n    C  Q 9 > :  CW   ! H v  /   s |;  y+    (>     s  % } C 
 OE  < 7  CZ   4 Z un + /   s |G  t+   d (>  x    y " 3 /Z C  L J :E 5  C[    k u R /   s |T  o+   I (>~     !~  A - C  J  7 3g  C^ 
   } vi y /   s |`  i+    (>W"  7   "Ӄ 0 O , C $ Hl [ 5 1-  C_ -  R  v  /   s |m  d+    (>0(     #̈  \ +1 C , F!  3m .  Ca M $   wc  /   s |y  _+    (>	.     $ō ? j ) C 3 A  . * 0 Ce  f n  x\  /   t |  U,   O (=;     &m M  ' C C ?= x , (E 9 Cf   "  x : 0    t |  P,    (=B     's   % C J <   *K & C Ch     yU ` 0   t |  K,    (=nH  v   (z [  $B C R :  ( # M Cj   
  y  0   t |  E,    (=GN     )   " C Z 8[  % ! V Cl   A 	 zL  0   t |  @,    (= U  6   * i  !{ C} b 6 ݕ #q _ ` Cm /    z  0   t |  ;,   U (< [     +     Cv i 3  !) % i Co P +  , {B  0&   t$ |  6,    (<a     , v   Cn q 1w ؠ   r Cp p L ] > {  0.   t) |  1-    (<h  V   -   Q Cf y , Ӥ O y  Cq    ` | k 0= ~  t2 }  '-    (<^u     /x{    CW  * &  @  Cr   { r },  0E z  t7 }  "-   [ (<7'{  u   0q ڑ  & CO  (K Ψ    Cr   /  }  0M v  t< }  -   # (</     1j    CG  & ) v   Cs     ~   0T r  t@ }(  -    (;7  5   2c ՞ - ^ C@  # ɪ - 
  Ct 2 
   ~  0\ n  tE }4  -    (;?     3\ % ;  C8  !l +  Y  Ct R . K   ' 0d j  tI }A  -    (;G     4U Ы I  C0  " ī  	   Ct r N     M 0l f  tN }M  	.   a (;uO  V   5N 1 W 1 C)   ( 
S   Ct  n    r 0s b  tR }Z  .   ) (;NW  *   6G ˸ e  C!  A !  r  Cs       0 Y  t[ }r  .    (; g  ww   89   { C    x  9  Cs     :  0 T  t` }~  .    (:o  r   92 J   C
    /   Cr       0 O  td }  .   g (:w  7l   :+    C  Z     Cr 3  6 0   : 0 J  th }  .   / (:  g   ;% V  H B       Cq S 0  A  ^ 0 E  tl }  .    (:e  a   <    B    U Q  Cq s P ܞ R y a 0 @  tq }  .    (:>  W\   = b  5 B  
n     Cp  p R d   0 ;  tu }  /    (:  V   >    B        Cp    u k  0 6  ty }  /   m (9  Q   ?	 n  g B    3 j . Cn   o  \  0 ,  t }  /    (9     @9 y   B  2   0 6 Cn   "    0 &  t }  /    (9|  7   A;   3 B   z   > Cm 3    L ? 0 !  t }  /    (9U     B=    B "   W  F Cl S 1 ̉   d 0   t ~  /   s (9.     C> 
 ' e B * E r   N Ck r Q =  ;  0   t ~  /   W (9  Wq   D@  5 	 B 2    I V Ck  r     0   t ~  0    (8  V   EB  C  B 9  h   _ Ci   ť  *  0 
  t ~+  0    (8  ;   FD  Q / B A V  8  g Ch   V    0   t ~7  0    (8  w    GF ! ^  B I   ܫ ] x Cd    3  @ 1   t ~P  0   ] (8E!  7f   I] + z  B X k A d "  Cb )  q D  d 1   t ~\  0   % (8'  ^   Jb    B `      C` G 6 $ V y  1   t ~i  0    (7-  V   Kf 6   * Bw h  .  Ӯ  C^ e W  g   1%   t ~u  0    (74  WN   Lk    Bo o ~  ӑ s  C\  x  x d  1,   t ~  0    (7:  F   Mp @  Z Bh w /  I 8  CZ   ?    14   t ~  1   c (7A  ?   Nu    B`       CX     N  1<   t ~  1   + (7\'G  w7   Oz J   BX  ޑ ~ ̽   CV      = 1D   t ~  1    (76/M  /   P~   # BQ   x . M  CR       1S   t ~  w1    (6?Z     R}   R BA  י vd    CP 8 ;     1[   t ~  r1   i (6G`     Sv ^   B9  E s á   CM V \ r    1b   t ~  m1   1 (6Og  W   To ~  ` B2   qN [   CK t } &    1j   t ~  h1    (6tWm     Uh |h    B*  Р n  c  CI       1r   t ~  c2    (6M_t     Va y -  B"  M l7  '  CF    #  
 1z   t ~  _2    (6&gz  w   WZ wq ;  B   i    CD   ? 4 q - 1   t   Z2   o (6 o  }   XS t I  B  ɧ g  @   CB    E 7  1   t   U2   7 (5w  7r   YL rz W  B   b	  =  C= ( @ Y g  ǘ 1 {  t ,  L2    (5     [> m r  A  ® _} l   C: F ` 
 x ʄ ǹ 1 t  t 9  G2    (5e  U   \7 k	  £ A  Z \ %  
 C8 d      1 l  t D  B2   u (5>     ]0 h  3 A   Za    C4   r  [  1 d  t Q  >2   = (5     ^) f   A   W  Q  C1   %    1 \  t \  93    (4  u   _" c  T A  d UA P   C-     1 ? 1 T  t h  53    (4     ` a   A 
  R 	  & C*     ̛ ` 1 K  t t  03    (4  5   a ^  t A   P    - C'    >   ȁ 1 C  t   ,3   { (4|     b
 \"   A   J 6 , ; C 3 _     1 2  t   #3    (4/  X{   d * W)  # A )  Hl   A C Q ~ ~T 	 C  1 )  t   3    (4  h   d, T   A 1 n E   F C n  | 	! έ  1 !  u   3    (3  U   e0 R1 
 C A 8  CJ b | K C   y 	1  % 1   u   4    (3  xB   f3 O   A @  @  A P C   wl 	B  F 1   u   4   I (3  .   g6 M9 % c A H e >$   U C
   u 	S  f 2   u
   4    (3m  8   h9 J 3  A P  ;   Z C	   r 	c P ɇ 2
   u
   4    (3F      i< HA A  A W  9 F  ^ C   : p 	t и ɧ 2   u   4    (3      j? E N  A _  3   h B ; x k 	 ч  2$   u   4   O (2     lJ @ j 0 Ap n  1K s  m B X  i 	   2+   u   4    (2 
     mM >P w  Ai v W . /  r B u  gL 	 V ( 23   u   4    (2(  w   nP ;  O Aa ~  ,'  k v B   d 	 ҽ H 2;   u '  5    (2^0  ױ   oS 9W   AY   )  1 { B   b 	 # h 2C   u 3  5   q (288   7   pV 6  n AQ  O ' [ ~  B   `b 	 ӊ ʈ 2J   u >  5   : (2@&     qY 4^   AJ   $q } |  B  2 ^ 	  ʨ 2R   u! J  5    (1H,  u   r\ 1   AB   ! z z  B  R [ 

 V  2Z   u$ V  5    (1P3  Wa   s_ /e   A:    vB v  B @  W, 
+ |  2i   u( m  5   w (1v`@     u` *k  r A+     s s  B ]  T 
;   2q   u* y  5   @ (1OhF  w   v{d '   A#  >  q q  B z  R 
L Q ' 2y u  u,   6   $ (1)pL     wtg %q    A  ~  oo o[  B   PC 
] ֺ H 2 k  u.   6    (1xS  6   xmi "   A  | _ m( m   B  
 M 
m $ h 2 a  u0   6    (0Y     yfm  x   A  z9  j j  B  , K 
~ ׍ щ 2 V  u2   6   } (0_     z_p  ) ; A  w 
3 h h  B  J IZ 
  ѩ 2 L  u4   6   F (0f  V   {Xt ~ 7  @  u 
 fV fq  B  i G
 
 . S 2 A  u6   6    (0gl     |Qw   E { @  p q a a  B D  Bo 
  ߐ 2 +  u9   6    (0y  u[   ~CR  ` x @  n  _ _  B `  @" 
 L ߮ 2    u;   6    (/  Y   <X  m w @  l-  D ]@ ]  B |  = 
   2   u<   7   L (/  5X   5^  { v @ 	 i  Z [J  B   ; 
 
  2 
  u>   7    (/  V   .c   t @  g  X Y  B    97  h  2   u@   7    (/  U   'i 
  s' @  e( ~ Vp V  B  ? 6   % 2   uA   7    (/Y  US    o   q @ ! b  T+ T  B  ] 4 ! $ B 2   uC   7    (/2  Q   u   p< @ ( `z P Q R_  B  | 2K 2  ` 2   uD (  7   R (/  P   {   n @ 0 [   MZ M  B| @  - R <  2   uG ?  7    (.  Տ      k @ @ Yt  K K  Bw \  +_ b   2   uH K  7    (.  5       jg @ G W  H Iq  Bq w  ) r   3   uJ V  8    (.q  y      h @ O T W F G3  Bl   &  R  3   uK a  }8   X (.K	  n    $  g| @ W Rk  DG D  Bg  8 $q    3   uL m  y8     (.$  Uc      f @ _ P * B B  Ba  W "$  
 - 3   uM x  u8    (-  X    (  d @x f M ޓ ? @  B\  v   f J 3# }  uO   q8    (-!  M   ڪ  , c @q n KY  =~ >F  BW      f 3+ q  uP   m8   y (-)  uB   Ӯ , : a @i v F  8 9  BL 1    w  3; X  uR   e8   & (-c9  6    0 U ^ @Y  DV 5 6 7  BF L      3B L  uS   a8    (-<A       c ]D @R  B  ѝ 4o 5W  B@ f  K  ! } 3J ?  uT   ^9    (-J      3 p Y @J  ?  2, 3 # B;  1   z  3R 2  uU   Z9    (,R  V    ߵ ~ X @B  =S n / 0 ( B5  P  #   3Z &  uV   V9   H (,Z      7  V @:  :  - . - B0  n 
` 3 -  3a   uV   R9     (,b      ڹ  U2 @3  8 > +b ,j 2 B*    C   3i   uW   O9     (,{j  v     :  S @+  6P į ) */ 8 B&    S  
 3q   uX   K9    (,Ur     & ռ  RF @#  1  $ % B B    # r  B 3   uZ   D9   N (,%     T о  OZ @  /K 
 "T #| G B 9     ^ 3   uZ   @9    (++     Z @  M @  ,    !@ L B S '   ? z 3   u[ !  <:    (+2  W   y`   Lm @  *    Q B m G 7   " 3   u[ -  8:    (+8     rf C   ?  (B k   U B  f   W < 3   u\ 7  5:    (+m?     kl   { ?  %  I  W B      U 3   u\ B  2:   T (+GE  w   dr E   ?  # R  O Z B   H   o 3   u] M  .:    (+ K     ]x     ?  !,    ] B
     A  3   u] X  +:    (*R  7   V~ G .  ?  r  =  b B   Z    3 i  u^ m  %:   v (*^     H I I 
 ?     
 ^ e B  " " 
 
 (  3 [  u^ x  !:   > (*e  X   A  W  ?     
! g A ; B  
 u  3 L  u^   :   " (*`k      : K d 
* ? ! [  	t 
 j A U a k 
-   3 >  u_   ;    (*9r     3  r  ? (  y 0  p A o   
< 
   3 0  u_   ;    (*x  w   , M  7 ? 0    m v A    
L Y 9 3 !  u_   ;   | ()~     %    ? 8 \ ]  0 | A   { 
[  R 3   u_   ;   D ()  7    O  C ? @    g   A   + 
j  k 3   u_   ;  	  ()         ? G _   |  A   ڎ 
   4   u_   ;  
  ()R  U   	o    ? W 	 (  >  A 	 = = 
   4   u_   ;  
  ()+     w R  ] ? _   [    A # ^  
   4   u_   ;  
 J ()$         ?x g  [ 
    A = ~ Ӝ 
   4$   u_   ;    ((,  u    S  $Y ?q n  }    A V  M 
    4+   u_   <    ((4        " ?i v    I  A p   
 _ : 43   u_   <    ((<  5    T  !e ?a ~ C g O   A   ̮ 
  T 4;   u^   <   l ((kD      ߝ    ?Y       A   ^ 
  m 4C |  u^   <  
 4 ((DL     ئ T ! p ?Q  + z  U  A  = ſ    4R ^  u^ /  <    ('\     ʤ U < { ?B   x> C   A  ] p #   4Z N  u^ :  <    ('d     í  I  ?:  o u     A 
 }   3 <  4b >  u] E  <   r ('m  u    U W  ?2   s(    A $   B   4j /  u] P  <   : ('u       d  ?+   p x a  A =   Q   4q   u\ Z  =    (']}  5    U r  ?#  U n 6 $  A W  0 a &  4y   u\ e  =    ('7         ?   k    A q   p t 8 4   u\ p  =    ('  
    ~T   ?   h ׯ ٪  A      Q 4   u[ {  =   x (&  V    {  ! ?   c ( /  A  \   2_ 	
 4   uZ   =   	 (&      v  ͎ >  ڄ aR    A  ~   2 	
 4   uY   =    (&w  u    tS   >  2 ^ Π в  A   N  2 	
 4   uX   =    (&P     } q  ʒ >   \3 ] t  A 
    3$ 	
 4   uX   =   b (&*  5   v oR   >  } Y  5  A $    3f 	 4   uW   =   * (&$     o l  ǖ >    W    A =  \  3 	 4 {  uV   >    (%*     i jQ   > 
  T Œ ǻ  A V    3 	. 4 j  uU   >    (%1  V,   b g  ę >  g Q P ~  A p >   4' 	D 4 Y  uT   >    (%7  A   [ eP   >  ǯ L    A  }  # 4 	p 4 7  uR   >   0 (%CD  w   M\ `N .  > ) U JA    A|    2 4 	 4 &  uQ   >    (%J  ס   Fb ] ;  > 1  G C   Aw   x A 5& 	 4   uP   >    ($Q  7   ?i [M I ! > 9  E   K  As   ' O 5 	
< 4   uO   >    ($W     8o X V Ǻ > @ C B    An    ^ 6 	
R 4   uN   >   R ($]     1u VK d ; > H  ? z   Ai     m 6\ 	
h 5   uM   >    ($d  W   *| S q ļ > P  =d 7   Ac 9 8 6 | 6 	
~ 5
   uL *  >    ($\j     # QI ~ > > X 1 :  W  A\ R X   6 	
 5   uJ 4  ?    ($6'q      N   > ` w 5 l   AN   A  7\ 	
 5$   uH H  ?   X (#7}      I   >p o  2 )   AH     7 	
 5,   uG R  ?   ! (#?  8     GD  C >h w  0^  \  AA     7 	
 54 v  uE ]  ?    (#H       D   >`  c -    A:   M  8 	
 5< d  uD g  ?    (#vP      BA  E >X   +) a   A3   }  8W 	 5D R  uB q  ?   z (#OX  W    ?   >Q   (    A,  = {  8 	) 5K ?  uA {  ?   B (#)`      =?  G >I  N %  ` 
 A%  ^ y[   8 	> 5S -  u@   ?    (#h      :   >A   #Y  !  A 0  w
  9 	S 5[   u>   ?    ("p  w    8<  J >9  / %    A b  ri , 9 	} 5j   u;   @    ("  5|   u 39  L >*     e  A	 z  p : 9 	 5r   u9   @   H ("i  z   { 0 ,  >"  o   &  A   m I G 	@ 5z   u8   @    ("B  x    .6 9  >   Z N   @  $ ku W G 	S 5   u6   ~@    ("  Uu   غ + G V >       @  E i% e G 	f 5   u4   {@     (!  s   ٳ )2 T  >
  M *  i  @  f f s H$ 	y 5   u2   y@    j (!  q   ڬ & a T >     +  @   d  HZ 	 5   u0   w@    3 (!  uo   ۥ $/ o  =    C   @   b1  H 	 5 q  u.   u@  !  (!  l   ܞ ! | R =     n  @ @  ]  H 	 5 K  u+   p@  "  (!6     ޑ   ~O =  z # x / ! @ Y 	 [<  I, 	 5 7  u)   nA  " p (!     ߊ &  | =    }6  $ @ q , X  I_ 	 5 $  u'   lA  # 9 (   W   
   {M =    z } ' @  N V  I 	 5   u%   jA  #  (      | !  y =  ~g ] x {o * @  q TH  I 	 5   u" #  hA  $  ( 
     u   xK =  |  vm y/ - @   Q  N 	%T 5   u  ,  fA  $  ( v  ws   n    = # y . t) v / @   O  O6 	%i 5   u 7  cA  % Z ( P  h   g 
  Q = * wR  q t 2 @   MT  Ov 	%~ 5   u A  `A  % # ( )  7\   `    = 2 r f m` p. 6 @   H . O 	% 5   u U  [A  &  ()  b   R,    = B p9  k m 8 @ 7 ? F` = P4 	% 5   u `  XA  & | (0  WV   K/   H = J m 4 h k : @ O a D K Ps 	% 6 r  u j  UA  ' E (#6  I   D4  )  = Q k{  f im ; @ f  A Z P 	% 6 ^  u t  SB  ' ) (j+=  =   =8  6 D = Y i  dW g- = @y ~  ?l i P 	% 6 J  u ~  PB  (  (C4C  w0   6< 	 C  =~ a f Z b d > @p   = w Q. 	& 6 6  u
   NB  (  (<I  $   /@  Q ? =v i d\ ߵ _ b @ @g   :  Ql 	&% 6& "  u   KB  )  (DP  7   (D  ^  =n q a  ] `k A @^  	 8u  Q 	&9 6. 
  u	   HB  ) K (LV     !H  k : =f x ]>  Y [ D @K  I 3  R$ 	&b 6=   u   CB  *  (\c  WV   _ z  5 =W  Z , V Y E @B 
 j 1  R` 	&v 6E   u   AB  +  (]ei  G   d    =O  X Ҋ T Wl G @9 &  //  R 	& 6M   t   >B  + l (7mp  8   g t  0 =G  V   RB U+ H @4 >  ,  R 	& 6U   t   <B  + 5 (uv  w*   k    =?  S m O R I @0 W  *  S 	& 6\   t   9C  ,  (}|     n n  + =8  Q`  M P J @+ o  (9  SP 	& 6d }  t   7C  ,  (  7   s    =0  O  T Kw Nh K @'   %  S 	& 6l h  t   4C  -  (     w g  % =(  L  I4 L( N @#  : #  R_ 	% 6t S  t   2C  - r (w     z   m =   G  D G U @  ~  4 R 	% 6 (  t   -C  .  (+     P   h =  E " Bj Ee X @    B S 	& 6   t   *C  /  (     U Z 
  =	  C2  @' C$ X @   P Q SK 	&% 6   t    (C  /  (  u   Y   c =  @  = @ X @
    _ S 	&8 6   t *  %C  0 ] (  {   _ S $  <  >u { ; > [ @ 3   m S 	&L 6   t 4  #C  0 % (  5v   e  2 ^ <  <  9] <` ^ @ K , [ | S 	&_ 6   t >  !D  1  (k  q   j L ?  <  9 R 7 : a ? d P 	  T3 	&s 6   t H  D  1  (E  l   p  L X <  7`  4 7 c ? | t   S 	%> 6   t R  D  1 ~ (  Ug   u E Y E <  2  0P 3X h ?   
  TL 	%c 6 f  t e  D  2  (  @  { = t @ <  0K  .
 1 k ?     T 	%v 6 P  t o  D  3  (  u<      <  - ^ + . m ?   n  T 	% 6 :  t y  D  3  (   8   5  : < $ +  ) , o ?  *   T 	% 6 $  t   D  4  (_  54      < , )4 / 'C *L r ? 
 O    U& 	% 6   t   D  4 M (9  0  y -  4 < 4 &  % ( t ? $ t w  U[ 	% 6   t   D  5  (  ,  r    < < $z   " % v ? ;  & 	 U 	% 6   t   
D  5  (   U(  k %  / < D " h  ~ # x ? R    U 	% 7   t   E  6  ()  $  d    < K b 8   } ?   / 3 V0 	&	 7   t   E  7 7 (z9  u8  
V    < [     ~ ?  *  B Vd 	& 7   t   E  7   (TA  2  O   # <| c   r w } ?  N  P V 	&- 7  p  t   E  7  (-I  5,  H    <t k : o . 4 | ?  r 7 ] V 	&? 7( Y  t   E  8  (Q"  '  
A    <l s     { ?    k W  	&Q 70 B  t   E  8 Y (Z(  !  :   ~ <e z o B   { ?    z W3 	&c 77 +  t   E  9 ! (b/  U  3  , } <]    b i y ?   =  Wf 	&t 7?   t   E  9  (j5    , } 9 { <U     & x ?w *    W 	& 7G   t   E  :  (nr<    %  F z <M   z  
 v ?k Z K E  W 	& 7W   t   F  ; _ ("H  ՛    ` w
 <=  ~ x\ V ] w ?e r o   X/ 	& 7^   t   F  ; ' (O  5   j n u <6   u   x ?_   ۠  Xa 	& 7f   t '  F  <  (U  e  	  { t <.    s:    y ?Y   N  e 	1 7n   t 0  F  <  ([  J   `  N <&  ^ p   z ?T     e 	1 7v q  t :  F  =  (b  U.     Mc <   n H P { ?N   Ԩ  e 	1 7~ Y  t C  F  = I (ch     V  K <   k   { ?H  # U  f 	1 7 A  t L  F  >  (=o        JY <  < h   | ?B  G   f2 	2 7 *  t~ U  F  >  (u  t   L  H <  s c ; C z ?6 0  \ , e 	19 7   tw h  F  ? k (  6  V ~A  = ;   a=   w ?0 H  	 9 f 	1H 7   ts q  F  ? 3 (    \ {  <x ;   ^   u ?* `  ƶ G f@ 	1W 7   to z  G  @  (~    b y6  : ;  ; \ q x r ?$ w  c T fg 	1f 7   tk   G  @  (W  V  i v  9n ;   Y / 6 o ?     a f 	1u 7   tg   G  A  (1    o t,  7 ;  k V   l ?  D  o f 	1 7   tc   G  A U (     v q  6c ;   Tb   j ?  h j | f 	1 7 h  t^   G  B  (  v  !| o  % 4 ;   Q f k g ?     g 	1 7 O  tZ   G  B  (    " l 2 3Y ;   L   a >   p  gO 	1 7   tR   G  C  (r    $ g L 0O ; / a J ܝ ߠ ^ >     gu 	1 7   tN   G  D [ (L    % e
 Y . ; 6  Gu Z \ [ > 3    g 	1 7   tJ   G  D $ (&&  V  & b f -D ; > Տ D   W > J > v  g 	1 7   tE   G  E  ( /    ' _ s + ; F & BB   T > b b "  g 	1 8   tA   G  E  (7    (~ ]x  *9 ; N о ? ӑ ֑ Q > y    h	 	2 8   t=   H  F } (?  v  )w Z  ( ; V W = N N O >   |  h- 	2 8   t8   H  F E (G    *p Xl  '/ ; ^  :u  
 M >   (   hQ 	2" 8 o  t4   H  G  (gO  6  +i U  % ;y e " 5A ʅ ͂ H >     h 	2= 8* <  t+ 
  H  H  (`    -[ P  " ;j u ĺ 2 B ? F >  7 - ( h 	2K 82 #  t'   H  H g (h  V  .T NT  ! ;b } Q 0	   C >  Z  5 h 	2Y 8: 	  t"   H  I 0 (p    /M K   ;Z   -o ù ƶ @ >  }  B i 	2f 8B   t %  H  I  (y    0F IG   ;R   * w s > > 3  0 O i$ 	2t 8J   t .  H  I  (  v  1? F   ;J   (J 3 . ; > J   \ iF 	2 8Q   t 7  H  J  (\    28 D:   ;C   %   9 > a   i ( 	I 8Y   t ?  H  J Q (6  6  31 A  
͛ ;;  K #9   6 > y 
 4 u = 	I 8a   t G  H  K  (!    4* ?-  
 ;3  | ( (  0 >  V   e 	I 8q T  t X  I  L ~ (.  W  6 :  7 
 ;#      - >|  { 9  | 	D 8y :  s `  I  L ~s (4    7 7 D 
` ;      * >x     | 	D 8   s h  I  M ~< (w;    8 5 Q 
 ;  <  ^ M $ >s     | 	D 8   s p  I  M ~ (QA  w  9 2 ^ 
P ;       >n   <  | 	D 8   s w  I  N } (+G    :  0 k 
} ;  Z r    >i  
   | 	D 8   s   I  N } (N  7  :' -~ w 
|@ :       >d 6 1 ~  + 	g 8   s   I  O }] (T    ;- *  
 :  x \ I :  >_ O V |?  : 	g 8   s   I  O }& (Z    <3 (q  
? :   E    >U   w  X 	g 8 d  s   I  P | (mg    >) #c « 
% :  &  x k  >Q   uB  g 	g 8 I  s   I  Q | (Gn    ?0   ¸ 
 : 
  5 3 &  >N   r  u 	g 8 .  s   I  Q |H (!t  v  @7 T  
 :  R     >J   p   	g 8   s   I  R | (
z  ֝  A>   
 :   (    >F  / nE +  	g 8   s   I  R { (  6  BD F  
 : " |  a W  >B  S k 7  	g 8   s   I  S { (    CK   
e : *      >>   w i D  	g 8   s   J  S { (%    DR 7  
 : 1      >:  )  gG P  	g 8   s   J  T {N (b-  V  EY   
K : 9   O F  >3  Y  b h  	g 8 o  s   J  U z (>    G    
1 : I <  
   >.  p  `H t  	h 9 T  s   J  U z (F  w  H 
 - 
 : Q  u    >+   # ]   	h
 9 8  s   J  V zo (N  ׶  I  : 
 : Y ~@   z  >'   E [   	h 9   s   J  V z8 (W  7  J 	 G 
 :~ a { f = 6  >#   g YK   	h 9   s   J  W z  (~_    K  T 
 :v h yD     >    V   	h# 9%   s   J  W y (Xg    L|  ` 
p :o p v N   x >    T   	h+ 9-   s   J  X y (2o  W  Mu r m 
 :g x tM ޾ }o j m >    RM  " 	h3 95   s   J  X yZ (x    Nn  z 
V :_  oX ٜ x { V > .  M  6 	hB 9E u  st -  J  Y x (  wt  P`  Ô 
< :O  l  v y J >  E 3 KL  ? 	hJ 9M X  so 5  J  Z x (  r  QY R á 
 :G  jd ~ t[ wY ? = ] U H   	b 9U <  si <  J  Z x{ (s  7q  RR  î 
 :?  g  r u 3 = t w F   	b" 9]   sc C  K  [ xD (M  o  SK B û 
* :7  eg _ o r $ =   DL    	b% 9d   s] J  K  [ x ('  n  TD   
 :0  b  m p  =  » A   	b( 9l   sW P  K  \ w (  Wl  U= 1  
 :(  `[ V kI nI  =   ?  w 	b+ 9t   sQ W  K  \ w (   k  V6   

 :   ]  i l  =   =L ! k 	b. 9|   sK ^  K  ] wf (  i  W/ !  
 :  X  d} g}  =  B 8 7 I 	p 9 r  s? l  K  ^ v (i  ,  Y!   
Wq :  VB U b8 e9  =  d 6M B I 	v 9 U  s: s  K  _ v (C  5|  Z ܈  
U :   S  _ b  = 0 Å 3 N H 	{ 9 8  s4 z  K  _ v (     [  " 
TM 9  Q; T ] `  = H å 1 Y G 	 9   s.   K  ` vP (
&    \ w / 
R 9  N  [g ^p  = `  /M d F 	 9   s(   K  ` v (
-  Vl  ]  ; 
Q* 9  L9 R Y" \- | = x  , p E 	 9   s"   K  a u (
3    ] e H 
O 9  I  V Y m =   * { C 	 9   s   K  a u (
:    ^  U 
N 9  G7 P T W ^ =  " (M  A 	 9   s   K  b ur (
_@  w\  _ S b 
Lt 9  B6 M P
 S$ @ =  ` #  < 	 9 k  s
   K  c u (
M  5  a B | 
IQ 9  ?  M P . =   !N  9 	 9 N  s   K  c t (%S    b Ź Ĉ 
G 9 % =! E K N  =  Ğ   5 	 9 0  r   K  d t (-Y    c 0 ĕ 
F. 9 - :  I> L]  =  Ľ   2 	 9   r   K  d t\ (5`  U  d  Ģ 
D 9 5 8 < F J  = 6  M  . 	 9   r   L  e t$ ({>f    e  į 
C 9 = 5v  D G  = M    * 	 9   r   L  e s (UFm    f  ļ 
Ay 9 E 2 5 Bn E  = e    % 	 :   r   L  f s (/Ns  u  g   
? 9 M 0j  @) CS  = | 8 M  ! 	 :
   r   L  f s} (	Vy  ձ  h
   
>U 9 T +^  ; >  =  v    	 : _  r   L  g s (g  Q  j/ o  
;2 9{ d ( " 9[ <  =  ŕ L   	c :! @  r   L  h r (o  R  k5   2 9s l &S  7 :I m =  Ŵ 	  b 	b :) "  r   L  h r (qx  VS  l; \   9k t #  4 8 [ =     C 	a :1   r   L  i rL (K  T  mA    9c | !G  2 5 I =   I ) # 	_ :9   r   L  i r (%  U  nH I "  9[    0H 3 5 =    3  	^ :A   r   L  j q (
  vV  oN  /  9S  *  . 1:  = 5 1   <  	\ :I   r   L  j q (
  V  pzT 6 < _ 9K   
 + .  = L P C F  	[ :Q   r   L  k qn (
  6W  qsZ  H  9C  }  '3 *t  = { ƌ  Z  	W :` I  r "  L  l p (
h  I  se  b  94   | $ (1  =  Ʃ ? c _ 	U :h *  r '  L  m p (
B  WE  t^  o  9,  _ z " %  =    m  	U :p 
  r -  L  m p (
  A  uW  { 
 9$   w  d #  =    x  	X :x   r 4  L  n pX (	  =  vP  ň 
g 9  
? t  !m  =~    =   	Z :   r{ ;  L  n p  (	  w:  wI p ŕ 
 9   rx  + n =z      	] :   ru B  L  o o (	  6  xB  Ţ 
3 9  4 o   \ =v  9    	_ :   rn I  L  o o (	  72  y; \ Ů 
 9   mm O  G =r  V :   	a : o  rg O  L  p oz (	^  .  z4  Ż 
  8   ha  &  =j K Ǐ    	f : 1  rZ ]  L  q o (	  T~  |&T   
 8   e    =e b Ǭ 9   	h :   rS c  M  q n (    }\ 3  
3 8   cY ;   =b z     	j :   rL j  M  r n (
    ~d ~  
 8   `  c  =_   ݍ  q 	l :   rF q  M  r nd (  t  l |  
 8 
 { ^T 	 
!  =\   7  a 	n :   r? w  M  s n, ({  Ԯ  
s y  
f 8   [ l 
  =Y     Q 	o :   r8 ~  M  s m (U%  4  { w	   8  s YP &   =U  9 ֊  A 	q : t  r1   M  t m (/.     t ! 2 8 !  V  ]  =R  V 3  0 	s : T  r*   M  t m (	6%     q .  8 )  Q V  z =K  Ȏ φ  Y 	 :   r   M  v m (G2  s   l G v 8 9 a OE   h =H 2 Ȫ 0  1 	 :   r   M  v l (O9  t   jS T u7 8 A  L  W V =D I   ( 	 	 :   r   M  w l (qW?  vt   g ` s 8 I C J@   : =A `  Ȃ 1  	 ;   r   M  w lp (K_E  u   e= m r 8 Q ܦ G B   == w  + :  	 ;   q   M  x l8 (&hL  6u   b z pl 8 Y 	 E:    =:    D  	
 ; q  q   M  x l ( pR  v   `' Ɔ n 8~ a l B  Q  =6  8 } M e 		 ; P  q   M  y k (xX  v   ] Ɠ m: 8v h  @5 s   =3  U & V ; 	 ;% 0  q   M  y kv (_  Vw   [ Ơ k 8o p ϕ ;/    =,  Ɏ x h  	 ;5   q   M  z k (hl     U ƹ hp 8_   8  I f =(   ɪ   q  	 ;=   q   M  { j (Br  v  $ So  f 8W  Z 6& _  G =$    z  	 ;E   q   M  | j (x    ) P  e> 8O   3   1 =  -  p  e 	 ;M   q   M  | j` (  6  / NX  c 8G  I 1     = D    : 	 ;U i  q   
M  } j) (    4 K  b 8?   . ގ @  = Z     	 ;] H  q   M  } i (    : IA  `t 87  C , H   = q 7 j   	 ;e '  q   M  ~ i (  V  ? F  ^ 8/   )  ݽ  =  R   / 	 ;m   q   M  ~ i (_    xE D*  ^ 8'   $ x :  =  ʉ d   	 ;|   q   M   i (  w  j\ ? + % 8  $ ! 2   =  ʥ 
   	 ;   q   M  Ԁ h (    ca < 7  8   z  Ը  =       	 ;   q    M  Ԁ h (  7  \f 9 D  8    Ψ w  <   `  y 	 ; _  q    M  ԁ hl (    Uj 7n Q O 8    q b 6 j <     T 	} ; =  q{   "M  Ԃ h5 (|    No 4 ]  7      T < )     	 ;   qs   %M  Ԃ g (V  V  Gr 2V j A 7  m g  ˳ > < @ - Y   	 ; ~  ql   'M  ԃ g (0    @x / v @ 7    ő r ' < V H   y 	 ; ~  qd   *N  ԃ g (    9} -> ǃ >z 7   
    <  ~ R   	 ; ~  qU $  0N  Ԅ g ('    + (& ǜ ;B 7  ? R  ¬  <  ˛    	 ; ~q  qM (  3N  ԅ f (/  6  $ % ǩ 9 7    { i  <  ˸    	 ; ~O  qE -  6N  ԅ f (s7     #
 ǵ 8
 7  ) I 5 &  <   K % z 	 ; ~-  q> 2  :N  Ԇ f\ (N@        6n 7 &      <    . G 	 ; ~
  q6 7  =N  ԇ f% ((H  V     4 7 .  G    <    6  	 ; }  q. ;  @N  ԇ e (P     h  37 7 6   e ^ | < 	 + E ? 
 	 ; }  q& @  CN  Ԉ e (Y       1 7 >  E   n < 	# H  G 
 	 ; }  q D  FN  Ԉ e~ (a  v   O  / 7 F , C   S < 	P ́ {= X 
? 	 < }^  q N  LN  ԉ e (kr  4  m 6 
 , 7 U   O S F < 	g ̞ x ` 
	 	 < };  q R  ON  Ԋ d (Ez    s   +, 7 ] ; C 
  8 < 	} ̺ v i 	 	 < }  p W  RN  Ԋ d ($    y  & ) 7z e     + < 	  t7 q ' 

 <" |  p [  VN  ԋ dh (+  T   	 3 H 7r m H @    < 	  q y & 
	 <* |  p _  YN  Ԍ d1 (1    Ѕ  @ 
 7j u ~  : I 
 < 	  o  & 
	 <2 |  p d  ]N  Ԍ c (8    ɋ v L 		 7b } |M >    < 	 , m/  &k 
	 <: |  p h  `N  ԍ c (>  t    Y i 7Z  y     < 	 H j  &/ 
	 <B |i  p l  dN  ԍ cn (bD  Ծ   \ e  7R  t  " =  < 
  f$  % 
	 <R |"  p t  kN  Ԏ b (Q  6   A ~  7B  rU 5    < 
1 ͛ c  # 
9 <Z {  p y  nN  ԏ b ( W  4    ȋ 4K 7:  o ۴    < 
G Ͷ as  # 
2 <b {  p }  rN  Ԑ b ( ^  U1   ' ȗ 2 72  m[ 3 R v  < 
]  _   	 <j {  p   uN  Ԑ bY ( d  /    Ȥ  7*  j ֱ 
 4  < 
t  \  a 	z <q {  p   xN  ԑ b! ( k  -    Ȱ 6 7#  h` 0   ~ < 
  Zl  ) 	s <y {q  p   {N  ԑ a ( Zq  u*    Ƚ  7  e Ѯ   n < 
 % X   	l < {N  p   N  Ԓ a ( 4w  (      7  cd , > k ^ < 
 A U   	e < {*  p   N  Ԓ az ( ~  5&  | d  [ 7  ^i )   > < 
 z Q  D 	V < z  p   N  ԓ a '    n I   6  [ Ǩ o  - < 
 Ζ N  
 	O < z  px   N  Ԕ ` '  T  g    6  Yn & ) _  <~  γ L[   	G < z  po   N  ԕ ` 'w    ` -   6  V £ |  
 <z %  J   	@ < zw  pg   N  ԕ `I 'R!    Y ۟  D 6  Tt   z ~  <v ;  G 
 Z 	8 < zS  p_   N  Ԗ ` ',)  t  R  !  6  Q  xY |  <r Q  ER   	0 < z/  pW   N  Ԗ _ '1    K փ -  6  O  v zR  <n g $ B   	( < z  pO   N  ԗ _ ':  4  E  : i 6  M
  s x  <j } @ @ "  	  < y  pG   N  ԗ _k 'B    >	 g F 
 6  H  oF s  <b  x ; 2 / 	 < y  p6   N  ԙ ^ 'oS  T  0 K _  6 + E  m  qF  <^  ϔ 9 :  	 < yz  p.   N  ԙ ^ 'J[    ) ɽ k  6 3 C"  j o  <Z  ϯ 7B B  	 < yV  p&   N  Ԛ ^ '$c    "  / x 8 6 ; @  hv l  <V   4 J  	 < y2  p   N  Ԛ ^U 'l  t  & Ġ Ʉ 7  6 C >*  f1 j} y <R   2 R w 	 =  y
  p   N  ԛ ^ 't    ,  ɑ 5 6 K ;  c h: i <N   09 Z B 	 = x  p
   N  ԛ ] '|  4  
2  ɝ 3 6 S 92  a e Y <J , ! - c 
 	 = x  p   N  Ԝ ] '    8  ɪ 2H 6 [ 6  _c c J <F B ? + k  	 = x  o   N  ԝ ][ 'g    = g ɶ 0 6| c 1  Z _% * <> n { & { l 	 =( xW  o   N  Ԟ \ '    ? J  -o 6l r /B x X \  <:  М $  6 	 =0 x3  o   N  Ԟ \ '    E   + 6d z ,  VN Z 
 <6  л "(  1 	 =7 x  o   N  ԟ \} '
  t  L ,   6]  *J v T	 XS  <3      	 =? w  o   N  ԟ \E '  Ԙ  R    6U  '  Q V
  </   w   	 =G w  o   N  Ԡ \ '  4  X    h 6M  %Q s O~ S  <+     o 	 =O w  o   N  ԡ [ '`    ^  
  6E  "  M7 Q  <(  4   . 	 =W wz  o   N  ԡ [ ':#    d   0 6=   V m J O;  <$ 
 R j   	 =_ wU  o   N  Ԣ [g '*  T  j b &  65  \ k Fh J  < 
2 э   i 	 =o w
  o   N  ԣ Z '7    Ӳ~ D > ^ 6%    D" Hl  < 
G ѫ `  & 	 =w v  o   N  ԣ Z '=  t  ԫ  K  6  ` g A F' u < 
]  
   	 = v  o   N  Ԥ Zm '}C    դ % W & 6   ~ ? C d < 
s  
   	 = v  o   N  ԥ Z5 'XJ  4  ֝  c  6
  e |b =S A S < 
  V   	P = vu  o   N  ԥ Y '2
P    ז  p t 6   y ; ?W B < 
 !    	H = vO  ov !  N  Ԧ Y '
V    ؏ w |  5  i w] 8 = 1 < 
 >   j 	@ = v*  on &  N  Ԧ Y ']  T  و  ʉ > 5  	 t 6 :  <  
 [ L  / 	7 = v  of *  N  ԧ YW '$c    ځ X ʕ  5   o 1 6D  ; 
 ҕ     	' = u  oU 2  
N  Ԩ X 'v4p  t  s 9 ʮ m 5  r mQ / 3  ; 	 Ҳ C 
  | 	 = u  oL 6  N  ԩ X 'P=v  Կ  l  ʺ 
 5 	  j -p 1  ;      @ 	 = un  oC :  N  ԩ Xy '+E}  4  e   	8 5  v hK +, /u  ; 4      	
 = uH  o; >  N  Ԫ XA 'M    ^    5   e ( -1  ; J 	 : $  	 = u#  o2 C  N  Ԫ W 'V    W |   5 ! z cE & *  ; _ (  ,  	 = t  o* G  N  ԫ W '^  T  P zk  g 5 )  ` $] (  ; t G  3 K 	 = t  o! K   N  ԫ W 'f    I w   5 1 ~ ^> " &]  ;  f / ;  	 = t  o O  $N  Ԭ WG 'no    B uK  2 5 9  Y9  ! ^ ;  Ӥ ~ J  	 = te  o W  ,N  ԭ V '#    5 p*   5 I  V I  M ;   % R S 	 > t?  n Z  /N  Ԯ V '  5  . m ) a 5 Q  T3  C ; ;    Z  	 > t  n _  3N  Ԯ Vi '    ' k
 5  5 Y 	 Q   ) ;    t a  	 > s  n b  7N  ԯ V2 '  T    hz A , 5~ a  O- {   ; 
   h  	 > s  n f  ;N  ԯ U '  U)   e N  5v h  L 6 o 	 ;  =  o  	׸ >& s  n i  @N  ԰ U 'g     cY Z  5n p ߘ J'  (  ; 4 [ h v k 	׭ >- s  n m  DN  Ա Uo 'B     ` f \ 5g x  G 
   ; H y  } " 	ע >5 sY  n p  HN  Ա U8 '  t   ^9 s  5_  ' B 	% 
U  ; r Ե \  'q 
! >E s  n w  RN  Բ T '  6  k Y ˋ w 5O  լ @    ;     ' 
! >M r  n y  WN  Գ T '    p V ˗ v$ 5G  1 =    ;   ͩ  & 
  >U r  n |  \N  Դ TY '    u S ˤ t 5?  д ; V Z  ;   M  &n 
  >] r  n ~  aN  Դ T" '`  V  z Qe ˰ r 57  9 8   d  ;     & 
  >e rn  n   gN  Ե S ':     N ˼ qA 5/  ˾ 6  S v ;   ƚ  % 
  >m rG  n   lN  Ե S '    ӄ LC  o 5'  C 3  ݫ f ;   @  %h 
  >u r  n   rN  Զ S_ '	  v  ̉ I  n  5   1 F _ U ;     % 
  >} q  n|   wN  Է S( '  փ  Ŏ G"  l_ 5   ,    4 ; , L 3  $` 
  > q  nj   N  Ը R '  g   B   i 5  X ) z } $ ;| A f   $ 
  > q  nb   N  Ը R 'Y"  `   ?o  g} 4   & 5 1  ;x U    # 
 z > qY  nY   N  Թ RJ '3')  VZ   <  e 4  d $~    ;t j  '  #U 
 l > q2  nP   N  Ժ R '0/  S   :L  d< 4   !  ͚  ;p     " 
 ] > q
  nG   N  Ժ Q '86  M   7 * b 4  s } i N  ;l   s  " 
 O > p  n>   N  Ի Q '@<  vF   5* 6 ` 4    %   ;h     "G 
 @ > p  n5   N  Ի Qk 'IB  ?   2 C _Z 4   z  Ʒ  ;d     d 
 > p  n-   N  Լ Q 'xQI  69   0 O ׂ 4   x X (  ;\  0    
 > pD  n   N  Խ P '-bU    x * g D 4       ;X  G    
 > p  n   N  Ծ Pq 'j\  V   q (R t ҥ 4 '  u    ;T  a Z  K 
 > o  n	   N  Ծ P: 'sb    j % ̀  4 / & 
 ٍ J x ;P " {  
  
 > o  n   N  Կ P '{i    c #/ ̌ h 4 7  r H  h ;K 7     
 > o  m   N  Կ O 'o  v  \   ̘  4 ? 4    X ;G L  M  t 
t > o~  m   N   O 'qu  ֪  U  ̤ * 4 G  p Ҿ g H ;C `   " > 	 ? oV  m   N   O\ 'K|  6  N z ̰ L 4 O B  y  8 ;? u   &  	 ? o-  m   N   O '&    G  ̽  4 W R     ;6    0  	[ ? n  m   N   N '  S  9     4x g  l ɮ ; 
 ;2  .  5 ݙ 	I ?$ n  m   N   Nb '    	2 3  
 4p o e  i   ;.  H 1 : / 	7 ?, n  m   N   N* '    
+   
Q 4h w  j '   ;*  a  ?  	$ ?4 nb  m   N   M 'j  s  $   
 4`  z   Z  ;%  z ~ D [ 	 ?< n9  m   N   M 'E     	|  
  4X   f    ;!   $ I  	 ?D n  m   N   M '  3  
   
 4P    \   ;    N ۅ 	 ?L m  m   N   ML '     X  
 4H   a  y  ; +  p S  	 ?T m  m   
N   L '      * 
V 4@  * X    ; S  } \ B 	 ?d mk  m{   N   L '  C  2  B 
% 40  |  L   ;	 g  {^ a  	 ?l mB  mr   N   LR 'd  8  7 
 N 
 4(  z< Q  S x ; { " y f j 	 ?t m  mi   $N   L '>
  v-  ; z Z 
 4   w    i :  4 v k  	z ?| l  m`   +M   K '  #  ?  g 
\ 4  uO L   Z :  F tO o ؐ 	g ? l  mW   1M   K '  6  D U s 
 4  r  >  K :  X q t # 	T ? l  mN   8M   Kt '$  
  H   
+ 4	  pd G  E < :  j o y ׵ 	A ? ls  mE   >M   K  ',    M / ͋ 
 4  m    . :  | mB } G 	- ? lJ  m<   EM   J '4  U  Q  ͗ 
 3  i Ѽ / m  :   h  k 	 ? k  m*   RM   Jz '8E  t  p v ͯ 
 3  f 9  #  :   f0   	 ? k  m!   YM   JB 'N  vc  t  ͻ 
2 3  d ̶    : .  c  Ս 	 ? k  m   `M   J
 'V  S  w P  
 3  a 2 d }  : B  a|   	 ? kz  m   fM   I '^  6B  { ݽ  
 3  _- Ǳ   {G  : V  _"   
P ? kP  m   mM   I 'g  2  ~ *  
t 3  \ /  x  : j  \   
Pj ? k%  l   vM   IH '}o!  !   ؗ  
rx 3  ZC ®  v  : } 5 Zk   
PS ? j  l   ~M   I 'Wx(  V     
p 3 & W , T tk  :  L X  #x 
- ? j  l   M   H '2.       p   3 . R *  o  :  z S[   
 ? j|  l   M   Hj ';  t6  "}O J  
!% 3 > Pl   m ~ :   P  D 
~ ? jQ  l   M   H2 'A  @  #vV ˶ ( 
 3 F M ' E kE o :   N   
d @ j&  l   M   G 'H  4J  $o^ # 4 
 3 N K   h ` :   LI  ' 
J @ i  l   M   G 'wN  T  %he Ə @ 
^ 3 V I	 "  f Q :   I   
0 @ i  l   M   Gp 'QT  ^  &am  L 
 3 ^ F  } dq A :   G  	 
 @ i  l   L   G8 ',[  Th  'Zt h X 
/ 3y f D  : b. 2 : .  E8  y 

 @# iy  l   L   G 'a  r  (S|  d 
 3q n A  ~ _ " : A  B   

 @+ iN  l   L   F 'h  |  )L @ p 
  3i v <  zq [b  : h + >&   

 @; h  l   L   F> 't  Օ  +>  Έ 
 3Y  :D  x- Y  : | ? ;  9 

 @C h  l   L   F 'q{  5z  ,7  Δ 
: 3Q  7  u V  :  S 9p   

v @K h  lw   L   E 'K  ^  -0  Π 
 3I  5] 	 s T  :|  h 7   

[ @S hu  ln   L   E '&  C  .) [ ά 
 3A  2  qf RG  :w  } 4   

A @[ hJ  le   L   E` '   U(  /"  θ 
t 39  0w  o# O  :r   2^   

& @c h  l\   L   E( '    0 3  

 31  . ~ l M  :l   0   c 

 @k g  lS   L   D '    1   
	G 3)  +  j Ko  :h   -   	H @s g  lJ   !L   D '  t  2
   
Xi 3!  &  f F  :^   (   	 @ gq  l8   1L   D. 'E)  6  4    
U; 3  $3 u c D w :Y )  &  R 	 @ gE  l/   9L   C ' 1    4 L   
S 3	  !  a BQ g :T <   $9   	 @ g  l'   BK   C ':    5"   
R 3  F q _J @ W :O O  # !  E 	 @ f  l   JK   C 'B  V  6' #  
Px 2    ]	 = G :J c  7    	 @ f  l   RK   CP 'K  v  7+  $ 
N 2  [ j Z ;z 8 :D v  L '  7 	 @ f  l   ZK   B 'S  m  80  0 
ML 2   ~ X 93 * :?   `    	 @ fl  l   bK   B 'e\  vc  94 e < 
K 2  v |a V@ 6  :9   q q  ( 	i @ f@  k   kK   B '@d  Z  :9  H 
J  2    wY Q 2k  :.       	7 @ e  k   {K   B 'u    <  ` 
F 2     t Ot 0'  :(    `   	 @ e  k   K   A '}    =  l 
E_ 2    rU M0 -  :$       	 @ e  k   K   A '  S  > } w 
C 2  % 	; o J +  :       	 @ ee  k   K   A\ '    ?  σ 
B3 2  -  mS H )U  :    
N   	 @ e:  k   K   A% '_    @ ~S Ϗ 
@ 2  5 U j Fb '
  : %      		 @ e
  k   K   @ ':  s  A { ϛ 	Ι 2  =  hR D $  : 9     	 @ d  k   K   @ '
  Ӗ  B y) ϧ 		 2  E n e A "  :
 M  ;  S 	 A d  k   K   @~ '  3  C v ϳ 	y 2  M  ` =Q   : t >   ; 	h A d\  k   J   @ '     E qh  	 2  ]  ^P ;
  t 9  R )   	L A d/  k   J   ? ''  T  F{% n  	C 2z  e  [ 8 e f 9  f  
  	0 A" d  k   J   ? 'Z-    Gt+ l=  	 2r  m / YO 6  X 9  z s   
A A* c  k   J   ?L '54    Hm1 i  	e 2j  u  V 4A  K 9     _ 
A A2 c  kw   J   ? ':  t  If8 g  	 2b  } N TN 1  > 9     Ÿ 
Am A: c|  kn   J   > '@    J_> d|  	/ 2Z    Q / I 1 9   _ 
  
AN AB cN  kf   J   > 'G  4  KXD a  	 2R   o ON -u  $ 9    
 k 
A/ AJ c!  k]   J   >R 'M    LQJ _Q  	 2J    JK ( 	v 
 9 $  K   
@ AZ b  kL   &J   = 'U
Z  U  NC Z$ 6 	 2:    G & 1  9 7     t 
@ Ab b  kC   1I   = '/`    O< W B 	* 22   ߩ EG $a   9 K     
@ Aj bj  k;   <I   =t '
g    P5 T N 	 2*   8 B "   9 ^ $ 4  $ 
@ Ar b=  k2   GI   == ''m  u  Q. Rb Y 	~ 2"    @E   ^  9 r 6   | 
@s Az b  k*   RI   < '/s  Վ  R' O e 	}[ 2   U =    9  H |   
@T A a  k!   ]I   < '8z  5  S  M6 q 	{ 2    ;C Q   9  [ !  * 
@4 A a  k   gI   <z 'u@  y  T J } 	z' 2
   q 8    9  m    
@ A a  k   rI   <C 'PI  o  U H	 Љ 	x 2   ΍ 3    9     . 
? A a*  j   I   ; 'Z    W B Р 	uX 1    1? @   9   Ѱ   
? A `  j   I   ; 'b    W @F Ь 	s 1   ɪ .  z s 9   T   
? A `  j   H   ;I 'j  u  X = и 	r% 1   8 ,< 
 8 e 9     / 
?u A `  j   H   ; 's  Մ  Y ;  	p 1   ) s  W 9   ʛ   
?U A `r  j   H   : 'p{  5w  Z 8  	n 1 
 T '9 	0  I 9 2  ?  ތ 
= A `D  j   H   : 'K  k  [ 5  	F 1   $  r : 9 E     
= A `  j ~  H   :j '%  ^  \ 3T  	ܪ 1  q "7  1 , 9 Y  È  X 
= A _  j |  H   : '   UQ  ] 0  	
 1 %  5  !   9     " 
=X A _  j w  H   9 '  e  _Ū +  	 1 5 !   g  9y  + t  ۇ 
=; A _`  j u  H   9p '  sk  ` (  	8 1 =  2     9t  ?    
= A _2  j s  H   99 'k  q  a &b " 	ԛ 1 E B  W   9o  R   P 
= B _  j q  H   9 'F  3w  b # . 	 1 M  0  ב  9j  f b  ٳ 
< B
 ^  j o  G    8 '   }  c !4 : 	b 1 U b   O  9e  u    
< B ^  j l  G   8v '    d  F 	 1 ]  ,    9_     { 
< B ^z  j j  #G   8? '  S  e  Q 	* 1z e   I   9Z   N   
< B" ^L  jz h  -G   8 '    f n ] 	̍ 1r m    E  9O '    ֣ 
<R B2 ]  jj c  BG   7 'f  u  h4 ? u 	U 1b } 1 %    9J :  9   
<4 B: ]  jb a  LG   7E 'A  p  i6  р 	ǹ 1Z    <   9E L    h 
< BB ]  jZ _  VG   7
 '  5W  jy8  ь 	 1R  R #   t 9@ _    bE  BJ ]d  jR Y  cG   6 '  >  kr; x ј ^ 1J     = f 9: q  #  a  BR ]3  jJ R  rG   6 '  &  lk= 	 Ѥ  1B  r " s  Y 95     `  BZ ]  jB K  F   6g '&  U
  md? I ѯ  1:    /  K 90   h  `  Bb \  j: D  F   6/ '%,    n]A  ѻ G 12   !  v > 9+     _@ f Bj \  j2 <  F   5 'b.3    oVD    1*   ! d  " 9"  2 N  ]   B{ \?  j# .  F  
 5m '??  c  qHc   / 1  >  !   9  A   \ 
 B \  j '  F   55 'GF  50  rAc Q  } 1   "  l  9  O   \6 
 B [  j   E   4 'PL    s:a    1
  ^  Л *  9  ^ 6  [s 
 B [  j   E   4 'XR    t3_ !   1   & X   9  p   5 5 B [{  j   E  
 4s 'aY  T  u,]  
 	 0  ~     9 *  |    B [K  i   	E   4; ']i_  c  v%[   	( 0  ~ (  X  9 <       B [  i   E   4 '8rf  0  wZ Y $ 	r 0  { ު ǐ   9 O    ;  B Z  i   #E   3 'zl  s  xW  0 	 0  v ٫ 
   8 s  	    B Z  i   =D   3A 'y  5  z	  G 	P 0 
 tM -  ?  8   |  =  B Z[  i   KD   3
 '    {  S 	 0  q ԭ    8   zP   d B Z*  i   XD   2 '~    { ^ _ 	 0  ol . B  } 8    w   F B Y  i   eD   2 'Y  U  |  j 	/ 0 & l ϰ  m n 8   u  > ( B Y  i   sD   2c '4    } - v 	y 0 . j 0  ' ` 8  # s:   
 B Y  i   D   2 '    ~ ؔ ҂ 	 0 6 h ʲ }  R 8  5 p   
 B Yi  i   D   1 '  u    ҍ 	 0 > e 2 ;  D 8  D n  < 
 B Y9  i   C   1 '  ՗   c ҙ 	Y 0 F ` 4   ( 8  b i   
 C X  i   C   11 'z  }   0 Ұ 	 0 V ^\  v   8 % p gk  7 
q C X  i   C   0 'T  r    ˗ Ҽ 	8 0 ^ [ 6 5  
 8 6  e   
S C Xw  i   C   0 '/  Vg     	 0y f Y}   Q   8 H  b   
4 C# XF  i   C   0o '
  \  	 e  	 0q n W 7    8 Y  `U  0 
 C+ X  i~   C   07 '  Q  
   	 0i v T  p   8 j  ]   	 C3 W  iw   B   0  '  vG   3  	c 0a ~ R1 9 /   8 |  [   	 C; W  io   B   / '  <     	 0Y  O   C  8   Y?   # CC W  ih   B   /u 'v  61      	f 0Q  J  l z  8   T   # CS W   iZ   2B   / '+$  o     	c4 0A  Hu < * xr  8   R(   #n C[ V  iS   AB   . '-  Sq   5 $ 	a| 09  F   v,  8   O  G #N Cc V  iL   OB   . '5  t  }  0 	_ 01  C <  s  8  ! Mo   #. Ck V  iE }  ^A    .C '߼>  v  v  ; 	^
 0)  A&  d q w 8  2 K   # Cs VZ  i? v  lA  ! . 'ߗG  sx  o h G 	\V 0!  > 8 " oX j 8  D H  , " C{ V)  i8 o  {A  ! - 'rO  {  h  S 	Z 0  <H   m \ 8  U FU  w " C U  i1 i  A  " - 'MX  3}  a 5 ^ 	X 0  9 7  j N 8{ ( f C    C U  i* d  A  # -e ''`    Z  j 	 0	  4 5 " fB 3 8p I  ?@  ǟ } C Uf  i Z  A  $ , 'q%  Td  M g Ӂ 	q /  2   c % 8j Y  <   b C U5  i V  @  % , '޸z+  a  F  ӌ 	 /  0 5  a  8e j  :  c F C U  i Q  @  & ,k 'ޓ2  ^  ?! 3 Ә 	 /  -  b _p 
 8_ z  8+   * C T  i L  @  ' ,4 'n8  t[  8'  ӣ 	E /  +A 3 }" ]+  8Y   5  '  C T  i G  @  ' + 'I>  X  1-  ӯ 	 /  (  z Z  8T   3s  Ĉ  C Tr  h C  @  ( + '$E  4U  *2 d ӻ 	 /  &e 1 x X  8N   1    C TB  h >  @  ) +q 'K  R  #8   	 /  #  vc VY  8I   .  J  C T  h 9  	@  ) +: 'Q  P  = 0  	_ /    q Q  8=   *  
  C S  h /  #?  + * 'ݏ^       	 / .  }. o O  88  - '  j f C S~  h *  0?  , * 'je     `  	3 / 6 ? z md MI  82  = %I   I C SM  h %  =?  , *@ 'Ek  u       	z / >  x- k% K  8,  M "  ) - C S  h    I?  - * ' q  ժ   +  	 / F c u h H  8&  ]      D R  h   W?  . ) 'x  5   }  	 / O  s+ f F} w 8! . k 4    D R  h   d?  . ) '~     z " 	O / W  p dd D: i 8 ? y   E  D R  h   q?  / )a 'ܱ     x[ . 	֖ / _  n) b% A \ 8 O  { }   D RX  h   ~?  0 )* '܌  Up  ݠ u 9 	 /x g 	= i' ] =u @ 8
 o   x _  D, Q  h   >  1 ( 'B  Q  Y p P 	k /h w  f [h ;3 2 8   g v  e D4 Q  h   >  2 (g '  sW  _ m \ 	ϲ /`  _ d% Y' 8 $ 7   
 s  H D< Q  h   >  3 (0 '  ]  g kU g 	 /X   a V 6  7   
 q v + DD Qb  h   >  3 ' '$  3c  n h r 	A /P   _$ T 4l  7   R o :  DL Q0  h   >  4 ' 'ۭ-  i  t f ~ 	N /H   \ Rg 2*  7    m   DT P  h   >  5 'm 'ۈ6  o  { c ԉ 	і /@   Z" P% /  7    j  b D\ P  h   >  6 '6 'c>  Su   ` ԕ 	 /8  ; W M -  7   < h    Dd P  h{   =  6 & '>G  {   ^L Ԡ 	 /0  c R Ih )!  7    c B  Dt P9  ho   =  8 & 'X  u7   Y Է 	 /    P G' &  7  * $ `   D| P  hi   =  9 &< '`  "   Vy  	 /   M D $  7 ! 8  ]   D O  hc   *=  9 & 'ڪi  5
   S  	! /   K B "X  7 0 E k Z I j D O  h]   8=  : % 'څq    { QB  	j /   H @m    7 @ U  X  L D Or  hX   E=  ; % '`z    t N  	 /   H F >.   7 O f  U  . D O@  hR   S=  ; %^ ';  T  m L  	 .   C ;   7 ^ v V R N  D O  hL   a<  < %& '    f Io  	E .  s A 9 C s 7 n   O L 
e D N  hF   n<  = $ '    _ F  	7% .  ݜ < 55  Z 7   @ H Kx 
! D Nx  h;   <  > $d '٧
    R$ A  	3 .  1 9 2 q N 7    D J 
 D NF  h6   <  ? $, 'ق  5~  K  > ) 	2 .   7 0 + B 7    A J 
 D N  h0   <  @ # ']  ;  D <c 5 	0k .  \ 4 .{ 
 6 7   + = IL 
 D M  h+   <  A # '8    = 9 @ 	. .    2 ,=  * 7    9 H 
 D M  h%   ;  A #j '$  T  6 7+ K 	- . ( ц / *  	d  7   s 6 G 
w D M}  h  }  ;  B #2 '*  p  / 4 W 	+` . 0  - ' "  7    2 G 
T D MJ  h w  ;  C " '1  ,  (
 1 b 	) . 8 ̱ * %   7y  	 ٺ . Fe 
2 D M  h p  ;  D " 'ؤ7  s  ! /W n 	( . @  % !  Z  7m  	'  ' D 
 E L  h c  
;  E "8 'ZD  5  X * Մ 	$ . P q #    7g $ 	4 ң # D4 
 E
 L  h ]  ;  F "  '5J    ] ' Ր 	" . X       7a 3 	A H   Q 
 E LN  h V  *:  G ! 'P    b $ ՛ 	Z . `   O   7Z B 	O   Q 
 E L  g P  8:  G ! 'W  U  g "G զ 	YJ .w h 3   R  7T Q 	\ ˎ  P` 
 E% K  g K  F:  H !Z ']    l  ղ 	W .o p      7N ` 	i 2  	 < E- K  g D  T:  I !" 'סd    p  ս - .g x ^     7H o 	v   C < E6 K  g ;  e:  J   '|%j  u  u q  u ._    \   7B | 	 w 	 ~ <_ E> KO  g 2  v:  J   'W.p  |  z    .W        76  	    < EN J  g    9  L  ( '
?}  a  4   L .F    
  u 70  	 a  , ; EV J  g   9  M  'G  b  :    .>  H 
 n u h 7)  	   e ; E^ J  g 
  9  M  'P  Sc  @ 
a   .6    3 / \ 7#  	    ; Ef JK  g   9  N f '֞Y  d  ˿F 
  $ ..  s    O 7  	 J   ; En J  g   8  O . 'ya  e  ̸L '  k .&      C 7  	    ;d Ev I  g   8  P  'Tj  se  ͱS  #  .     } \ 6 7  
   H ;@ E~ I  g    8  Q  '/r  f  ΪY  .  .  /  A  ) 7	  
 0   ; E Iz  g   8  Q l '
{  3g  ϣ_  O 9 C .  Y   ׌  6   
4 v   : E I  g   48  S  '    ѕ|  P  -      F  6  $ 
D   ' : E H  g   F7  T  '՛  S  Ҏ v [  -    S    6  1 
T   ^ : E H  g   W7  T  'v    Ӈ  f d -     л  6  ? 
d _   2c E Ht  g   h7  U : 'R    Ԁ ; r 		@ -   {  v  6  M 
s     2@ E H@  g   y7  V  '-  s  y  } 	 -  B   3  6  [ 
   > 2 E H  g   7  W  '    r  ֈ 	 - 	  y f   6  i 
 J  | 1 E G  g   6  X  '  3  k b ֓ 	 -  n  + ǭ ߷ 6  v 
    1 E G  g   6  X \ 'Ծ    d  ֟ 	a -     $ ߠ 6   
 3  3 1 E G;  g {  6  Z  't  U
  V  ֵ  - * 1 r x  ߔ 6   
    $ E G  g r  6  [  'O    O   n - 2   =  ߈ 6   
 x v   E F  g c  6  [ b '*    H K  m9 - : ^ o  T | 6   
  j =  E F  g T  5  \ * '  t  A ۭ  kt - B |    p 6   
  ] a  E F`  g E  #5  ]  '	    :   i - J z l ٓ  d 6    ^ Q ԅ  F F(  g 6  ;5  ^  'ӻ  4  3 q  g - R x#  \  Y 6      D Ө b F E  g '  R4  _ h 'ӗ
    ,   f' - Z u i $ ? M 6   %  8  ; F E  g   i4  ` 0 'r    & 4  db -} b p e д  6 6 ! D     F' EI  g   4  b  '(')       ` -m r n  | p * 6~ ! S }  2  F/ E  g   3  b n '/0     X % _ -e z l b C +  6w ! b {*  T  F8 D  g   3  c 6 '86  t  
 ƺ 0 ]Q -]  i     6p !( r x  d  F@ D  g~   3  d  'ҹ@<    #  <  -U  gD ^    6j !6 ~ vn    FH Dj  g|   3  e  'ҔIC  4  ' | G  -L  d  œ c  6c !C  t    FP D3  gz   2  f  'oRI    ,  R ( -D  bs \ X "  6\ !Q  q    FX C  gx   2  g < 'KZO    0 ? ] d -<  `
     6V !^  oW    b F` C  gv   22  g  '&cV  T  5  h  -4  [8   `  6H !x  j  |  Fp CW  gr |  ]1  i  'tc  1  T b   -$  X W l   ޿ 6A !  h>  ު  Fx C   gq o  s1  j ^ 'ѷ}i  u   W  ׊ U -  Vc  0  ޳ 6: !  e  u  F B  gp `  1  k  'ђo    Z $ ו  -  S R   ާ 64 !  c    F B  go P  1  l  'mv  4  ^  נ  -  Q   S ޛ 6- !  a#   Ф F Bx  gn @  0  m  'I|    b  ׫  -  O* Q   ޏ 6& !  ^ z  ~ F B?  gm 0  0  m d '$    e F ׶ ) ,  L  F  ރ 6  !  \g m  W F B  gl    0  n  '  T  i   b ,  JX O   w 6 !  Z
 _ 1 1 F A  gk   /  o  '    l   } ,  E M   _ 6 ! + UN D {  F A\  gj   2/  q j 'А  t  }   z ,  C  a  S 6 ! 7 R 8 o  F A%  gi   H/  r 3 'k     )   ,  @ J %  G 5 " C P -  w F @  gi   ^.  s  'G  4     N ,  >L   D : 5 " O N6 "   S F @  gh   t.  s  '"       ԇ ,  ; I  } . 5 "  Z K    . F @~  gg   .  t p '    ~ J   , $ 9{  { z " 5 "- f I}  6 
 F @G  gf   .  u 9 '  Ty  w    , , 7 F A x  5 ": r G   g  F @  ge   -  v  'ϳ  d  p 
 % 4 , 4 4   v? 
 5 "F ~ D    F ?  ge   -  w  'ώ  O  i k 0 n , < /   q  5 "_  @   x G ?h  gd s  -  y ? 'E    [ * G  , L -q B [ o{  5 "k  =  [ t G
 ?1  gd e  -  y  '   4  T  R  , T +  # m;  5 "x  ;O  ޕ Q G >  gc Y  !,  z  '   j  M  ] O , \ ( @  j  5 "  8   - G >  gb N  5,  {  ')  ?   F }J h  ,z d &= }  h  5 "  6   
 G" >  ga B  H,  | E 'β1  T  ? z s  ,r m # {> y fv ݻ 5 "  4:  ?  G* >X  g` 7  \,  } 
 '΍:    8 x
 ~ 
 ,j u !o x > d1 ݰ 5 "  1  w  G2 >!  g` +  p+  }  'hC    1 ui ؉ I ,b }  v<  a ݥ 5 "  /  ^  G: =  g`   +  ~  'CK  s  * r ؔ  ,Z  : q;  ]g ݎ 5 " 
 *  ͼ d GJ =|  g_   +  Հ / ']  5   m ت o ,J   n ~X [$ ݃ 5 " 
 (j {  > GR =D  g_   +  Ձ  'e    
 j ص  ,B  l l; | X x 5 " 
  &
 p   GZ =
  g_   *  Ղ  'Ͱn     hF   ,:   i y V m 5{ " 
- # f F  Gc <  g_   *  Ղ l '͋v"  U  	 e  + ,2   g: w TZ a 5t # 
: !T [ t  Gk <  g`   *  Ճ 5 'f(    
 c  i ,*  7 d uo R V 5m # 
G  P ɢ  Gs <g  g`   *  Մ  'B/    
$ `d   ,!   b9 s4 O J 5f # 
T  E   G{ <0  g`   /)  Յ  '5  u  ) ]   ,  	d _ p M = 5_ #) 
a < :  \ G ;  ga   D)  Ն r ';  Փ  / ["  % ,   Z l I $ 5R #C 
{  % U  G ;  gb   o)  Շ  '̯H     U 
  ,  * X7 jI F  5K #P 
 &   xC G ;R  gc   )  Ո  '̊N     S@   +   U h D  5D #] 
   n ta G ;  gc t  (  Չ x 'eU  R   P # } +  Y S8 e BA  5= #j 
 n   t< G :  gc h  ¬(  Պ A '@[     M . Ծ +   P c ?  57 #w 
    t G :  gd \  (  Ջ 	 'b     K\ 9  +   N8 a_ =  50 # 
 	  	 s G :w  ge P  (  Ջ 
 'h  s    H D @ +   K _% ;x  5) # 
 Z  < s G :A  ge D  '  Ռ 
 'n  	   F O ς +   I9 \ 94  5# # 
   o s G :
  gf 8  '  Ս 
c '˭u  3   Cx Z  +   D9 X} 4 ܱ 5 # 
  C   s^ G 9  gg    $'  Տ  'd    , >5 p E + ' z A VG 2q ܤ 5 # 
    s8 G 9e  gh   8'  Տ  '?  S  3 ; { ȇ + /  ?: T 04 ܘ 5 # 
   8 s G 9.  gi   L&  Ր i '	    : 8 ن  + 7  < Q - ܋ 5 #  /   ^ G 8  gj   a&  Ց 1 '    A 6P ِ ~ + ? B :; O +  4 #     ] G 8  gk   u&  Ւ  '  s  G 3 ٛ  + G  7 Mh )~ s 4 #  v   ] H 8  gm   Ê&  Փ  'ʬ#    |O 1 ٦ 	 + O s 5; K0 'B g 4 #     ] H
 8R  gn   Þ&  Փ o 'ʇ,  3  uU .j ٱ N + W  2 H % [ 4 $ %   ; ]{ H 8  go   ó%  Ք 7 'c4    n\ + ټ  + _ < - D   C 4 $ 4  u  ], H% 7  gr   %  Ֆ 
 'F  U   ` &  | +o o  += BQ P 6 4 $& ;  k  Sa H- 7v  gt   %  ՗ 
 'N    !Y #  L +g x l ( @  ) 4 $2 C O d i  H5 7@  gt   %  ՘ 
= 'W    "R !?   +_   &> =   4 $> J  ] hL  H= 7  gu   $  ՘ 
 'ɫ`  u  #K   a +W  Ϝ # ;   4 $I R  U g  HE 6  gv   %$  ՙ 	 'Ɇh    $D   ݭ +O  3 !> 9q ^  4 $U Y < N f t HM 6  gw }  7$  ՚ 	 'bq  5  %= X   +G    7; "  4 $` a  G e N HU 6j  gx t  I$  ՛ 	_ '=z    &6   D +?  d ? 5   4 $l h چ ? e) ) H^ 65  gy j  [$  ՛ 	' '    '/   ؐ +7  Ô ? 0 m  4 $ v  1 c  Hn 5  g| V  #  ՝  '  6  )!  4 ( +&  ,  .\ 
2  4 $ ~ s ) b  Hv 5  g} L  đ#  ՞ e 'Ȫ  5  * , ? t +   @ ,$  ۸ 4 $   " b  H~ 5^  g B  ģ#  ՟ - 'Ȇ  u3  + 	 J  +  Y  )  ۫ 4 $  ι  a8 m H 5(  g 8  ĵ#  ՟  'a  2  ,  T  +   
? ' z ۞ 4} $  ^  `n G H 4  g .  #  ՠ  '<  51  - C _ X +   
 %z : ۑ 4v $    _ ! H 4  g $  "  ա  '  /  -  j ̤ *  ! @ #@  ۅ 4o $  ǧ  ^  H 4  g   "  բ 3 '  .  .  u  *    !  x 4h $  L  ^
  H 4R  g   "  բ  '!  U,  / [ ڀ = *      : ^ 4Z $    \v  H 3  g   !"  դ  'ǅ.  3  1  ڕ  *   B Z  Q 4S $  9  [ c H 3  g   4"  ե U '`4  sF  2 r ڠ # * 	      D 4L %    Z = H 3z  g   F!  զ  '<:  Y  3  ګ o *   C  { 7 4E %    c) o H 3E  g   X!  զ  'A  3k  4 , ڶ U *  H   : * 4= %  &  bb I H 3  g   j!  է  'G  ~  5    * "  D t   47 %+    a $ H 2  g   {!  ը [ '
M    6    * * x  :   4/ %7  p  `  H 2  g   ō!  թ $ 'ƩT  S  7 A  ; * 2  D 
  {  4( %C     
 H 2o  g   Ş!  թ  'ƄZ    8   	[ * : > E    4 %[   _   
 I  2  g   Ż   ի } ';/g  t  :& V  	Xj * J   X   4 %f )    
 I 1  g      լ E '8m  Ԭ  ;- ܳ  	V * R n G " ߓ  4 %q "    
b I 1  g      լ  'At  4  <4   	U * [    w ڿ 4 %|  O  b 
? I 1m  g      խ  'Jz    =; k  	Ss *| c  H  Y ڲ 3 %      
 I  1:  g      ծ  'ŨR    >B  " 	Q *t k 5  | # ڤ 3 %     
 I( 1  g      ծ K 'ń[  T  ?I # , 	P# *l s  H E  ڗ 3 %  ?  C 
 I0 0  g      կ  '_d    @zO  7 	N| *d { d   Ը ډ 3 %     
 I9 0  g ~     հ  ';l    AsW  B 	L *\     [ n 3 %   0  ! 
l II 08  g q  =  ձ Q '~    Ce ǔ W 	I *K  + K c 7 ` 3 %    k 
H IQ 0  g k  K  ղ  '  3+  D^(  b 	G *C  }  )  R 3 %  z   
% IY /  g d  Z  ճ  'Ĩ  z  EW; K m 	F7 *;  {Z L   E 3 %     
 Ia /  g ]  i  մ  'Ą    FPM  w 	D *3  x    7 3 %   { F 
 Ii /i  g W  w  մ s '_  T  GI^  ۂ 	B *+  v L | ū ) 3 %  j w  
 Iq /6  g P  Ɔ  յ < ':  h  HBq ^ ۍ 	AB *#  t!  C È  3 &	   s  
 Iy /  g I  ƕ  ն  '    I;  ۘ 	? *  q O 	 K  3 &   n  
s I .  g C  ƣ  շ   '  u  J4  ۢ 	= *  l P    3 &-   e  
 I .g  g 5    ո  A 'è  3>  L&\  ۸ 	I *  j  [   3 &9  ~ a  
 I .4  g /    չ  
 'Ã  ;  Ma '  	H )  h Q " W  3 &E  |G ] R 
| I .   g (    չ  '_  8  Ng   	F] )  e     3 &Q  y Y  
Y I -  g "    պ  ':  S5  Ol   	D )  cJ S ׯ  ٿ 3z &]  w T  
5 I -  g     ջ c '  2  P
r 9  	C )  `  v  ٲ 3t &i  u7 P , 
 I -e  g   
  ռ , '  /  Qw   	Ai ) 	 ^{ W ?  ٥ 3l &s h r L t 
 I -2  g 
    ռ  '    s,  Q}   	? ) 	
 \  
 g ٗ 3e &} 	 p G  
 I ,  g   (  ս  '¨  (  R J  	> ) 	 WE  ̡ H } 3W & 
 k B ѩ 
0 I ,  g   A  տ 2 '_  4  T    	X ) 	& T ^ j 9 p 3P & 
 ir A  
0 I ,g  g   M  տ  ':"  1  U [ " 	Ƽ ) 	. Rw  3 * c 3I & 
 g ? f 
0 I ,5  g   Y    '+   S-  Vٚ  - 	  ) 	6 P a   V 3B & 
~ d =  
0 I ,  g   e    '4&  *  WҠ  8 	Å ) 	> M   
 I 3; & 
b bd < ! 
0{ I +  g   q   T '=-  &  X˦ k B 	 ) 	F KB e   < 33 &  `
 :  
0[ J +  g   }     'E3  s#  YĬ  M 	N ) 	N H  `  / 3, &  ] 8  
0: J +n  g   ǉ    'N9    Z   W 	 ) 	V Fu h , § " 3% &  [U 6 9 
0 J +<  g   Ǖ    '_W@  3  [ z b 	 ) 	^ A k  Q  3 &  V 3  
/ J$ *  g   Ǯ   " 'hL    ] . w 	 )p 	o ??   &  3 &  TF 1 N 
/ J, *  g   Ǻ    'qS  T  ^ } ܂ 	E )h 	w < n \   3 &  Q / ʪ 
/ J4 *t  g       'yY    _ z ܌ 	 )` 	 :q  (   3 '  O - N 
3 J< *B  g      { '`    ` x= ܗ 	C )X 	 8 q    2 '  M8 *  
3 JE *  g      ( 'f  t}  a u ܢ 	 )P 	 5   ~  2 '  J (  
3 JM )  g       '_l  r  b r ܬ 	 )G 	 3= t  R ظ 2 '#  H & K 
3 JU )  g       ';s  4g  c pK ܷ 	t )? 	 0 ~ Y $ ت 2 '-  F) #  
3r J] )y  g       'y  \  dx m  	 )7 	 , y   ؐ 2 '@  Au  F 
3, Jm )  g       '  R]  fi hZ  	~ )' 	 ) wz   ؂ 2 'I  ?   
3	 Ju (  g   ,    '  ]  gb e  	}
 ) 	 ': t  l t 2 'R  <   
2 J~ (  g   9    '  ]  h[ c
  	{s ) 	 $ r} V ? g 2 '\  :f  ? 
2 J (~  h   F   P '`  r]  iT `g  	y ) 	 "j o   Y 2 'g  8	   
2 J (L  h   S    ';  ]  jM ]  	x@ ) 	   m}   K 2 'r  5   
2} J (  h   `    '  2]  kF [  	v ( 	  j   > 2 '}  3T  6 
2Z J '  h   m    '  ]  l@  Xs  	u ( 	 5 h w  0 2 '  0   
26 J '  h   z   r '  ^  m9 U   	ss ( 	 f c  .  2 '  ,F 
  	҉ J 'S  h   ȏ    '    o+- P 5 
 ( 
  a    2 '  ) 
 : 	j J '"  h   Ț    '`
    p$3 M @ 
 ( 
	  ^    2 ' ~ ' 	  	J J &  h   ȥ   x '<  s  q8 K2 J 
 ( 
 1 \ d   2y ' { %8 	  	* J &  h   Ȱ   @ '    r= H U 
a ( 
  Y - ~  2q ' y " 	 u 	 J &  h }  Ⱥ    '(  2  sB E _ 
 ( 
" 
c W  R  2j ' v    l 	͛ J &_  h  z      '0    tH C= j 	 ( 
*  T  &  2b ' s )  l( 	y J &.  h# w      '9    uM @ t 	t ( 
2  R   ׶ 2[ ' p   k 	W J %  h& s     b 'B  R  uQ =  	 ( 
:   M }  כ 2K ' j   jE 	 K  %  h, m      '<S    w 8 ݔ 	 ( 
J b J z x ׍ 2D ( g   i 	 K %j  h/ i      '\  t  x 5 ݞ 	? ( 
S  H x N ׀ 2< ( d g  i 	 K %9  h2 f  	   h 'e  Ԏ  yު 3Q ݩ 	 ( 
[  E v| }# s 25 ( a 
   h_ 	̮ K %  h5 c     0 'm  4v  z׬ 0 ݳ 	% (| 
c 0 C tK z e 2- (" ^ 
  g 	̌ K  $  h9 _       'v  ^  {Я . ݽ 	 (t 
k  @ r x X 2% (* Z X  g 	j K) $  h< \  +    '  F  |ɱ +[  	 (l 
s d > o v J 2 (2 X   fx 	G K1 $u  h? Y  7    'b  T-  }³ (  	~ (d 
{  ; m tr = 2 (; X   e 	% K9 $D  hC U  B   R '=%    ~ &  	 ([ 
 1 6 iO p " 2 (N Y   d 	 KI #  hJ O  Y    '2  ua      	 (K 
  4! g m  2  (X Y   c 	˾ KQ #  hM K  e    '8  1     	L (C 
 d 1 d k  1 (a Y =  cF 	˛ KY #  hQ G  p   X '?  5   l  	 (; 
  /% b i  1 (i U   b 	y Kb #P  hU D  |     'E       	3 (3 
  , ` gb  1 (o Q   a 	V Kj #  hX @  ɇ    'bK       	 (+ 
 1 *) ^] e8  1 (u N 0   	 Kr "  h\ =  ɓ    '>R  Tq   u & 	 (" 
  ' \0 c
  1 ({ J    	 Kz "  h` 9  ɞ   z 'X  A    0 	e ( 
 b %, Z `  1 ( F {  L 	 K "  hd 6  ɪ   B '_    | % : 	 ( 
 Ւ  - U \ ֣ 1 ( @    	 K "*  hl /      'k    n  O 	Ǵ ( 
 +  S| Z_ ֕ 1 ( = k  | 	 K !  hp +      'r  3  g - Z 	o ' 
  2 QP X3 ֆ 1 ( :   |X 	 K !  ht (     H 'dx    `  d 	 ' 
 ]  O$ V x 1 ( 8   c 	 K !  hx $      '?
~    Y   n 	B ' 
  4 L S i 1 ( 5 \  c7 	 K !h  h| !      '  R  R 3 y 	 ' 
 Ɏ  J Q Z 1 ( 2   b 	f K !8  h       '    K  ރ 	, '  ' 9 H O L 1 ( / ީ  b 	E K !  h      j '%  }  D  ލ 	 '    Fs MZ = 1 ( , O  aj 	% K    h      2 '-  rc  = : ޘ 	 '   	 B I   1| ( % ך  `5 	 K  w  h   %    'e?  4t  0<  ެ 	 ' &  ? ? F  1t (   @  _ 	 K  G  h   /   p '@H  t  )B ? ޷ 	s ' / "  = D  1l (    ^ 	 K    h   :   8 'P  s  "H   	 ' 7  B ; B  1d (  Ќ  ^c 	 K   h   E    'Y  Ts  N   	^ ' ? V  9k @_  1\ (  2  ] 	^ K   h   P    'b  s  T D  	 ' G  F 7? >6  1T (    ], 	= L   h   [    'k  r  
Z   	H ' O   5 <
  1L (  ~  \ 	 L
 V  h   f   Z 's  tr  `   	 ' W ' J 2 9 տ 1D (  %  [ 	 L &  h   q   # 'f|  q  f H  	3 ' ` \ M . 5 դ 14 (  p  Z 	 L%   h   ʇ    '  l    	 	 'o p   ,f 3f ՗ 1, (    ^ 	} L-   h   ʒ   ` '  h   L  	 'g x  O *: 1; Չ 1$ )     ^O 	\ L6 f  h   ʝ   ) '  Uc   ӣ  	$ '_  -  ( / | 1 )  a  ] 	: L> 6  h   ʨ    '  _  ܨ  ( 	 'W   S % , o 1 )
    ] 	 LF   h   ʳ    '  Z  ծ P 2 	 'N  b  # * a 1 )    \~ 	 LN   h   ʾ    'h  uV  γ ˦ = 	 'F   V ! ( T 1 )  S  [ 	 LV   h      J 'C  Q  Ǹ  G 	 '>    b &s F 0 )    [F 	 L^ v  h       '  5M   S Q 	p '6     "+ + 0 )$  G  Z 	r Lo   h       '    t   f 	[ '&  i ^     0 ))    Yr 	Q Lw   h      P '  S$  { W p 	 '       0 )/    X 	/ L   h        '$  *    z 	G '   a    0 )4  9  X8 	
 L   h       'i+  0    ߄ 	߽ '
  8  b   0 )9    W 	 L W  h       'E1  s6   Y ߏ 	3 '   b H b  0 )7    V 	 L '  h   !   r '!7  <    ߙ 	ܩ &  l  1 :  0 )4  *  V_ 	 L   i    ,   ; '>  3B    ߣ 	 &   g    0 )1    U 	 L   i   8    'D  H   Z ߭ 	ٕ &  9 l   Ԫ 0 )+    T 	B L i  i   N   x '+Q  R  s   	ւ &  |    ԛ 0 ))    + 	r& L 9  i   X   A 'k4W    l \  
 &  zj o  
{ Ԍ 0 )& | i  +h 	r L 
  i   c   	 'G=^    e   
` &  x   U | 0 )" t   * 	q L   i    m    '"Ed  r  ^   
 &  u s  0 m 0 )! l   / 	sd L   i%   w    'Nj  Ҿ  W \  
# & # s5  j  ^ 0w )  f [  /Z 	sC L }  i*   ˁ    b 'Wq  2  P   
! & , p v N  N 0o ) b   . 	s# L O  i/   ˋ   + '`w    I   
  & 4 ni  3  ? 0g ) ^   .4 	s L    i4   ˕    'h}    B \ 	 
 & < i   `   0U ) V   -
 	r M   i?   ˪   h 'Iz    4   
 & L g3 |  6  0M ) R   ,z 	r M
   iD   ˴   1 '$    - \ ' 

 & T d   
  0D ) N ~A  + 	r M e  iI   ˾    '   r  &  1 
 & ] be ~    0< ) E {  +R 	r` M 6  iO       '      < 
 &z e _     03 ) < y  * 	r? M"   iT       '  2   [ F 
 &r m ]  t   0* ) 3 w2  *( 	r M+   iZ      S '      P 
 &j u [1  ] {  0! ) * t  ) 	q M3   i_       'o      Z 
 &b } X  E W Ӵ 0 )   r  ( 	q M; {  ie       'K  S  
 ~Y d 
 &Y  S    ӓ 0 )  m  ' 	q MK   iq     	 Y '      y x 

 &I  Q    ӄ / )	  kq  '= 	qy MS   iw     	 ! '  r  	 vW  
v &A  O0    v / )
  i  & 	qX M\   i|     
  '  Ҭ   s  

 &9  L  ۮ  h / )  f  & 	q7 Md   i   %    '  2   q   
	r &0  Jf  ٍ u Z / )  dc  %z 	q Ml d  i   0   z 'q    # nU  
 &(  H 	 l O L / )
  b	  $ 	p Mt 5  i   :   C 'M    + k  
n &   E  Q * ? / )  _  #- 	r M|   i   D  
  ')  R  5 h  	 &  C9  3  0 / )  ]V  " 	r M   i   O  
  '  	  > fQ  	2 &  >n   Ժ  / )
  X  !b 	r M {  i   d   I '  r  Ʒ@ `  	/ %  <
   җ  / )	  VG    	rk M L  i   o    '!    ǰI ^N  	 %  9 ~ ʾ u  / )  S   . 	rI M   i   y    's)
  2  ȩS [  	, %  7A { Ȣ S  / )  Q   	r' M   i   ̄    'O2    ɢ] X  	 %  4 y Ɔ 8  / )  O:   	r M   i |  ̏   k '+;  )  ʛg VJ  	) % 
  2y v j   / )  L  _ 	q M   i z  ̙   3 'D  SC  ˔q S  	 % 
 0 t M   / ) w J   	q M d  i w  ̤    'M#  \  ̍{ P  	' % 
 - q 1  Ҳ /y ) f H-  ) 	q M 6  i t  ̯    'U*  u  ͆ NE  	 % 
 ( l   ҕ /g ) D Cz   	qZ M   i o     9 'vg6    xy H - 	 % 
) & j   ҇ /] ( 3 A   V 	q7 M   i l      'Rp=  3  q F@ 7 	# % 
1 $ g   y /T (  >   	q M }  i j      '-yC  E  j C A 	 % 
9 ! e  i j /K (  <m   	p M N  i g      '	I  }  c @ K 	" % 
B U b  R \ /B (  :   	p M    i d     [ 'P  S  \ >: U 	 % 
J  ` n ; N /9 (  7   	p N   j a     # 'V    U ; _ 	  % 
R  ] L # > /0 (  5_  ,N 	wF N   j _      ']  "  N 8 i 
 % 
Z % [ ,  / /' (  3  + 	w$ N   j \     ߴ 'xc  tZ  G 64 s 
 %| 
b                                                                                                                                                                                                                                                                