PDS_VERSION_ID      = PDS3
LABEL_REVISION_NOTE = "SE-MTC, 11/12/2015"

     /* File format and length */
PRODUCT_ID    = "T1_00367036065.GEO"
ORIGINAL_PRODUCT_ID = "PTE8J219.QUB"
RECORD_TYPE   = FIXED_LENGTH
RECORD_BYTES  = 512
FILE_RECORDS  = 72
LABEL_RECORDS = 10
FILE_STATE    = CLEAN

     /* Pointers to data objects */
^QUBE      = 11
 
     /* Producer information */
PRODUCER_ID               = ROSETTA_VIRTIS_TEAM
PRODUCER_FULL_NAME        = "CAPACCIONI"
PRODUCER_INSTITUTION_NAME = "OBSERVATOIRE DE PARIS-LESIA"
PRODUCT_CREATION_TIME     = 2016-11-24T10:39:28.00
TELEMETRY_SOURCE_ID       = "VIRTIS_EGSE3"
SOFTWARE_VERSION_ID       = {"VirtisRos SW v.4.10", "EGSE_SOFT_7.4", 
"PDS_CONVERTER_7.4","EGSE2PSA_LBL_1.2.2", "GEOROS_6.2", "V_GEOLABEL_6", 
"GEOROS_7.1", "V_GEOLABEL_6"}

     /* Data description parameters */
DATA_SET_NAME        = "ROSETTA-ORBITER 67P VIRTIS 3 PRELANDING MTP006 V1.0"
DATA_SET_ID          = "RO-C-VIRTIS-3-PRL-MTP006-V1.0"
PRODUCT_TYPE         = EDR
PROCESSING_LEVEL_ID  = 2
STANDARD_DATA_PRODUCT_ID = "VIRTIS GEOMETRY"
MISSION_NAME         = "INTERNATIONAL ROSETTA MISSION"
MISSION_ID           = ROSETTA
INSTRUMENT_HOST_NAME = "ROSETTA-ORBITER"
INSTRUMENT_HOST_ID   = RO
MISSION_PHASE_NAME   = "PRELANDING MTP006"
PI_PDS_USER_ID       = CAPACCIONI
INSTRUMENT_NAME      = "VISIBLE AND INFRARED THERMAL IMAGING SPECTROMETER"
INSTRUMENT_ID        = "VIRTIS"
INSTRUMENT_TYPE      = "IMAGING SPECTROMETER"
^INSTRUMENT_DESC     = "RO_VIRTIS_EAICD.ASC"
ROSETTA:CHANNEL_ID   = "VIRTIS_H"
DATA_QUALITY_ID      = 1
DATA_QUALITY_DESC    = "0:INCOMPLETE ; 1:COMPLETE"

     /* Science operations information */
TARGET_TYPE            = "COMET"
TARGET_NAME            = "67P/CHURYUMOV-GERASIMENKO 1 (1969 R1)"
START_TIME             = 2014-08-19T02:21:40.512
STOP_TIME              = 2014-08-19T02:52:29.260
SPACECRAFT_CLOCK_START_COUNT = "1/0367035631.53306"
SPACECRAFT_CLOCK_STOP_COUNT  = "1/0367037480.36789"
ORBIT_NUMBER           = "N/A"
OBSERVATION_TYPE       = "NULL"
SC_SUN_POSITION_VECTOR        = (-193446098.050, 424471320.171, 246059177.299)
SC_TARGET_POSITION_VECTOR     = ( 17.690, -38.575, -66.148)
SC_TARGET_VELOCITY_VECTOR     = ( -0.001, -0.000, 0.000)
COORDINATE_SYSTEM_ID          = "-1000012000"
COORDINATE_SYSTEM_NAME        = "67P/C-G_CK"
DECLINATION                   = -999.999
RIGHT_ASCENSION               = -999.999
MAXIMUM_LATITUDE              = 62.390
MINIMUM_LATITUDE              = 59.376
EASTERNMOST_LONGITUDE         = 124.454
WESTERNMOST_LONGITUDE         = 107.079
SPACECRAFT_ALTITUDE           = 77.104
PHASE_ANGLE                   = 29.958
SUB_SPACECRAFT_LATITUDE       = 48.262
SUB_SPACECRAFT_LONGITUDE      = 207.028
SLANT_DISTANCE         = 77.438184
SOLAR_DISTANCE         = 527392161.776
SOLAR_LONGITUDE        = 118.69686
SUB_SOLAR_LATITUDE     = 17.815
SUB_SOLAR_LONGITUDE    = 186.997
NOTE = "The values of the keywords SC_SUN_POSITION_VECTOR, 
SC_TARGET_POSITION_VECTOR and SC_TARGET_VELOCITY_VECTOR are related to the 
J2000 frame. The values of SUB_SPACECRAFT_LATITUDE and 
SUB_SPACECRAFT_LONGITUDE are northern latitude and eastern longitude in the 
planetocentric frame defined by the shape model. All values are computed at 
mid-session. Distances are given in <km>, velocities in <km/s> angles in 
<deg>"


     /* Instrument status */
INSTRUMENT_MODE_ID    = 10
^INSTRUMENT_MODE_DESC = "RO_VIRTIS_EAICD.ASC"

     /* Pointer to navigation data files*/
SPICE_FILE_NAME = {"NAIF0011.TLS","PCK00010.TPC","DE405.bsp","JUP263.bsp",
"ROS_160929_STEP.TSC","ROS_V26.TF","ROS_CHURYUMOV_V01.TF","ROS_VIRTIS_V13.TI",
"cg-spc-shap5-v1.1_Cedric.TPC","RORB_DV_145_01___T19_00216.bsp",
"CORB_DV_145_01___T19_00216.bsp","RATT_DV_145_01_01____00216.bc",
"RATT_DV_145_01_01____00216.bc","CATT_DV_145_01_______00216.bc",
"cg-spc-shap5-v1.1-cheops.bds"}

     /* Cube keywords */
OBJECT = QUBE
 AXES                       = 3
 AXIS_NAME                  = (BAND,SAMPLE,LINE)
 CORE_ITEMS                 = (31,64,4)
 CORE_ITEM_BYTES            = 4
 CORE_ITEM_TYPE             = MSB_INTEGER
 CORE_BASE                  = 0.0
 CORE_MULTIPLIER            = 1.0
 CORE_VALID_MINIMUM         = -2147483648
 CORE_NULL                  = -2147483648
 CORE_LOW_REPR_SATURATION   = -2147483648
 CORE_LOW_INSTR_SATURATION  = -2147483648
 CORE_HIGH_REPR_SATURATION  = 2147483647
 CORE_HIGH_INSTR_SATURATION = 2147483647
 CORE_NAME                  = "GEOMETRIC PARAMETERS"
 CORE_UNIT                  = "UNK"
 CORE_DESC                  = "PARAMETERS ARE DEFINED IN EAICD"

 SUFFIX_BYTES               = 4
 SUFFIX_ITEMS               = (0,0,0)
END_OBJECT = QUBE

END
                                                                                                                                                                                                                                                                                                                                                                                                 o 9 U  	% 	4 	/ 	
 z 	 	, Λ ; i x B    e . 
5 -HsA    3 $Zt 
; u Y A  7 S}  	% 	4t 	 	ѯ  	 	,a Z <   C
    e . 
5 -HFA    7 $XS 
; u W A  5< Q e 	%8 	4' 	 	S  	f 	+  >  Q CZ c   e . 
5H -HA	  P  ; $V2 
<
 u V A ] 2 N  	$ 	3 	U 	  		 	+S  @   C    e . 
4 -GA
    {@ $T 
<  u T A  0 L 6 	$ 	3 	
 	Ф  	  v B  ) C    e . 
4 -GA    tE $Q 
<6 e R A  .X I ם 	$+ 	3? 	 	L $ 	X j vJ C   D@ U   e . 
4i -GA  p  mH $O 
<K e P A / , G  	# 	2 	k 	  	 ع q E   D    e . 
4 -GfA "  Х  fN $M 
<a 
 N A  ) D n 	#m 	2 	 	ϝ K 	 : q G  P D    e . 
3 -G:@)  0  _R $K 
<v 
 M A b ' B  	# 	2o 	 	E  	^ ׺ qp I   E 0   e . 
3 -G
@/    XW $Ij 
< 
 K A  %M ? = 	" 	2* 	} 	 r 	 : q- K )  E\ y   e . 
3T -F@5    Q[ $GH 
< 
 I A  #
 =	 ʣ 	"R 	1 	* 	Γ  	 ֺ p L : t E    e . 
3  -F@<  P}  J` $E' 
<  G A 0   : 	 	! 	1 	 	:  	e  | N K  E 
   e . 
2 -F@B  s  Cd $C 
< k F A   7 o 	! 	1W 	 	 , 	 	 { P ] 8 F2 T   e . 
2u -FZ@I  i  <i $@ 
< j D A c @ 5j  	!6 	1 	) 	͇ ݾ 	 ߈ { R n  Fz    e . 
2" -F.@O  p_  5m $> 
< i B A   2 < 	  	0 	 	- Q 	h  {I S   F    e . 
1 -F@U  U   .q $< 
= i @ A   0T  	 x 	0 	~ 	  	 ޅ { U  	\ G	 2   e . 
1 -E@\  0K  !'v $: 
=# i > A  4 +@ u 	 	/ 	 	$  	l  _e Y  
 G    e . 
1 -E{@h  z  #; $6> 
=N ' ; A b  (  	X 	/ 	} 	 њ 	 	M	 [ [  
 G    f . 
0 -EN@o  Ny  $A $4 
=d h" 9 A   &9 ? 	 	/p 	/ 	o  	~ 	L  \  
 H6 j   f . 
0 -E!@u  x  %G $1 
=z h
 7 A  j #  	 	/* 	 	 ̙ 	~P 	 @ ^  ^ H    f . 
0 -D@|  w  &M $/ 
= s 5 A . 
( !>  	9 	. 	 	ʻ  	} 	  `   H '   f . 
/ -D@  nv  &S $- 
= C 4 A    } 	 	. 	E 	h ǎ 	} 	,  b * C I<    f . 
/l -D@  u  'Y $+ 
=  2 A c  C  	| 	.X 	 	 	 	} 	  d E  I    e . 
/ -Dn@  .u  (^ $)u 
=  0 A ~ `  k 	  	. 	 	  	| 	=  e ` 
' I F   e . 
. -DB@  t  )d $'T 
=  . A {  T  	 	- 	b 	v  	|M 	s h g { 
 JF    e . 
.r -D@  s  *j $%2 
=  , A y<   R 	g 	- 	 	# t 	{ 	 7 i   J 
   e . 
. -C@  Nr  +p $# 
>  + A v  e  	 	-E 	 	  	{| 	  k   J k   e . 
- -C@  q  ,v $  
>&  ) A tz R  7 	 	, 	߁ 	} j 	{ 	& z m   KQ    e . 
-\ -C@  p  -| $ 
>< m ' A r 
 
t  	X 	, 	6 	,  	z 	 L o  b K (   e . 
- -Cb@  np  .ł $ 
>R ; % A o  
 # 	 	,d 	 	 b 	zJ 	@  p   L     e . 
, -C5@  o  / $ 
>g 	 # A m] y   	 	, 	ޢ 	Ǌ  	y 	 aR r  A LW    e . 
,b -C	@  .n  0 $i 
>} _ " A j -   	K 	+ 	] 	9 o 	y 	 a% t $  L 3   e . 
, -B@  m  1 $H 
> @   A f@  1  	 	+* 	 	Ɩ  	x 	 ` x A f M8    e . 
+ -B@  PU  3 $ 
>   A c =  s 	? 	* 	} 	F  	x 	y ` y P  M    f . 
+0 -BV@  E  4 $ 
>   A a  9  	 	* 	/ 	  	x, 	 `l { ^ ( M k   f . 
* -B)@  5  5 $
 
>   A _,   g 	 	*/ 	 	ŧ = 	w : y } l  N    f . 
* -A@  p%  6 $ 
> s  A \ L F  	> 	) 	ܖ 	X  	w 
 $  v  N_     f . 
*R -A@    7 $	~ 
? u  A Zx   [ 	 	) 	L 		 k 	w1     = N G   f . 
* -A@  0  8 $\ 
?) u  A X ެ Y } 	 	)8 	 	ĺ  	v Y     N    f . 
) -Av@    9x $; 
?? ur  A U `  {Q 	: 	( 	۶ 	l  	v 1 
    O0    f . 
) -AI@    :r $ 
?U HO  A Sc  g x 	 	( 	h 	 9 	v@     G Or    f . 
)X -A@  O  ;k $  
?j HF 
 A Q   vJ 	 	(K 	 	  	u a     O X   f . 
) -@@    <d
 # 
? H=  A N { a s 	2 	' 	 	Â s 	u  q    O    f . 
( -@@}    =] # 
? H5 
 A LS 4  qB 	 	' 	c 	3  	uV     G P9    f . 
( -@@z  o  >V # 
? e  A I  3 n 	 	'k 	 	  	u x     Px    f . 
(^ -@j@v!  ϔ  ?O #q 
? e  A G δ  l; 	7 	') 	٤ 	 X 	t qI ;    P V   f . 
( -@=@s(  /  @H #P 
?   A EO |  i 	 	& 	E 	H   	t~ p 
   4 P    f . 
' -@@o.  s  AA #. 
?   A B D o g& 	 	& 	 	  	t8 p     Q+    g . 
' -?@l4  c  B: # 
@    A >M   b 	 	&7 	 	J  	s o t    Q 9   g . 
', -?@eA  8  D+ # 
@,   A ; Ú s _ 	 	% 	ע 	 ~ 	se  j   f Q r   g . 
& -?]@bH  :  E% # 
@B mx  A 9 \  \ 	P 	% 	6 	 |@ 	s " 9    R    g . 
& -?0@^N  n;  F
 # 
@X mm  A 7\ 1  Zj 	 	% 	 	O y 	r      R`    g . 
&j -?@[T  =  G #e 
@m ma  A 5  t W 	 	%Y 	] 	 w~ 	r `    ] R 5   g . 
&2 ->@X[  .?  H #C 
@ mU  A 2   UD 	m 	%- 	 	 u 	r3 }F     R u   g . 
% ->@Ta  @  I	 #! 
@   A 0s  + R 	" 	% 	Ջ 	G r 	q |     S    g . 
% ->}@Qg  B  J$ #  
@   A .)  Ó P  	 	$ 	) 	 pp 	q |    E SX    g . 
% ->P@Mn  ND  J* # 
@   A + |  M 	 	$ 	 	 n 	qf 9 DT    S    h . 
%T ->$@Jt  E  K0 #ܼ 
@ 	  A ) \ b J 	N 	$ 	g 	? k 	q' 9 D+    S I   h . 
% -=@G{  G  L6 #ڛ 
@ 	  A 'U <  Hi 	 	$c 	 	 i 	p 9g D    S z   h . 
$ -=@C  nH  M= #y 
A 	  A % 0 9 E 	 	$N 	ӧ 	 g4 	p 9! C   U T.    h . 
$ -=@@  J  NC #W 
A 	  A " #  CE 	 	$: 	I 	6 d 	pi 8 C    Tc    h . 
$ -=q@<  .L  OI #5 
A/ 	  A   !  @ 	F 	$. 	 	 b 	p, H @    T 
   h . 
$Z -=D@9  M  PO # 
AE 	P  A M "  >' 	 	$' 	ҝ 	 `P 	o j I    T 6   h . 
$# -=@6  O  QV # 
AZ 	Ud  A  #  ; 	 	$ 	I 	2 ^ 	o - "  | W T a   i . 
# -<@2  NQ  R\ # 
Ap 	Uh  A  #  6l 	I 	$
 	ѡ 	} Yu 	o@  
  f  U]    i . 
# -<@,  \  T #Ɍ 
A 	Up  B U   3 	 	# 	M 	" W- 	o t 
  [  U    i . 
#` -<d@(  pP  U #j 
A 	Ut  B    1D 	 	# 	 	 T 	n 6 
  P N U    i . 
#D -<7@%  D  V #I 
A 	Ux  B    . 	 	# 	Щ 	q R 	n 6 ?c  E  U =   i . 
#
 -<
@!  08  W #' 
A 	#2  B  %  ,! 	h 	# 	] 	 PM 	nP 6 ?9  ;  V' m   i . 
" -;@  ,  X # 
A 	#2  B
 v +  ) 	1 	# 	 	 M 	n 6^ ?  2  V\    j . 
" -;@     Y # 
B 	#1  B 
? 1 3 ' 	
 	# 	 	i K 	m 6 >  ( P V    j . 
"f -;@  P  Z # 
B 	#1  B
  :  $s 	
 	# 	x 	 Id 	m 2 ;    V    j . 
"J -;W@    [ # 
B2 	%  B  D I ! 	
 	# 	, 	 G 	mU 2 ;    V .   j . 
" -;*@    \} #~ 
BH 	%  B  N  A 	
T 	# 	 	V D 	m 29 ;~  	  W/ ^   j . 
! -:@
  o  ]v #\ 
B] 	%  B f W a  	
 	# 	Ε 	 B} 	l 1 ;U   P Wc    j . 
! -:@
    ^o #; 
Bs 	%  B 2 ^   	 	# 	K 	 @. 	l      W    j . 
!l -:@  /  _h # 
B   B  _  z 	 	# 	 	? = 	lN M     W    j . 
!5 -:w@    `a # 
B   B  f   	{ 	# 	 	 ;u 	l 1    ' X ;   k . 
  -:K@      aZ # 
B   B  q  C 	C 	# 	{ 	 9 	k     u XZ }   k .~ 
  -:?  O  bS # 
B   B U } E  	 	# 	5 	$ 6 	kf y m    X    k .~ 
 r -9?
    cL # 
B {  B   w 
 	 	# 	̮ 	l 1 	j      _ Y! D   k .~ 
  -9?  n  e> #N 
C
 X  B"  ~ ~  	 	# 	k 	 / 	j| d      Yc    k .~ 
 -9k?   Ω  f7 #- 
C F  B$  | { T 	V 	# 	) 	 -/ 	j- 	kq      Y    k .~ 
x -9>?'  .  g0 # 
C5 	%  B& z z yF  	( 	# 	 	N * 	i 	4 3   !N Y    k .} 
A -9?-    h) # 
CK 	Q|  B( N x v   	
 	# 	˨ 	 (^ 	i 	3 3   ! Z6 [   k .} 
 -8?3    i" # 
C` 	Q9  B* " v t t 	
 	# 	k 	 % 	i1 	3 3   ! Z|    k .} 
 -8?:  N  j # 
Cv 	P  B,  t r*  	
 	# 	, 	% # 	h 	3 3   "C Z    k .} 
~ -8?@    k # 
C 	P  B.  r o = 	
} 	# 	 	 !* 	h 	3| 2   " [
 3   k .} 
+ -8^?G  |  l
 #a 
C 	Pq  B0  ps mO  	
W 	#v 	ʜ 	m  	h7 	3S 2   " [Q {   k .} 
 -81?M  nu  m #@ 
C 	P.  B2 ސ ng j  	
1 	#a 	T 	 O 	g 	g    #A [    k .} 
 -8?S  n  n 	 # 
C 	v  B4 l lZ ht  	

 	#L 	 	  	g 	g    # [    k .} 
M -7?Z  .f  n # 
C 	v  B6 H jL f  		 	#7 	 	S x 	g, 	g    # \5 h   l .| 
 -7?`  _  o # 
C 	vS  B8 $ h, c M 		 	# 	| 	 
 	f 	g    $= \    l .| 
 -7~?f  W  p # 
D
 	v  B:   f a%  		 	" 	/ 	  	f~ 	gw    $ \    l .| 
 -7Q?m  NP  q # 
D" 	u  B;  c ^ % 		 	" 	 	; 4 	f% 	 )   $ ] O   l .| 
7 -7$?s  I  r! #t 
D8 	b  B=  a \>  		m 	" 	ȗ 	 
 	e 	 )   %@ ]f    l .| 
 -6?z  A  s& #R 
DM 	a  B? ; ]j WV n 		D 	"/ 	 	*  	e 	y    % ^ L   l .| 
Y -6?  H  uȁ # 
Dx 	j  BC ˭ [1 T  		/ 	! 	ǲ 	 f 	d 	[    &L ^U    l .| 
 -6q?  00  v #~ 
D 	jb  BE ɛ X Rp P 		 	! 	f 	w  	dQ 	>    & ^    l .| 
 -6D?    w #| 
D 	j  BG Ǆ V O  	 	!C 	 	 | 	c 	؃ M   '  ^ K   l .| 
z -6?     x #z 
D 	Yy  BI m T, M~ 3 	 	  	 	  	c 	d M    '^ _L    l .| 
' -5?  O  y #x 
D 	Y  BK h Q K ѫ 	 	  	t 	o  	c* 	خ Nx    ' _    l .| 
 -5?    z #vd 
D 	X<  BM d Oo H % 	 	 " 	# 	  	b 	ؐ N   ( _ Z   l .{ 
 -5?    { #tB 
D 	W  BO e M F ̠ 	 	 	 	  	bd 	q N  
 (w `K    l .{ 
- -5d?  o  | #r  
E 	Wh  BQ e J C  	 	E 	Ł 	u  	b 	R N   ( `    l .{ 
 -57?  ψ  } #o 
E% 	V  BS e H A ǚ 	 	 	2 	$  	a 	3 N 
  )1 ` i   l .{ 
 -5
?  /p  ~ #m 
E: 	V  BU f E >  	 	R 	 	 + 	a= 	; $   ) aG    l .{ 
O -4?  X   #k 
EP 	f  BW f C% <,  	 	 	đ 	  	` 	' $   ) a    l .{ 
 -4?  ?  { #i 
Ef 	  BY g @ 9  	 	B 	> 	/ C 	` 	m    *; a k   l .{ 
 -4?  O'  t #gv 
E{ 	X  B[ g > 73  	 	 	 	  	`" 	\    * b9    l .{ 
q -4W?    m #eT 
E 	  B] f ;u 4  	 	" 	Û 	 ` 	_ 	J    * b    l .{ 
 -4*?    f #c2 
E 	  B_ f 8 2E  	 	 	L 	B  	_g 	8    +> b f   l .{ 
 -3?  n  _ #a 
E 	$ ~ Ba n 3 -X  	 	 	® 	  	^ 
 D   + c~    l .{ 
? -3?  /  Q #\ 
E 	ς z Be w 1h * % 	 	 	^ 	V ܇ 	^A 
"x e   ,L c r   l .{ 
 -3w?~    J #Z 
E 	 x Bg  . (m  	 	| 	 	  	] 
( o  # , d-    l .{ 
 -3J?{    C #X 
F 	 v Bi  ,I % . 	 	 	 	 ׉ 	]p 
( o   ( - d 2   l .{ 
E -3?x  N  < #Vf 
F' 	l t Bk  ) #  	 	n 	v 	o 	 	] 
( o " - -l d    l .{ 
 -2?t    5 #TD 
F= 	 r Bm  '< ! O 	 	 	( 	- ҉ 	\ 
( p! $ 2 - e:    l .z 
 -2?q  }  . #R" 
FS 	k p Bo  $   	 	I 	 	 
 	\5 
( pE & 7 .+ e U   l .z 
K -2?n  n^  ' #P  
Fh 	 n Bq  " 9 ~ 	 	 	 	 ͓ 	[ 	  ( 7 . e    l .z 
 -2j?j  ?    #M 
F~ 	 l Bs v w   	u 	 	L 	h   	[t 	  * 5 . f9    l .z 
 -2=?g&  .    #K 
F 	f j Bu k  _  	f 	{ 	 	' Ȯ 	[ 	 , , 3 /. f Y   l .z 
Q -2?d,     #I 
F 	 h Bw ` A  E 	V 	 	 	 ; 	Z 	 Q . 1 / f    l .z 
 -1?a2     #Gx 
F 	 f By U    	G 	B 	l 	  	ZU 	 2@ 0 0 / g.    l .z 
 -1?]9  M   #EV 
F 	z d B{ J  
 \ 	7 	 	 	R S 	Y 	B z 2 - 0/ g [   l .z 
s -1?Z?     #C4 
F 	 b B} / J 
  	 	 	 	  	Y 	? ֝ 4 & 0} g    l .z 
; -1]?WF  
   #A 
F 	 ` B   ) r 	 	4 	 	  	YE 	< ֿ 6  0 h    l .z 
 -10?SL  me   #> 
G 	 ^ B      	 	 	8 	u  	X 	;d  8  1 h] >   l .z 
 -1?PR  F   #< 
G* 	ר \ B     	 	 	 	 X 	XO 	;F  <  1 h    l .y 
& -0?J_  Z  ) #8 
GU 	
 X B   g  	o 	\ 	U 	  	W 	;7  >  1 i,    l .y 
 -0|?Fe  ]  / #6f 
Gk 	ֿ V B o     * 	H 	 	 	J  	W 	 c @  2( in O   l .y 
 -0O?Cl  O`  7 #4D 
G 
	8 T B K :   	! 	
 	 	 @ 	Wd 	 c B  2h i    l .y 
 -0"?@r  c  = #2" 
G 
 R B  s 2 1 	 	
 	 	  	W 	 c D  2 i    m .y 
G -/?=y  f  D #0  
G 
 P B }   } 	 	( 	> 	\  	V 	! [ F  2 j1    m .y 
 -/?9  oh  J #- 
G 	/ N B {  e {? 	 	4 	 	 ) 	Vz 	! c H  3/ ju S   m .x 
 -/?6  k  Q #+ 
G 	 L B y   x 	Q 	
? 	 	  	V) 	!t l J  3s j    m .x 
 -/o?3  /n  W #) 
G 	 J B wI   v[ 	 		J 	f 	 i 	U 	!X t L  3 j    m .x 
M -/B?0  q  ^ #'w 
H 	c H B u  " s 	 	; 	 	8  	U 	3  N z 3 kC !   m .x 
 -/?,  t  d #%U 
H 	 F B r y  q 	 	 	 	  	U4 	3  P l 4A k h   m .x 
 -.?)  Ov  j ##3 
H- 	r D B p K N o 	g 	 	 	 E 	T 	} _ R ^ 4 k    m .x 
 -.?&  y  q #! 
HB 	 B B nX )  l 	& 	 	D 	g  	T 	_ e T N 4 l    m .x 
S -.?#  |  w # 
HX 	 @ B l  { j8 	 	h 	 	!  	TC 	A j V > 5	 lV 4   m .w 
  -.b?  o  ~ # 
Hm 	 > B i w  g 	 	 	 	 ) 	S 	# p X . 5K l x   m .w 

 -.5?  ς  y # 
H 	S < B g  ߩ eR 	d 	  	m 	  	S ; qV Z  5 l    m .w 

 -.?  /  r # 
H 	d : B c |  `d 	  	 	 # 	S  K
 ^  5 mV .   n .w 

" --?  >  de #C 
H 	D 6 B ` K ` ] 	  	 	  	R  K  `  67 m g   n .w 
 --?  NH  ]l #! 
H 	" 4 B ^ 7  [z 	L  	> 	^ ~ 	R  J b  6o m    n .v 
 --U?  Q  Vt # 
H 	 1 B \6 9 ~ Y 	  	 	 + 	RA  J d  6 n    n .v 
{ --(?	  [  O{ #
 
I 	 / B Y 9 
 V 	  	 	  	Q W J f  6 nD    n .v 
D -,?  nd  H # 
I 	 - B W 9 Μ T 	o  	U 	|  	Q   h  7 n J   n .v 
 -,?  n  A #	 
I/ 	O+ + B UL ; + Q 	  	 	1 ( 	Qd  
 j n 7U n    n .v 
 -,>  .x  : #v 
ID 	N ) B R W ɻ O2 	  	 	 | 	Q   m [ 7 o    n .v 
 -,t>    3 #S 
IZ 	N ' B P s L L 	e  	o 	 zn 	P   o H 7 oI    n .u 
e -,G>    , #1 
Ip 	N % B N8   JH 	
  	# 	N x 	P} 
 V q 1 8 o L   n .u 
. -,>  N  % # 
I 	_ # B K  s G 	  ! 	 	 u 	P5  V s  8D o    n .u 

 -+>     " 
I 	2 ! B I l  EK 	 T  	 	 sm 	O   u  8} p    o .u 

 -+>     " 
I 	  B G#   B   	E 	W q 	O   w  8 pD    o .u 

k -+>  n   " 
I 	~  B D = 1 @O  < 	 	 n 	OP   y  8 p D   o .u 

4 -+g>  λ  	 " 
I 	~  B Bh   = @  	 	 l] 	O v  {  91 p    o .t 
	 -+:>%  .   "c 
I 	~{  B @  [ ;T   	g 	b j 	N O  }  9m q    o .t 
	 -+
>+     "A 
J 	~G  B ;H   6_ $  	 	 eN 	N     9 q E   o .t 
	V -*>8  P   " 
J1 	n+  B 8 i   3  2 	 	s b 	M  0  l : q    o .t 
	 -*>>     " 
JG 
	  B 6   1k _  	E 	# ` 	M  0  R :Q r    o .t 
 -*Y>E      " 
J\ 
	c  B 4 T N .   	 	 ^R 	MC  0  8 : rB    o .s 
 -*,>K  p  & " 
Jr 
	+  B 1   ,q {  	 	 [ 	L п 0   : r .   o .s 
w -)>Q    , "r 
J 
 
 B /# b | )   	k 	, Y 	L г 1    : r h   o .s 
@ -)>X  0  2 "P 
J 
  B ,   'p  z 	 	 WY 	Lm Ч 1   ;# r    p .s 
 -)>^    8 "- 
J 
  B *: u  $ $  	 	 U 	L% К 1   ;W s3    p .s 
 -)y>d    > " 
J 
K  B '  O "t  u 	 	2 R 	K 5 lH   ; sr    p .r 
 -)L>k  P  D " 
J 	Ϝ  B %'      	V 	 PV 	K   lR   ; s W   p .r 
b -)>q    J " 
J 	]   B "   r  v 	 	 M 	KA 
 l\   <  s    p .r 
* -(>x    P "ڤ 
K	 	  B    5    	 	2 K 	J  lf  l <8 t5    p .r 
 -(>~  p  ¡V "؁ 
K 	  B  G  j   	 	 IJ 	J  lp  S <p tv    p .r 
 -(>    Ú\ "_ 
K4 	Σ  B   |    	S 	 F 	JZ  ly  : < t V   p .r 
 -(k>  0  ēb "< 
KI 	f  B  v  b   	 	- D 	J
 	y   ! < t    p .q 
0 -(>>    Ōh " 
K_ 	  B      5 	 	 B1 	I 	yz 2   =# uD    p .q 
 -(>    ƅn " 
Kt 	q  B  zG    Q 	C 	. =U 	H 	s    = u    p .q 
n -'>  C  wZ "˳ 
K 

  B 
 w  	f   	 	 : 	H 	r    = v3    p .q 
 -'>  Q  pa "ɐ 
K 

|  B G uh 8  W Y 	 	 8 	H@ 	p    >? v .   p .q 
 -'^>  o_  ij "n 
K 

  B  r  p   	 	: 6 	G 	o    > v    p .q 
 -'1>  m  br "K 
K 
	  B  p    e 	> 	 3 	G 	n    > w    p .q 
X -'>  /{  [z ") 
K 
	>  B \ n }" | u  	 	 1? 	G- 	l 6   ?
 wl !   p .q 
 -&>    T " 
L 
  B   k z   m 	 	I . 	F 
` m   ?` w    p .q 
 -&>    M " 
L  	  B  i? xc    	u 	 ,F 	FW 
J m   ? x#    p .q 
^ -&}>  O  F " 
L6 	6  B  f v  ? s 	4 	 ) 	E 
3 m8  { @ x H   p .q 

 -&P>    ? " 
LK 	  C ` d` s    	 	S 'C 	Ey 
xu [  v @_ x    p .q 
 -&#>    8 "| 
La 	  C } a qQ   q 	 	 $ 	E 
xh   r @ yF #   p .q 
d -%>  o  1 "Z 
Lv 	  C  _n n    	t 	 "2 	D 
xZ   n A y    p .q 
 -%>    * "7 
L 	i  C { \ l   _ 	1 	W  	D 
q M  i Ar z     p .q 
 -%>  /  # " 
L 	  C	 h Zx j6    	 	 # 	C 
q t  c A zs m   p .q 
N -%o>|     " 
L 	k  C T W g &  M 	 	  	C0 
q   ^ B& z    p .q 
  -%B>y     " 
L 	  C  U ev  b  	f 	g  	B 
V J9  Y B {< J   p .q 
  -%>u  P   " 
L 	F  C ߚ Pc `   ޅ 	 	  	A 
$ J  e C^ |* V   p .q 	 -$>o      "i 
M
 	E^  C O M ^V N   	 	{ 2 	A 

 J  k C |    o .q 	v -$>l  n   "F 
M" 	D  C A K5 [   7 	U 	- 
 	@ 
 J  q D: } c   o .q 	 -$b>i     "# 
M8 	D  C R H Y g  ܐ 	
 	 
 	@ B   z D }    o .r 	 -$5>f$  .   " 
MN 	,  C a E W$    	 	 > 	?l B    E% ~ Ä   o .r 	( -$>b*     " 
Mc 	,  C n CH T v   	u 	?  	> Bn ,   E ~    o .r 	 -#>_0    ݱ " 
My 	+g  C ́ @ RM   V 	) 	  	>@ BS Q   F  ī   o .r 	. -#>\7  N!  ָ " 
M 	*  C! ʭ = O Ѕ  ٕ 	 	  7 	= B7 u   F  ?   n .r 	 -#>Y=  $  Ͼ "v 
M 	)  C#  ;/ Mi 
 3  	 	M | 	=	  0   G #    n .r 	P -#T>VD  '   "T 
M   C% 
 8i J ˕ a  	7 	  	<] w O   G  ƍ   n .s 	 -#'>SJ  n*   "1 
M   C' = 5 H`  ݏ  	 	  	; M n   H& K :   n .s 	: -">PP  ,   " 
M @  C* | 2 E Ʀ  : 	c 	[ * 	; #     H     n .s 	 -">LW  ./   " 
M u  C,  0 CF /  V 	 	 g 	:\     I; r ȑ   m .t 	@ -">I]  2   " 
N 	5  C.  -A @  G p 	 	  	9 ?   0 I 
 G   m .t 	 -"s>Fc  5   " 
N%   C0 < *j >: B ڂ Ӄ 	E 	k  	8 ?   Y Jv     m .t 	+ -"F>Cj  N8   " 
N:   C2  ' ;   ҏ 	 	  	8     K m    l .u 	 -">@p  :   "a 
NP b6  C4 E ! 6  ~ | 	 	  	6     Lg  ̃   l .u 	R -!>:}  o  7 " 
N{ `u  C9   3Y l  m 	8 	.  	5 <R >   M x W   k .v 	 -!>6  ϭ  < " 
N O7  C;   0   H 	 	 " 	4 < X   M - .   k .v 	! -!e>3  /  |B "~ 
N NQ  C= 0  - u \  	1 	 4 	4 ; q  H Nh     k .w 	z -!9>0    uF "| 
N Mj  C?  f +4  թ  	 	3 H 	3E @q   q O     j .w 	 -!>-    nL "z 
N   CB  % (s }  ` 	% 	 _ 	2x @@    O G Э   j .x 	I - >*  O  gR "xn 
N   CD &  %  B  	 	 u 	1 @    Pd  с   i .x 	 - >'    `W "vK 
N   CF u  "  Ӌ ǘ 	 	6 r 	0 q    Q"  o   i .y 	 - >$    Y\ "t) 
O #<  CH  o  
  A 	H 	 s 	/ q   % Q  X   i .y 	U - X>!  o  Rb "r 
O' "K  CJ  J     	 	 u 	/ q[   V R D A   h .z 	 - +>  χ  Kg "o 
O< !Z  CL h 8  , k  	 	K w 	.# q    SO  +   h .z 	 ->  /  Dl "m 
OR  i  CO  - 
  и  	? 	 h 	-3 | 	Y   T  &   g .{ 	a ->  ~  =q "k 
Og i  CQ  2   P  ~ 	 	 N 	,9 , 	Y    T  ,   g .{ 	 ->  y  6w "i{ 
O} l  CS X ; "  G f 	 	k 4 	+>  	Y 
 ? U  3   f .| 	 -w>  Ot  /| "gX 
O n  CU  E % y Ό O 	' 	#  	*D  	Y  ~ V c :   f .} 	5 -J>  o  ( "e6 
O q  CW   X (   B 	o 	  	)M  	5   WV 9 <   e .} 	s ->  k  ! "c 
O %  CZ   9 L ̇ 8 	 	W  	'= q 	  F Y  h   d .~ 	 ->    T "^ 
O   C^   B   9 	Q 	  	&3  	-   Y     d . 	+ ->  -  \ "\ 
O   C` |h  K  ( 5 	 	 Z 	% 
Z 
    Z  ޥ   c . 	M -i=    c "Z 
P = | Cb y  S 6 ʀ + 	 	  	# 
Z 
   ? [     b . 	o -<=    i "Xe 
P) <d z Ce w*  Z    	1 	\  	" 
Z 
!   \  V   b . 	u -=  M  q "VC 
P> ;E x Cg t 
 Y } 2 
 	t 	 A 	!l 
3* 	   ]     a . 	 -=	    x "T  
PT v v Ci q " X ! ȋ  	 	  	 2 
 
7   ^ _ "    ` . 	 -=     "Q 
Pi  t Ck oQ ! ` }   	  	 q 	 
M 
7 "  `! G N   ` . 	 -=  n    "O 
P  q Cn l  j {t B  	K 	i  	 
 
7 % 9 aA m    _ . 	 -[=    ێ "M 
P z o Cp j 5 u y& ƚ  	 	4  	< 
 
7 '  ba  "   ^ . 	 -.=#  .  ԕ "K 
P O m Cr gy #  v  ^ 	 	 ' 	  	 ) 
 cq  {   ] . 	 -=)     ͜ "Ir 
P W k Ct d    t J  	+ 	 = 	" C 4 + 0 d f W   ] . 	F -=/  '  Ƥ "GO 
P C h Cv b7   r9 ĝ  	x 	 Y 	P C W . S d  /   ] . 	 -=6  N/   "E, 
P Y f Cy _ Ɣ ޟ o  A 	 	_ u 	~ Cs { 0 v eg     \ . 	0 -z=<  7   "C	 
Q  n d C{ \ y ۪ m L  	 	+  	  ۴ 2  f     \ . 	 -M=C  >   "@ 
Q 	 b C} Z\ ? ص kS £  	Q 	  	 m  4  f  |   \ . 	 - =I  nF   "> 
Q+ 	 ` C U   f A  	 	 { 	   9  gt ,    [ . 	< -=V  -  
 ":~ 
QU 
 [ C Rj c  dq   	 	` x 	@   ;  g  <   [ . 	 -=\     "8[ 
Qk 
 Y C O   b&  W 	] 	- v| 	 
 y =  h     [ . 	y -l=b     "68 
Q 
Š W C M&   _ 6  	 	 s 	U 
  ? z hh f    [ . 	& -?=i  M  
 "4 
Q 
N T C Js Q  ] v F 	 	 q{ 	 
 7 B j h     [ . 	 -=o     "1 
Q 
 R C G   [I   	 	 n 	\ 
  D Z i
 <    [ . 	 -=v    y "/ 
Q 
 P C E   Y   / 	d 	e lr 	 
  F I i`  v   [ . 	, -=|  n(  r "- 
Q 
 N C BX   V 6  	 	4 i 	c 
?   H 8 i     [ . 	 -=  :  k "+ 
Q 
 K C ? X  T[ v c 	 	 gr 	 
t' , K # i v W   [ . 	܅ -^=  .L  d ")f 
R 7Y I C < D  Q   	 	 e
 	 
t  M  j3     [ . 	N -1=  ^  ^ "'C 
R 6 G C : >  O   	I 	o b 	. 
t 
 O  ji     [ . 	 -=  p  W "%  
R, 6 E C 7T A  M5   	 	+ `E 	 
uY 
 Q  j i S   [ . 	 -=  N  P "" 
RB 5t B C 4 D  J  } 	 	~ ] 	q 
bX  T  j     [ . 	ۋ -=    I  "  
RW D @ C 1 R  Hi 3 X 	 	~ [ 	 
b > V v k     [ . 	8 -}=    B) " 
Rm D6 > C . g  E G ; 	1 	~N Y' 	 
  X N k3 Q ?   [ . 	  -P=  n  ;2 " 
R ʈ < C + ~  C \   	b 	} V 	^ 
Ƞ Vz [ + kh     [ . 	 -#=    4; "q 
R { 9 C