PDS_VERSION_ID      = PDS3
LABEL_REVISION_NOTE = "SE-MTC, 11/12/2015"

     /* File format and length */
PRODUCT_ID    = "T1_00366974865.GEO"
ORIGINAL_PRODUCT_ID = "PTE8I919.QUB"
RECORD_TYPE   = FIXED_LENGTH
RECORD_BYTES  = 512
FILE_RECORDS  = 72
LABEL_RECORDS = 10
FILE_STATE    = CLEAN

     /* Pointers to data objects */
^QUBE      = 11
 
     /* Producer information */
PRODUCER_ID               = ROSETTA_VIRTIS_TEAM
PRODUCER_FULL_NAME        = "CAPACCIONI"
PRODUCER_INSTITUTION_NAME = "OBSERVATOIRE DE PARIS-LESIA"
PRODUCT_CREATION_TIME     = 2016-11-24T10:40:38.00
TELEMETRY_SOURCE_ID       = "VIRTIS_EGSE3"
SOFTWARE_VERSION_ID       = {"VirtisRos SW v.4.10", "EGSE_SOFT_7.4", 
"PDS_CONVERTER_7.4","EGSE2PSA_LBL_1.2.2", "GEOROS_6.2", "V_GEOLABEL_6", 
"GEOROS_7.1", "V_GEOLABEL_6"}

     /* Data description parameters */
DATA_SET_NAME        = "ROSETTA-ORBITER 67P VIRTIS 3 PRELANDING MTP006 V1.0"
DATA_SET_ID          = "RO-C-VIRTIS-3-PRL-MTP006-V1.0"
PRODUCT_TYPE         = EDR
PROCESSING_LEVEL_ID  = 2
STANDARD_DATA_PRODUCT_ID = "VIRTIS GEOMETRY"
MISSION_NAME         = "INTERNATIONAL ROSETTA MISSION"
MISSION_ID           = ROSETTA
INSTRUMENT_HOST_NAME = "ROSETTA-ORBITER"
INSTRUMENT_HOST_ID   = RO
MISSION_PHASE_NAME   = "PRELANDING MTP006"
PI_PDS_USER_ID       = CAPACCIONI
INSTRUMENT_NAME      = "VISIBLE AND INFRARED THERMAL IMAGING SPECTROMETER"
INSTRUMENT_ID        = "VIRTIS"
INSTRUMENT_TYPE      = "IMAGING SPECTROMETER"
^INSTRUMENT_DESC     = "RO_VIRTIS_EAICD.ASC"
ROSETTA:CHANNEL_ID   = "VIRTIS_H"
DATA_QUALITY_ID      = 1
DATA_QUALITY_DESC    = "0:INCOMPLETE ; 1:COMPLETE"

     /* Science operations information */
TARGET_TYPE            = "COMET"
TARGET_NAME            = "67P/CHURYUMOV-GERASIMENKO 1 (1969 R1)"
START_TIME             = 2014-08-18T09:21:40.509
STOP_TIME              = 2014-08-18T09:52:29.243
SPACECRAFT_CLOCK_START_COUNT = "1/0366974431.54469"
SPACECRAFT_CLOCK_STOP_COUNT  = "1/0366976280.36981"
ORBIT_NUMBER           = "N/A"
OBSERVATION_TYPE       = "NULL"
SC_SUN_POSITION_VECTOR        = (-192988391.918, 425237440.272, 246416939.924)
SC_TARGET_POSITION_VECTOR     = ( 49.159, -29.177, -67.025)
SC_TARGET_VELOCITY_VECTOR     = ( -0.001, -0.000, 0.000)
COORDINATE_SYSTEM_ID          = "-1000012000"
COORDINATE_SYSTEM_NAME        = "67P/C-G_CK"
DECLINATION                   = -999.999
RIGHT_ASCENSION               = -999.999
MAXIMUM_LATITUDE              = 65.581
MINIMUM_LATITUDE              = 59.406
EASTERNMOST_LONGITUDE         = 230.821
WESTERNMOST_LONGITUDE         = 223.049
SPACECRAFT_ALTITUDE           = 86.197
PHASE_ANGLE                   = 34.446
SUB_SPACECRAFT_LATITUDE       = 20.539
SUB_SPACECRAFT_LONGITUDE      = 8.485
SLANT_DISTANCE         = 87.885893
SOLAR_DISTANCE         = 528008325.766
SOLAR_LONGITUDE        = 118.61671
SUB_SOLAR_LATITUDE     = 19.243
SUB_SOLAR_LONGITUDE    = 346.691
NOTE = "The values of the keywords SC_SUN_POSITION_VECTOR, 
SC_TARGET_POSITION_VECTOR and SC_TARGET_VELOCITY_VECTOR are related to the 
J2000 frame. The values of SUB_SPACECRAFT_LATITUDE and 
SUB_SPACECRAFT_LONGITUDE are northern latitude and eastern longitude in the 
planetocentric frame defined by the shape model. All values are computed at 
mid-session. Distances are given in <km>, velocities in <km/s> angles in 
<deg>"


     /* Instrument status */
INSTRUMENT_MODE_ID    = 10
^INSTRUMENT_MODE_DESC = "RO_VIRTIS_EAICD.ASC"

     /* Pointer to navigation data files*/
SPICE_FILE_NAME = {"NAIF0011.TLS","PCK00010.TPC","DE405.bsp","JUP263.bsp",
"ROS_160929_STEP.TSC","ROS_V26.TF","ROS_CHURYUMOV_V01.TF","ROS_VIRTIS_V13.TI",
"cg-spc-shap5-v1.1_Cedric.TPC","RORB_DV_145_01___T19_00216.bsp",
"CORB_DV_145_01___T19_00216.bsp","RATT_DV_145_01_01____00216.bc",
"RATT_DV_145_01_01____00216.bc","CATT_DV_145_01_______00216.bc",
"cg-spc-shap5-v1.1-cheops.bds"}

     /* Cube keywords */
OBJECT = QUBE
 AXES                       = 3
 AXIS_NAME                  = (BAND,SAMPLE,LINE)
 CORE_ITEMS                 = (31,64,4)
 CORE_ITEM_BYTES            = 4
 CORE_ITEM_TYPE             = MSB_INTEGER
 CORE_BASE                  = 0.0
 CORE_MULTIPLIER            = 1.0
 CORE_VALID_MINIMUM         = -2147483648
 CORE_NULL                  = -2147483648
 CORE_LOW_REPR_SATURATION   = -2147483648
 CORE_LOW_INSTR_SATURATION  = -2147483648
 CORE_HIGH_REPR_SATURATION  = 2147483647
 CORE_HIGH_INSTR_SATURATION = 2147483647
 CORE_NAME                  = "GEOMETRIC PARAMETERS"
 CORE_UNIT                  = "UNK"
 CORE_DESC                  = "PARAMETERS ARE DEFINED IN EAICD"

 SUFFIX_BYTES               = 4
 SUFFIX_ITEMS               = (0,0,0)
END_OBJECT = QUBE

END
                                                                                                                                                                                                                                                                                                                                                                                                   " ! $
 %J  	l 
H 	$o #8n 	 Ш L H Y 	 	:0 !4 XH x 2^ߕ  l   #o (:  * ' "F !b $p %H  	Z 
I 	$ #7 	6 E 	 H X} 	 	9 P4 XF y1 2^ߕ  c   !e (M n *  "@ ! $ %GJ  	I 
I? 	$ #5 	   H W 		 	8 4 XD y 2^ߕ  UZ   [ (` H *  ": ! $< %E y 	8 
Id 	% #4/ 	   H WI 	 	89 4 XC y 2^kߕ  P  ! Q (s  " * 
 "3 !` $ %C 0 	& 
I 	%P #2 	B  B H V 	 	7 4 XA zc 2^Sߖ  G  ' G (   *   "- !
 $ %BR  	 
I 	% #1Z 	  |] H V 	$ 	6 5 X? z 2^:ߖ  u>  * = (  *  "' ! $n %@  	 
I 	% #/ 	  { H U 	0 	6L F5 X= {% 2^"ߖ  4  0 3 ( X *  "! !_ $ %? Q 	 
I 	% #.~ 	= : y H T 	> 	5 }5 X; { 2^
ߖ  5+  3 ) ( , *  " !	 $: %=^  	 
J 	&7 #- 	  x H TR 	K 	5
  5 X: { 2]ߖ  "  9  (  +  " !ݳ $ %; o 	 
JC 	&q #+ 	 ~ wX H S 	Y 	4i 
5 X8 |W 2]ߖ%     >  (  +  " !] $ %:  	ɱ 
Jh 	& #*4 	1   v H} S' 	g 	3 
$5 X6 | 2]|ߖ,  U  !B 
 (  +  " ! $m %8k z 	ʜ 
J 	& #( 	  t Ht R 	t 	3( 
Z5 X4 } 2]qߖ2    "zG 
  )
 } +#  " !ٲ $ %6  	ˆ 
J 	'  #'X 	~ d s Hj Q 	 	2 
5 X2 } 2]eߖ9    #sK 
 ) P +,  " !] $: %5 { 	o 
J 	'Z #% 	'  z H` Qf 	 	1 
5 X1 } 2]yZߖ?  t  $lP  )0 ~ +6  "j ! $ %3x  	Y 
J 	' #$ 	 ) 9 HV P 	 	1C 
5 X/ ~K 2]aOߖE    %eU  )C U +@  "N !ճ $ %1 x 	D 
K# 	' ## 	x   HM P< 	 	0 
26 X- ~ 2]IDߖL  4  &^Y  )U - +J  "O ! $ %.  	< 
Kn 	(C # < 	 	 u H9 O 	
 	/^ 
6 X) a 2].ߖX    (P   ){  +]  "+ ! $: %, O 	7 
K 	(} # 	p  3 H/ N 	 	. 
6 X(  2] #ߖ_  R  )I  )  +g x " !Є $ %+: ŷ 	2 
K 	( #d 	 I  H& M 	 	. 
6 X& ? 2\ߖe    *B  )  +q n " !8 $ %)  	, 
K 	( # 	   H MX 	
 	-z 
B6 X$  2\
ߖl    +;"  ) [ +z e " ! $n %' Ȅ 	% 
L 	)+ # 	f { [ H L 	
 	, 
x6 X"  2\ߖr  r  ,4(  ) 2 + [ " !̡ $ %&H  	 
L) 	)f #  	   H	 L3 		 	,7 
6 X  U 2\~ߖx  Ҹ  --.  ) 	 + Q "x !U $< %$ V 	 
LN 	) # 	   G K 	  	+ 
6 X  2\~ߖ  2  .&4  )  + G "i !	 $ %"  	 
Lu 	) #H 	 Z [  G K 	1 	* 
6 X 3 2\o~ߖ    /< ~ *    + > "[ !Ⱥ $ %!U v 	 
L 	* # 	!  S G J} 	A 	*V 
U6 X  2\W~ߖ    0B t *  + 4 "M !e $z %  	 
L 	*N #p 	!   G I 	R 	) 
7 X  2\?~ߖ  R  1H j *% a + * "? ! $ %
 ё 	 
L 	* # 	"L :  G IZ 	c 	) 
7 X I 2\'~ߖ    2
N ` *8 7 +   " !ĺ $M %d  	ڟ 
M 	* # 	"   G H 	t 	(w 
7 X  2\~ߖ    3U V *K 
 +  " !c $ % J 	| 
M; 	* #, 	# z ~K G H9 	 	' 
77 X ' 2[~ߖ  r  3[ L *^  + 
 " ! $! % բ 	^ 
Mc 	+6 #
 	$;  }	 G G 	 	'9 
p7 X z 2[~ߖ    4a B *q  +  " ! $ %r  	@ 
M 	+o #T 	$  { G G 	  	& 
7 X  2[~ߖ  2  5g 8 *  +  "q !f $ % 7 	 
M 	+ #
 	% wf ] G F  	% 
7 X X 2[~ߖ    6m - *  +  " ! $ %  	 
N 	, #8 	' t  G EZ  	$ 
7 X 7 2[}~qߖ  S7  8ً  *  ,  " !e $3 % 	 	 
N) 	,X # 	' s k G D  	# 
38 X	  2[e~fߖ  5  9Ґ  *  ,  " ! $ %6 N 	 
NQ 	, #} 	( f ~a G D1  	#$ 
W8 X  2[M~[ߖ  4  :˖  *  ,  " ! $ %
 ޒ 	i 
Nx 	, # 	); d } Gw C  	"t 
{8 X h 2[4~Pߖ  s2  ;Ĝ  * f ,   "Y !d $}q %  	C 
N 	- # 	) o U Gm C
  	! 
8 X  2[~Eߖ  1  <  +  ,)  "% ! ${ %
H  	 
N 	-C #b 	* nV  Gc Bw  	! 
8 X F 2[~:ߖ  3/  =  +  ,3  " ! $zE % V 	 
N 	- #  	+e l  GY A  	 d 
8 X   2Z~/ߖ  -  >  +.  ,=  " !c $x %  	 
O 	- " 	, ks d GP AR  	 
8 W % 2Z~$ߖ  ,  ?  +A ^ ,G  " !
 $w %f  	 
O> 	- "H 	, j  GF @  	 
09 W  2Z~ߖ  S*  @  +T 8 ,P  "{ ! $u % - 	} 
Oe 	.> " 	- h  G< @.  	U 
U9 W  2Z~
ߖ  )  A ˾ +g  ,Z  "P !b $s %% s 	T 
O 	.| " 	.F g r G3 ?  	 
z9 W r 2Z~ߗ  '  B ɴ +z  ,d { "% ! $rY %   	3 
O 	. "/ 	. e " G) ?  	 
9 W  2Zs}ߗ  s&  C Ǫ +  ,n q " ! $p $  	 
O 	. " 	/ d< } G >z  	H 
9 W P 2ZZ}ߗ  $  D Š +  ,w h " !u $o- $J " 	 
P 	/@ "s 	0l b | G = $ 	 
9 W  2ZB}ߗ  3"  E~ Ö + v , ^ "{ !( $m $ 3 	 
P+ 	/ " 	1# aY {/ G =Z / 	 
9 W . 2Z*}ߗ  !  Fw  + N , T "~7 ! $l $ D 	 
PR 	/ " 	1 _ y G < : 	= 
6: W  2Z}ߗ$    Gp  + ' , J "{ !@ $h $  	 
P 	0D " 	3D U nu F ; Q 	 
݅: W ` 2Y}ߗ1  H  Ib n +  , 7 "z ! $gA $4  	s 
P 	0 " 	3 TM m$ F ; ^ 	8 
ܮ: W  2Y}ߗ8  U  J[ d ,  , - "y ! $e $ , 	V 
P 	0 "> 	4 R k F : j 	 
: W > 2Y}ߗ>  ra  KT Z ,$ j , $ "xV !Y $d $ n 	8 
Q 	1 " 	5^ Qj j F : x 	 
 : W  2Y}ߗD  n  LM O ,7 A ,  "w ! $b $Z z 	 
Q> 	1G " 	6 O i1 F 9u  	5 
*: W  2Y}ߗK  2z  MF E ,J  ,  "u ! $` $ S 	 
Qf 	1 "" 	6 N g F 8  	 
S: W  2Yh}}ߗQ    N? ; ,]  ,  "tQ !l $_V $ * 	 
Q 	1 " 	7x M f F 8\  	 
}; W  2YP}rߗW    O8 1 ,p  ,  "r ! $] $  	 
Q 	2 "d 	8* K e> F 7  	4 
ק; W j 2Y7}gߗ^  R  P2 ' ,  ,  "q ! $\+ $  	x 
Q 	2L " 	8 J3 c F 7D  	 
; W  2Y}\ߗd    Q+  , q ,  "p1 !v $Z $E  	P 
R 	2 " 	9 H b F 6  	 
; W H 2Y}Qߗk    R$  , G ,  "n !/ $Y  $  	< 
R+ 	2 "H 	:? GP aK F 6-  	5 
(; W  2X}Fߗq  r  S 	 ,  -	  "mq ! $Wk $
 Z 	' 
RR 	3 " 	: E _ F 5  	 
T; W & 2X};ߗw    T$  ,  -  "l3 ! $U $l p 	 
Rz 	3O " 	; 6 P Fz 5  	 
Ӏ; W z 2X}0ߗ~  2  U,  , U -  "k
 !] $TA $  	 
R 	3 "* 	<P 5D O Fp 4  	; 
Ү< W  2X}%ߗ    V4  , ) -&  "i ! $R $1  	 
R 	3 " 	< 3 N8 Ff 4 ! 	 
< W X 2X}ߗ    W<  -  -0  "hV ! $Q $ޓ j 	 
R 	4 "m 	= BC ` F] 3{ 1 	 
< W  2Xu}ߗ  S  WD  - ɴ -:  "e !9 $M $Y 	 ! 	 
SA 	4 "ٲ 	? ?_ ]z FI 2i R 	
 
]< W  2XE|ߗ    Y*  -@ _ -M  "dO ! $LZ $ٻ 	 	c 
Sh 	4 "T 	? = \( F@ 1 c 	 
Έ< W  2X,|ߗ  r  Z1  -S 5 -W  "c ! $J $ 	 	@ 
S 	5 " 	@u <| Z F6 1W t 	C 
ʹ< W  2X|ߗ    [9  -f 
 -` ~ "a !W $I1 $ր 	 
  
S 	5U "ը 	A= '; mS F, 0 y 	 
= W  2W|ߗ  2'  \@  -y 
C -j u "`i ! $G $ 	 
  
S 	5 "\ 	B % k F" 0: { 	
 
= W } 2W|ߗ  0  ]F  - 
 -t k "_ ! $F $E 	 
 
T 	5 " 	B $ j F /  	
 
= W  2W|ߗ  8  ^O  - 
 -~ a "] !l $Dk $Ѩ 	 
 
T( 	6 " 	C #2 i5 F / ׂ 		G 
= W \ 2W|ߗ  R@  _V  - 
 - X "\W ! $B $ 	} 
d 
TN 	6X "y 	Dh ! g F . ֆ 	 
	= W  2W|ߗ  H  `] { - 
 - N "Z ! $A> $m 	; 
1 
Ts 	6 "- 	E2   fv E . Պ 	 
= W V 2W|ߗ  Q  ad q - 
 - D "Y !w $? $ 	! 
 
T 	6 " 	E * e E -u ԏ 	 
,> W  2Wj|ߗ  rY  bl g - 
W - : "Xc !& $> $; 		< 
 
T 	7" "̕ 	F  c E , Ӕ 	M 
>> W P 2WR|ߗ  a  cs ] - 
/ - 1 "W, ! $<y $ɤ 	
X 
 
T 	7i "I 	G | bW E ,[ ҙ 	 
O> W  2W9|~ߗ  2i  dz S . 
 - ' "U ! $: $
 	q 
f 
U 	7 " 	H] K X E + ћ 	 
[> W J 2W!|sߗ  r  e H .# 
? -  "T !3 $9L $w 	 
1 
U0 	7 "ȼ 	I. JG  E +@ М 	 
e> W  2W	|hߗ  z  f ~> .6 
 -  "S !} $7 $ 	
 
 
UV 	8B "v 	I H  E * Ϟ 	C 
o? W D 2V|]ߗ  R  g |4 .I 
 - 
 "RQ !| $6 $R 	 
	 
U| 	8 "0 	J G 7 E *% Π 	 
z? W  2V|Rߗ    h z* .\ 
 -   "O~ !y $2 $- 	. 
d 
U 	9! "Ü 	Lb  B E ) ̬ 	 
? W  2V|<ߘ
  rV  ju v . 
< -  "N !x $1[ $ 	 
/ 
U 	9l "P 	M( m AN E ( ˴ 	 G 
? W  2V|1ߘ  `  kn t . 
 -  "L !wV $/ $ 	 
 
V 	9 " 	M ! ? E ' ʽ  
@ W  2Vw|%ߘ  2i  lg r . 
 .  "KA !v $.- $u 	\ 

 
V7 	: " 	N  > E 't   
@ W  2V_|ߘ  s  m` o . 
ܸ .  "I !t $, $ 	 
 
V] 	:K "k 	Ox  =, E} &   
@ W  2VF|ߘ#  }  nY m . 
݋ .  "Hm !sg $+  $P 	 
Y 
V 	: " 	P< = ; Et &c  ] 
	@ W  2V.|ߘ*  R  oR k . 
_ .#  "G !r $)j $ 	 
# 
V 	: " 	Q  :j Ej %   
 @ W  2V{ߘ0    pK i . 
2 .,  "E !p $' $+ 	T 
 
V 	;+ " 	Q  9	 E` %T   
7@ W 
 2U{ߘ7    qD g / 
 .6  "Dc !ot $&= $ 	R 
 
V 	;v "; 	R \ 7 EW $  / 
NA W y 2U{ߘ=  r  r= e / 
 .@  "C !n! $$ $ 	I 
l 
W 	; " 	S\ o t EM $B  h 
UA W  2U{ߘC  ҭ  s6 c /,  .I  "A !l $# $t 	 
- 
W? 	<
 " 	T6 n  EC #   
VA W s 2U{ߘJ  2  t/ a /? j .S  "@c !k{ $!y $ 	 
 
Wd 	<U " 	U mk  E9 #*   
WA W  2U{ߘP    u( _ /R 
L .]  "? !j( $ $O 	 
 
W 	< "C 	U l+ M E0 "   
YB W  2U{ߘV    v! ] /e - .g x "= !h $M $ 	 
l 
W 	< " 	V j  E& "  < 
[B W  2Uk{ߘ]  R  w [ /x  .p o "<M !g $ $* 	N 
+ 
W 	=3 " 	W i  E !  r 
]B W  2US{ߘc    x Y /  .z e "; !f/ $  $ 	; 
 
W 	=} " 	Xl hm & E !     
aB W  2U;{ߘj    y
 W~ /  . [ "8} !c $ $t 	0 
f 
XF 	> " 	Z e a D    
fC W  2U
{ߘv  `  zR Si /  . H "7: !b6 $] $ 	) 
# 
Xk 	>\ " 	Z d  D e  M 
kC W  2T{tߘ}  4^  {W Q_ / t . > "5 !` $ $O 	 ! 
 
X 	> " 	[  / D  
  
uC W  2T{iߘ  ]  |] OT / * . 4 "4 !_ $1 $ 	  
 
X 	> "J 	\  - D Z   
C W  2T{^ߘ  [  }c MJ / +q . + "3A !^= $ $+ 	! 
Y 
X 	?: " 	]K ^ ,B D  &  
C W  2T{Sߘ  TZ  ~i K@ 0 ,C . ! "1 !\ $ $ 	" 
 
Y 	? " 	^ 1 * D R 2 W 
D W  2T{Hߘ  X  n I6 0# - .  "0 ![ $n $ 	# 
 
Y& 	? " 	^ rM  D  6  
D W  2Tx{=ߘ  W  t G, 06 Z" .  "/f !ZE $ $t 	$} 
 
YK 	@ "I 	_ q'  D B 7  
D W  2T`{1ߘ  tU  z E" 0H [ .  ".& !X $A $ 	%z 
@ 
Yq 	@a " 	` p 8 D  9  
D W  2TG{&ߘ  T  ǀ C 0[ [ .  ", !W $	 $P 	&u 
 
Y 	@ " 	aw n  D 3 ; ' 
E W~  2T/{ߘ  4R   A
 0n \ .  "+ !VE $ $ 	'q 
 
Y 	@ " 	bQ m p D  > Z 
E W| ! 2T{ߘ  Q   ? 0 ] .  "*j !T ${ $, 	(l 
 ] 
Y 	A> "i 	c+ l  D % @  
E Wz  2S{ߘ  O   < 0 ^ /  ")+ !S $ $ 	)g 
! 
Z 	A "1 	d kp  D  C  
E Wx 7 2Szߘ  TM   : 0 _c /  "' !RC $L $
 	*H 
! 
Z& 	A " 	d jM C D  G  
E Wv  2Szߘ  L   8 0 `C /  "& !P $ $~ 	+ 
"w 
ZJ 	B# " 	e i+  Dw  L , 
F Wt M 2Szߘ  J   6 0 a# /  "%( !O $  $ 	+ 
#) 
Zm 	Bs " 	f c  Dn 	 G S 
F Ws  2Szߘ  tI   4 0 gK /)  ""t !L # $ 	-m 
$ 
Z 	C "I 	h~   DZ  8  
sG Wo  2Slzߘ  3   0 1 i /<  "! !K #S $X 	.5 
%= 
Z 	Ci "" 	im 6  DQ j 0  
\G Wm x 2STzߘ     . 1 i /F  " !JB # $ 	. 
% 
Z 	C " 	jh _ L DG  #  
9G Wk  2S;zߘ    z , 1,  /O  "d !H #, $F 	/ 
& 
[& 	D
 " 	k   D= F   
G Wi  2S#zߘ  S  s * 1?  /Y  "# !G # $ 	0 
'N 
[M 	D_ " 	l   D4    
H Wg l 2S
zߘ    l ( 1R  /c | " !F@ # $5 	1 
' 
[t 	D " 	mx R | D* 1   
H We  2Rzߙ    e & 1e o /l r " !D #r $ 	2 
( 
[ 	E " 	nm   D     
H Wc  2Rzߙ	  s  ^ $ 1x G /v i "W !C # $% 	3 
)V 
[ 	EV " 	oa \  D   7 
sI Wa ) 2Rzuߙ    W "u 1  / _ " !B< #K $~ 	4N 
* 
[ 	E "` 	pT  V D
   U 
WI W`  2Rzjߙ  3  P  k 1  / U " !@ # $} 	5 
* 
\ 	E "? 	qF j  D 
  t 
<I W^ Z 2Rz_ߙ    I a 1  / L "Y !? #$ ${ 	5 
+a 
\8 	FL " 	r8   C   ݓ 
!I W\  2RxzTߙ"    B W 1  / B " !>> # $z 	6 
, 
\_ 	F " 	s* { 1 C   ܲ 
J WZ p 2R`zIߙ)  T
  ; L 1 y / 8 " !< # $xz 	7 
, 
\ 	F " 	t   C v   
J WX  2RGz>ߙ/    4 B 1 O / / "Z !; #i $v 	8W 
-q 
\ 	GA " 	u   n C    
J WV  2R/z3ߙ6    - 8 1 % / % " !:D # $uh 	9$ 
.  
\ 	G " 	u    C i   
K WT H 2Rz'ߙ<  t&  ' . 2  /  " !8 #B $s 	9 
. 
\ 	G " 	w n  C     
K WR  2QzߙB  /    $ 2# W /  "; !6I # $p 	; 
0+ 
]G 	H " 	yR 8  C 
 Z  
L WN < 2QzߙO      2H Y /  "	 !4 # $oF 	< 
0 
]p 	H " 	zz  w C 
% 9  
L WL  2QyߙU    
  2[ Z /  "	 !3 # $m 	= 
1 
] 	I( " 	{   C    
@L WK  2Qyߙ\  R   	 2n [ /  " !2G #b $l5 	? 
2( 
] 	Iz " 	| pT Z C 	   

M WI L 2Qyߙb      2 e /  " !0 # $j 	@ 
2 
] 	I " 	} p  C   
 
M WG  2Qlyߙi      2 = 0  "b !/ #< $i$ 	A- 
3s 
^
 	J "w 	~ o  C 
   
M WE ~ 2QSyߙo  r    2  0  "9 !.A #ب $g 	B? 
4 
^1 	Jl "c 	 o^ E C| 
t  5 
N WC $ 2Q;yߙu  Ғ    2  0  " !, # $f 	CP 
4 
^X 	J "O 	 o
  Cr 	  L 
oN WA  2Q"yߙ|  2    2  0$  " !+ #Ձ $d 	Da 
5c 
^ 	K "~; 	 n  Ch 	h  c 
JN W? V 2Q
yߙ      2  0.  " !*; # $c 	Er 
6 
^ 	K_ "}' 	 nn 0 C_   z 
%O W=  2Pyߙ      2 q 08  "  !( #[ $ax 	F 
6 
^ 	K "| 	 ,k [ CU Z  ͆ 
~O W;  2Pyߙ  R    3 W 0A  !n !' # $_ 	G 
7P 
^ 	L  "{. 	 +   CK   v 
}O W9 e 2Pyߙ      3 G 0K  !F !&: #5 $^h 	H 
7 
_ 	LR "z= 	 +  CA ;  e 
|DP W7  2Pyߙ  }    3, 8 0U  ! !$ #͡ $\ 	I 
8 
_A 	L "yM 	 + J C8  e V 
zP W5  2Pyvߙ  rz  "  3? ( 0^  ! !# # $[X 	J 
9S 
_g 	L "x] 	E *  C.  G G 
yQ W3 u 2Pwykߙ  v  (  3R  0h w ! !"D #{ $Y 	K 
9 
_ 	MH "wn 	l *)  C$  * 9 
xEQ W1 8 2P_y`ߙ  2s  - w 3e 	 0r m ! ! #T $V 	M 
;G 
_ 	M "u 	 )F } C v   
uR W. á 2P.yJߙ  4  ~ b 3  0 Z !i !A # $UB 	O 
; 
` 	NB "t 	 ݍ  C    
tPR W, c 2Py?ߙ  T'   X 3 N 0 P !G ! #. $S 	P( 
< 
`( 	N "s 	 L  B e   
sR W* 
 2Oy4ߙ     N 3 * 0 F !& ! # $R> 	Q= 
=' 
`N 	N "r 	 
 5 B   + 
qS W( ű 2Oy)ߙ     D 3  0 = ! !: # $P 	RQ 
= 
`u 	OF "q 	   B [  7 
pS W& W 2Oyߙ  t   9 3  0 3 ! ! #s $O= 	Sm 
>f 
` 	O "p 	 Ls tN B   5 
onT W$  2Oyߙ    x / 3 # 0 ) ! ! # $M 	T 
? 
` 	O "o 	6 L r B H  ( 
nT W"  2Oyߙ  3  q % 3 $ 0   ! !3 #J $L< 	U 
? 
` 	PM "n 	[ K q B   k  
lT W  g 2Oxߙ    j  4 %t 0  ! ! # $J 	V 
@C 
a 	P "m 	 Kn pK B  4 ~R  
kyU W * 2Ojxߙ    c  4# &_ 0  !t ! #! $I; 	W 
@ 
a0 	P "l 	 K n B  }:  
j)U W  2ORxߙ  S  \  46 'J 0  !W !, # $G 	X 
A 
aV 	QR "k 	 J m B " |#  
hV W ʓ 2O9xߙ    U  4I (5 0  !: ! # $F: 	Z 
B 
a{ 	Q "k 	 Jo lJ B  {  
gV W U 2O!xߚ    N  4\ )  0  ! ! #b $D 	[ 
B 
a 	R  "j 	 J j B  y  
f<V W  2Oxߚ  s  G  4o *
 0  ! !) # $C8 	\) 
C\ 
a 	RW "i- 	) I i B  x  
dW W ̾ 2Nxߚ  ӏ  @  4 * 1  ! ! #9 $A 	]9 
C 
a 	R "h@ 	I Iw hI B  w  
cW W ́ 2Nxߚ  3  9  4 + 1
  ! ! # $@7 	^Q 
D 
b 	S "gS 	h I% f B ~ v  
bVW W C 2Nxߚ  u  2  4 , 1  ! ! #} $=6 	` 
E 
b[ 	S "e 	 {b wX Bm o t  
_X W Ϭ 2Nxߚ(  R6  $ ȵ 4 oF 1*  !z ! # $; 	a 
F 
b 	T	 "d 	 {  v Bc  st  
^`Y W
 o 2Nvxߚ.  2   ƫ 4 p0 13  !c !/ #[ $:6 	b 
G 
b 	T` "c 	 z t BY c r^  
]Y W 1 2N]xwߚ5  /   ġ 4 q 1=  !L ! # $8 	c 
G 
b 	T "b 	 z sd BP  qI  
[Z W  2NExlߚ;  r+    5 r 1G  !5 ! #9 $75 	d 
H] 
b 	U
 "a 	? z] r BF X p5  
ZnZ W Қ 2N,xaߚA  (    5 r 1P  ! !2 # $5 	f
 
H 
c" 	Uc "a  	a z p B<  o"  
YZ W ] 2NxVߚH  2$    5- s 1Z  ! !  # $43 	g& 
I 
cJ 	U "` 	 y oq B3 O n  
W[ W  2MxKߚN  !   x 5@ t 1d { !   # $2 	h> 
J8 
cr 	V "_2 	 y n! B)  l w 
V[ V  2Mx@ߚT     n 5S u 1m q !  5 # $12 	iO 
J 
c 	Vf "^K 	 yb l B G k o 
U5\ V Ո 2Mx5ߚ[  R   d 5f v 1w h !۲   #d $/ 	jT 
Ks 
c 	V "]e 	 y% k B  j h 
S\ V K 2Mx*ߚa     Z 5y wr 1 ^ !ڒ   # $.2 	k^ 
L 
c 	W "\~ 	 xG io B B i b 
R\ V 
 2Mxߚh     O 5 x 1 T !t  ; #B $, 	lh 
L 
d 	Wh "[ 	 x h B  h ] 
QS] V  2Mxߚn  r   E 5 x 1 K !V   # $+2 	mr 
MT 
d8 	W "Z 	9 w f A ? g X 
P] V ؒ 2Mhxߚt     ; 5 y 1 A !7   #  $) 	n| 
M 
d` 	X "Y 	V w e~ A  f S 
N^ V 9 2MPwߚ{  2   1 5 z 1 7 !  K # $(3 	o 
N 
d 	Xm "X 	s |u m A = e N 
Ms^ V  2M7wߚ     ' 5 z 1 . !   # $& 	p 
O> 
d 	X "W 	 |9 lE A  d I 
L)^ V ھ 2Mwߚ    ˻  5 {{ 1 $ !Ҿ  [ # $# 	r 
P 
d 	Yp "V3 	 { i A  be @ 
I_ V B 2Lwߚ    ͮ?  6 }J 1  !Ѡ   #K $"3 	s 
Q  
e% 	Y "UM 	 { hU A > aY = 
HN` V  2Lwߚ    Χ@  6$ ~1 1  !Ђ   # $  	t 
Q 
eM 	Z "Th 	 {O g A  `M ; 
G` V ݬ 2Lwߚ  s  Ϡ@  67  1   !V  i #) $4 	u 
R_ 
et 	Zs "S 	 { e A A _B 9 
E` V n 2Lwߚ  |  ЙA  6J  1   !*   # $ 	v 
R 
e 	Z "R 	/  m A  ^7 6 
Dxa V 0 2Lwߚ  3W  ђA  6] - 1   !   # $4 	w} 
S 
e 	[ "Q 	I O lP A E ], 3 
C0a V  2Lswߚ  3  ҋA  6p  1   !  x #v $ 	xv 
T: 
e 	[u "P 	b  k A  \" 1 
Ab V  2L[wߚ    ӄB  6  2   !ʶ  ' # $6 	yo 
T 
f 	[ "O 	{  i A J [ / 
@b V x 2LBwߚ  R  }B  6  2   !ɑ   #U $ 	zf 
Uw 
f: 	\! "O 	  hb A{  Z . 
?\b V : 2L*wxߚ    vC  6  2   !k   # $9 	{^ 
V 
fa 	\y "N. 	 p g Aq R Y - 
>c V  2Lwmߚ    oB  6  2%   !F  A #3 $ 	|U 
V 
f 	\ "MK 	 : e Ah  W - 
<c V  2Kwbߚ  r|  hD  6  2/   !!   # $> 	}K 
Wg 
f 	]) "Lh 	 ~ p A^ [ V . 
;c V f 2KwWߚ  X  aD  6 
 28   !   # $ 	~@ 
X 
f 	] "K 	 E oF AT  U - 
:Hd V ( 2KwLߚ  23  ZE  6  2B   !  ` #} $D 	6 
X 
f 	] "J 	 
 m AK e T - 
9d V  2KwAߚ    SE  7  2L   !®   #{ $ 	& 
YT 
g% 	^0 "I 	   AA  S + 
7e V  2Kw6ߚ    LF y 7 * 2U   !   #z^ $
J 	 
Y 
gL 	^ "H 	E   A7 m R  
6fe V p 2K~w+ߚ  Q  EF o 7.  2_   !(  5 #w= $
O 	 
[> 
g 	_7 "GM 	ď J  A$ s P  
3f V  2KMwߛ    7 Y 7T  2r  m !   #u $ 	 
[ 
g 	_ "Fz 	Ų 	  A  O  
2jf V  2K4w
ߛ  s}  0 O 7g  2|  c !  ٟ #t $V 	 
\ 
g 	_ "E 	  X A { N  
1g V  2Kvߛ
  q  ) E 7z  2  Y !  Q #r $ 	 
]! 
h 	`> "D 	   A   M  
/g V s 2Kvߛ  3e  " }; 7  2  P !   #p $\ 	 
] 
h: 	` "D  	 J  @  L  
.uh V 6 2Jvߛ  Y   {1 7  2  F !b  ն #ol $ 	 
^[ 
ha 	` "C* 	7  9 @  K  
-(h V  2Jvߛ   L   y& 7  2  < !?  i #m $b 	 
^ 
h 	aD "B6 	2 ] 8_ @  J  
,h V  2Jvߛ'  S@  
 w 7  2  3 !  ! #lK # 	s 
_ 
h 	a "AB 	+  7 @ ) I  
*i V a 2Jvߛ-  4   u 7  2  ) !   #j #e 	f 
`D 
h 	a "@V 	-  ~ @  H  
)i V $ 2Jvߛ4  (   s 7  2   !  В #i* # 	S 
` 
h 	bF "?k 	0  T @ C G * 
({j V  2Jpvߛ:  s   p 7 s 2   !  K #g #g 	; 
a 
i& 	b ">~ 	0 _ S @  F = 
'Mj V  2JWvߛ@     n 8 _ 2   !   #f	 # 	" 
b2 
iM 	b "= 	/  R5 @ ` E Q 
&!j V O 2J?vߛG  3   l 8% L 2   !W  ̼ #dy #i 		 
b 
iu 	cE "< 	-  P @  D e 
$k V  2J&vߛM     j 88 8 2  !-  t #b # 	 
cz 
i 	c "; 	,  O @ ~ C z 
#k V  2JvߛS     h 8K $ 2  !  - #aY #l 	 
d 
i 	c ": 	)  N& @  B  
"k V { 2IvzߛZ  R   f 8^  2  !   #_ # 	 
d 
i 	dE "9 	& ; L @  A  
!tl V " 2Ivoߛ`     d 8q  3  !  W #\ # 	 
f 
j= 	d "8 	 d J @  ?  
"m V  2IvYߛm  qL   ` 8  3  !^   #[! #p 	j 
f 
jg 	eC "7 	  H @v Q ?  
m V M 2IvMߛs  G  ﹫ ^ 8  3   !>   #Y # 	\ 
gJ 
j 	e "6* 	  V @m  >  
m V  2IzvBߛz  1B   \ 8 ` 3*  !   #X #q 	M 
g 
j 	e "5@ 	 > U @c s =  
n V  2Ibv7ߛ  >   Z 8 M 33  !  > #Vz # 	2 
h 
j 	fA "4V 	
  T? @Y  <' ~- 
|n V y 2IIv,ߛ  9   X 8 9 3=  !   #T #s 	 
i+ 
k 	f "3l 		 i R @P  ;4 }D 
Rn V ; 2I0v!ߛ  Q4   Vy 8 % 3G  !   #Sa # 	 
i 
k8 	f "2 	  Q @F * :A |[ 
)o V  2Ivߛ  /   To 9	  3P  !u  ] #Q #u 	 
j] 
ka 	g> "1 	  P2 @< ߽ 9O {s 
o V  2Hvߛ  +   Rd 9  3Z  !I   #PG # 	 
j 
k 	g "0 	  8Y @3 Q 8_ z 
o V g 2Hv ߛ  q&   PZ 9/ t 3d { !   #N #w 	 
k 
k 	g "/ 	  7  @)  7p y 
p V ) 2Huߛ  !   NP 9B \ 3m r !  x #M. # 	m 
l' 
k 	h; ". 	 U 5 @ z 6 x 
p V  2Huߛ  1  z LF 9U D 3w h !  , #K #y 	& 
l 
l 	h "- 	  4O @  5 w 
uq V  2Huߛ    s J; 9h , 3 ^ !e   #J # 	 
mV 
l2 	h ", 	  2 @ ݥ 4 w  
Tq V 9 2Huߛ    l H1 9{  3 U !   #H #{ 	 
m 
l[ 	i7 ", 	 @ < @ ; 3 v 
3q V  2Hluߛ  Q  e F' 9 ( 3 K !  I #F # 	A 
n 
l 	i "+ 	  ; ?  2 u; 
r V  2HSuߛ  
  ^ D 9  3 A !   #Eo #} 	 
o 
l 	i "*/ 	  :, ? g 1 tX 

r V  d 2H:uߛ    W B 9  3 8 !  e #BU #׀ 	K 
pF 
m 	j "(W 	  7| ? ە 0 r 
s V  2H	uߛ    I = 9  3 $ !   #@ # 	 
p 
m* 	j "'l 	~ l 6$ ? - / q 

s V  2Guߛ  0   B ; 9 ڱ 3  !L   #?< #Ԅ 	 
qq 
mU 	k1 "& 	p  4 ?  .1 p 
	ls V R 2Guߛ    < 9 : ۙ 3  !   #= # 	D 
r	 
m~ 	k "% 	b  3t ? \ -G o 
Lt V  2Gu{ߛ    5
 7 : ܀ 3  !  : #<" #ш 	 
r 
m 	k "$ 	S \ 2 ?  ,] o 
.t V  2Gupߛ  P  . 5 :' g 3  !]   #: #
 	 
s9 
m 	l. "# 	C  0 ? َ +t n/ 
t V ~ 2Gueߛ    ' 3 :: O 3  !   #9	 #΍ 	; 
s 
m 	l "" 	3  /m ? ' * mP 
u V} @ 2GvuZߜ       1 :M 5 3  !  ^ #7| # 	 
tg 
n# 	l "! 	  < ?  ) lx 
u V{  2G]uOߜ  p    / :`  3  !n   #5 #ˑ 	 
t 
nM 	m, "  	   ? ^ ( k 
u Vy  2GDuDߜ  й  & - :s Y 4  !   #4e # 	1 
u 
nw 	m " 	   ?  ' j 
v Vw l 2G,u9ߜ  0  + + : ; 4  !  t #2 #Ȗ 	 
v 
n 	m " 	 <  ?{ ה & i 
 v Vv 	 2Gu.ߜ    	1 ) : ! 4  !  # #1Q # 	} 
v 
n 	n( " 	 ; ` ?r 5 &! i( 	v Vt 	 2Fu#ߜ    	6 ' : " 4%  !/   #/ #Ś 	$ 
w/ 
n 	n| " 	s ;#  ?h  %I hd 	w Vr 
` 2Fuߜ&  P  
< % : # 4.  !   #.; # 	 
w 
o" 	n " 	B :  ?^ x $r g 	w Vp  2Fuߜ,    A #x : $ 48  !  1 #, # 	u 
xG 
oN 	o& " 	 := C ?U  # f 	w Vn  2Fuߜ3    G !n : %^ 4A  !F   #+' #! 	 
x 
oy 	oz " 	 9  ?K ռ " f 	x Vl T 2Ftߜ9  p  
L d : &; 4K  !  @ #( #& 	m 
y 
o 	p" " 	z 8 ( ?8  ! d 	x Vh 
 2FgtߜF  0  b O ; ' 4^  !^   #& # 	 
zq 
o 	pv " 	G 8z  ?. ԥ  B c 	y Vg H 2FNtߜL    e E ;1 ( 4h w !~   #$ #+ 	 
{ 
p# 	p " 	 8 k ?% H n c 	y Ve  2F5tߜR    k ; ;D ) 4r m !|  Y ##r # 	b 
{ 
pN 	q " 	 7 
 ?   bR 	y Vc  2FtߜY  P  p 0 ;W * 4{ d !{s   #! #0 	 
|$ 
px 	qq " 	 70  ? Ӑ  a 	y Va < 2Ftߜ_    t & ;j +d 4 Z !z!   # ] # 	 
| 
p 	q " 	v 6 P ? 5  ` 	z V_  2Etߜf    z  ;~ ,? 4 P !x  y # #4 	F 
}F 
p 	r " 	A 6X  >   ` 	z V]  2Etߜl  p  ~  ; - 4 G !w~  . #H # 	 
} 
p 	rl " 	 |a  > ~ J _P 	 z V[ 0 2Etߜr  Х   
 ; + 4 = !v,   # #: 	 
~g 
q# 	r " 	 { 
! >   p ^ 	{ VZ  2Etߜy  0   
 ; + 4 3 !t   #3 # 	' 
~ 
qN 	s " 	 {O  >   ] 	{ VX  2Et|ߜ      ; , 4 * !s  N # #? 	 
 
qx 	sh "
 	 z d > f  \ 	{ VV @ 2Eptqߜ      ; - 4   !r;   # # 	k 
 
q 	s " 	k z?  > 	  \$ 	| VT  2EWtfߜ  P    ; . 4  !p   # #D 	
 
 
q 	t " 	B y  > Э  [[ 	| VR  2E?t[ߜ  }    < / 4 
 !o  g #	 # 	 
* 
q 	tb "
 
  y2 G > Q 8 Z 	| VP P 2E&tPߜ  u  x   < 0 4  !nM   # #I 	P 
 
r! 	t "	 
  x  >  a Y 	} VN  2E
tEߜ  pm  q  <) 1f 4  !l   # # 	 
; 
rL 	u " 
 x(   > Ϛ  X 	} VL  2Dt:ߜ  e  j  << 2M 4 