function PLOT_ICAL5(l5)
%PLOT_ICAL5 Plot Density and velocity of RPC ICA moment data.
%
% Example:
%    l5 = READICA_L5; % Read a days worth of moment data
%    PLOT_ICAL5(l5)
%
% See also: IMPORT_L5, READICA_L5

massH = l5.mass == 1 & l5.charge == 1;
massHe2 = l5.mass == 4 & l5.charge == 2;
massHe = l5.mass == 4 & l5.charge == 1;
massC = l5.mass == 18 & l5.charge == 1;

pl1 = subplot(5,1,1);
semilogy(l5.time(massH),   l5.density(massH), '.-', ...
              l5.time(massHe2), l5.density(massHe2), '.-', ...
              l5.time(massHe),  l5.density(massHe), '.-', ...
              l5.time(massC),   l5.density(massC), '.-');
datetick x
title('Density')
ylabel('cm^{-3}')
lg1 = legend('H^+', 'He^{++}', 'He^{+}', 'C^{+}','Location','NorthEastOutside');

%% Plot H^{+} velocity vectors
pl2 = subplot(5,1,2);
l5.v(massH & isnan(l5.density),:) = nan;
plot(l5.time(massH), l5.v(massH,1), '.-', ...
     l5.time(massH), l5.v(massH,2), '.-', ...
     l5.time(massH), l5.v(massH,3), '.-')
datetick x
title('H^{+} velocity vectors')
ylabel('kms^{-1}')
lg2 = legend('V_x', 'V_y', 'V_z','Location','NorthEastOutside');
lg2.Position([1 3]) = lg1.Position([1 3]);
pl2.Position([1 3]) = pl1.Position([1 3]);

%% Plot He^{++} velocity vectors
pl3 = subplot(5,1,3);
l5.v(massHe2 & isnan(l5.density),:) = nan;
plot(l5.time(massHe2), l5.v(massHe2,1), '.-', ...
     l5.time(massHe2), l5.v(massHe2,2), '.-', ...
     l5.time(massHe2), l5.v(massHe2,3), '.-')
datetick x
title('He^{++} velocity vectors')
ylabel('kms^{-1}')
lg3 = legend('V_x', 'V_y', 'V_z','Location','NorthEastOutside');
lg3.Position([1 3]) = lg1.Position([1 3]);
pl3.Position([1 3]) = pl1.Position([1 3]);

%% Plot He^{+} velocity vectors
pl4 = subplot(5,1,4);
l5.v(massHe & isnan(l5.density),:) = nan;
plot(l5.time(massHe), l5.v(massHe,1), '.-', ...
     l5.time(massHe), l5.v(massHe,2), '.-', ...
     l5.time(massHe), l5.v(massHe,3), '.-')
datetick x
title('He^{+} velocity vectors')
ylabel('kms^{-1}')
lg4 = legend('V_x', 'V_y', 'V_z','Location','NorthEastOutside');
lg4.Position([1 3]) = lg1.Position([1 3]);
pl4.Position([1 3]) = pl1.Position([1 3]);

%% Plot C^{+} velocity vectors
pl5 = subplot(5,1,5);
l5.v(massC & isnan(l5.density),:) = nan;
plot(l5.time(massC), l5.v(massC,1), '.-', ...
     l5.time(massC), l5.v(massC,2), '.-', ...
     l5.time(massC), l5.v(massC,3), '.-')
datetick x
title('C^{+} velocity vectors')
ylabel('kms^{-1}')
lg5 = legend('V_x', 'V_y', 'V_z','Location','NorthEastOutside');
lg5.Position([1 3]) = lg1.Position([1 3]);
pl5.Position([1 3]) = pl1.Position([1 3]);
end
