function table = import_l2(filename, e_levels, startRow, endRow)
%IMPORTFILE Import numeric data from a text file as column vectors.
%   [table] = IMPORTFILE(FILENAME, E_LEVELS) Reads data from text file FILENAME for the default
%   selection.
%
%   [TABLE] = IMPORTFILE(FILENAME, E_LEVELS, STARTROW, ENDROW) Reads data from rows STARTROW
%   through ENDROW of text file FILENAME.
%
% Example:
%   [TABLE] = importfile('RPCICA150317T04_000_96L2.TAB', 96, 1, 16384);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2016/02/23 14:04:45

%% Initialize variables.
delimiter = ',';
if nargin<=2
    startRow = 1;
    endRow = inf;
end

%% Format string for each line of text:
%   column1: text (%s) iontime
%   column2: double (%f) badhvmask
%   column3: double (%f) shadowmask
%   column4: double (%f) promsection
%   column5: double (%f) pacclevel
%   column6: double (%f) mtable
%   column7: double (%f) azimuthal_index_start
%   column8: double (%f) azimuthal_index_stop
%   column9: double (%f) masschannel_index_start
%   column10: double (%f) masschannel_index_stop
%   column11: double (%f) elevation_index_start
%   column12: double (%f) elevation_index_stop

%   column13-column20: double (%f) ionspectra 8 levels
% or
%   column13-column44: double (%f) ionspectra 32 levels
% or
%   column13-column108: double (%f) ionspectra 96 levels
%
% For more information, see the TEXTSCAN documentation.
formatSpec = ['%s%f%f%f%f%f%f%f%f%f%f%f' repmat('%f', 1, e_levels) '%[^\n\r]'];

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this code. If
% an error occurs for a different file, try regenerating the code from the
% Import Tool.
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'HeaderLines', startRow(1)-1, 'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'HeaderLines', startRow(block)-1, 'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for unimportable
% data, select unimportable cells in a file and regenerate the script.

%% Allocate imported array to column variable names
table = struct( ...
    'iontime', datenum(dataArray{1}, 'yyyy-mm-ddTHH:MM:SS.FFF'), ...
    'badhvmask', dataArray{2}, ...
    'shadowmask', dataArray{3}, ...
    'promsection', dataArray{4}, ...
    'pacclevel', dataArray{5}, ...
    'mtable', dataArray{6}, ...
    'azim', [dataArray{7}, dataArray{8}], ...
    'masschannel', [dataArray{9}, dataArray{10}], ...
    'elev', [dataArray{11}, dataArray{12}], ...
    'ionspectra', [dataArray{13:end-1}] ...
);
