function [ ICAsoftwareversion, ICAbootimage ] = get_sw_version( prom, time )
%GET_SOFTWARE_VERSION Finds the latest versions of the calibration files
%    [sw, boot] = GET_SW_VERSION( prom, time ) prom is a promsection
%    and time is a datenum representing date of current data and returns
%    the software version (sw) and boot image (boot) used
%
%    % Example:
%    [sw, boot] = GET_SW_VERSION(14, datenum('2015-01-10 12:13:14'))

    % Default version of the software an table used when making these measurements
    ICAsoftwareversion = 2;  

    % figure out what table was loaded baswed on prom section and date
    patchdate1 = datenum(2014,10,30);
    patchdate2 = datenum(2015,3,20);
    patchdate3 = datenum(2015,4,28);

    ICAbootimage = prom-1;  % here we boot from
    if ICAbootimage == 15
        % Earth flyby table,  ESC_H offset  assumed to be 0V
        ICAsoftwareversion = 3;

    elseif ICAbootimage == 14
        if time < patchdate1  % before this date section 14 was like version '02'
            ICAsoftwareversion = 2;
        else
            % ESC_H offset  assumed to be 34.5V
            ICAsoftwareversion = 4;
        end

    elseif ICAbootimage == 13
        % ESC_H offset assumed to be 32.5V
        ICAsoftwareversion = 5;

    elseif ICAbootimage == 12
        % ESC_H offset  assumed to be 30.5V
        ICAsoftwareversion = 6;

    elseif ICAbootimage == 11
        if time < patchdate3
            ICAsoftwareversion = 2;
        else
            % ESC_H offset  assumed to be 33.3V, low energy dense
            ICAsoftwareversion = 7;
        end
    elseif ICAbootimage == 10
        if time < patchdate3
            ICAsoftwareversion = 2;
        else
            % ESC_H offset  assumed to be 33.33V, low energy fast
            ICAsoftwareversion = 8;
        end
    elseif ICAbootimage == 9
        if time < patchdate2
            ICAsoftwareversion = 2;
        else
            % ESC_H offset  assumed to be 33.33V, copy of 04 with mass lookup tables
            ICAsoftwareversion = 9;
        end
    elseif ICAbootimage == 8
        if time < patchdate3
            ICAsoftwareversion = 2;
        else
            % copy of PROM section 11
            ICAsoftwareversion = 7;
        end
%     else
%         ICAsoftwareversion = 2;
    end
    % none of the newly uploaded tables. Assume default. ESC_H offset  assumed to be 0V
end

