/*
 * DFMS_structs.hh
 *
 *  Created on: Jul 24, 2013
 *      Author: marinaldi
 */

#ifndef DFMS_STRUCTS_HH_
#define DFMS_STRUCTS_HH_

#include <cstdlib>
#include <cctype>
#include <cstdio>
#include <cstring>

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

#include <dirent.h>
#include <errno.h>
#include <sys/types.h>

#include "DFMS_globals.hh"

using namespace std;


struct prePkFitInfo {
    double fwhm;
	int peakLoc[50];
	bool pkInBounds[50];
	double peakHght[50];
	double msMass[50];
	double peakWidth[50];
	bool pkAboveThresh[50];
	int maxPkLoc;
	double maxPkVal;
	int maxId;
	void printPeaks(int num) {
		printf("--------------------------------------------------------------------\n");
		printf("--------------------- Preliminary Peaks Found ----------------------\n");
		printf(" Peak#   PixLoc    Height       Width   AboveThresh?   PeakInBounds?\n");
		printf("--------------------------------------------------------------------\n");
		for (int i=0; i<num; i++) {
			printf(" %2.2d      %3.3d     %10.2f     %4.1f        %d              %d\n",i,
				   peakLoc[i]+1,peakHght[i],peakWidth[i],pkAboveThresh[i],pkInBounds[i]);
		}
		printf("maxPeak index = %3.3d\n",maxId);
		printf("maxPeak Loc = %3.3d\n",maxPkLoc);
		printf("maxPeak Value = %10.2f\n",maxPkVal);
		printf("-----------------------------------------------------\n");
	}
	void printPeakMass(int num) {
			printf("--------------------------------------\n");
			printf("----- Preliminary Peaks Found --------\n");
			printf(" Peak#   PixLoc    Height       Mass\n");
			printf("--------------------------------------\n");
			for (int i=0; i<num; i++) {
				printf(" %2.2d      %3.3d     %10.2f     %6.2f\n",i,
													peakLoc[i],peakHght[i],msMass[i]);
			}
			printf("-------------------------------------------------------------------\n");
	}
	void init() {
		for (int i=0; i<50; i++) {
			peakLoc[i] = 0;
			pkInBounds[i] = false;
			msMass[i] = 0.0;
			peakHght[i] = 0.0;
			peakWidth[i] = 0.0;
		}
		maxPkLoc = 0;
		maxPkVal = 0.0;
		maxId = 0;
	}
};


struct DFMSModeInfo {
    string sMode;
    string modeType;
    bool isGCU;
    string detector;
    string res;
    bool lowRes;
    bool hiRes;
    string sens;
    double emission;
    string modeDesc;
    double zoom;
    void printData() {
         printf("      sMode:  %-5s\n",sMode.c_str());
         printf("  Mode Type:  %-8s\n",modeType.c_str());
         printf("      isGCU:  %-d\n",isGCU);
         printf(" Instrument:  %-3s\n",detector.c_str());
         printf(" Resolution:  %-4s\n",res.c_str());
         printf("     lowRes:  %-d\n",lowRes);
         printf("Sensitivity:  %-4s\n",sens.c_str());
         printf("   Emission:  %-9.3e\n",emission);
         printf("  Mode Desc:  %-8s\n",modeDesc.c_str());
         printf("       Zoom:  %-3.3f\n",zoom);
    }
};

struct L2FileInfo {
     string fileName;
     string dateTime;
     string startTime;
     string stopTime;
     double secSince1970;
     int fileSize;
     int GS;
     int mode;
     int indexToSpcMass;
     int posPDSLastline;
     bool isGCU;
     bool isSLF;
     int gainStep;
     double commandedMass;
     double intgTime;
     double emission;
     bool hiRes;
     bool lowRes;
     double zoom;
     double zoomUnc;
     void printData() {
         string ans;
         printf("FileName:  %-31s\n",fileName.c_str());
         printf("    date:  %-18s\n",dateTime.c_str());
         printf("fileSize:  %-5.5d bytes\n",fileSize);
         printf("  startT:  %s\n",startTime.c_str());
         printf("   stopT:  %s\n",stopTime.c_str());
         printf("  modeID:  %-4.4d\n",mode);
         if(isSLF) ans=string("Yes"); else ans=string("No");
         printf("   isSLF:  %-3.3s\n",ans.c_str());
         if(isGCU) ans=string("Yes"); else ans=string("No");
         printf("   isGCU:  %-3.3s\n",ans.c_str());
         if(hiRes) ans=string("Yes"); else ans=string("No");
         printf("high Res:  %-3.3s\n",ans.c_str());
         if(lowRes) ans=string("Yes"); else ans=string("No");
         printf(" low Res:  %-3.3s\n",ans.c_str());
         printf("    Zoom:  %-3.1f\n",zoom);
         printf(" Zoomunc:  %-3.1f\n",zoomUnc);
         printf("gainSTep:  %-2.2d\n",gainStep);
         printf("commMass:  %-6.2f amu\n",commandedMass);
         printf("intgTime:  %-4.2f sec\n",intgTime);
         printf("emission:  %-6.2e amps\n",emission);
         printf("secs1970:  %-13.6e sec since 1970\n\n",secSince1970);

     }
     void init() {
         fileName="";
         dateTime="";
         startTime="";
         stopTime="";
         secSince1970=0;
         commandedMass=0;
         intgTime=0;
         emission=0;
         zoom=0;
         zoomUnc=0;
         fileSize=0;
         mode=0;
         indexToSpcMass=0;
         gainStep=0;
         isGCU=false;
         isSLF=false;
         hiRes=false;
         lowRes=false;
     }
};

struct DirInfo {
     string dirName;
     string dateTime;
     string type;
     void printData() {
         string ans;
         printf("dirName:  %s\n",dirName.c_str());
         printf("   date:  %s\n",dateTime.c_str());
         printf("   type:  %s\n",type.c_str());
     }
};

struct gtFileInfo {
    int index;
    string filename;
    string dirName;
    string dateTime;
    string ModelType;
    double secSince1970;
    dbl2D gain;
    void printHeader() {
        printf("File Index:  %d\n",index);
        printf("  filename:  %s\n",filename.c_str());
        printf("   dirName:  %s\n",dirName.c_str());
        printf(" File date:  %s\n",dateTime.c_str());
        printf("Model type:  %s\n",ModelType.c_str());
        printf("  secs1970:  %-13.6e sec since 1970\n\n",secSince1970);
    }
    void readGain(dbl2D &gt) {
        for (int i=0; i<16; i++) {
            // Use vector objects dynamic fill to add values
            gain.push_back(dslice());
            for (int j=0; j<4; ++j) {
                gain[i].push_back(0.0);
                gain[i][j] = gt[i][j];
            }
        }
    }
    void printGain() {
        printf("  filename:  %s\n",filename.c_str());
        printf(" pixel     N/A          Row A          Row B\n");
        for (int i=0; i<16; i++) {
            printf("%3.3d     %6.6f     %8.6e     %8.6e\n",
                   int(gain[i][0]), gain[i][1], gain[i][2], gain[i][3]);
        }
    }
};

struct pgFileInfo {
	 int index;
	 string filename;
     string dirName;
     string dateTime;
     string ModelType;
     string dType;
     int GainStep;
     dbl2D pixG;
     void printHeader() {
    	 printf("File Index:  %d\n",index);
         printf("  filename:  %s\n",filename.c_str());
         printf("   dirName:  %s\n",dirName.c_str());
         printf(" File date:  %s\n",dateTime.c_str());
         printf(" Data type:  %s\n",dType.c_str());
         printf("Model type:  %s\n",ModelType.c_str());
         printf(" Gain Step:  %d\n",GainStep);
     }
     void readPG(dbl2D &pg) {
    	 for (int i=0; i<NUMPIX; i++) {
    		 // Use vector objects dynamic fill to add values
    		 pixG.push_back(dslice());
    		 for (int j=0; j<5; ++j) {
    			 pixG[i].push_back(0.0);
    			 pixG[i][j] = pg[i][j];
    		 }
    	 }
     }
     void printPG() {
    	 printf("  filename:  %s\n",filename.c_str());
    	 printf(" pixel     Row A-1          Row A-2          Row B-1          Row B-2\n");
    	 for (int i=0; i<NUMPIX; i++) {
    		 printf("%3.3d     %10.10f     %10.10f     %10.10f     %10.10f\n",
    				 int(pixG[i][0]), pixG[i][1], pixG[i][2], pixG[i][3], pixG[i][4]);
    	 }
     }
     bool ifGS(int GS) {
    	 if (GS == GainStep) return true;
    	 return false;
     }
};

struct fitFileInfo {
	string fileName;
	string dateTime;
	double commandedMass;
	int fitPeriod;
	int L2Id;
	int timeTag;
	string type;
	string massType;
	string resType;
	void printData(string t) {
		printf("---- FileType %s Info -----\n",t.c_str());
		printf("  FileName:  %-31s\n",fileName.c_str());
        printf("      date:  %-18s\n",dateTime.c_str());
        printf(" fitPeriod:  %-4.4d\n",fitPeriod);
        printf("      L2Id:  %-4.4d\n",L2Id);
        printf("   timeTag:  %-12.12d\n",timeTag);
		printf("  FileType:  %-3s\n",type.c_str());
        printf("  massType:  %-1s\n",massType.c_str());
        printf("  resType:  %-1s\n",resType.c_str());
        printf("  commMass:  %-6.2f amu\n\n",commandedMass);
	}
	void init() {
		fitPeriod = 0;
		timeTag = 0;
		L2Id = -1;
		commandedMass = -1.0;
	}
};

struct x0FitInfo {
	double m, m0;
	double x;
	double pix0, pix0Unc;
	string file;
	void reset() {
		m = m0 = x = pix0 = pix0Unc = 0.0;
		file.clear();
	}
	void print() {
		printf("m0 = %f6.2\n",m0);
		printf("m = %f6.2\n",m);
		printf("x = %f6.2\n",x);
		printf("pix0 = %f6.2\n",pix0);
		printf("pix0Unc = %f6.2\n",pix0Unc);
		printf("file = %s\n\n",file.c_str());
	}
	void printM0() {
		printf("m0 = %f6.2\n",m0);
		printf("file = %s\n\n",file.c_str());
	}

	void printPix0() {
		printf("pix0 = %f6.2\n",pix0);
		printf("file = %s\n\n",file.c_str());
	}
};

struct spcInfo {
	string name;
	double kmass0;
	double kmass1;
	double kmass2;
	double kmass3;
	void reset() {
		name = "N/A";
		kmass0 = 0.0;
		kmass1 = 0.0;
		kmass2 = 0.0;
		kmass3 = 0.0;
	}
};

struct linFitParams {
	double aA, bA, aB, bB;
	double R2coeffA, R2coeffB;
};

struct polyInfo {
	double c[2][4];
	string fileName;
	void printData() {
		printf("FileName        :  %-31s\n",fileName.c_str());
		for (int i=0; i<2; i++) {
			if (i == 0) printf("----------- Row A -----------\n");
			if (i == 1) printf("----------- Row B -----------\n");
			for (int j=0; j<4; j++) printf("Poly coeff[%1.1d][%1.1d]:  %-9.4e\n", i,j,c[i][j]);
		}
	}
};

struct ppmInfo {
	int mode;
	double mass;
	double ppmDiff;
	double timeTag;
	string fileName;
	void printPPM() {
		printf("    mode:  %-4.4d\n", mode);
        printf(" timeTag:  %-13.6e\n",timeTag);
        printf("    mass:  %-6.2f\n",mass);
        printf(" ppmDiff:  %-8.2f\n",ppmDiff);
		printf("    File:  %-s\n",fileName.c_str());
	}
	void init() {
		mode = 0;
		timeTag = 0.0;
		ppmDiff = 0.0;
		mass = 0.0;
		fileName = "";
	}
};

struct altPkInfo {
	double peakLoc;
	double pkHght;
	double pkWd;
	double fracHght;
	bool abT;
	void printAltPk() {
		printf(" peakLoc:  %-3.3d\n", (int)peakLoc);
        printf("fracHght:  %-5.3f\n",fracHght);
	}
	void init() {
		peakLoc = 0;
		fracHght = 0.0;
		pkHght = 0.0;
		pkWd = 0.0;
		abT = false;
	}
};

struct excludeInfo {
	string sStart;
	string sEnd;
	string comment;
	double dStart;
	double dEnd;
	void print() {
		printf("    sStart:  %-s\n", sStart.c_str());
		printf("      sEnd:  %-s\n", sEnd.c_str());
		printf("    dStart:  %-f\n", dStart);
		printf("      dEnd:  %-f\n", dEnd);
		printf("   Comment:  %-s\n", comment.c_str());
	}
};

struct statsInfo {
    double min;
    double max;
    double avg;
    double median;
    double sigma;
    double sigOavg;
    void print() {
        printf("       Min:  %0.f\n", min);
        printf("       Max:  %0.f\n", max);
        printf("      Mean:  %0.f\n", avg);
        printf("    Median:  %0.f\n", median);
        printf("     Sigma:  %0.f\n", sigma);
    }
    void debug() {
        char tmp[100];
        sprintf(tmp,"       Min:  %0.f\n", min);
        toDebug << string(tmp);
        sprintf(tmp,"       Max:  %0.f\n", max);
        toDebug << string(tmp);
        sprintf(tmp,"      Mean:  %0.f\n", avg);
        toDebug << string(tmp);
        sprintf(tmp,"    Median:  %0.f\n", median);
        toDebug << string(tmp);
        sprintf(tmp,"     Sigma:  %0.f\n", sigma);
        toDebug << string(tmp);
        sigOavg = sigma/avg *100.0;
        sprintf(tmp,"     SigRatio:        %9.3f%s\n", sigOavg,"%");
        toDebug << string(tmp);
    }
};


#endif /* DFMS_STRUCTS_HH_ */
