/*
 * DFMS_readConstFile.cc
 *
 *  Created on: Oct 18, 2013
 *      Author: marinaldi
 *  
 *  The the DFMS Constants file
 */

#include "DFMS_readConstFile.hh"

/* ----------------------------------- Read DFMS Constants File  ---------------------------------------*/

int DFMS_readConstFile(string constantsFile) {

	string sFunctionName="DFMS_readConstFile";

	map<string,string> sConstInputs;
	map<string,int> iConstInputs;
	map<string,double> dConstInputs;
	map<string,bool> bCfgInputs;

	ifstream cfile;
	char input[200];
	string line, word, str;
	vector<string> tokens;
	bool isBool;

	// Open the DFMS Constants file for reading
	cfile.open((sInstallDir+constantsFile).c_str());
	if(!cfile.is_open()) {
		sErrorMessage="Error opening DFMS Constants File: "+constantsFile;
		writeToLog(sErrorMessage, sFunctionName, FATALERROR);
		return 0;
	}

	// Read in a line at a time
 	while (true) {
 		cfile.getline(input,200);
 		if (cfile.eof()) break;
		line.assign(input);
		word = line.substr(0,1);
		if (word != "#") {
			isBool = false;
			util_Tokenize(line, tokens);
			if ((tokens[1].compare("true") == 0) || (tokens[1].compare("false") == 0)) isBool=true;
			if (util_isInteger(tokens[1])) {
				iConstInputs[tokens[0]] = util_stringToInt(tokens[1]);
			} else if (util_isFloat(tokens[1])) {
	 			dConstInputs[tokens[0]] = atof(tokens[1].c_str());
			} else if (isBool) {
	 			bCfgInputs[tokens[0]] = util_stringToBool(util_trim(tokens[1]));
			} else {
	 			sConstInputs[tokens[0]] = tokens[1];
			}
			tokens.clear();
		} 
	}  
	cfile.close(); 

	// Assign the DFMS constants values to the proper internal variables
	PKLOWPT = iConstInputs["PKLOWPT"];
	PKHIGHPT = iConstInputs["PKHIGHPT"];
	MIN4GCUFIT = iConstInputs["MIN4GCUFIT"];
	MIN4SLFFIT = iConstInputs["MIN4SLFFIT"];
	COPSDELTA = iConstInputs["COPSDELTA"];
	NUMDAYSTOFITGCU = iConstInputs["NUMDAYSTOFITGCU"];
	NUMDAYSTOFITSLF = iConstInputs["NUMDAYSTOFITSLF"];
	NUMSDEV = iConstInputs["NUMSDEV"];
	GCUMASSDEL = dConstInputs["GCUMASSDEL"];
	NONGCUMASSDEL = dConstInputs["NONGCUMASSDEL"];
	GCULOWCUTOFF = dConstInputs["GCULOWCUTOFF"];
	GCUHICUTOFF = dConstInputs["GCUHICUTOFF"];
	SLFLOWCUTOFF = dConstInputs["SLFLOWCUTOFF"];
	SLFHICUTOFF = dConstInputs["SLFHICUTOFF"];
	PPMDIFFMIN = dConstInputs["PPMDIFFMIN"];
	ENOISET = dConstInputs["ENOISET"];
	STDCALDEV = dConstInputs["STDCALDEV"];
	MODAMP = dConstInputs["MODAMP"];
	Q = dConstInputs["Q"];
	CLEDA = dConstInputs["CLEDA"];
	CONVADC = dConstInputs["CONVADC"];
	CONV = dConstInputs["CONV"];
	DISP = dConstInputs["DISP"];
	PKHEIGHTLIMIT = dConstInputs["PKHEIGHTLIMIT"];
	HRMASSDELTA = dConstInputs["HRMASSDELTA"];
	HRPIX0UNC = dConstInputs["HRPIX0UNC"];
	LRPIX0UNC = dConstInputs["LRPIX0UNC"];
	CONVERTOUTBPEAK = bCfgInputs["CONVERTOUTBPEAK"];
	CONVERTLOWAMP = bCfgInputs["CONVERTLOWAMP"];
	CONVERTHIGHRES = bCfgInputs["CONVERTHIGHRES"];
    PIX0ROWDIFF = dConstInputs["PIX0ROWDIFF"];

	if (verbose >= 3) {

		// print String,string map
		map<string,string>::const_iterator st;

		if (sConstInputs.size() > 0) {
			for (st = sConstInputs.begin(); st != sConstInputs.end(); ++st) {
				cout << st->first << " = " << st->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - sConstInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}
	
		// print string,int map
		map<string,int>::const_iterator it;
	
		if (iConstInputs.size() > 0) {
			for (it = iConstInputs.begin(); it != iConstInputs.end(); ++it) {
				cout << it->first << " = " << it->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - iConstInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}
	
		// print string,double map
		map<string,double>::const_iterator dt;
	
		if (dConstInputs.size() > 0) {
			for (dt = dConstInputs.begin(); dt != dConstInputs.end(); ++dt) {
				cout << dt->first << " = " << dt->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - dConstInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}

		// print string,bool map
		map<string,bool>::const_iterator bt;

		if (bCfgInputs.size() > 0) {
			for (bt = bCfgInputs.begin(); bt != bCfgInputs.end(); ++bt) {
				cout << bt->first << " = " << bt->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - bCfgInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}

	}

	// write to process log and standard out
	sInfoMessage = "Completed reading DFMS Constants File. ";
	writeToLog(sInfoMessage, sFunctionName, INFO);
     
	// Release memory
	sConstInputs.clear();
	dConstInputs.clear();
	iConstInputs.clear();
	bCfgInputs.clear();

	return 1;

}
