/*
 * DFMS_readCfgFile.cc
 *
 *  Created on: Jan 15, 2013
 *      Author: marinaldi
 *  
 *  The the run Configuration file
 */

#include "DFMS_readCfgFile.hh"

/* ----------------------------------- Read Config File  ---------------------------------------*/

int DFMS_readCfgFile(string cfgFile)
{

	string sFunctionName="DFMS_readCfgFile";

	map<string,string> sCfgInputs;
	map<string,int> iCfgInputs;
	map<string,double> dCfgInputs;
	map<string,bool> bCfgInputs;

	ifstream cfile;
	char input[200];
	string line, word, str;
	vector<string> tokens;
	bool isBool;

	// Get install environment variable DFMS_INSTALL_DIR
	str = getenv("DFMS_INSTALL_DIR");
	if (str.length() != 0) {
		sInstallDir = str;
	} else {
		cout << "Environment variable DFMS_INSTALL_DIR is not set" << endl;
		cout << "This variable must be set and point to the directory" << endl;
		cout << "containing the src/ folder" << endl;
		exit(EXIT_FAILURE);
	}
	str.clear();
    if (sInstallDir.substr(sInstallDir.length()-1) != "/") sInstallDir += "/";

	// Open the input Config file for reading
	cfile.open((sInstallDir+cfgFile).c_str());
	if(!cfile.is_open()) {
		sErrorMessage="Error opening Config File: "+cfgFile;
		writeToLog(sErrorMessage, sFunctionName, FATALERROR);
		return 0;
	}

	// Read in a line at a time
 	while (true) {
 		cfile.getline(input,200);
 		if (cfile.eof()) break;
		line.assign(input);
		word = line.substr(0,1);
		if (word != "#") {
			isBool = false;
			util_Tokenize(line, tokens);
			if ((tokens[1].compare("true") == 0) || (tokens[1].compare("false") == 0)) isBool=true;
			if (util_isInteger(tokens[1])) {
				iCfgInputs[tokens[0]] = util_stringToInt(tokens[1]);
			} else if (util_isFloat(tokens[1])) {
	 			dCfgInputs[tokens[0]] = atof(tokens[1].c_str());
			} else if (isBool) {
				bCfgInputs[tokens[0]] = util_stringToBool(util_trim(tokens[1]));
			} else {
	 			sCfgInputs[tokens[0]] = tokens[1];
			}
			tokens.clear();
		} 
		line.clear();
		word.clear();
	}
	cfile.close(); 

    sLogPath = sCfgInputs["sLogPath"];
    if (sLogPath.substr(sLogPath.length()-1) != "/") sLogPath += "/";
    sLogPath = sInstallDir+sLogPath;

    sDiagPath = sCfgInputs["sDiagPath"];
    if (sDiagPath.substr(sDiagPath.length()-1) != "/") sDiagPath += "/";
    sDiagPath = sInstallDir+sDiagPath;

    sTimeSeriesPath = sCfgInputs["sTimeSeriesPath"];
    if (sTimeSeriesPath.substr(sTimeSeriesPath.length()-1) != "/") sTimeSeriesPath += "/";
    sTimeSeriesPath = sInstallDir+sTimeSeriesPath;

    sL3InfoLogPath = sCfgInputs["sL3InfoLogPath"];
    if (sL3InfoLogPath.substr(sL3InfoLogPath.length()-1) != "/") sL3InfoLogPath += "/";
    sL3InfoLogPath = sInstallDir+sL3InfoLogPath;

    sQLLogPath = sCfgInputs["sQLLogPath"];
    if (sQLLogPath.substr(sQLLogPath.length()-1) != "/") sQLLogPath += "/";
    sQLLogPath = sInstallDir+sQLLogPath;

    if (overRideInput == 0) {
    	sL2sourcePath = sCfgInputs["sL2sourcePath"];
    	if (sL2sourcePath.substr(sL2sourcePath.length()-1) != "/") sL2sourcePath += "/";
    	sL2sourcePath = sInstallDir+sL2sourcePath;
    } else {
    	if (sL2sourcePath.substr(sL2sourcePath.length()-1) != "/") sL2sourcePath += "/";
    	sL2sourcePath = sInstallDir+sL2sourcePath;
    }

    sGainTablePath = sCfgInputs["sGainTablePath"];
    if (sGainTablePath.substr(sGainTablePath.length()-1) != "/") sGainTablePath += "/";
    sGainTablePath = sInstallDir+sGainTablePath;

    sModeIDTablePath = sCfgInputs["sModeIDTablePath"];
    if (sModeIDTablePath.substr(sModeIDTablePath.length()-1) != "/") sModeIDTablePath += "/";
    sModeIDTablePath = sInstallDir+sModeIDTablePath;

    sMassPeakTablePath = sCfgInputs["sMassPeakTablePath"];
    if (sMassPeakTablePath.substr(sMassPeakTablePath.length()-1) != "/") sMassPeakTablePath += "/";
    sMassPeakTablePath = sInstallDir+sMassPeakTablePath;

    if (overRideOutput == 0) {
    	sL3outputPath = sCfgInputs["sL3outputPath"];
    	if (sL3outputPath.substr(sL3outputPath.length()-1) != "/") sL3outputPath += "/";
    	sL3outputPath = sInstallDir+sL3outputPath;
    } else {
    	if (sL3outputPath.substr(sL3outputPath.length()-1) != "/") sL3outputPath += "/";
    	sL3outputPath = sInstallDir+sL3outputPath;
    }

	sCOPSdataPath = sCfgInputs["sCOPSdataPath"];
	if (sCOPSdataPath.substr(sCOPSdataPath.length()-1) != "/") sCOPSdataPath += "/";
	sCOPSdataPath = sInstallDir+sCOPSdataPath;

	sPlotFilePath = sCfgInputs["sPlotFilePath"];
	if (sPlotFilePath.substr(sPlotFilePath.length()-1) != "/") sPlotFilePath += "/";
	sPlotFilePath = sInstallDir+sPlotFilePath;
     
	sx0FitsDataPath = sCfgInputs["sx0FitsDataPath"];
	if (sx0FitsDataPath.substr(sx0FitsDataPath.length()-1) != "/") sx0FitsDataPath += "/";
	sx0FitsDataPath = sInstallDir+sx0FitsDataPath;

    sPix0DFilePath = sCfgInputs["sPix0DFilePath"];
    if (sPix0DFilePath.substr(sPix0DFilePath.length()-1) != "/") sPix0DFilePath += "/";
    sPix0DFilePath = sInstallDir+sPix0DFilePath;
    
    // GNU plot path is NOT relative to sInstallDir
	sGNUplotPath = sCfgInputs["sGNUplotPath"];
	if (sGNUplotPath.substr(sGNUplotPath.length()-1) != "/") sGNUplotPath += "/";
    
	sInstrumentModel = sCfgInputs["sInstrumentModel"];
	sGainTableBaseName = sCfgInputs["sGainTableBaseName"];
	sPixelGainTableBaseName = sCfgInputs["sPixelGainTableBaseName"];
	NUMPG = iCfgInputs["NUMPG"];
	DIAGTOFILE = iCfgInputs["DIAGTOFILE"];
	L3INFOTOFILE = iCfgInputs["L3INFOTOFILE"];
	QLINFOFILE = iCfgInputs["QLINFOFILE"];
    PIX0DELTOFILE = iCfgInputs["PIX0DELTOFILE"];
    TIMESERIESOUT = iCfgInputs["TIMESERIESOUT"];
    L3SET_MASS_PRECISION = iCfgInputs["L3SET_MASS_PRECISION"];
	BADDATA = dCfgInputs["BADDATA"];
	DOCEM = bCfgInputs["DOCEM"];
    
    // Peak Exclusion file names
    sPeakExclusionFile1 = sCfgInputs["sPeakExclusionFile1"];
    sPeakExclusionFile2 = sCfgInputs["sPeakExclusionFile2"];

	if (verbose >= 3) {

		// print String,string map
		map<string,string>::const_iterator st;

		if (sCfgInputs.size() > 0) {
			for (st = sCfgInputs.begin(); st != sCfgInputs.end(); ++st) {
				cout << st->first << " = " << st->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - sCfgInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}
	
		// print string,int map
		map<string,int>::const_iterator it;
	
		if (iCfgInputs.size() > 0) {
			for (it = iCfgInputs.begin(); it != iCfgInputs.end(); ++it) {
				cout << it->first << " = " << it->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - iCfgInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}
	
		// print string,double map
		map<string,double>::const_iterator dt;
	
		if (dCfgInputs.size() > 0) {
			for (dt = dCfgInputs.begin(); dt != dCfgInputs.end(); ++dt) {
				cout << dt->first << " = " << dt->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - dCfgInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}

		// print string,bool map
		map<string,bool>::const_iterator bt;

		if (bCfgInputs.size() > 0) {
			for (bt = bCfgInputs.begin(); bt != bCfgInputs.end(); ++bt) {
				cout << bt->first << " = " << bt->second << endl;
			}
		} else {
			sErrorMessage = "Cannot print - bCfgInputs contains no values. ";
			writeToLog(sErrorMessage, sFunctionName, WARN);
		}

	}

	// write to process log and standard out
	sInfoMessage = "Completed reading Configuration File. ";
	writeToLog(sInfoMessage, sFunctionName, INFO);
     
	// Release memory
	sCfgInputs.clear();
	dCfgInputs.clear();
	bCfgInputs.clear();
	iCfgInputs.clear();

	return 1;

}
