/*
 * DFMS_process_CLA.cc
 *
 *  Created on: Jan 15, 2013
 *      Author: marinaldi
 *  
 *  Process all Command Line Arguments
 */

#include "DFMS_process_CLA.hh"

/* -------------------------------------- Do Command line stuff ------------------*/

int DFMS_process_CLA(int argc, char* argv[]) {

	string sFunctionName="DFMS_process_CLA";
	int c;
	char usage[2000], utmp[200];
	string L2DirName=sL2sourcePath;
    string File;

	sprintf(usage,"%s","\n\n"  );
	sprintf(utmp,"%s","     [-C <Input Configuration file name>,    default = \"ConfigFile.dat\"] \n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-c <Input Constants file name>,        default = \"DFMS_Constants.dat\"] \n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-d <debug mode >,                      default = 0 No debug ] \n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-f <process specific file >,           default = process all files ] \n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-h <Help> - Dump this help screen ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-i <Input> - Define the input directory ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-l <Suppress processing new GCU/SLF files>]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-m <process specific modes >,          default = process all modes ] \n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			          	       <value  =  220 - mode number to process > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-o <Output> - Define the output directory ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-O - Run code to simply dump a file with numbered L2 processing order]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-p <Create an L2/L3 plot file> ,       default = 0 no file created ] \n");
	strcat(usage,utmp);
    sprintf(utmp,"%s","     [			          	       <value  =  1 - Plot L2 Raw Data > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			           	       <value  =  2 - Plot L2 Raw Data and Fit > ]\n");
	strcat(usage,utmp);
    sprintf(utmp,"%s","     [			          	       <value  =  3 - Create L2 Raw Data Postscript File > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			           	       <value  =  4 - Create L2 Raw Data and Fit Postscript File > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-r <verbose levels (0,1,2)>,           default = 0 minimal output]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			          	       <value  =  1 - default plus > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			           	       <value  =  2 - value=1 plus > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			           	       <value  =  3 - value=2 plus > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			           	       <value  =  10 - dump preFit peak Found info > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [			           	       <value  =  100 - dump All debug diagnostics > ]\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-v <Version Number> ]\n\n");
	strcat(usage,utmp);
	sprintf(utmp,"%s","     [-x <Use External pix0 for Calib.>,     default = Do not use ] \n");
	strcat(usage,utmp);

	cout << endl;

	while ((c = getopt (argc, argv, "C:c:df:hi:lm:p:Oo:r:vx:")) != -1)
		switch (c) {
			case 'C':
				cfgFile = string(optarg);
				if (!util_fileExists(cfgFile)) {
					printf("\n The file: %s does not exit\n",cfgFile.c_str());
					exit(EXIT_FAILURE);
                }
				break;
			case 'c':
				constantsFile = string(optarg);
				if (!util_fileExists(constantsFile)) {
					printf("\n The file: %s does not exit\n",constantsFile.c_str());
					exit(EXIT_FAILURE);
                }
				break;
			case 'd':
				debug = 1;
				break;
			case 'f':
				doOneFile = 1;
				dfmsFileName = string(optarg);
				processNewGCUSLFfiles = 0;  // Also suppress First Loop, processing new GCU/SLF files
				break;
			case 'h':
				printf("\n usage: %s [CcdfhilmpOorvx] %s\n", argv[0], usage);
				exit(EXIT_SUCCESS);
				break;
			case 'i':
				overRideInput = 1;
				sL2sourcePath = string(optarg);
				break;
			case 'l':
				processNewGCUSLFfiles = 0;
				break;
			case 'm':
				intMode = atoi(optarg);
				break;
			case 'p':
				iPltFile = atoi(optarg);
				printf("Gnuplot is not supported in this version\n\n");
                exit(EXIT_FAILURE);
				break;
			case 'o':
				overRideOutput = 1;
				sL3outputPath = string(optarg);
				break;
			case 'O':
				dumpL2Order = 1;
				break;
			case 'r':
				verbose = atoi(optarg);
				break;
			case 'v':
				printf("%s version: %s\n", sCurrentSoftwareName.c_str(), sCurrentSoftwareVersionID.c_str());
				printf("written by: M.A. Rinaldi\n");
				printf("e-mail: marinaldi@comcast.net\n\n");
				exit(EXIT_SUCCESS);
				break;
			case 'x':
				useExternalPix0 = 1;
				ePix0A = atof(optarg);
				ePix0B = ePix0A;
				printf("This option is not implemented in this version\n");
				exit(EXIT_FAILURE);
				break;
			case '?':
				if (optopt == 'C' || optopt == 'c' || optopt == 'f' || optopt == 'm' || optopt == 'p' ||
					optopt == 'r' || optopt == 'x') {
					fprintf (stderr, "DFMS_process_CLA: Error, Option -%c requires an argument.\n", optopt);
					exit(EXIT_FAILURE);
				} else if (isprint (optopt)) {
					fprintf (stderr, "DFMS_process_CLA: Error, Unknown option `-%c'.\n", optopt);
					exit(EXIT_FAILURE);
				} else {
					fprintf (stderr, "DFMS_process_CLA: Error, Unknown option character `\\x%x'.\n",optopt);
					return 1;
	  		    }
			    break;
		    default:
			abort ();
		}

	return 0;

}

