

// define project global variables

#ifndef DFMS_GLOBALS_H_
#define DFMS_GLOBALS_H_


#include <cstdio>
#include <cstdlib>
#include <cctype>
#include <ctime>
#include <cfloat>
#include <cmath>
#include <cstring>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdint.h>
#include <errno.h>
#include <unistd.h>
#include <stdarg.h>
#include <assert.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <algorithm> 
#include <map>
#include <vector>
#include <set>


#include "DFMS_L3Info_Class.hh"
#include "DFMS_definedConstants.hh"

using namespace std;

enum { FATALERROR, ERROR, WARN, INFO };

//  Software name and version ID globals
extern string sCurrentSoftwareName;
extern string sCurrentSoftwareVersionID;

// Level 3 Info Class object
extern DFMS_L3Info_Class *L3Info;

// Dynamic Vector arrays
typedef map<string,string> mapstr;
typedef vector<int> islice;
typedef vector<islice> int2D;
typedef vector<string> sslice;
typedef vector<sslice> str2D;
typedef vector<double> dslice;
typedef vector<dslice> dbl2D;

extern string sInstallDir;
extern string sTimeSeriesPath;

extern int debug;
extern int verbose;

// Next 4 vars mainly used for debugging
extern double pgout[512][5][5];
extern double pgTime[5];
extern string pgFname[5];
extern int whichGS;

extern string sL3InfoLogPath;
extern fstream l3Log;
extern fstream QuickLookLog;
extern fstream pix0D;
extern int intMode;

extern string sPeakExclusionFile1;
extern string sPeakExclusionFile2;
extern string sPeakExclFile1Date;
extern string sPeakExclFile2Date;

extern map<int,vector<pair<int,int> > > peaksToExclude1;
extern map<int,vector<pair<int,int> > > peaksToExclude2;

// The GCU/SLF file maps
extern mapstr gcuLmLrFile;
extern mapstr gcuHmLrFile;
extern mapstr gcuLmHrFile;
extern mapstr gcuMmHrFile;
extern mapstr gcuHmHrFile;
extern mapstr slfLmLrFile;
extern mapstr slfHmLrFile;
extern mapstr slfLmHrFile;
extern mapstr slfMmHrFile;
extern mapstr slfHmHrFile;

// Global constants set in Config/DFMS_FM_Constants Files
extern int NUMDAYSTOFITGCU;
extern int NUMDAYSTOFITSLF;
extern int DIAGTOFILE;
extern int L3INFOTOFILE;
extern int QLINFOFILE;
extern int PIX0DELTOFILE;
extern int TIMESERIESOUT;
extern int NUMPG;
extern bool CONVERTOUTBPEAK;
extern bool CONVERTLOWAMP;
extern bool CONVERTHIGHRES;
extern int PKLOWPT;
extern int PKHIGHPT;
extern int MIN4GCUFIT;
extern int MIN4SLFFIT;
extern int NUMSDEV;
extern int COPSDELTA;
extern double ENOISET;
extern double STDCALDEV;
extern double MODAMP;
extern double PKHEIGHTLIMIT;
extern double GCUMASSDEL;
extern double NONGCUMASSDEL;
extern double GCULOWCUTOFF;
extern double GCUHICUTOFF;
extern double SLFLOWCUTOFF;
extern double SLFHICUTOFF;
extern double PPMDIFFMIN;
extern double Q;
extern double CLEDA;
extern double CONVADC;
extern double DISP;
extern double CONV;
extern double BADDATA;
extern double HRMASSDELTA;
extern double HRPIX0UNC;
extern double LRPIX0UNC;
extern double PIX0ROWDIFF;

// CLA flags
extern int overRideInput;
extern int overRideOutput;
extern int dumpL2Order;

// Non-linear fitting flags
extern bool infNanErr;
extern bool stepFuncA;
extern bool stepFuncB;

// Variables related to user supplied external pix0
extern int useExternalPix0;
extern double ePix0A;
extern double ePix0B;

extern string sRow[2];

extern string sErrorMessage;
extern string sInfoMessage;
extern fstream toLog;
extern fstream toDebug;

// Global best file names
extern string sBestPGTtime;
extern string sBestMPST;
extern string sBestNGCOPS;
extern string sBestRGCOPS;
extern string sBestBGCOPS;

// Various map/flags counting reasons files were skipped
// or exceptions raised
extern map<string,int> skipReas;
extern map<string,int> sideAexceptionType;
extern map<string,int> sideBexceptionType;
extern map<string,int> exceptionType;
extern map<string,int> pix0Spread;
extern map<int,int> modesPresent;
extern map<double,int> thisRunCommMassFitSuccess;
extern map<double,int> thisRunCommMassFitFailed;
extern int totFilesSkipped;
extern int numVerificPeaksFound;
extern int numVerificPeaksUsed;

// Verification masses to look for in constructing nonGCU m0 vs pix0 fit files
extern set<double> slfSet;

// Special mass array
extern int spMasses[NUMSPECIALMASSES];

// MCP Detector Emission value in Amps
extern double emission;

// peak vs ppmdiff stats
extern pair<double,double> pkPPMpair;
extern vector<pair<double,double> > pkPPMvec;

// distinct modes
extern map<int,bool> distinctModes;

// Max and min time (secs) in a series of L2 files
extern double L2TimeMax;
extern double L2TimeMin;

// Various File existence flags
extern bool isRecentGCUavailable;
extern bool isNewPDS;

// Number of files with a given Gain Step value
// used for PG interpolation
extern int multiGS[16];

// End of Line variable
extern char EOL[];
extern string dfmsEOL;

// Do CEM files only
extern bool DOCEM;

// Set L3 Mass precision (1 = 4 digits after comma, 0 = 2 digits after comma
extern int L3SET_MASS_PRECISION;

extern int iicnt;

#endif   //DFMS_GLOBALS_H_
