
#ifndef DFMS_PROCESSMCP_CLASS_H_
#define DFMS_PROCESSMCP_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_L2_file_Class.hh"
#include "DFMS_PDS_L3_file_Class.hh"
#include "DFMS_MPST_Class.hh"
#include "DFMS_COPS_Class.hh"
#include "DFMS_PeakFit_Class.hh"
#include "DFMS_definedConstants.hh"
#include "DFMS_Gain_Table_Class.hh"
#include "DFMS_PixelGain_Table_Class.hh"
#include "DFMS_LinFit_Class.hh"
#include "DFMS_X0FitFile_Class.hh"
#include "DFMS_FindAllPeaks_Class.hh"
#include "DFMS_Histogram_Class.hh"
#include "DFMS_PolyFit_Class.hh"

extern int iPltFile;
extern string sPlotFilePath;
extern string sGNUplotPath;
extern string sDiagPath;
extern int NUMPG;
extern double ENOISET;
extern int qlCount;
extern string sBestFitFile;
extern map<int,polyInfo> pC;
extern vector<ppmInfo> ppmSLFLmLrA, ppmSLFMmLrA, ppmSLFHmLrA, ppmSLFLmLrB, ppmSLFMmLrB, ppmSLFHmLrB;
extern vector<ppmInfo> ppmSLFLmHrA, ppmSLFMmHrA, ppmSLFHmHrA, ppmSLFLmHrB, ppmSLFMmHrB, ppmSLFHmHrB;
extern map<double,spcInfo> speciesDef;

class DFMS_ProcessMCP_Class {

	public:
		string sCOPSpath;
		string sMPSTpath;
		string sL3Path;
		string L3File;
		string fitFilePath;
		double gainA, gainB;
		double zoom;

		int iXl,iXr;

		int l3PkMaxIdA, l3PkMaxIdB;

		double aGCUA, bGCUA, r2GCUA;
		double aGCUB, bGCUB, r2GCUB;
		double aSLFA, bSLFA, r2SLFA;
		double aSLFB, bSLFB, r2SLFB;

		double pix0UncA, pix0UncB;

		double* fMassScaleA;
		double* fMassScaleB;

		double avgPgA;
		double avgPgB;

		prePkFitInfo pkFI;
		map<double,altPkInfo> pkMap;

		bool noSLFFitFile;

		int numGoodPks;
		int numGoodPksA;
		int numGoodPksB;
		bool foundVerifPeak;

		double meanOffset;
		double meanOffsetStdDev;
    
        // Create Data arrays that will hold background/offset data ready for poly fit
        double *xPolyA, *xPolyB;
        double *yPolyA, *yPolyB;
        int numGdAPixels;
        int numGdBPixels;
    
        double c0Offset, c0OffsetA, c0OffsetB;
		double gainCorrIonConv;
		double meanOffsetA, meanOffsetB;
		double peakAreaA, peakAreaB;

		double currConvConstant;
		double threshold;
          
		L2FileInfo L2Info;
		DFMS_PDS_L2_file_Class *L2Obj;
          
		DFMS_COPS_Class *COPSobjIn;
		DFMS_MPST_Class *MPSTobjIn;

		dbl2D pixG;
		double* Xin;
		double* YAin;
		double* YBin;
		double* yAFit;
		double* yBFit;
		str2D calData;
		dbl2D L3Data;
		str2D L3HKdata;
		str2D MPSTdata;
		int mptIndx;
        int mptRows;
        string commandedMass;
        string massType, resType;
        peakInfo *PeakF;

        vector<fitFileInfo> fitInfo;
        string gcuPix0FitFileName;
        string slfPix0FitFileName;


        DFMS_LinFit_Class *linFitA, *linFitB;
        double* offSetFitA;
        double* offSetFitB;

    	string calID4A,calID4B; // CalID's used for a specific DFMS Row of data
    	string calID5A,calID5B; // CalID's used for a specific DFMS Row of data
    	string calID6A,calID6B; // CalID's used for a specific DFMS Row of data

    	bool gPFsuccessA;   // True if gaussian fit to peak in Row A succeeded, False otherwise
    	bool gPFsuccessB;   // True if gaussian fit to peak in Row B succeeded, False otherwise

	public:
		DFMS_ProcessMCP_Class (string, string, string, string,
                                   string, double, double, dbl2D&, DFMS_PDS_L2_file_Class *);
		~DFMS_ProcessMCP_Class();

		void addCOPSinfo(string, string, string);
		void addPolyOffCoeffInfo(int, int *);
		void applyGainCorrection(int);
		int applyOffsetSubtraction(int);
		void assignDefaultFitParams(int, DFMS_PeakFit_Class *);
        int assignFitParams(DFMS_PeakFit_Class *, int);
		int calcOffset(int);
		double calcPixUnc(double, double, double, double);
		double calcPPMDiff(double, double);
		double yieldCorr();
		int calibGCU(DFMS_PeakFit_Class *, DFMS_X0FitFile_Class *, string, int);
		int calibSLF(DFMS_PeakFit_Class *, DFMS_X0FitFile_Class *, DFMS_X0FitFile_Class *, string, int);
		int calibNonGCUnonSLF(DFMS_PeakFit_Class *, DFMS_X0FitFile_Class *, DFMS_X0FitFile_Class *, string, int);
		void createL3MassScale();
		int createNewMPSTfile(string);
		int findAltPeak(double *, double *, bool *);
		double findAvgPixelGain(int);
		int findBestCOPSfile(string, string &, string &);
		int findBestMPSTfile(string, int, string &);
		void findIonRate(int);
		int findMPSTpeak(double, verifPeakInfo *, double);
		int findOffsetPixels(int);
		int formCalData();
		void formL3HKdata();
		int getCOPSfilesInDir(string);
		int getMPSTdata(string, verifPeakInfo *);
		int getMPSTfilesInDir();
		void getL2HKdata(str2D &);
		void setCalID(int,string,string,string);
		void setPrecision(bool,string &);
		vector<double> spMassInRange();
		void makeAvgVals();

		double peakCenterMass(L2FileInfo &, double, double, double);
		int processL2(L2FileInfo &, DFMSModeInfo &);
		int prepOffsetDataLR(int iRow);
        int prepOffsetDataHR(int iRow);
		int quickPlotDataAndFit(int, string, string, string, string);
		int quickPlotL2Data(int, string, string, string);
		void rowBModCorr(int);
		void setNonGCUNonSLFL3Info(int, double, double, double, double, double,
								double, double, int, double, double);
		void setSLFL3Info(int, double, double, double, double, double,
								double, double, verifPeakInfo *, int, double, double);
		double setPPMDiff(int, int *);
		int writeL2L3DataFit(int, string, string, string);
		int writeTimeSeriesFile(string, DFMSModeInfo &);

};

#endif  //DFMS_PROCESSMCP_CLASS_H_
