/*
 * DFMSprocessCEM.cc
 *
 *  Created on: Apr 25, 2016
 *      Author: Mike Rinaldi
 */

#include "DFMS_ProcessCEM_Class.hh"

//
// ---------------------------- Constructor ------------------------------------
//
DFMS_ProcessCEM_Class::DFMS_ProcessCEM_Class(string p3, string f3, string c,
										DFMS_PDS_L2_file_Class *L2) {

	string sFunctionName = "DFMS_ProcessCEM_Class::DFMS_ProcessCEM_Class";

	// Create local L2 file Object
	L2Obj = L2;
	mass = NULL;

	// CEM L2 Data items
	L2fileName = L2Obj->getFileName();
	L2fileDate = L2Obj->getFileDate();

	// CEM L3 Data items
	L3path = p3;
	L3fileName = f3;
	L3File = L3path+L3fileName;
	L3fileDate = L2Obj->getFileDate();
	L3HKrows = 40;
	L3DataRows = L2Obj->getDataRows();

	// COPS Data Items
	COPSobjIn = NULL;
	copsPressRG = 0.0;
	copsPressNG = 0.0;
	copsPressBG = 0.0;
	sCOPSpath = c;

	commMass = 0.0;
	step0 = 0.0;
	resPS = 0.0;
}

//
// ---------------------------- Destructor -------------------------------------
//
DFMS_ProcessCEM_Class::~DFMS_ProcessCEM_Class() {
	// TODO Auto-generated destructor stub

	delete mass; mass = 0;

	L3HKobj.clear();
	L3DataObj.clear();
	L3HKdata.clear();
	L3Data.clear();

	L2HKdata.clear();

}

//
// -------------------------- initializeData -----------------------------------
//
void DFMS_ProcessCEM_Class::initializeData() {

	string sFunctionName = "DFMS_ProcessCEM_Class::intializeData";

	int hkItems = 4;
	// Allocate memory and copy data arrays
	//L2Obj->printL2File("L2HKdata");
	for(int i=0; i<L3HKrows; ++i) {
		L3HKdata.push_back(sslice());
		for (int j=0; j<hkItems; ++j) {
			L3HKdata[i].push_back(L2Obj->HKdata[i][j]);
		}
	}

	int l3Items = 2;
	// Allocate memory and copy data arrays
	for(int i=0; i<L3DataRows; ++i) {
		L3Data.push_back(dslice());
		for (int j=0; j<l3Items; ++j) {
			L3Data[i].push_back(0.0);
			//cout << "L2Data["<<i<<"]["<<j<<"]="<<L2Data[i][j] << endl;
		}
	}
}

//
// ----------------------------- formHKobj -------------------------------------
//
int DFMS_ProcessCEM_Class::formHKobj() {

	// Modify the L2 HK Desc Object (L3 has fewer rows)
	L3HKobj["OBJECT"]             = "DFMS_HK_TABLE";
	L3HKobj["NAME"]               = "DFMS_HOUSEKEEPING_TABLE";
	L3HKobj["INTERCHANGE_FORMAT"] = "ASCII";
	L3HKobj["ROWS"]               = util_intToString(L3HKrows);
	L3HKobj["COLUMNS"]            = "5";
	L3HKobj["ROW_BYTES"]          = "80";
	L3HKobj["^STRUCTURE"]         = "\"DFMS_L3_HK.FMT\"";
	L3HKobj["END_OBJECT"]         = "DFMS_HK_TABLE";

	return 1;
}

//
// ----------------------------- formL3DataObj -------------------------------------
//
int DFMS_ProcessCEM_Class::formL3DataObj() {

	L3DataObj["OBJECT"]             = "CEM_DATA_L3_TABLE";
	L3DataObj["NAME"]               = "CEM_DATA_L3_TABLE";
	L3DataObj["INTERCHANGE_FORMAT"] = "ASCII";
	L3DataObj["ROWS"]               = util_intToString(L3DataRows);
	L3DataObj["COLUMNS"]            = "4";
	L3DataObj["ROW_BYTES"]          = "80";
	L3DataObj["^STRUCTURE"]         = "\"DFMS_L3_DATA2.FMT\"";
	L3DataObj["END_OBJECT"]         = "CEM_DATA_L3_TABLE";

	return 1;

}

//
// ------------------------------ writeOldPDSheader ------------------------------------
//
int DFMS_ProcessCEM_Class::writeOldPDSheader(fstream &os) {

	string sFunctionName = "DFMS_ProcessCEM_Class::writeOldPDSheader";

    char tmp[810];
    string stmp;
    string ctmp="None";
	int lblRec = 91;
	int L3recs = L3DataRows;
	int lastLineNum = lblRec+L3HKrows+L3recs;

	// Start forming and writing the PDS Header.
	// Old L2 values that are to be directly transfered to L3 header contain a
	// reference to PDSheader["xxxxx"].
	// New L3 values are created from L3 relevant data
	// Note: the variable PDSheader["xxxxx"] contains unmodified L2 data.

    stmp = "PDS_VERSION_ID                   =     ";
		L2Obj->PDSheader["PDS_VERSION_ID"] = util_trimEOL(L2Obj->PDSheader["PDS_VERSION_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PDS_VERSION_ID"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "LABEL_REVISION_NOTE              =     \"2015-01-01,Thierry Semon(UoB),";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "                                        Version1.0 release\"";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "SOFTWARE_NAME                    =     ";
       string ttmp = "\""+sCurrentSoftwareName+"\"";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),ttmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "SOFTWARE_VERSION_ID              =     ";
       ttmp = "\""+sCurrentSoftwareVersionID+"\"";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),ttmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_PIXEL0_A_MASS     =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_doubleToString(commMass)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_PIXEL0_B_MASS     =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_doubleToString(commMass)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "SOURCE_FILE_NAME                 =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(L2fileName.substr(0,27)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_CAL_ID4           =     ";
    	ctmp = "None";
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),ctmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_CAL_ID5           =     ";
		ctmp = "None";
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),ctmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_CAL_ID6           =     ";
		ctmp = "None";
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),ctmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "RECORD_TYPE                      =     ";
    L2Obj->PDSheader["RECORD_TYPE"] = util_trimEOL(L2Obj->PDSheader["RECORD_TYPE"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["RECORD_TYPE"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "RECORD_BYTES                     =     ";
    L2Obj->PDSheader["RECORD_BYTES"] = util_trimEOL(L2Obj->PDSheader["RECORD_BYTES"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["RECORD_BYTES"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "FILE_RECORDS                     =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lastLineNum)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "LABEL_RECORDS                    =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "^DFMS_HK_TABLE                   =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec+1)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "^DFMS_MASS_CAL_TABLE             =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec+L3HKrows+1)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "^MCP_DATA_L3_TABLE               =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec+L3HKrows+1)).c_str());
       os << string(tmp) << dfmsEOL;

    string newDName = L2Obj->PDSheader["DATA_SET_ID"];
    replace(newDName,"-2-","-3-");
    stmp = "DATA_SET_ID                      =     ";
    	newDName = util_trimEOL(newDName);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),newDName.c_str());
		os << string(tmp) << dfmsEOL;

    newDName = L2Obj->PDSheader["DATA_SET_NAME"];
    replace(newDName,"2","3");
    stmp = "DATA_SET_NAME                    =     ";
    	newDName = util_trimEOL(newDName);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),newDName.c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "PRODUCT_ID                       =     ";
       string name = L3fileName.substr(0,26);
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),name.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "PRODUCT_CREATION_TIME            =     ";
       string tTime = getProcessTime(1);
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),tTime.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "PRODUCT_TYPE                     =     RDR";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "PROCESSING_LEVEL_ID              =   \"3\"";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "MISSION_ID                       =     ";
    	L2Obj->PDSheader["MISSION_ID"] = util_trimEOL(L2Obj->PDSheader["MISSION_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["MISSION_ID"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "MISSION_NAME                     =     ";
    	L2Obj->PDSheader["MISSION_NAME"] = util_trimEOL(L2Obj->PDSheader["MISSION_NAME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["MISSION_NAME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "TARGET_NAME                      =     ";
    	L2Obj->PDSheader["TARGET_NAME"] = util_trimEOL(L2Obj->PDSheader["TARGET_NAME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["TARGET_NAME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "TARGET_TYPE                      =     ";
    	L2Obj->PDSheader["TARGET_TYPE"] = util_trimEOL(L2Obj->PDSheader["TARGET_TYPE"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["TARGET_TYPE"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "MISSION_PHASE_NAME               =     ";
    	L2Obj->PDSheader["MISSION_PHASE_NAME"] = util_trimEOL(L2Obj->PDSheader["MISSION_PHASE_NAME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["MISSION_PHASE_NAME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_HOST_NAME             =     ";
    	L2Obj->PDSheader["INSTRUMENT_HOST_NAME"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_HOST_NAME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_HOST_NAME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_HOST_ID               =     ";
    	L2Obj->PDSheader["INSTRUMENT_HOST_ID"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_HOST_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_HOST_ID"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_NAME                  =     ";
    	L2Obj->PDSheader["INSTRUMENT_NAME"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_NAME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_NAME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_ID                    =     ";
    	L2Obj->PDSheader["INSTRUMENT_ID"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_ID"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_MODE_ID               =     ";
    	L2Obj->PDSheader["INSTRUMENT_MODE_ID"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_MODE_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_MODE_ID"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "^INSTRUMENT_MODE_DESC            =     ";
    	L2Obj->PDSheader["^INSTRUMENT_MODE_DESC"] = util_trimEOL(L2Obj->PDSheader["^INSTRUMENT_MODE_DESC"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["^INSTRUMENT_MODE_DESC"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_TYPE                  =     ";
    	L2Obj->PDSheader["INSTRUMENT_TYPE"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_TYPE"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_TYPE"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "DETECTOR_ID                      =     ";
    	L2Obj->PDSheader["DETECTOR_ID"] = util_trimEOL(L2Obj->PDSheader["DETECTOR_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["DETECTOR_ID"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "DETECTOR_DESC                    =     ";
    	L2Obj->PDSheader["DETECTOR_DESC"] = util_trimEOL(L2Obj->PDSheader["DETECTOR_DESC"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["DETECTOR_DESC"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "CHANNEL_ID                       =     ";
    	L2Obj->PDSheader["CHANNEL_ID"] = util_trimEOL(L2Obj->PDSheader["CHANNEL_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["CHANNEL_ID"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "START_TIME                       =     ";
    	L2Obj->PDSheader["START_TIME"] = util_trimEOL(L2Obj->PDSheader["START_TIME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["START_TIME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "STOP_TIME                        =     ";
    	L2Obj->PDSheader["STOP_TIME"] = util_trimEOL(L2Obj->PDSheader["STOP_TIME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["STOP_TIME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "SPACECRAFT_CLOCK_START_COUNT     =     ";
    	L2Obj->PDSheader["SPACECRAFT_CLOCK_START_COUNT"] = util_trimEOL(L2Obj->PDSheader["SPACECRAFT_CLOCK_START_COUNT"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SPACECRAFT_CLOCK_START_COUNT"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "SPACECRAFT_CLOCK_STOP_COUNT      =     ";
		L2Obj->PDSheader["SPACECRAFT_CLOCK_STOP_COUNT"] = util_trimEOL(L2Obj->PDSheader["SPACECRAFT_CLOCK_STOP_COUNT"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SPACECRAFT_CLOCK_STOP_COUNT"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "PRODUCER_ID                      =     ";
    	L2Obj->PDSheader["PRODUCER_ID"] = util_trimEOL(L2Obj->PDSheader["PRODUCER_ID"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PRODUCER_ID"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "PRODUCER_FULL_NAME               =     ";
    	L2Obj->PDSheader["PRODUCER_FULL_NAME"] = util_trimEOL(L2Obj->PDSheader["PRODUCER_FULL_NAME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PRODUCER_FULL_NAME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "PRODUCER_INSTITUTION_NAME        =     ";
    	L2Obj->PDSheader["PRODUCER_INSTITUTION_NAME"] = util_trimEOL(L2Obj->PDSheader["PRODUCER_INSTITUTION_NAME"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PRODUCER_INSTITUTION_NAME"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "DATA_QUALITY_ID                  =     ";
       string qid = "\""+util_intToString(4)+"\"";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),qid.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "DATA_QUALITY_DESC                =     \"";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      0 means 'Nominal quality, avg. PPM deviance < 500\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      1 means 'Self-calibrated, GCU avg. PPM deviance >= 500, SELF < 500\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      2 means 'Adopted mass scale avg. PPM deviance >= 500\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      3 means 'Enhanced Noise\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      4 means 'Not enough peaks found for accurate calibration/verification\'";
    	sprintf(tmp,"%-78s",stmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "SC_SUN_POSITION_VECTOR           =     ";
    	L2Obj->PDSheader["SC_SUN_POSITION_VECTOR"] = util_trimEOL(L2Obj->PDSheader["SC_SUN_POSITION_VECTOR"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SC_SUN_POSITION_VECTOR"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SC_TARGET_POSITION_VECTOR        =     ";
    	L2Obj->PDSheader["SC_TARGET_POSITION_VECTOR"] = util_trimEOL(L2Obj->PDSheader["SC_TARGET_POSITION_VECTOR"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SC_TARGET_POSITION_VECTOR"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "COORDINATE_SYSTEM_ID             =     ";
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["COORDINATE_SYSTEM_ID"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "COORDINATE_SYSTEM_NAME           =     ";
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["COORDINATE_SYSTEM_NAME"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SC_TARGET_VELOCITY_VECTOR        =     ";
    	L2Obj->PDSheader["SC_TARGET_VELOCITY_VECTOR"] = util_trimEOL(L2Obj->PDSheader["SC_TARGET_VELOCITY_VECTOR"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SC_TARGET_VELOCITY_VECTOR"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SPACECRAFT_ALTITUDE              =     ";
    	L2Obj->PDSheader["SPACECRAFT_ALTITUDE"] = util_trimEOL(L2Obj->PDSheader["SPACECRAFT_ALTITUDE"]);
        sprintf(tmp,"%-40.40s%-38.38s",stmp.c_str(),L2Obj->PDSheader["SPACECRAFT_ALTITUDE"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SUB_SPACECRAFT_LATITUDE          =     ";
    	L2Obj->PDSheader["SUB_SPACECRAFT_LATITUDE"] = util_trimEOL(L2Obj->PDSheader["SUB_SPACECRAFT_LATITUDE"]);
        sprintf(tmp,"%-40.40s%-38.38s",stmp.c_str(),L2Obj->PDSheader["SUB_SPACECRAFT_LATITUDE"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SUB_SPACECRAFT_LONGITUDE         =     ";
    	L2Obj->PDSheader["SUB_SPACECRAFT_LONGITUDE"] = util_trimEOL(L2Obj->PDSheader["SUB_SPACECRAFT_LONGITUDE"]);
        sprintf(tmp,"%-40.40s%-38.38s",stmp.c_str(),L2Obj->PDSheader["SUB_SPACECRAFT_LONGITUDE"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "DESCRIPTION                      =     ";
    	L2Obj->PDSheader["DESCRIPTION"] = util_trimEOL(L2Obj->PDSheader["DESCRIPTION"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["DESCRIPTION"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "NOTE                             =     ";
    	L2Obj->PDSheader["NOTE"] = util_trimEOL(L2Obj->PDSheader["NOTE"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["NOTE"].c_str());
        os << string(tmp) << dfmsEOL;

    // Add an 79 character blank line to separate PDSheader from first Object descriptor
	sprintf(tmp,"%-78s"," ");
	os << string(tmp) << dfmsEOL;

	return 1;

}

//
// ------------------------------ writeNewPDSheader ------------------------------------
//
int DFMS_ProcessCEM_Class::writeNewPDSheader(fstream &os) {

	string sFunctionName = "DFMS_ProcessCEM_Class::writeNewPDSheader";

    char tmp[810];
    string stmp;
    string ctmp="None";
	int lblRec = 0;
	int L3recs = L3DataRows;

	if (L2Obj->PDSheader["SPICE_FILE_NAME"].empty()) {
		L2Obj->PDSheader["SPICE_FILE_NAME"] = "\"N/A\"";
		lblRec = 91;
	} else {
		lblRec = 104;
	}
	int lastLineNum = lblRec+L3HKrows+L3recs;

	// Start forming and writing the PDS Header.
	// Old L2 values that are to be directly transfered to L3 header contain a
	// reference to PDSheader["xxxxx"].
	// New L3 values are created from L3 relevant data
	// Note: the variable PDSheader["xxxxx"] contains unmodified L2 data.

    stmp = "PDS_VERSION_ID                   =     ";
    	L2Obj->PDSheader["PDS_VERSION_ID"] = util_trimEOL(L2Obj->PDSheader["PDS_VERSION_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PDS_VERSION_ID"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "LABEL_REVISION_NOTE              =     \"2007-09-27,Thierry Semon(UoB),";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "                                        Version2.1 release\"";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "SOFTWARE_NAME                    =     ";
       string ttmp = "\""+sCurrentSoftwareName+"\"";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),ttmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "SOFTWARE_VERSION_ID              =     ";
       ttmp = "\""+sCurrentSoftwareVersionID+"\"";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),ttmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_PIXEL0_A_MASS     =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_doubleToString(commMass)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_PIXEL0_B_MASS     =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_doubleToString(commMass)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "SOURCE_FILE_NAME                 =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(L2fileName.substr(0,27)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_CAL_ID4           =     ";
    	ctmp = "None";
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),ctmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_CAL_ID5           =     ";
    	ctmp = "None";
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),ctmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "ROSETTA:ROSINA_CAL_ID6           =     ";
    	ctmp = "None";
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),ctmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "RECORD_TYPE                      =     ";
    	L2Obj->PDSheader["RECORD_TYPE"] = util_trimEOL(L2Obj->PDSheader["RECORD_TYPE"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["RECORD_TYPE"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "RECORD_BYTES                     =     ";
    	L2Obj->PDSheader["RECORD_BYTES"] = util_trimEOL(L2Obj->PDSheader["RECORD_BYTES"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["RECORD_BYTES"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "FILE_RECORDS                     =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lastLineNum)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "LABEL_RECORDS                    =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec)).c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "^DFMS_HK_TABLE                   =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec+1)).c_str());
       os << string(tmp) << dfmsEOL;

 //   stmp = "^DFMS_MASS_CAL_TABLE             =     ";
   //    sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec+L3HKrows+1)).c_str());
     //  os << string(tmp) << dfmsEOL;

    stmp = "^CEM_DATA_L3_TABLE               =     ";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),(util_intToString(lblRec+L3HKrows+1)).c_str());
       os << string(tmp) << dfmsEOL;

    string newDName = L2Obj->PDSheader["DATA_SET_ID"];
    replace(newDName,"-2-","-3-");
    stmp = "DATA_SET_ID                      =     ";
    	newDName = util_trimEOL(newDName);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),newDName.c_str());
    	os << string(tmp) << dfmsEOL;

    newDName = L2Obj->PDSheader["DATA_SET_NAME"];
    replace(newDName,"2","3");
    stmp = "DATA_SET_NAME                    =     ";
		newDName = util_trimEOL(newDName);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),newDName.c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "PRODUCT_ID                       =     ";
       string name = L3fileName.substr(0,26);
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),name.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "PRODUCT_CREATION_TIME            =     ";
       string tTime = getProcessTime(1);
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),tTime.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "PRODUCT_TYPE                     =     RDR";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "PROCESSING_LEVEL_ID              =     \"3\"";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "MISSION_ID                       =     ";
    	L2Obj->PDSheader["MISSION_ID"] = util_trimEOL(L2Obj->PDSheader["MISSION_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["MISSION_ID"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "MISSION_NAME                     =     ";
    	L2Obj->PDSheader["MISSION_NAME"] = util_trimEOL(L2Obj->PDSheader["MISSION_NAME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["MISSION_NAME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "TARGET_NAME                      =     ";
    	L2Obj->PDSheader["TARGET_NAME"] = util_trimEOL(L2Obj->PDSheader["TARGET_NAME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["TARGET_NAME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "TARGET_TYPE                      =     ";
    	L2Obj->PDSheader["TARGET_TYPE"] = util_trimEOL(L2Obj->PDSheader["TARGET_TYPE"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["TARGET_TYPE"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "MISSION_PHASE_NAME               =     ";
    	L2Obj->PDSheader["MISSION_PHASE_NAME"] = util_trimEOL(L2Obj->PDSheader["MISSION_PHASE_NAME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["MISSION_PHASE_NAME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_HOST_NAME             =     ";
    	L2Obj->PDSheader["INSTRUMENT_HOST_NAME"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_HOST_NAME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_HOST_NAME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_HOST_ID               =     ";
    	L2Obj->PDSheader["INSTRUMENT_HOST_ID"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_HOST_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_HOST_ID"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_NAME                  =     ";
    	L2Obj->PDSheader["INSTRUMENT_NAME"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_NAME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_NAME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_ID                    =     ";
    	L2Obj->PDSheader["INSTRUMENT_ID"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_ID"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_MODE_ID               =     ";
    	L2Obj->PDSheader["INSTRUMENT_MODE_ID"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_MODE_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_MODE_ID"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "^INSTRUMENT_MODE_DESC            =     ";
    	L2Obj->PDSheader["^INSTRUMENT_MODE_DESC"] = util_trimEOL(L2Obj->PDSheader["^INSTRUMENT_MODE_DESC"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["^INSTRUMENT_MODE_DESC"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "INSTRUMENT_TYPE                  =     ";
    	L2Obj->PDSheader["INSTRUMENT_TYPE"] = util_trimEOL(L2Obj->PDSheader["INSTRUMENT_TYPE"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["INSTRUMENT_TYPE"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "DETECTOR_ID                      =     ";
    	L2Obj->PDSheader["DETECTOR_ID"] = util_trimEOL(L2Obj->PDSheader["DETECTOR_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["DETECTOR_ID"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "DETECTOR_DESC                    =     ";
    	L2Obj->PDSheader["DETECTOR_DESC"] = util_trimEOL(L2Obj->PDSheader["DETECTOR_DESC"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["DETECTOR_DESC"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "CHANNEL_ID                       =     ";
    	L2Obj->PDSheader["CHANNEL_ID"] = util_trimEOL(L2Obj->PDSheader["CHANNEL_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["CHANNEL_ID"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "START_TIME                       =     ";
    	L2Obj->PDSheader["START_TIME"] = util_trimEOL(L2Obj->PDSheader["START_TIME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["START_TIME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "STOP_TIME                        =     ";
    	L2Obj->PDSheader["STOP_TIME"] = util_trimEOL(L2Obj->PDSheader["STOP_TIME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["STOP_TIME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "SPACECRAFT_CLOCK_START_COUNT     =     ";
    	L2Obj->PDSheader["SPACECRAFT_CLOCK_START_COUNT"] = util_trimEOL(L2Obj->PDSheader["SPACECRAFT_CLOCK_START_COUNT"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SPACECRAFT_CLOCK_START_COUNT"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "SPACECRAFT_CLOCK_STOP_COUNT      =     ";
		L2Obj->PDSheader["SPACECRAFT_CLOCK_STOP_COUNT"] = util_trimEOL(L2Obj->PDSheader["SPACECRAFT_CLOCK_STOP_COUNT"]);
		sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SPACECRAFT_CLOCK_STOP_COUNT"].c_str());
		os << string(tmp) << dfmsEOL;

    stmp = "PRODUCER_ID                      =     ";
    	L2Obj->PDSheader["PRODUCER_ID"] = util_trimEOL(L2Obj->PDSheader["PRODUCER_ID"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PRODUCER_ID"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "PRODUCER_FULL_NAME               =     ";
    	L2Obj->PDSheader["PRODUCER_FULL_NAME"] = util_trimEOL(L2Obj->PDSheader["PRODUCER_FULL_NAME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PRODUCER_FULL_NAME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "PRODUCER_INSTITUTION_NAME        =     ";
    	L2Obj->PDSheader["PRODUCER_INSTITUTION_NAME"] = util_trimEOL(L2Obj->PDSheader["PRODUCER_INSTITUTION_NAME"]);
    	sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["PRODUCER_INSTITUTION_NAME"].c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "DATA_QUALITY_ID                  =     ";
       string qid = "\""+util_intToString(4)+"\"";
       sprintf(tmp,"%-39s%-39s",stmp.c_str(),qid.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "DATA_QUALITY_DESC                =     \"";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      0 means 'Nominal quality, avg. PPM deviance < 500\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      1 means 'Self-calibrated, GCU avg. PPM deviance >= 500, SELF < 500\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      2 means 'Adopted mass scale avg. PPM deviance >= 500\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      3 means 'Enhanced Noise\'";
       sprintf(tmp,"%-78s",stmp.c_str());
       os << string(tmp) << dfmsEOL;

    stmp = "      4 means 'Not enough peaks found for accurate calibration/verification\'\"";
    	sprintf(tmp,"%-78s",stmp.c_str());
    	os << string(tmp) << dfmsEOL;

    stmp = "SC_SUN_POSITION_VECTOR           =     ";
    	L2Obj->PDSheader["SC_SUN_POSITION_VECTOR"] = util_trimEOL(L2Obj->PDSheader["SC_SUN_POSITION_VECTOR"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SC_SUN_POSITION_VECTOR"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SC_TARGET_POSITION_VECTOR        =     ";
    	L2Obj->PDSheader["SC_TARGET_POSITION_VECTOR"] = util_trimEOL(L2Obj->PDSheader["SC_TARGET_POSITION_VECTOR"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SC_TARGET_POSITION_VECTOR"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SC_TARGET_VELOCITY_VECTOR        =     ";
    	L2Obj->PDSheader["SC_TARGET_VELOCITY_VECTOR"] = util_trimEOL(L2Obj->PDSheader["SC_TARGET_VELOCITY_VECTOR"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SC_TARGET_VELOCITY_VECTOR"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SPACECRAFT_ALTITUDE              =      ";
    	L2Obj->PDSheader["SPACECRAFT_ALTITUDE"] = util_trimEOL(L2Obj->PDSheader["SPACECRAFT_ALTITUDE"]);
        sprintf(tmp,"%-40.40s%-38.38s",stmp.c_str(),L2Obj->PDSheader["SPACECRAFT_ALTITUDE"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SUB_SPACECRAFT_LATITUDE          =      ";
    	L2Obj->PDSheader["SUB_SPACECRAFT_LATITUDE"] = util_trimEOL(L2Obj->PDSheader["SUB_SPACECRAFT_LATITUDE"]);
        sprintf(tmp,"%-40.40s%-38.38s",stmp.c_str(),L2Obj->PDSheader["SUB_SPACECRAFT_LATITUDE"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SUB_SPACECRAFT_LONGITUDE         =      ";
    	L2Obj->PDSheader["SUB_SPACECRAFT_LONGITUDE"] = util_trimEOL(L2Obj->PDSheader["SUB_SPACECRAFT_LONGITUDE"]);
        sprintf(tmp,"%-40.40s%-38.38s",stmp.c_str(),L2Obj->PDSheader["SUB_SPACECRAFT_LONGITUDE"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "SPICE_FILE_NAME                  =     ";
    	L2Obj->PDSheader["SPICE_FILE_NAME"] = util_trimEOL(L2Obj->PDSheader["SPICE_FILE_NAME"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["SPICE_FILE_NAME"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "DESCRIPTION                      =     ";
    	L2Obj->PDSheader["DESCRIPTION"] = util_trimEOL(L2Obj->PDSheader["DESCRIPTION"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["DESCRIPTION"].c_str());
        os << string(tmp) << dfmsEOL;

    stmp = "NOTE                             =     ";
    	L2Obj->PDSheader["NOTE"] = util_trimEOL(L2Obj->PDSheader["NOTE"]);
        sprintf(tmp,"%-39s%-39s",stmp.c_str(),L2Obj->PDSheader["NOTE"].c_str());
        os << string(tmp) << dfmsEOL;

    // Add an 79 character blank line to separate PDSheader from first Object descriptor
	sprintf(tmp,"%-78s"," ");
	os << string(tmp) << dfmsEOL;

	return 1;

}

//
// ------------------------------ writeHKdata ------------------------------------
//
int DFMS_ProcessCEM_Class::writeHKdata(fstream &os) {

	string sFunctionName = "DFMS_ProcessCEM_Class::writeHKdata";

	char line[80];
	string sOut;

	for (int i=0; i<L3HKrows; i++) {
		sprintf(line,"\"%-32s\",\"%-5s\",\"%-24s\",\"%-5s\"%1s",
		(L3HKdata[i][0]).c_str(),(L3HKdata[i][1]).c_str(),
		(L3HKdata[i][2]).c_str(),(L3HKdata[i][3]).c_str()," ");
		sOut = string(line);
		os << sOut << dfmsEOL;
	}

	return 1;

}

//
// ----------------------------- getL2HKdata -----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// This method assigns the L2 HK data that needs to pass unchanged to L3 HK (row 0-12)
//
// inputs:
//   None
//
// returns:
//   None
// =============================================================================
// History: Written by Mike Rinaldi, March 2013
// =============================================================================
//
void DFMS_ProcessCEM_Class::getL2HKdata() {

     string sFunctionName="DFMS_ProcessCEM_Class::getL2HKdata";

     int numFields = 4;

     // Same as L2 values ROSINA_DFMS_SCI_MODE
     for (int i=0; i<numFields; ++i) L3HKdata[0][i] = L2Obj->HKdata[2][i];
     // Same as L2 values ROSINA_DFMS_SCI_MODE
     for (int i=0; i<numFields; ++i) L3HKdata[1][i] = L2Obj->HKdata[3][i];
     // Same as L2 values ROSINA_DFMS_SCI_MAG_TEMPERATURE
     for (int i=0; i<numFields; ++i) L3HKdata[2][i] = L2Obj->HKdata[43][i];
     // Same as L2 values ROSINA_DFMS_SCI_COVER_POSITION
     for (int i=0; i<numFields; ++i) L3HKdata[3][i] = L2Obj->HKdata[44][i];
     // Same as L2 values ROSINA_DFMS_SCI_LEDA_FAR_OFFSET
     for (int i=0; i<numFields; ++i) L3HKdata[4][i] = L2Obj->HKdata[48][i];
     // Same as L2 values ROSINA_DFMS_SCI_GAIN_OFF_SPECTRUM
     for (int i=0; i<numFields; ++i) L3HKdata[5][i] = L2Obj->HKdata[52][i];
     // Same as L2 values ROSINA_DFMS_IONSRC_TEMPRATURE
     for (int i=0; i<numFields; ++i) L3HKdata[6][i] = L2Obj->HKdata[128][i];
     // Same as L2 values ROSINA_DFMS_MAGNET_TEMPERATURE
     for (int i=0; i<numFields; ++i) L3HKdata[7][i] = L2Obj->HKdata[170][i];
     // Same as L2 values ROSINA_DFMS_RDP_TEMPERATURE
     for (int i=0; i<numFields; ++i) L3HKdata[8][i] = L2Obj->HKdata[173][i];
     // Same as L2 values ROSINA_DFMS_LEDA_TEMPERATURE
     for (int i=0; i<numFields; ++i) L3HKdata[9][i] = L2Obj->HKdata[174][i];
     // Same as L2 values ROSINA_DFMS_ASPC_TEMPERATURE
     for (int i=0; i<numFields; ++i) L3HKdata[10][i] = L2Obj->HKdata[228][i];
     // Same as L2 values ROSINA_DFMS_FDPA_TEMPERATURE
     for (int i=0; i<numFields; ++i) L3HKdata[11][i] = L2Obj->HKdata[244][i];

}


//
// ---------------------------- formL3HKdata -----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// This method constructs the remaining L3 housekeeping data array (row 13-end)
//
// inputs: None
//
// returns:
//   none
// =============================================================================
// History: Written by Mike Rinaldi, March 2013
// =============================================================================
//
void DFMS_ProcessCEM_Class::formL3HKdata(const L2FileInfo &L2Info) {

     string sFunctionName="DFMS_ProcessCEM_Class::formL3HKdata";

     // Define beginning of L3 HK additions
     int HKs = 12;

     // Set COPS NG ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_COPS_PRESSURE_NG         ";
     L3HKdata[HKs][1] = "     ";
     if (copsPressNG != BADDATA) {
    	 L3HKdata[HKs][2] = util_doubleToString(copsPressNG);
    	 util_toUpperCase(L3HKdata[HKs][2]);
     } else {
    	 L3HKdata[HKs][2] = "N/A";
     }
     L3HKdata[HKs++][3] = "mbar ";

     // Set COPS RGv ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_COPS_PRESSURE_RG         ";
     L3HKdata[HKs][1] = "     ";
     if (copsPressRG != BADDATA) {
    	 L3HKdata[HKs][2] = util_doubleToString(copsPressRG);
    	 util_toUpperCase(L3HKdata[HKs][2]);
     } else {
    	 L3HKdata[HKs][2] = "N/A";
     }
     L3HKdata[HKs++][3] = "mbar ";

     // Set Cal Signal A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SIGNAL_CAL_VAL_A";
     L3HKdata[HKs][1] = "     ";
     if (L2Info.hiRes) {
    	 L3HKdata[HKs][2] = "0.5";
     } else if (L2Info.lowRes) {
    	 L3HKdata[HKs][2] = "5.0";
     }
     L3HKdata[HKs++][3] = "     ";

     // Set Cal signal Dev A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SIGNAL_CAL_DEV_A";
     L3HKdata[HKs][1] = "     ";
	 L3HKdata[HKs][2] = "0.01";
     L3HKdata[HKs++][3] = "     ";

     // Set Cal Signal B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SIGNAL_CAL_VAL_B";
     L3HKdata[HKs][1] = "     ";
     if (L2Info.hiRes) {
    	 L3HKdata[HKs][2] = "0.5";
     } else if (L2Info.lowRes) {
    	 L3HKdata[HKs][2] = "5.0";
     }
     L3HKdata[HKs++][3] = "     ";

     // Set Cal signal Dev B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SIGNAL_CAL_DEV_B";
     L3HKdata[HKs][1] = "     ";
	 L3HKdata[HKs][2] = "0.01";
     L3HKdata[HKs++][3] = "     ";

     // Set Offset A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_OFF_LEVEL_A     ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     // Set Offset Dev A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_OFF_STDEV_A     ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     // Offset Polynomial fit Mode specific File name  ---------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_OFF_COEFF_FILE  ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     addPolyOffCoeffInfo(1,&HKs);

     // Set Offset B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_OFF_LEVEL_B     ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     // Set Offset Dev B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_OFF_STDEV_B     ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     addPolyOffCoeffInfo(2,&HKs);

     // Set GCU pix0 A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_GCU_PIXEL0_A    ";
     L3HKdata[HKs][1] = "N/A";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     // Set GCU pix0 Unc A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_GCU_PIXEL0_UNC_A";
     L3HKdata[HKs][1] = "N/A";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     // Set GCU pix0 B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_GCU_PIXEL0_B    ";
     L3HKdata[HKs][1] = "N/A";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     // Set GCU pix0 Unc B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_GCU_PIXEL0_UNC_B";
     L3HKdata[HKs][1] = "N/A";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "     ";

     // Set Self pix0 A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SELF_PIXEL0_A   ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = util_doubleToString(step0);
     L3HKdata[HKs++][3] = "     ";

     // Set Self pix0 Unc A  ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SELF_PIXEL0_UNCA";
     L3HKdata[HKs][1] = "N/A";
     L3HKdata[HKs][2] = "+/-5";
     L3HKdata[HKs++][3] = "     ";

     // Set Self pix0 B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SELF_PIXEL0_B   ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = util_doubleToString(step0);
     L3HKdata[HKs++][3] = "     ";

     // Set Self pix0 Unc B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_SELF_PIXEL0_UNCB";
     L3HKdata[HKs][1] = "N/A";
     L3HKdata[HKs][2] = "+/-5";
     L3HKdata[HKs++][3] = "     ";

     // Set PPM dev A ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_AVG_PPM_DEV_A   ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs++][3] = "ppm  ";

     // Set PPM dev B ----------------------------------------
     L3HKdata[HKs][0] = "ROSINA_DFMS_SCI_AVG_PPM_DEV_B   ";
     L3HKdata[HKs][1] = "     ";
     L3HKdata[HKs][2] = "N/A";
     L3HKdata[HKs][3] = "ppm  ";

}

//
// ------------------------- addPolyOffCoeffInfo -------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// This method is canibalized from DFMS_processMCP_CLASS.  It serves no purpose
// other than to mimic the process of writing an MCP L3 file but with all values
// set to "N/A"
//   iRow - Row A/B
//   HKs - Row number in the Housekeeping object
//
// returns:
//   None
// =============================================================================
// History: Written by Mike Rinaldi, May 2016
// =============================================================================
//
void DFMS_ProcessCEM_Class::addPolyOffCoeffInfo(int iRow, int *HKs) {

	int rowNum = *HKs;

	if (iRow == 1) {

		//
		L3HKdata[rowNum][0] = "ROSINA_DFMS_SCI_OFF_COEFF_C1_A  ";
		L3HKdata[rowNum][1] = "     ";
		L3HKdata[rowNum][2] = "N/A";
		L3HKdata[rowNum++][3] = "     ";
		//
		L3HKdata[rowNum][0] = "ROSINA_DFMS_SCI_OFF_COEFF_C2_A  ";
		L3HKdata[rowNum][1] = "     ";
		L3HKdata[rowNum][2] = "N/A";
		L3HKdata[rowNum++][3] = "     ";
		//
		L3HKdata[rowNum][0] = "ROSINA_DFMS_SCI_OFF_COEFF_C3_A  ";
		L3HKdata[rowNum][1] = "     ";
		L3HKdata[rowNum][2] = "N/A";
		L3HKdata[rowNum++][3] = "     ";

	} else {

		//
		L3HKdata[rowNum][0] = "ROSINA_DFMS_SCI_OFF_COEFF_C1_B  ";
		L3HKdata[rowNum][1] = "     ";
		L3HKdata[rowNum][2] = "N/A";
		L3HKdata[rowNum++][3] = "     ";
		//
		L3HKdata[rowNum][0] = "ROSINA_DFMS_SCI_OFF_COEFF_C2_B  ";
		L3HKdata[rowNum][1] = "     ";
		L3HKdata[rowNum][2] = "N/A";
		L3HKdata[rowNum++][3] = "     ";
		//
		L3HKdata[rowNum][0] = "ROSINA_DFMS_SCI_OFF_COEFF_C3_B  ";
		L3HKdata[rowNum][1] = "     ";
		L3HKdata[rowNum][2] = "N/A";
		L3HKdata[rowNum++][3] = "     ";
	}

	*HKs = rowNum;
}

//
// ------------------------------ writeL3data ------------------------------------
//
int DFMS_ProcessCEM_Class::writeL3data(fstream &os) {

	string sFunctionName = "DFMS_ProcessCEM_Class::writeL3data";

	char line[80];
	string sOut;

	// Write mass and Signal to L3 file
	for (int i=0; i<L3DataRows; i++) {
		sprintf(line,"%2.2d,%8.2f,%17.2f,%48s",(i+1),L3Data[i][0],L3Data[i][1]," ");
		sOut = string(line);
		os << sOut << dfmsEOL;
	}

	return 1;
}

//
// ---------------------------- Open PDS file ------------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Opens a PDS file
//
// inputs:
//	file - full path name to file
//  str  - reference to input or output stream
//
// returns:
//   1 if success, 0 if failure
// =============================================================================
// History:  Written by Mike Rinaldi, Mar 2013
// Modified PDS version:  May 2016
// =============================================================================
//
int DFMS_ProcessCEM_Class::openFile(string file, fstream &str) {

	string sFunctionName = "DFMS_ProcessCEM_Class::openFile";

	// Open the PDS file input stream for writing

	str.open(file.c_str(), fstream::out | fstream::binary);
	if(!str.is_open()) {
		sErrorMessage = "Error opening for writing PDS File: "+file;
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}


	return 1;
}

//
// ---------------------------- Close PDS file ------------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Closes a PDS file
//
// inputs:
//  is - reference to input or output stream
//
// returns:
//   None
// =============================================================================
// History:  Written by Mike Rinaldi, Mar 2013
// =============================================================================
void DFMS_ProcessCEM_Class::closeFile(fstream &is) {

	// close the L3 file input stream
	is.close();
}

//
// --------------------------------- writeObj --------------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Write an Object description to PDS file
//
// inputs:
//  os - reference output stream
//  descObj - string,value map pairs describing the object
//  last - 1 if this is the last object to write, 0 otherwise
//
// returns:
//   1 if success, 0 if failure
// =============================================================================
// History:  Written by Mike Rinaldi, Mar 2013
// =============================================================================
int DFMS_ProcessCEM_Class::writeObj(fstream &os, mapstr &descObj, int last) {

	string sFunctionName = "DFMS_ProcessCEM_Class::writeObj";

	char line[80];
	string value;

	sprintf(line,"%-33s=     %-39s","OBJECT",(descObj["OBJECT"]).c_str());
	os << string(line) << dfmsEOL;
	sprintf(line,"   %-30s=     %-39s","NAME",(descObj["NAME"]).c_str());
	os << string(line) << dfmsEOL;
	sprintf(line,"   %-30s=     %-39s","INTERCHANGE_FORMAT",(descObj["INTERCHANGE_FORMAT"]).c_str());
	os << string(line) << dfmsEOL;
	sprintf(line,"   %-30s=     %-39s","ROWS",(descObj["ROWS"]).c_str());
	os << string(line) << dfmsEOL;
	sprintf(line,"   %-30s=     %-39s","COLUMNS",(descObj["COLUMNS"]).c_str());
	os << string(line) << dfmsEOL;
	sprintf(line,"   %-30s=     %-39s","ROW_BYTES",(descObj["ROW_BYTES"]).c_str());
	os << string(line) << dfmsEOL;
	sprintf(line,"   %-30s=     %-39s","^STRUCTURE",(descObj["^STRUCTURE"]).c_str());
	os << string(line) << dfmsEOL;
	sprintf(line,"%-33s=     %-39s","END_OBJECT",(descObj["END_OBJECT"]).c_str());
	os << string(line) << dfmsEOL;

	if (last) {
		value = "END";
	} else {
		value = "";
	}

	sprintf(line,"%-78s",value.c_str());
	os << line << dfmsEOL;

	return 1;
}

//
// -----------------------------------------  createL3file ----------------------------------------
//
int DFMS_ProcessCEM_Class::createL3File() {

	string sFunctionName = "DFMS_ProcessCEM_Class::createL3File";

	int rows,cols;
	fstream os;
	int nSuccess;

	// Open the L3 File stream for output
	openFile(L3File,os);

	// Form the HK data descp obj
	nSuccess = formHKobj();
	if (!nSuccess) {
		sErrorMessage = "Unable to form the L3 HK data Object \n";
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}

	// Form the L3 data descp obj
	nSuccess = formL3DataObj();
	if (!nSuccess) {
		sErrorMessage = "Unable to form the L3 data Object\n";
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}

	// write the L3 file PDS header
	// New PDS header applies for dates >= 01/1/2014 00:00:00
	if (isNewPDS) {
		nSuccess = writeNewPDSheader(os);
		if (!nSuccess) {
			sErrorMessage = "Unable to write the New PDS header for file: ";
			sErrorMessage += L3File;
			writeToLog(sErrorMessage, sFunctionName, ERROR);
			return 0;
		} else {
			//cout << "Writing NEW PDS header" << endl;
		}
	} else {
		nSuccess = writeOldPDSheader(os);
		if (!nSuccess) {
			sErrorMessage = "Unable to write the Old PDS header for file: ";
			sErrorMessage += L3File;
			writeToLog(sErrorMessage, sFunctionName, ERROR);
			return 0;
		} else {
			//cout << "Writing OLD PDS header" << endl;
		}
	}
	//if (verbose == 1) printL3File("PDSHeader");

	// Write the L3 file HK object description
	nSuccess = writeObj(os, L3HKobj, 0);
	if (!nSuccess) {
		sErrorMessage = "Unable to write the HK Object Descp. for file: ";
		sErrorMessage += L3File;
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}
	//if (verbose == 1) printL3File("L3HKobj");

	// Write the L3 Data object description
	nSuccess = writeObj(os, L3DataObj, 1);
	if (!nSuccess) {
		sErrorMessage = "Unable to write the L3 Object Descp. for file: ";
		sErrorMessage += L3File;
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}
	//if (verbose == 1) printL3File("L3CalObj");

	// Write the L3 file HK Data
	nSuccess = writeHKdata(os);
	if (!nSuccess) {
		sErrorMessage = "Unable to write the HK Data to file: ";
		sErrorMessage += L3File;
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}
	//if (verbose == 1) printL3File("L3HKdata");

	// Write the L3 file L3 Data
	nSuccess = writeL3data(os);
	if (!nSuccess) {
		sErrorMessage = "Unable to write the L3 Data to file: ";
		sErrorMessage += L3File;
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}
	//if (verbose == 1) printL3File("L3data");

	// Close the L3 File stream
	closeFile(os);

	return 1;

}

//
// ------------------------------ printL3File ------------------------------------
//
void DFMS_ProcessCEM_Class::printL3File(string type) {

	// First print the PDS Header

	map<string,string>::const_iterator it;

	if (type == "PDSHeader" || type == "All") {
		for (it = L2Obj->PDSheader.begin(); it != L2Obj->PDSheader.end(); ++it) {
			printf("%-32s =     %-s\n",(it->first).c_str(),(it->second).c_str());
		}
		cout << endl;
	}

	// Next print out HK Object description
	if (type == "L3HKobj" || type == "All") {
		for (it = L3HKobj.begin(); it != L3HKobj.end(); ++it) {
			printf("%32s =     %-s\n",(it->first).c_str(),(it->second).c_str());
		}
		cout << endl;
	}

	// Next print out Data Object description
	if (type == "L3dataObj" || type == "All") {
		for (it = L3DataObj.begin(); it != L3DataObj.end(); ++it) {
			printf("%32s =     %-s\n",(it->first).c_str(),(it->second).c_str());
		}
	     cout << "END" << endl;
	}

	// Next print out the HK data
	if (type == "L3HKdata" || type == "All") {
	 	for (int i=0; i<L3HKrows; i++) {
			printf("\"%-32s\",\"%-5s\",\"%-15s\",\"%-5s\"\n",
				(L3HKdata[i][0]).c_str(),
				(L3HKdata[i][1]).c_str(),
				(L3HKdata[i][2]).c_str(),
				(L3HKdata[i][3]).c_str());
		}
	}

	// Finally print out the data
	if (type == "L3data" || type == "All") {
		for (int i=0; i<L3DataRows; i++) {
			printf("%6f,%17.6f,%16.6f,%17.6f,%16.6f,\n",
				L3Data[i][0], L3Data[i][1], L3Data[i][2], L3Data[i][3], L3Data[i][4]);
		}
	}

}

//
// --------------------------------------- DumpL3toFile ----------------------------------------
//
int DFMS_ProcessCEM_Class::DumpL3toFile(string path) {

	string file=path + L3fileName.substr(0,L3fileName.length()-4)  + "_plot.dat";
	fstream os;
	os.open(file.c_str(), fstream::out | fstream::binary);
	os << "Pixel    Mass-A   IonRate-A    Mass-B    IoRate-B" << dfmsEOL;
	char tmp[80];
	for (int i=0; i<L3DataRows; ++i) {
		sprintf(tmp,"%5d    %f    %f     %f      %f",
				L3Data[i][0],L3Data[i][1],L3Data[i][2],
				L3Data[i][3],L3Data[i][4]);
		os << string(tmp) << dfmsEOL;
	}

	os.close();

	return 1;
}

//
//  --------------------------- getResPerStep ----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Calculate the CEM Resolution per Step
//
// returns:
//   Res per step
// =============================================================================
// Modified: Adapted:  Written by Mike Rinaldi.  April 2016
// =============================================================================
//
double DFMS_ProcessCEM_Class::getResPerStep(L2FileInfo &L2Info) {

	double delMoM0 = 0.0;

	// Resolution per step
	if (L2Info.hiRes) {
		delMoM0 = 1.0/10000.00;
	} else if (L2Info.lowRes) {
		delMoM0 = 1.0/1000.00;
	}

	return delMoM0;

}

//
//  --------------------------- getSignalScale ----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Calculate the CEM signal Scale from Resolution info
//
// returns:
//   Signal in ions/Spectrum
// =============================================================================
// Modified: Adapted:  Written by Mike Rinaldi.  April 2016
// =============================================================================
//
double DFMS_ProcessCEM_Class::getSignalScale(const L2FileInfo &L2Info) {

	double intgT = 1.0;
	double sig=0.0;

    double eDisp = calcDispersion(L2Info.commandedMass);
	sig = eDisp*resPS / (CONV * intgT);

	return sig;

}

//
//  --------------------------- getMassScale ----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Calculate the CEM mass scale from input commanded mass and step
//
// returns:
//   Mass value
// =============================================================================
// Modified: Adapted:  Written by Mike Rinaldi.  April 2016
// =============================================================================
//
double DFMS_ProcessCEM_Class::getMassScale(double stepi) {

	double mAti;

	// Get mass at stepi
	mAti = commMass*((stepi - step0)*resPS  + 1.0);

	return mAti;

}

//
//  --------------------------- getStep0 ----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Calculate the step0 value from input commanded mass
//
// returns:
//   step0 value
// =============================================================================
// Modified: Adapted:  Written by Mike Rinaldi.  April 2016
// =============================================================================
//
double DFMS_ProcessCEM_Class::getStep0(const L2FileInfo &L2Info) {

    string sFunctionName="DFMS_ProcessCEM_Class::cemMassScale";

	double m0 = L2Info.commandedMass;
	double stp0 = 0.0;

	// Check resolution setting
	if (L2Info.hiRes) {

		if (m0 >= 12 && m0 <= 15) {
			stp0 = 3.6713*m0 - 10.85;
		} else if (m0 >= 16 && m0 <= 18) {
			stp0 = 3.4728*m0 - 31.38;
		} else if (m0 >= 19 && m0 <= 45) {
			stp0 = -26.49*log(m0) + 106.0;
		} else if (m0 >= 46 && m0 <= 140) {
			stp0 = 6.0;
		} else {
			sErrorMessage = "Illegal commanded Mass: ";
	        sErrorMessage += util_doubleToString(m0);
	        writeToLog(sErrorMessage, sFunctionName, ERROR);
	        skipReas["illegalCEMmass"];
	        totFilesSkipped++;
	        return -99.0;
		}

	} else if (L2Info.lowRes) {
		stp0 = -8.10*log(m0) + 40.68;
	}

	return stp0;

}

//
//  --------------------------- processL2 ----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Convert one CEM L2 file to L3
// 	L2Info  -  Level 2 Cem file info struct
//
// returns:
//   1 if successfull, 0 otherwise
// =============================================================================
// Modified: Adapted:  Written by Mike Rinaldi.  April 2016
// =============================================================================
//
int DFMS_ProcessCEM_Class::processL2(L2FileInfo &L2Info) {

	string sFunctionName="DFMS_ProcessCEM_Class::processL2";

	commMass = L2Info.commandedMass;
	double stepi=0;

	// Get Resolution per step
	resPS = getResPerStep(L2Info);

	// Get step 0 for this commanded mass
	step0 = getStep0(L2Info);

	// Calculate Signal
	double sigScale = getSignalScale(L2Info);

	// Develop the CEM mass scale
	mass = new double[L3DataRows];
	for (int i=0; i<L3DataRows; i++) {
		stepi = (double)(i+1);
		mass[i] = getMassScale(stepi);
	}

	// Transfer L2 HK data to L3 HK array
	initializeData();

	// Get first 12 L2 HK data values and copy to first 12 L3HK data values
	getL2HKdata();

	// Add COPS Info
	addCOPSinfo();

	// Now form the remaining L3 HK data values
	formL3HKdata(L2Info);

	// Form the L3 Data array
	for (int i=0; i<L3DataRows; i++) {
		L3Data[i][0] = mass[i];
		L3Data[i][1] = L2Obj->L2Data[i][1]*sigScale;
		//cout << "L3Data["<<i<<"][0]="<<L3Data[i][0] << endl;
		//cout << "L3Data["<<i<<"][1]="<<L3Data[i][1] << endl;
		continue;
	}

	return 1;

}

//
// ------------------------------ addCOPSinfo ----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// This method Gets the COPS BG or NG and RG data and saves the relevant info
//
// inputs:
//   None
//
// returns:
//   None
// =============================================================================
// History:  Written by Mike Rinaldi
// Modified for CEM:  May 2016
// =============================================================================
//
void DFMS_ProcessCEM_Class::addCOPSinfo() {

	string sFunctionName = "DFMS_ProcessCEM_Class::addCOPSinfo";

	int nSuccess;
	COPSobjIn = NULL;

	// Attempt to get COPS BG data

	if (sBestBGCOPS.compare("N/A") != 0) {

		// Now do the BG COPS Data
		COPSobjIn = new DFMS_COPS_Class(sCOPSpath, sBestBGCOPS, "bg");

		// Get the COPS BG data file
		nSuccess = COPSobjIn->getCOPSdata();
		if (!nSuccess) {
			sErrorMessage = "Unable to read the COPS BG file: ";
			sErrorMessage += COPSobjIn->getFileName()+"\n";
			writeToLog(sErrorMessage, sFunctionName, ERROR);
			copsPressNG = BADDATA;
			copsPressRG = BADDATA;
		} else {
			// Save COPS value
			copsPressNG = atof((COPSobjIn->COPSHKdata[31][2]).c_str());
			copsPressRG = atof((COPSobjIn->COPSHKdata[32][2]).c_str());
		}
		if (verbose >= 2) COPSobjIn->printCOPSdata("All");

		delete COPSobjIn;  COPSobjIn=0;

	} else {  // No COPS NG or RG Data

		if (sBestNGCOPS.compare("N/A") == 0) {
			copsPressNG = BADDATA;
		}
		if (sBestRGCOPS.compare("N/A") == 0) {
			copsPressRG = BADDATA;
		}
	}

	// Attempt to get COPS NG data

	if (sBestNGCOPS.compare("N/A") != 0) {

		// Open COPS data using DFMS_COPS_Class...
		//cout << "sCOPSpath = " << sCOPSpath << endl;

		COPSobjIn = new DFMS_COPS_Class(sCOPSpath, sBestNGCOPS, "ng");

		// Get the COPS NG data file
		//cout << "sCOPSpath = " << sCOPSpath << endl;

		nSuccess = COPSobjIn->getCOPSdata();
		if (!nSuccess) {
			sErrorMessage = "Unable to read the COPS NG file: ";
			sErrorMessage += COPSobjIn->getFileName()+"\n";
			writeToLog(sErrorMessage, sFunctionName, ERROR);
			copsPressNG = BADDATA;
		} else {
			// Save COPS value
			copsPressNG = atof((COPSobjIn->COPSHKdata[31][2]).c_str());
		}
		if (verbose >= 2) COPSobjIn->printCOPSdata("All");

		delete COPSobjIn;  COPSobjIn=0;

	} else {  // No COPS NG Data
		if (sBestBGCOPS.compare("N/A") == 0) {
			copsPressNG = BADDATA;
		}
	}

	// Attempt to get COPS RG data

	if (sBestRGCOPS.compare("N/A") != 0) {

		// Now do the RG COPS Data
		COPSobjIn = new DFMS_COPS_Class(sCOPSpath, sBestRGCOPS, "rg");

		// Get the COPS RG data file
		nSuccess = COPSobjIn->getCOPSdata();
		if (!nSuccess) {
			sErrorMessage = "Unable to read the COPS RG file: ";
			sErrorMessage += COPSobjIn->getFileName()+"\n";
			writeToLog(sErrorMessage, sFunctionName, ERROR);
			copsPressRG = BADDATA;
		} else {
			// Save COPS value
			copsPressRG = atof((COPSobjIn->COPSHKdata[32][2]).c_str());
		}
		if (verbose >= 2) COPSobjIn->printCOPSdata("All");

		delete COPSobjIn;  COPSobjIn=0;

	} else {  // No COPS RG Data

		if (sBestBGCOPS.compare("N/A") == 0) {
			copsPressRG = BADDATA;
		}
	}

}

