/*
 * DFMS_PolyFit_Class.cc
 *
 *  Created on: Apr 1, 2014
 *      Author: marinaldi
 */

#include "DFMS_PolyFit_Class.hh"

//
// ------------------------- Constructor ------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Set up variables for poly fit
//
// inputs:
//		n - number of points to fit
//      d - Degree of fit
//      x - pointer to independent array elements
//      y - pointer to dependent array elements
//
// returns:
//   true if success, false if failure
// =============================================================================
// History:  Adapted from GSL example by Mike Rinaldi, August 2014
// =============================================================================
DFMS_PolyFit_Class::DFMS_PolyFit_Class(int n, int d, double *x, double *y) {

	num = n;
	degree = d;

	dx = new double[num];
	dy = new double[num];
    coeff = new double[degree];

    for(int i=0; i<num; i++) {
    	dx[i] = x[i];
    	dy[i] = y[i];
    }

}

//
// ------------------------- destructor ------------------------------
//
DFMS_PolyFit_Class::~DFMS_PolyFit_Class() {

    delete[] dx; dx=0;
    delete[] dy; dy=0;
    delete[] coeff; coeff=0;

}

//
// -------------------------------- polyFit ------------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// Perform a polynomial fit to x/y data using a 'deg' order polynomial
//
// inputs:
//		None
// returns:
//   true if success, false if failure
// =============================================================================
// History:  Adapted from GSL example by Mike Rinaldi, August 2014
// =============================================================================
bool DFMS_PolyFit_Class::polyFit() {

	string sFunctionName = "DFMS_PolyFit_Class::polyFit";

	gsl_multifit_linear_workspace *ws;
	gsl_matrix *cov, *X;
	gsl_vector *y, *c;
	double chisq;

  	X = gsl_matrix_alloc(num, degree);
  	y = gsl_vector_alloc(num);
  	c = gsl_vector_alloc(degree);
  	cov = gsl_matrix_alloc(degree, degree);

  	for(int i=0; i < num; i++) {
    	gsl_matrix_set(X, i, 0, 1.0);
    	for(int j=0; j < degree; j++) {
      		gsl_matrix_set(X, i, j, pow(dx[i], j));
    	}
    	gsl_vector_set(y, i, dy[i]);
  	}

  	ws = gsl_multifit_linear_alloc(num, degree);
 	gsl_multifit_linear(X, y, c, cov, &chisq, ws);

  	/* store result ... */
  	for(int i=0; i < degree; i++) {
    	coeff[i] = gsl_vector_get(c, i);
  	}

  	gsl_multifit_linear_free(ws);
  	gsl_matrix_free(X);
  	gsl_matrix_free(cov);
  	gsl_vector_free(y);
  	gsl_vector_free(c);

  	return true;
}

//
// ------------------------- printCoeff ------------------------------
//
void DFMS_PolyFit_Class::printCoeff() {

	for(int i=0; i < degree; i++) {
		cout << "coeff[" << i << "] = " << coeff[i] << endl;
	}

}
