
#ifndef DFMS_PEAKFIT_CLASS_H_
#define DFMS_PEAKFIT_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_stats.hh"
#include "DFMS_Histogram_Class.hh"
#include "DFMS_definedConstants.hh"

extern int iPltFile;
extern string sGNUplotPath;

//
// This Class represents the relevant data and methods that act on an COPS file
//
class DFMS_PeakFit_Class {

	public:

		bool fitSucceeded;

		int nPeakRange;
		int iXl, iXr;

		double* Xin;
		double* Yin;
		double* yAin;
		double* yBin;

		int yAmaxId;
		int yBmaxId;

		double* XpartIn;
		double* YpartIn;

		double* yFit;
		double* yFitA;
		double* yFitB;

        double fwhm;
		double* weight;
		double* coeff;
		double* errCoeff;
		int nParams;
		double meanOffset;
		double threshold;
		L2FileInfo L2Info;
		str2D MPSTdata;
		int MPSTrows;
		string peakFound;

     public:
		DFMS_PeakFit_Class(int, double*, int, str2D &, double, double,
				              int, int, int);
		~DFMS_PeakFit_Class();
		int initPeakFit(int,int,double,double,bool);
		double curveFit(double*, double*, double**, double**, double**, double*);
		int processCurveFit(int, int);
		double fitFunc(double, double*);
		void calcDeriv(double**);
		void calcWeights(int);
		int calcParamErrors(int);
		int bestPeak(int);
		bool checkHistoSmoothness(DFMS_Histogram_Class *, int);
		int invertMatrix(int, double**);
		void printIteration(int, double, double, double*, double**, double **, double **);
		void errorOnFitParams(double);
};

#endif //DFMS_PEAKFIT_CLASS_H_
