
#ifndef DFMS_PDS_FILE_CLASS_H_
#define DFMS_PDS_FILE_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"


//
// This Class represents the relevant data and methods that pertain to any PDS file
//
class DFMS_PDS_file_Class {

	// Data
	public:
		mapstr PDSheader;
		string pdsFileName;
		int numObjs=0;
		int lblRecs=0;
		int lastPDSHeaderLine=0;

	public:
		// Generic Methods
		DFMS_PDS_file_Class();
		~DFMS_PDS_file_Class();

		// I/O setup methods
		int openFile(string file, fstream &, int);
		void closeFile(fstream &);

		// Input methods
		int readPDSheader(fstream &);
		int readObj(fstream &, mapstr &, int &, int &);

		// Output method
		int writeObj(fstream &, mapstr &, int);

		// Helper method
		int findLastPDSLine();

};

#endif //DFMS_PDS_FILE_CLASS_H_
