
#ifndef DFMS_PDS_L2_DIR_CLASS_H_
#define DFMS_PDS_L2_DIR_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_definedConstants.hh"
#include "DFMS_PDS_L2_file_Class.hh"
#include "DFMS_Gain_Table_Class.hh"
#include "DFMS_ModeID_Table_Class.hh"
#include "DFMS_CreateGCUSLFPix0_Class.hh"
#include "DFMS_PixelGain_Interp_Class.hh"
#include "DFMS_GainTable_Interp_Class.hh"
#include "DFMS_X0FitFile_Class.hh"

extern string sMassPeakTablePath;
extern string pgtPath;
extern string sPixelGainTableBaseName;
extern string sBestPGTtime;
extern string sInstrumentModel;

extern map<int,DFMSModeInfo> modeData;
extern map<int,polyInfo> pC;

extern int processNewGCUSLFfiles;

class DFMS_PDS_L2_dir_Class {

	private:
		int numFiles;
		string fileName;
		string dateTime;
		string path;
		linFitParams gcuP;

	public:

		int numDmodes;
		vector<int> badL2Ids;
		// Vector holding all L2 file info
		vector<L2FileInfo> allL2;
		vector<L2FileInfo> L2Info;

		// Vectors holding GCU and SLF file Info
		vector<fitFileInfo> gcuLmLrFiles, gcuHmLrFiles, gcuLmHrFiles, gcuMmHrFiles, gcuHmHrFiles;
		vector<fitFileInfo> slfLmLrFiles, slfHmLrFiles, slfLmHrFiles, slfMmHrFiles, slfHmHrFiles;

	public:
		DFMS_PDS_L2_dir_Class(string);
		~DFMS_PDS_L2_dir_Class();
		int getNumFiles() {return L2Info.size();}
		void printL2FileList();
		void printFileInfo(int);

		int findL2FileSize();
		int findL2Mode();
		bool findResState();
		bool verifyL2();
		string findL2FileDate();

		int	getL2FilesInDir(int);
		int getFileIndex(string);

		void sortL2Files();
		int getHKInfo(int, long*);
		int gatherGCUL2Files(int, int, double);
		int gatherSLFL2Files(int, int, double);
		//int getMassResAndStore(bool);
		//bool getSLFAndStore(bool);
		int processPix0FitData(int, int, DFMS_GainTable_Interp_Class*, vector<gtFileInfo> &, DFMS_ModeID_Table_Class*, DFMS_PixelGain_Interp_Class *, vector<pgFileInfo> &,
            vector<L2FileInfo> &, vector<L2FileInfo> &, int*);
		int findPix0ForGCUSLFType(int, int, string, string, string, vector<fitFileInfo> &, DFMS_GainTable_Interp_Class*, vector<gtFileInfo> &, DFMS_ModeID_Table_Class*, DFMS_PixelGain_Interp_Class *, vector<pgFileInfo> &, vector<L2FileInfo> &,
            vector<L2FileInfo> &, int*);

		bool onlyOneDistinctMass(vector<fitFileInfo> &);
		void printFitVars(string, string, string);

};

#endif  //DFMS_PDS_L2_DIR_CLASS_H_
