/* 
 * File:   DFMS_ModeID_Table_Class.hh
 * Author: marinaldi
 *
 * Created on June 8, 2013, 4:47 PM
 */

#ifndef DFMS_MODEID_TABLE_CLASS_HH
#define DFMS_MODEID_TABLE_CLASS_HH

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"

extern map<int,DFMSModeInfo> modeData;

class DFMS_ModeID_Table_Class: public DFMS_PDS_file_Class  {

	private:
		string path;
		string fileName;
		string modeIDfile;
		int modeIDrows;
		int modeIDcols;
     
	public:
		mapstr modeIDobj;
		//str2D modeIDdata;
    
	public:
		DFMS_ModeID_Table_Class(string p, string f);
		virtual ~DFMS_ModeID_Table_Class();
		int getRows() {return modeIDrows;}
		string getfileName() {return fileName;}
     	string getFileDate();
		mapstr getPDSheader() {return PDSheader;}
          
		// Input Method
		int readModeData(fstream &);
		int getModeData();
     	DFMSModeInfo getModeInfo(int);

     	static string findLatestModeTable(string );
     
     	void printModeFile(string);
		int isValid();

};

#endif  /* DFMS_MODEID_TABLE_CLASS_HH */

