
#ifndef DFMS_MPST_CLASS_H_
#define DFMS_MPST_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"

//
// This Class represents the relevant data and methods 
// that act on a Mass Peak Table file
//
class DFMS_MPST_Class: public DFMS_PDS_file_Class {

	// Data
     private:
		string path;
		string fileName;
		string MPSTfile;
		int MPSTrows;
		int MPSTcols;

	// Data
	public:
		map<string,string> MPSTobj;
		str2D MPSTdata;
		string creationTime;
		string sModeOut;

	public:
		// Generic methods
		DFMS_MPST_Class(string p, string f);
		DFMS_MPST_Class(string p, string f, int n, mapstr &P,
										mapstr &d, str2D &);
		~DFMS_MPST_Class();
		int getRows() {return MPSTrows;}
		string getModeID();
		string getfileName() {return fileName;}

		// Input Method
		int readMPSTdata(fstream &);

		// Methods to form output MPST Features
		int formMPSTobj();
		//int formPDSheader();

		// Methods to write MPST Feautres
		int openFile4Out(string, fstream &);
		int writePDSheader(fstream &);
		int writeMPSTdata(fstream &, int, int);

		// Methods to process the MPST specifics
		int getMPSTdata();
		int putMPSTfile();
		void printMPSTobj(string);
		int isValid();
          
		static int getMPSTfilesInDir(string, vector<L2FileInfo> &, string);
		static int findBestMPSTfile(string, string, bool, vector<L2FileInfo> &);
          
};

#endif //DFMS_MPST_CLASS_H_
