/*
 * DFMS_LinFit_Class.cc
 *
/*
    This class implements a standard linear regression on
    experimental data using a least squares fit to a straight
    line graph.  Calculates coefficients a and b of the equation:

                        y = a + b * x

    for data points of x and y.  Also calculates the coefficient of
    determination, the coefficient of correlation, and standard
    error of estimate.

    The value n (number of points) must be greater than 2 to
    calculate the regression.  This is primarily because the
    standard error has a (N-2) in the denominator.

    Check haveData() to see if there is enough data in
    LinearRegression to get values.

    You can think of the x,y pairs as 2 dimensional points.
    The class Point2D is included to allow pairing x and y
    values together to represent a point on a plane.

*/

#include "DFMS_LinFit_Class.hh"

using namespace std;

DFMS_LinFit_Class::~DFMS_LinFit_Class() {

	//cout << "linfit Destructor just ran" << endl;

}

//
//  -------------------- Constructor 1 ---------------------------------
//
DFMS_LinFit_Class::DFMS_LinFit_Class() {

    a = b = sumX = sumY = sumXsquared = sumYsquared = sumXY = 0.0;
    n = 0L;
    coefC = 0.0;
    coefD = 0.0;
    stdError = 0.0;

    // Additions
    Syox = Sb = Sa =0.0;

}

/*
//
//  -------------------- Constructor 2 ---------------------------------
//
DFMS_LinFit_Class::DFMS_LinFit_Class(Point2D *p, long size) {

    long i;
    a = b = sumX = sumY = sumXsquared = sumYsquared = sumXY = 0.0;
    n = 0L;

    if (size > 0L) // if size greater than zero there are data arrays
        for (n = 0, i = 0L; i < size; i++)
            addPoint(p[i]);
}
*/
//
//  -------------------- Constructor 3 ---------------------------------
//
DFMS_LinFit_Class::DFMS_LinFit_Class(double *x, double *y, long size, int itype) {

    long i;
    a = b = sumX = sumY = sumXsquared = sumYsquared = sumXY = 0.0;
    n = 0L;

    // if size greater than zero there are data arrays
    if (size > 0L) {
    	for (n = 0, i = 0L; i < size; i++) {
    		addXY(x[i], y[i], itype);
    		//if (itype == 2) {
    		//	if (size == 2) cout << "x[" << i << "] = " << x[i] << "  -  y[" << i << "] = " << y[i] << endl;
    		//}
    	}
    }
    //if (size == 2) {
    //	cout << "a = " << a << endl;
    //	cout << "b = " << b << endl;
    //	cout << "cal y[" << 0 << "] = " << a+b*x[0] << endl;
    //	cout << "cal ymid = " << a+b*(x[1]+x[0])/2 << endl;
    //	cout << "cal y[" << 1 << "] = " << a+b*x[1] << endl;
    //}
}


//
// ------------------------------------ findOffSet -----------------------------------------
//
double DFMS_LinFit_Class::findOffSet(long s, double b, string type, string resType, string massType, int iRow) {

	long size = s;
	double *yInt = new double[size];
	double sum = 0.0;

	if (type.compare("SLF") == 0) {

	    if (resType.compare("L") == 0) {
	    	if (iRow == 1) {
	    		if (size > 0L) { // if size greater than zero there are data arrays
	    			if (massType.compare("L") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfLmLrA[i].pix0 - b*slfLmLrA[i].m0;
	    					sum += yInt[i];
	    				}
	    				double a = sum/size;
	    				return a;
	    			} else if (massType.compare("H") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfHmLrA[i].pix0 - b*slfHmLrA[i].m0;
	    					sum += yInt[i];
	    				}
	    				double a = sum/size;
	    				return a;
	    			}
	    		}
	    	} else {
	    		if (size > 0L) { // if size greater than zero there are data arrays
	    			if (massType.compare("L") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfLmLrB[i].pix0 - b*slfLmLrB[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			} else if (massType.compare("H") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfHmLrB[i].pix0 - b*slfHmLrB[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			}
	    		}
	    	}
	    } else if (resType.compare("H") == 0) {
	    	if (iRow == 1) {
	    		if (size > 0L) { // if size greater than zero there are data arrays
	    			if (massType.compare("L") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfLmHrA[i].pix0 - b*slfLmHrA[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			} else if (massType.compare("M") == 0) {
	    				for (int i=0; i<size; i++) {
	    					//cout << "slfMmHrA[" << i << "].pix0 = " << slfMmHrA[i].pix0 << "  "  << slfMmHrA[i].m0 <<endl;
	    					yInt[i] = slfMmHrA[i].pix0 - b*slfMmHrA[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			} else if (massType.compare("H") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfHmHrA[i].pix0 - b*slfHmHrA[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			}
	    		}
	    	} else {
	    		if (size > 0L) { // if size greater than zero there are data arrays
	    			if (massType.compare("L") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfLmHrB[i].pix0 - b*slfLmHrB[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			} else if (massType.compare("M") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfMmHrB[i].pix0 - b*slfMmHrB[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			} else if (massType.compare("H") == 0) {
	    				for (int i=0; i<size; i++) {
	    					yInt[i] = slfHmHrB[i].pix0 - b*slfHmHrB[i].m0;
	    					sum += yInt[i];
	    				}
		    			double a = sum/size;
		    			return a;
	    			}
	    		}
	    	}
	    }
	}

	delete[] yInt;

	return 0;
}

//
// -------------------------- Perform the fit ---------------------------
//
void DFMS_LinFit_Class::startFit(long s, string type, string resType, string massType, int iRow) {


    long size = s;

    if (type.compare("GCU") == 0) {
    	if (resType.compare("L") == 0) {
    		if (iRow == 1) {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						addXY((const double&) gcuLmLrA[i].m0, (const double&) gcuLmLrA[i].pix0,1);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) gcuHmLrA[i].m0, (const double&) gcuHmLrA[i].pix0,1);
    					}
    				}
    			}
    		} else {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						addXY((const double&) gcuLmLrB[i].m0, (const double&) gcuLmLrB[i].pix0,1);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) gcuHmLrB[i].m0, (const double&) gcuHmLrB[i].pix0,1);
    					}
    				}
    			}
    		}
    	} else if (resType.compare("H") == 0) {
    		if (iRow == 1) {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						addXY((const double&) gcuLmHrA[i].m0, (const double&) gcuLmHrA[i].pix0,1);
    					} else if (massType.compare("M") == 0) {
    						addXY((const double&) gcuMmHrA[i].m0, (const double&) gcuMmHrA[i].pix0,2);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) gcuHmHrA[i].m0, (const double&) gcuHmHrA[i].pix0,2);
    					}
    				}
    			}
    		} else {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						addXY((const double&) gcuLmHrB[i].m0, (const double&) gcuLmHrB[i].pix0,1);
    					} else if (massType.compare("M") == 0) {
    						addXY((const double&) gcuMmHrB[i].m0, (const double&) gcuMmHrB[i].pix0,2);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) gcuHmHrB[i].m0, (const double&) gcuHmHrB[i].pix0,2);
    					}
    				}
    			}
    		}
    	}

    } else if (type.compare("SLF") == 0) {

    	if (resType.compare("L") == 0) {
    		if (iRow == 1) {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						//cout << slfLmLrA[i].m0 << " " << slfLmLrA[i].pix0 << endl;
    						addXY((const double&) slfLmLrA[i].m0, (const double&) slfLmLrA[i].pix0,1);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) slfHmLrA[i].m0, (const double&) slfHmLrA[i].pix0,1);
    					}
    				}
    			}
    		} else {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						addXY((const double&) slfLmLrB[i].m0, (const double&) slfLmLrB[i].pix0,1);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) slfHmLrB[i].m0, (const double&) slfHmLrB[i].pix0,1);
    					}
    				}
    			}
    		}
    	} else if (resType.compare("H") == 0) {
    		if (iRow == 1) {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						cout << slfLmHrA[i].m0 << " " << slfLmHrA[i].pix0 << endl;
    						addXY((const double&) slfLmHrA[i].m0, (const double&) slfLmHrA[i].pix0,1);
    					} else if (massType.compare("M") == 0) {
    						addXY((const double&) slfMmHrA[i].m0, (const double&) slfMmHrA[i].pix0,1);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) slfHmHrA[i].m0, (const double&) slfHmHrA[i].pix0,1);
    					}
    				}
    			}
    		} else {
    			if (size > 0L) { // if size greater than zero there are data arrays
    				for (long n = 0, i = 0L; i < size; i++) {
    					if (massType.compare("L") == 0) {
    						addXY((const double&) slfLmHrB[i].m0, (const double&) slfLmHrB[i].pix0,1);
    					} else if (massType.compare("M") == 0) {
    						addXY((const double&) slfMmHrB[i].m0, (const double&) slfMmHrB[i].pix0,1);
    					} else if (massType.compare("H") == 0) {
    						addXY((const double&) slfHmHrB[i].m0, (const double&) slfHmHrB[i].pix0,1);
    					}
    				}
    			}
    		}
    	}
    }

}

//
//  ---------------------------- avgPix0 ---------------------------------
//
double DFMS_LinFit_Class::avgPix0(string type, string resType, string massType, int iRow) {

	double sum = 0.0;

	if (type.compare("GCU") == 0) {
		if (resType.compare("L") == 0) {
			if (iRow ==1) {
				if (massType.compare("L") == 0) {
					for (int i=0; i<gcuLmLrA.size(); i++) {
						sum += gcuLmLrA[i].pix0;
					}
					return sum/gcuLmLrA.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<gcuHmLrA.size(); i++) {
						sum += gcuHmLrA[i].pix0;
					}
					return sum/gcuHmLrA.size();
				}
			} else {
				if (massType.compare("L") == 0) {
					for (int i=0; i<gcuLmLrB.size(); i++) {
						sum += gcuLmLrB[i].pix0;
					}
					return sum/gcuLmLrB.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<gcuHmLrB.size(); i++) {
						sum += gcuHmLrB[i].pix0;
					}
					return sum/gcuHmLrB.size();
				}
			}
		} else if (resType.compare("H") == 0) {
			if (iRow ==1) {
				if (massType.compare("L") == 0) {
					for (int i=0; i<gcuLmHrA.size(); i++) {
						sum += gcuLmHrA[i].pix0;
					}
					return sum/gcuLmHrA.size();
				} else if (massType.compare("M") == 0){
					for (int i=0; i<gcuMmHrA.size(); i++) {
						sum += gcuMmHrA[i].pix0;
					}
					return sum/gcuMmHrA.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<gcuHmHrA.size(); i++) {
						sum += gcuHmHrA[i].pix0;
					}
					return sum/gcuHmHrA.size();
				}
			} else {
				if (massType.compare("L") == 0) {
					for (int i=0; i<gcuLmHrB.size(); i++) {
						sum += gcuLmHrB[i].pix0;
					}
					return sum/gcuLmHrB.size();
				} else if (massType.compare("M") == 0){
					for (int i=0; i<gcuMmHrB.size(); i++) {
						sum += gcuMmHrB[i].pix0;
					}
					return sum/gcuMmHrB.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<gcuHmHrB.size(); i++) {
						sum += gcuHmHrB[i].pix0;
					}
					return sum/gcuHmHrB.size();
				}
			}
		}

	} else if (type.compare("SLF") == 0) {

		if (resType.compare("L") == 0) {
			if (iRow ==1) {
				if (massType.compare("L") == 0) {
					for (int i=0; i<slfLmLrA.size(); i++) {
						sum += slfLmLrA[i].pix0;
					}
					return sum/slfLmLrA.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<slfHmLrA.size(); i++) {
						sum += slfHmLrA[i].pix0;
					}
					return sum/slfHmLrA.size();
				}
			} else {
				if (massType.compare("L") == 0) {
					for (int i=0; i<slfLmLrB.size(); i++) {
						sum += slfLmLrB[i].pix0;
					}
					return sum/slfLmLrB.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<slfHmLrB.size(); i++) {
						sum += slfHmLrB[i].pix0;
					}
					return sum/slfHmLrB.size();
				}
			}
		} else if (resType.compare("H") == 0) {
			if (iRow ==1) {
				if (massType.compare("L") == 0) {
					for (int i=0; i<slfLmHrA.size(); i++) {
						sum += slfLmHrA[i].pix0;
					}
					return sum/slfLmHrA.size();
				} else if (massType.compare("M") == 0){
					for (int i=0; i<slfMmHrA.size(); i++) {
						sum += slfMmHrA[i].pix0;
					}
					return sum/slfMmHrA.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<slfHmHrA.size(); i++) {
						sum += slfHmHrA[i].pix0;
					}
					return sum/slfHmHrA.size();
				}
			} else {
				if (massType.compare("L") == 0) {
					for (int i=0; i<slfLmHrB.size(); i++) {
						sum += slfLmHrB[i].pix0;
					}
					return sum/slfLmHrB.size();
				} else if (massType.compare("M") == 0){
					for (int i=0; i<slfMmHrB.size(); i++) {
						sum += slfMmHrB[i].pix0;
					}
					return sum/slfMmHrB.size();
				} else if (massType.compare("H") == 0){
					for (int i=0; i<slfHmHrB.size(); i++) {
						sum += slfHmHrB[i].pix0;
					}
					return sum/slfHmHrB.size();
				}
			}
		}
	}

	return 0.0;

}

//
//  ------------------------ addXY ------------------------------------
//
void DFMS_LinFit_Class::addXY(const double& x, const double& y, int itype) {

	n++;
    sumX += x;
    sumY += y;
    sumXsquared += x * x;
    sumYsquared += y * y;
    sumXY += x * y;
    Calculate(itype);
}

//
//  ---------------------- Calculate ---------------------------------
//
void DFMS_LinFit_Class::Calculate(int itype) {



    if (haveData(itype)) {

    	if (fabs( double(n) * sumXsquared - sumX * sumX) > DBL_EPSILON) {

            b = ( double(n) * sumXY - sumY * sumX) /
                ( double(n) * sumXsquared - sumX * sumX);
            a = (sumY - b * sumX) / double(n);

            double sx = b * ( sumXY - sumX * sumY / double(n) );
            double sy2 = sumYsquared - sumY * sumY / double(n);
            double sy = sy2 - sx;

            coefD = sx / sy2;
            coefC = sqrt(coefD);
            stdError = sqrt(sy / double(n - 2));

        } else {

            a = b = coefD = coefC = stdError = 0.0;
        }

    }
}

//
//  -------------------------------- haveData ----------------------------------------
//
int DFMS_LinFit_Class::haveData(int itype) {
	if (itype == 1) return (n > 2 ? 1 : 0);
	if (itype == 2) return (n >= 2 ? 1 : 0);
	return 0;
}

//
//  ---------------------------------- errors ----------------------------------------
//
void DFMS_LinFit_Class::errors(string type, string resType, string massType, int iRow) {

	double meanX=0.0;

	if (haveData(1)) {
		double *yRes = new double[n];
		double *x = new double[n];
		double *y = new double[n];
		if (type.compare("GCU") == 0) {
			if (resType.compare("L") == 0) {
				if (iRow ==1) {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = gcuLmLrA[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuLmLrA[i].pix0;
					} else if (massType.compare("H") == 0){
						for (int i=0; i<n; i++) x[i] = gcuHmLrA[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuHmLrA[i].pix0;
					}
				} else {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = gcuLmLrB[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuLmLrB[i].pix0;
					} else if (massType.compare("H") == 0){
						for (int i=0; i<n; i++) x[i] = gcuHmLrB[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuHmLrB[i].pix0;
					}
				}
			} else if (resType.compare("H") == 0) {
				if (iRow ==1) {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = gcuLmHrA[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuLmHrA[i].pix0;
					} else if (massType.compare("M") == 0){
						for (int i=0; i<n; i++) x[i] = gcuMmHrA[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuMmHrA[i].pix0;
					} else if (massType.compare("H") == 0){
						for (int i=0; i<n; i++) x[i] = gcuHmHrA[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuHmHrA[i].pix0;
					}
				} else {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = gcuLmHrB[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuLmHrB[i].pix0;
					} else if (massType.compare("M") == 0){
						for (int i=0; i<n; i++) x[i] = gcuMmHrB[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuMmHrB[i].pix0;
					} else if (massType.compare("H") == 0){
						for (int i=0; i<n; i++) x[i] = gcuHmHrB[i].m0;
						for (int i=0; i<n; i++) y[i] = gcuHmHrB[i].pix0;
					}
				}
			}

		} else if (type.compare("SLF") == 0) {

			if (resType.compare("L") == 0) {
				if (iRow ==1) {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = slfLmLrA[i].m0;
						for (int i=0; i<n; i++) y[i] = slfLmLrA[i].pix0;
					} else if (massType.compare("H") == 0) {
						for (int i=0; i<n; i++) x[i] = slfHmLrA[i].m0;
						for (int i=0; i<n; i++) y[i] = slfHmLrA[i].pix0;
					}
				} else {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = slfLmLrB[i].m0;
						for (int i=0; i<n; i++) y[i] = slfLmLrB[i].pix0;
					} else if (massType.compare("H") == 0) {
						for (int i=0; i<n; i++) x[i] = slfHmLrB[i].m0;
						for (int i=0; i<n; i++) y[i] = slfHmLrB[i].pix0;
					}
				}
			} else if (resType.compare("H") == 0) {
				if (iRow ==1) {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = slfLmHrA[i].m0;
						for (int i=0; i<n; i++) y[i] = slfLmHrA[i].pix0;
					} else if (massType.compare("M") == 0){
						for (int i=0; i<n; i++) x[i] = slfMmHrA[i].m0;
						for (int i=0; i<n; i++) y[i] = slfMmHrA[i].pix0;
					} else if (massType.compare("H") == 0){
						for (int i=0; i<n; i++) x[i] = slfHmHrA[i].m0;
						for (int i=0; i<n; i++) y[i] = slfHmHrA[i].pix0;
					}
				} else {
					if (massType.compare("L") == 0) {
						for (int i=0; i<n; i++) x[i] = slfLmHrB[i].m0;
						for (int i=0; i<n; i++) y[i] = slfLmHrB[i].pix0;
					} else if (massType.compare("M") == 0){
						for (int i=0; i<n; i++) x[i] = slfMmHrB[i].m0;
						for (int i=0; i<n; i++) y[i] = slfMmHrB[i].pix0;
					} else if (massType.compare("H") == 0){
						for (int i=0; i<n; i++) x[i] = slfHmHrB[i].m0;
						for (int i=0; i<n; i++) y[i] = slfHmHrB[i].pix0;
					}
				}
			}
		}

        meanX = sumX/double(n);
        double sumYres2=0.0;
        double sumXmxm=0.0;

        // Calculate the preliminary variables. Residues,...
		for (int i=0; i<n; i++) {
			yRes[i] = a - b*x[i];
			sumYres2 += (y[i] - yRes[i])*(y[i] - yRes[i]);
			sumXmxm += (x[i] - meanX)*(x[i] - meanX);
		}

		// Calculate errors on fit parameters a/b
        Syox = sqrt(sumYres2/double(n-2));
        if (sumXmxm > 0) {
            Sa = Syox * sqrt(sumXsquared/(double(n)*sumXmxm));
        	Sb = Syox/sqrt(sumXmxm);
        } else {
        	Sa = 0.0;
        	Sb = 0.0;
        }


    	delete[] yRes;
    	delete[] x;
    	delete[] y;
	}

}

//
//  ------------------- overloaded operator << --------------------------
//
ostream& operator<<(ostream& out, DFMS_LinFit_Class& lr) {

    if (lr.haveData(1))
        out << "f(x) = " << lr.geta()
            << " + ( " << lr.getb()
            << " * x )";
    return out;
}


