/* 
 * File:   DFMS_Histogram_Class.hh
 * Author: marinaldi
 *
 * Created on March 29, 2013, 4:14 PM
 */

#ifndef DFMS_HISTOGRAM_CLASS_HH
#define DFMS_HISTOGRAM_CLASS_HH

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_stats.hh"

class DFMS_Histogram_Class {

	public:
    	int numPix;
    	double hMin;
    	double hMax;
    	int iMin;
    	int iMax;
    	int numBins;
    	double binSize;
    	int* histo;
    	double* sumInHisto;
    	double* array;
    	double** countsInBin;
    	string type;
    
	public:
    	DFMS_Histogram_Class(double*, int ,int, string);
    	~DFMS_Histogram_Class();
    	double getHmin() {return hMin;}
    	double getHmax() {return hMax;}
    	double getBinSize() {return binSize;}
    	int getImin() {return iMin;}
    	int getImax() {return iMax;}

    	void createHisto(int);
    	double histoPeak(int*);
    	void meanOffset(double*, double*);
    	void printHistoInfo();

};

#endif	/* DFMS_HISTOGRAM_CLASS_HH */

