
#ifndef DFMS_GAIN_TABLE_CLASS_H_
#define DFMS_GAIN_TABLE_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"
//
// This class represents the relevant data and methods that act on a Gain Table files
//
class DFMS_Gain_Table_Class: public DFMS_PDS_file_Class {

	private:
		string path;
		string fileName;
		string GTfile;
		int TableRows;
		int TableCols;

	public:
		mapstr GTobj;
		dbl2D gTdata;

	public:
		DFMS_Gain_Table_Class(string p, string f);
		~DFMS_Gain_Table_Class();
		int readGTdata(fstream &);
		int getGainTable();
		string getFileName() {return fileName;}
		void printGTtable(string);
    
        static int getGTFileInfo(string gtPath,vector<gtFileInfo> &);

};

#endif  //DFMS_GAIN_TABLE_CLASS_H_
