;
; ----------------------- read_file ----------------------------
;
pro read_file,tdata,header,process

	str = ' '
	
	; Send file pointer back to beginning if not already there
	point_lun,1,0L  
	
	readf,1,str
	if (strpos(str,'Skipped') ne -1) then begin
		process = ' - L2 File Skipped'
	endif else begin
	    process = ''
	endelse
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMode = fields[1]
	mode = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMass = fields[1]
	mass = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	siXl = fields[1]
	iXl = fix(fields[1])	
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	siXr = fields[1]
	iXr = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPix0A = fields[1]
	pix0A = float(fields[1])

	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPix0B = fields[1]
	pix0B = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sGcuPix0A = fields[1]
	gcuPix0A = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sGcuPix0B = fields[1]
	gcuPix0B = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMeanOffsetA = fields[1]
	meanOffsetA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMeanOffsetB = fields[1]
	meanOffsetB = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPkIDA = fields[1]
	;pkIDA = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPkIDB = fields[1]
	;pkIDB = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakCenterA = fields[1]
	peakCenterA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakCenterB = fields[1]
	peakCenterB = float(fields[1])
	
		readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakWidthA = fields[1]
	peakWidthA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakWidthB = fields[1]
	peakWidthB = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakAreaA = fields[1]
	peakAreaA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakAreaB = fields[1]
	peakAreaB = float(fields[1])
	
	header =  { mode:mode, sMode:sMode, $
				mass:mass, sMass:sMass, $
				pkIDA:0,    sPkIDA:sPkIDA, $
				pkIDB:0,    sPkIDB:sPkIDB, $
				iXl:iXl,   siXl:siXl, $
				iXr:iXr,   siXr:siXr, $
				gcuPix0A:gcuPix0A, sGcuPix0A:sGcuPix0A, $
				gcuPix0B:gcuPix0B, sGcuPix0B:sGcuPix0B, $
				meanOffsetA:meanOffsetA, sMeanOffsetA:sMeanOffsetA, $
				meanOffsetB:meanOffsetB, sMeanOffsetB:sMeanOffsetB, $
				pix0A:pix0A, sPix0A:sPix0A, $
				pix0B:pix0B, sPix0B:sPix0B, $
				peakCenterA:peakCenterA, sPeakCenterA:sPeakCenterA, $
				peakCenterB:peakCenterB, sPeakCenterB:sPeakCenterB, $
				peakWidthA:peakWidthA, sPeakWidthA:sPeakWidthA, $
				peakWidthB:peakWidthB, sPeakWidthB:sPeakWidthB, $
				peakAreaA:peakAreaA, sPeakAreaA:sPeakAreaA, $
				peakAreaB:peakAreaB, sPeakAreaB:sPeakAreaB  }
			  
	readf,1,str							
	
	readf,1,tdata	

end
;
;
;
pro makePlot,tdata,header,tit

	set_plot,'X'
				
	black = 0
	green = 20
	red = 220
	!p.background = 255
					
	plot,tdata(0,*),tdata(1,*), title=tit, xsty=1, xtitle='Pixel',ytitle='Raw Counts Row A',xrange = [1,512],color=black
	  ;	xyouts,0.12,0.95,'______ Row A Data',/normal,color=black
	  ;	xyouts,0.12,0.93,'Target Mass = '+header.sMass,/normal,color=black
	  ;  xyouts,0.80,0.57,process,color=[255,0,0],/normal,color=black
		    
	;plot,tdata(0,*),tdata(6,*), title=tit, xsty=1, xtitle='Pixel',ytitle='Raw Counts Row B',xrange = [1,512],color=black
	  ; 	xyouts,0.12,0.45,'______ Row B Data',/normal,color=black
	  ; 	xyouts,0.12,0.43,'Target Mass = '+header.sMass,/normal,color=black
	  ;  xyouts,0.80,0.07,process,color=[255,0,0],/normal,color=black


end
;
; ---------------------------- Main ----------------------------------
;

dir  = getenv('DFMS_INSTALL_DIR')+'/data/plotFiles/'

!p.charsize=1.7
!p.background = 255
!p.color = 0
loadct,2
str = ' '
mode = ' '

read,str,prompt='Enter a specific mode or a for All [eg., 220,150,.. or A] :'
if (str eq 'a' OR str eq 'A') then begin
	filter = '*.dat'
endif else begin
    if (strlen(str) eq 1) then mode = 'm000'
    if (strlen(str) eq 2) then mode = 'm00'
    if (strlen(str) eq 3) then mode = 'm0'
    if (strlen(str) eq 4) then mode = 'm'
    filter = '*'+mode+str+'*.dat'
endelse


;file = dialog_pickfile(path=dir, title='Select a File to plot')
files = FILE_SEARCH(dir,filter)

tdata = fltarr(11,512)

numx = 3
numy = 3
!p.multi=[0,numx,numy]

num = n_elements(files)

if (!d.name eq 'X') then window,1,xsize=1200,ysize=1200
   
for i=0,num-1,numx*numy do begin

	for j=i,i+numx*numy-1 do begin
	    file = files[j]
		openr,1,file		
		read_file,tdata,header,process
		spos = strpos(file,'/',/reverse_search)
		tit = strmid(file,spos+1,100) 
		makePlot,tdata,header,tit
		close,1
		
	endfor
	read,str,prompt='Do another set? [Y/N] '
	str = strupcase(str)
	if (str eq "N") then break
	
endfor

end
