;
; ---------------------- findPeakRange -------------------------
;
pro findPeakRange,data,istrt,istop

	ids = where(data gt 0)
	s = size(ids)
	if (s[1] ne 0 and ids[0] ne -1) then begin
		istrt = ids[0]
		istop = ids[s[1]-1]
	endif else begin
	    istrt = 0
	    istop = 0
	endelse
	;stop

end
;
; ----------------------- read_file ----------------------------
;
pro read_file,tdata,header,process,bproc

	str = ' '
	
	; Send file pointer back to beginning if not already there
	point_lun,1,0L  
	
	readf,1,str
	if (strpos(str,'Skipped') ne -1) then begin
		process = ' - L2 File Skipped'
		bproc = 1
	endif else begin
	    process = ''
	    bproc = 0
	endelse
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMode = fields[1]
	mode = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMass = fields[1]
	mass = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	siXl = fields[1]
	iXl = fix(fields[1])	
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	siXr = fields[1]
	iXr = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPix0A = fields[1]
	pix0A = float(fields[1])

	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPix0B = fields[1]
	pix0B = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sGcuPix0A = fields[1]
	gcuPix0A = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sGcuPix0B = fields[1]
	gcuPix0B = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMeanOffsetA = fields[1]
	meanOffsetA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sMeanOffsetB = fields[1]
	meanOffsetB = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPkIDA = fields[1]
	;pkIDA = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPkIDB = fields[1]
	;pkIDB = fix(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakCenterA = fields[1]
	peakCenterA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakCenterB = fields[1]
	peakCenterB = float(fields[1])
	
		readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakWidthA = fields[1]
	peakWidthA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakWidthB = fields[1]
	peakWidthB = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakAreaA = fields[1]
	peakAreaA = float(fields[1])
	
	readf,1,str
	fields = strsplit(str,'=',/extract)
	sPeakAreaB = fields[1]
	peakAreaB = float(fields[1])
	
	header =  { mode:mode, sMode:sMode, $
				mass:mass, sMass:sMass, $
				pkIDA:0,    sPkIDA:sPkIDA, $
				pkIDB:0,    sPkIDB:sPkIDB, $
				iXl:iXl,   siXl:siXl, $
				iXr:iXr,   siXr:siXr, $
				gcuPix0A:gcuPix0A, sGcuPix0A:sGcuPix0A, $
				gcuPix0B:gcuPix0B, sGcuPix0B:sGcuPix0B, $
				meanOffsetA:meanOffsetA, sMeanOffsetA:sMeanOffsetA, $
				meanOffsetB:meanOffsetB, sMeanOffsetB:sMeanOffsetB, $
				pix0A:pix0A, sPix0A:sPix0A, $
				pix0B:pix0B, sPix0B:sPix0B, $
				peakCenterA:peakCenterA, sPeakCenterA:sPeakCenterA, $
				peakCenterB:peakCenterB, sPeakCenterB:sPeakCenterB, $
				peakWidthA:peakWidthA, sPeakWidthA:sPeakWidthA, $
				peakWidthB:peakWidthB, sPeakWidthB:sPeakWidthB, $
				peakAreaA:peakAreaA, sPeakAreaA:sPeakAreaA, $
				peakAreaB:peakAreaB, sPeakAreaB:sPeakAreaB  }
			  
	readf,1,str							
	
	readf,1,tdata	

end
;
; ----------------------------------------- plotIons -----------------------------------------------------
;
pro plotIons,tdata,iplt0,iplt1,header,process,tit,black,red,green

	plot,tdata(5,iplt0:iplt1),tdata(6,iplt0:iplt1), xticklayout=4, xtitle='Mass Scale (AMU)',ytitle='Ion Rate (Ions/s) Row A',$
			     color=black, /ylog, xgridstyle=2, ygridstyle=2
	oplot,tdata(5,header.iXl:header.iXr),tdata(3,header.iXl:header.iXr),linestyle=2, color=red
				
	;axis,xaxis=0,xrange=[min(tdata(5,iplt0:iplt1)),max(tdata(5,iplt0:iplt1))],xtitle='Mass Scale (AMU)',color=black
	;axis,xaxis=1,xrange=[iplt0,iplt1],xtitle='Pixel #',color=black
				
	if (header.iXl > 1 && header.iXr < 511) then begin
		oplot,[header.iXl,header.iXl],[!y.crange[0],!y.crange[1]],linestyle=2,color=green
		oplot,[header.iXr,header.iXr],[!y.crange[0],!y.crange[1]],linestyle=2,color=green
	endif
	xyouts,0.12,0.95,'File: '+tit,/normal,color=black
	xyouts,0.12,0.93,'_______ Row A Ion Rate',/normal,color=black
	xyouts,0.12,0.91,'----- Row A Fit',/normal,color=red
	xyouts,0.12,0.89,'Commanded Mass = '+header.sMass,/normal,color=black
   	if (strlen(header.sPkIDA) gt 1) then begin
   		xyouts,0.12,0.87,'Peak ID = '+header.sPkIDA,/normal,color=black
   		if (header.peakCenterA ne -999) then begin
    		xyouts,0.12,0.85,'Peak Center = '+header.sPeakCenterA,/normal,color=black
    		xyouts,0.12,0.83,'Peak Width = '+header.sPeakWidthA,/normal,color=black
    		xyouts,0.12,0.81,'Peak Area = '+header.sPeakAreaA+' (Ions/s)',/normal,color=black
    	endif else begin
    		xyouts,0.12,0.85,'Peak Center = N/A',/normal,color=black
    		xyouts,0.12,0.83,'Peak Width = N/A',/normal,color=black
    		xyouts,0.12,0.81,'Peak Area = N/A',/normal,color=black
    	endelse
   		xyouts,0.12,0.79,'pix0A = '+header.sPix0A,/normal,color=black
   		xyouts,0.12,0.77,'gcuPix0A = '+header.sGcuPix0A,/normal,color=black
   	endif else begin
   		xyouts,0.12,0.87,'pix0A = '+header.sPix0A,/normal,color=black
   		xyouts,0.12,0.85,'gcuPix0A = '+header.sGcuPix0A,/normal,color=black
   	endelse
   	xyouts,0.80,0.57,process,/normal,color=red
	    			    	
	plot,tdata(11,iplt0:iplt1),tdata(12,iplt0:iplt1), xticklayout=4, xtitle='Mass Scale (AMU)',ytitle='Ion Rate (Ions/s) Row B',$
	     color=black, /ylog, xgridstyle=2, ygridstyle=2
	oplot,tdata(11,header.iXl:header.iXr),tdata(9,header.iXl:header.iXr),linestyle=2,color=red
			
	;axis,xaxis=0,xrange=[min(tdata(11,iplt0:iplt1)),max(tdata(11,iplt0:iplt1))],xtitle='Mass Scale (AMU)',color=black
	;axis,xaxis=1,xrange=[iplt0,iplt1],xtitle='Pixel #',color=black
				
	if (header.iXl > 1 && header.iXr < 511) then begin
		oplot,[header.iXl,header.iXl],[!y.crange[0],!y.crange[1]],linestyle=2,color=green
		oplot,[header.iXr,header.iXr],[!y.crange[0],!y.crange[1]],linestyle=2,color=green
	endif
	xyouts,0.12,0.45,'File: '+tit,/normal,color=black
	xyouts,0.12,0.43,'_______ Row A Ion Rate',/normal,color=black
	xyouts,0.12,0.41,'----- Row A Fit',/normal,color=red
	xyouts,0.12,0.39,'Commanded Mass = '+header.sMass,/normal,color=black
   	if (strlen(header.sPkIDA) gt 1) then begin
   		xyouts,0.12,0.37,'Peak ID = '+header.sPkIDA,/normal,color=black
   		if (header.peakCenterB ne -999) then begin
    		xyouts,0.12,0.35,'Peak Center = '+header.sPeakCenterB,/normal,color=black
    		xyouts,0.12,0.33,'Peak Width = '+header.sPeakWidthB,/normal,color=black
    		xyouts,0.12,0.31,'Peak Area = '+header.sPeakAreaB+' (Ions/s)',/normal,color=black
    	endif else begin
    		xyouts,0.12,0.35,'Peak Center = N/A',/normal,color=black	
    		xyouts,0.12,0.33,'Peak Width = N/A',/normal,color=black
    		xyouts,0.12,0.31,'Peak Area = N/A',/normal,color=black
    	endelse
   		xyouts,0.12,0.29,'pix0A = '+header.sPix0A,/normal,color=black
   		xyouts,0.12,0.27,'gcuPix0A = '+header.sGcuPix0A,/normal,color=black
   	endif else begin
   		xyouts,0.12,0.37,'pix0A = '+header.sPix0A,/normal,color=black
   		xyouts,0.12,0.35,'gcuPix0A = '+header.sGcuPix0A,/normal,color=black    	
   	endelse
   	xyouts,0.80,0.07,process,/normal,color=red
   	
end
;
; ------------------------ makePlot -----------------------------
;
;
pro makePlot,dir,num,file

	
	tdata = fltarr(13,512)
	
	read_file,tdata,header,process,bproc
	
    spos = strpos(file,'/',/reverse_search)
	tit = strmid(file,spos+1,100)+process
	
	;!p.multi=[0,1,2]
	
	case num of 
	
	    1: begin 
	    
	    		!p.multi=[0,1,2]
				if (!d.name eq 'X') then window,1,xsize=800,ysize=1200
				
				black = 0
		    	green = 20
		    	red = 220
		    	!p.background = 255
				
				; Plot Row A
				plot,tdata(0,*),tdata(1,*), /ylog, /ynozero, title=tit, yrange=[40000.0, 60000.0],ysty=1,xsty=1, xtitle='Pixel',ytitle='Raw Counts Row A',xrange = [1,512],color=black
				if (bproc eq 0) then begin
				    oplot,tdata(0,*),tdata(4,*),psym=3,color=red
			    	xyouts,0.12,0.95,'______ Row A Data',/normal,color=black
			    	xyouts,0.12,0.93,'.............. Row A offset',/normal,color=red
			    	xyouts,0.12,0.91,'Commanded Mass = '+header.sMass,/normal,color=black
			    endif else begin
			    	xyouts,0.12,0.95,'______ Row A Data',/normal,color=black
			    	xyouts,0.12,0.93,'Commanded Mass = '+header.sMass,/normal,color=black			    
			    endelse
			    xyouts,0.80,0.57,process,color=[255,0,0],/normal
			    
			    ; Plot Row B
				plot,tdata(0,*),tdata(7,*), /ylog, /ynozero,title=tit, yrange=[40000.0, 60000.0],ysty=1,xsty=1, xtitle='Pixel',ytitle='Raw Counts Row B',xrange = [1,512],color=black
				if (bproc eq 0) then begin
				    oplot,tdata(0,*),tdata(10,*),psym=3,color=red
					xyouts,0.12,0.45,'______ Row B Data',/normal,color=black
		       		xyouts,0.12,0.43,'.............. Row B offset',/normal,color=red
		       		xyouts,0.12,0.41,'Commanded Mass = '+header.sMass,/normal,color=black
		       	endif else begin
			    	xyouts,0.12,0.45,'______ Row B Data',/normal,color=black
			    	xyouts,0.12,0.43,'Commanded Mass = '+header.sMass,/normal,color=black			    
			    endelse
			    xyouts,0.80,0.07,process,color=[255,0,0],/normal
			    
			end
			
			2: begin
				
				!p.multi=[0,1,2]
				str = ' '
				sfile = strmid(file,spos+1,100)
				dotPos = strpos(sfile,'.',/reverse_search)
				psfile = strmid(sfile,0,dotPos)+'_RawCounts.ps'
				;stop
				psFileName = dir+'psplots/'+psfile
				print,psFileName
				cgPS_open,psFileName
					loadct,2
					!p.charsize=0.6
					black = 0
		    		green = 20
		    		red = 220
		    		!p.background = 255
				
					; Plot Row A
					plot,tdata(0,*),tdata(1,*), title=tit, xsty=1, xtitle='Pixel',ytitle='Raw Counts Row A',xrange = [1,512],color=black
					if (bproc eq 0) then begin
				    	oplot,tdata(0,*),tdata(4,*),psym=3,color=red
			    		xyouts,0.12,0.95,'______ Row A Data',/normal,color=black
			    		xyouts,0.12,0.93,'.............. Row A offset',/normal,color=red
			    		xyouts,0.12,0.91,'Commanded Mass = '+header.sMass,/normal,color=black
			    	endif else begin
			    		xyouts,0.12,0.95,'______ Row A Data',/normal,color=black
			    		xyouts,0.12,0.93,'Commanded Mass = '+header.sMass,/normal,color=black			    
			    	endelse
			    	xyouts,0.80,0.57,process,color=[255,0,0],/normal
			    
			  	    ; Plot Row B
					plot,tdata(0,*),tdata(7,*), title=tit, xsty=1, xtitle='Pixel',ytitle='Raw Counts Row B',xrange = [1,512],color=black
					if (bproc eq 0) then begin
				    	oplot,tdata(0,*),tdata(10,*),psym=3,color=red
						xyouts,0.12,0.45,'______ Row B Data',/normal,color=black
		       			xyouts,0.12,0.43,'.............. Row B offset',/normal,color=red
		       			xyouts,0.12,0.41,'Commanded Mass = '+header.sMass,/normal,color=black
		       		endif else begin
			    		xyouts,0.12,0.45,'______ Row B Data',/normal,color=black
			    		xyouts,0.12,0.43,'Commanded Mass = '+header.sMass,/normal,color=black			    
			    	endelse
			    	xyouts,0.80,0.07,process,color=[255,0,0],/normal	
			    
			    read,str,prompt='Create [P]ostscript or P[N]G  [P/N]?: '
			    str = strupcase(str)
			    if (str eq 'P') then begin
			    	cgPS_close
			    endif
			    if (str eq 'N') then begin
			    	cgPS_close, /PNG
			    endif 
			    
		
		   end

	    3: begin 
	    
				!p.multi=[0,1,2]
		        iplt0 = 20
	            iplt1 = 492	    
		    	if (!d.name eq 'X') then window,3,xsize=800,ysize=1200
		    	black = 0
		    	green = 20
		    	red = 220
		    	!p.background = 255
		    	
		    	plotIons,tdata,iplt0,iplt1,header,process,tit,black,red,green
		    	
			end
			
		4: begin
		   
   		   	    !p.multi=[0,1,2]
		   		iplt0 = 20
	            iplt1 = 492	
				sfile = strmid(file,spos+1,100)
				dotPos = strpos(sfile,'.',/reverse_search)
				psfile = strmid(sfile,0,dotPos)+'_IonRate.ps'
				psFileName = dir+'psplots/'+psfile
				print,psFileName
				cgPS_open,psFileName
					loadct,2
					!p.charsize=0.6
					black = 0
		    		green = 20
		    		red = 220
		    		!p.background = 255
		   		
		   		    plotIons,tdata,iplt0,iplt1,header,tit,black,red,green
		   		    
		   		str=' '
			    read,str,prompt='Create [P]ostscript or P[N]G  [P/N]?: '
			    str = strupcase(str)
			    if (str eq 'P') then begin
			    	cgPS_close
			    endif
			    if (str eq 'N') then begin
			    	cgPS_close, /PNG
			    endif 		
		   end
		  
		else: print,'Wrong value'
		
	endcase
end
;
; ---------------------------- Main ----------------------------------
;

dir  = getenv('DFMS_INSTALL_DIR')+'/data/plotFiles/'

!p.charsize=1.3
!p.background = 255
!p.color = 0
loadct,2

while(1) do begin

	close,1
	file = dialog_pickfile(path=dir, title='Select a File to plot')
	;file = cgpickfile(path=dir,filter='*.dat',/must_exist,$
     ;                  /read,title='Select a File to plot')
	print,'Currently processing file: '+file
	openr,1,file
	
	num=1
	while (1) do begin
		print,'-----------------------------------------------'
		print,'  Function to Perform                    Value'
		print,'-----------------------------------------------'
		print,' Plot L2 Raw Data with Offset              1  '
		print,' Make L2 Raw Data PNG/PS File              2  '
		print,'         ----------------------------'	
		print,' Plot L2 Ion Data/Fit                      3  '
		print,' Make L2 Ion Data/Fit PNG/PS File          4  '
		print,'         ----------------------------'			
		print,' Choose a different file                   5  '
		print,' Quit                                      6  '
		print,'-----------------------------------------------'
		read,num,prompt='Enter Value [1-6] : '
		if (num eq 5 or num eq 6) then begin
		    if (num eq 5) then begin 
		        device,window_state=wState
		    	if (wState[1]) then wdelete,1
		    	if (wState[2]) then wdelete,2
		    	if (wState[3]) then wdelete,3
			endif
			break
		endif else begin 
			makePlot,dir,num,file
		endelse
	endwhile

	if (num ge 6) then begin
		device,window_state=wState
		if (wState[1]) then wdelete,1
		if (wState[2]) then wdelete,2
		if (wState[3]) then wdelete,3	
		break
	endif 
	
endwhile

end
