;
; ------------------------ get a Value -------------------------------
;
function getValue,str,pos,vpos

	fields = strsplit(str,',',/extract)
	val = strcompress(fields[vpos],/remove_all)
	len = strlen(val)
	if(strpos(val,'"') NE -1) then val = strmid(val,1,len-2)
	return,val
	
end
;
; ----------------------- get an HK Item -----------------------------
;

pro getHKitem,result

	str = ' '
	HKitems = ['ROSINA_DFMS_SCI_MASS','ROSINA_DFMS_SCI_MODE','ROSINA_DFMS_SCI_GAIN_OF_SPECTRUM']
	hkdone = fltarr(n_elements(HKitems))
	result = strarr(n_elements(HKitems))
	;
	for i=0,327 do begin
		readf,1,str
		for j=0,n_elements(HKitems)-1 do begin
  			pos = strpos(str, HKitems[j])
			if (pos NE -1) then begin
				result[j] = getValue(str,pos,2)
			endif
		endfor
	endfor
	
end
;
; ---------------------------- Main ----------------------------------
;
dir = '/Users/marinaldi/Documents/workspace/ROSINArepo/DFMS/data/dfms/mc/'
str = ' '

data = intarr(3)
tdata = intarr(3,512)
;
window,xsize=1000,ysize=1000
!p.charsize=1.3
!p.background = 255
!p.color = 0
loadct,39
!x.range = [1,512]
	
while(1) do begin

	file = dialog_pickfile(path=dir, title='Select an L2 file to plot')
    openr,1,file

	getHKitem,result
    mass = result[0]
    mode = result[1]
    GS = result[2]
    
	for i=0,511 do begin
		readf,1,str
		data = strsplit(str,',',/extract)
		tdata[*,i] = data
	endfor
	close,1

	tit = strmid(file,strlen(file)-31,31)+'  -  Row A/B'
	plot,tdata(0,*),tdata(1,*), title=tit, xsty=1, xtitle='Pixel',ytitle='Raw Counts'
	oplot,tdata(0,*),tdata(2,*),linestyle=2,color=[255,0,0]
	xyouts,0.85,0.93,'______ Row A',/normal
	xyouts,0.85,0.91,'----- Row B',/normal,color=[255,0,0]
	xyouts,0.85,0.89,'Mass = '+mass,/normal
	xyouts,0.85,0.87,'Mode = '+mode,/normal
	xyouts,0.85,0.85,'GStep = '+GS,/normal
	
endwhile

end
