;
; ------------------------ get a Value -------------------------------
;
function getValue,str,pos,vpos
	fields = strsplit(str,',',/extract)
	val = strcompress(fields[vpos],/remove_all)
	len = strlen(val)
	if(strpos(val,'"') NE -1) then val = strmid(val,1,len-2)
	return,val
end
;
; ---------------------------- Main ----------------------------------
;
dir = '/Users/marinaldi/Documents/workspace/ROSINArepo/DFMS/data/dfms/mc/'

datafiles = FILE_SEARCH(dir,'mc_*.tab', /FOLD_CASE)
num = n_elements(datafiles)
str = ' '
knownMass = ['16','18','20','22','28','44','66','78','129','131','132']
HKitems = ['ROSINA_DFMS_SCI_MASS','ROSINA_DFMS_SCI_MODE','ROSINA_DFMS_SCI_GAIN_OF_SPECTRUM']
numFields = n_elements(HKitems)+3
valArray = strarr(numFields,num)

openw,2,'/Users/marinaldi/Documents/workspace/ROSINArepo/DFMS/data/dfms/L2SummaryList.txt'

for i=0,num-1 do begin

	file = datafiles[i]
	valArray[0,i] = string(i+1)
    valArray[1,i] = strmid(file,strlen(file)-31,31)
	openr,1,file
	k=2
	while (~EOF(1)) do begin
		readf,1,str
		for j=0,n_elements(HKitems)-1 do begin
  			pos = strpos(str, HKitems[j])
			if (pos NE -1) then begin
				valArray[k,i] = getValue(str,pos,2)
				if (j eq 0) then begin
				   id = where(knownMass eq valArray[k,i])
				   if (id eq -1) then begin
				   	   valArray[numFields-1,i] = '-'
				   endif else begin
				   	   valArray[numFields-1,i] = 'V'
				   endelse
				endif
				k=k+1
			endif
			if (k EQ n_elements(HKitems)+2) then k=2
		endfor
	endwhile
	dump = strjoin(valArray[*,i],',',/single)
	printf,2,dump
	if (i mod 100 eq 0) then print,i+1
	close,1
	;if (i eq 3) then stop
endfor
close,2
end
