pro ra_mike_header_init, filename, outfile, header
;   Version Date: 2010 Jul 15

COMMON mike_data

;+
;   Modifies the FITS header to add Mike-specific keywords.
;-
mike_log, /start, /time

Blank = '        '

sxaddpar, Header, 'MIKE_BEG', strmid(systime(),4,20), ' START MIKE KEYWORD BLOCK'
sxaddpar, Header, Blank, '', before='MIKE_BEG'
sxaddpar, Header, Blank, '=============================================', $
   before='MIKE_BEG'
sxaddpar, Header, Blank,  '', before='MIKE_BEG'

;;;
;   Put in the current pipeline version information
;
sxaddpar, Header, 'MIKE_VER', MikeFlags.Version, ' Version of Mike pipeline code'

infilename = file_basename(filename)
outfilename = file_basename(outfile)

sxaddpar, header, 'FILE_IN', strupcase(infilename), ' Input file for processing'
sxaddpar, header, 'FILE_OUT', strupcase(outfilename), ' Output file after processing'

sxaddpar, header, 'DATAQUAL', 0, ' Data quality flag'

sxaddpar, header, 'BADFILE', '', ' File containing bad pixel mask'
sxaddpar, header, 'BADFLAG', 'F', ' Bad pixel mask applied to data?'
sxaddpar, header, 'BADVALUE', 'IEEE NaN', ' Value of bad pixel(s)'

sxaddpar, header, 'DEADFLAG', 'F', ' Dead-time correction applied?'

sxaddpar, header, 'DARKFLAG', 'F', ' Dark counts subtracted from data?'
sxaddpar, header, 'DARKFILE', '', ' Detector dark count rate file'
sxaddpar, header, 'DARKNORM', 0., ' Normalization factor applied to dark file'

sxaddpar, header, 'SKYFLAG', 'F', ' Sky background subtracted from data?'
sxaddpar, header, 'SKYFILE', '', ' Sky background file'
sxaddpar, header, 'SKYNORM', 0., ' Normalization factor applied to sky file'

sxaddpar, header, 'FLATFLAG', 'F', ' Flatfield correction applied?'
sxaddpar, header, 'FLATFILE', '', ' Detector flatfield file'

sxaddpar, header, 'AEFFFLAG', 'F', ' Effective area calibration applied?'
sxaddpar, header, 'AEFFFILE', '', ' Detector effective area file'

sxaddpar, header, 'HVFLAG', 'F', ' High voltage correction applied?'
sxaddpar, header, 'HVFILE', '', ' High voltage correction file'

sxaddpar, header, 'TVAEFLAG', 'F', ' Correct for time-variable A_eff?'
sxaddpar, header, 'CORRFILE', '', ' Effective Area correction file'

sxaddpar, header, 'WAVEFLAG', 'F', ' Stim pixel correction applied?'
sxaddpar, header, 'LINFLAG', 'F', ' Data resampled onto common wavelength scale?'
sxaddpar, header, 'WAVEFILE', '', ' Detector wavelength solution used'

sxaddpar, header, 'BUNIT', 'Counts', ' Units of data in the primary HDU'

sxaddpar, Header, 'MIKE_END', '', ' END MIKE KEYWORD BLOCK'
sxaddpar, Header, Blank, '', after='MIKE_END'
sxaddpar, Header, Blank, '=============================================', $
   after='MIKE_END'
sxaddpar, Header, Blank, '', after='MIKE_END'

end
