; Simple function that accepts an ET start time and determines the count rate
; of the dark image. The count rate is calculated as the total number of
; counts in [50:950,*] divided by the image exposure time.

; MODIFICATION HISTORY:
;   v1. 2009 Nov 10  AJS Update to include PC10 dark rate
;   v2. 2009 Nov 12  AJS Update to include ESB3 dark rate

FUNCTION ra_darkrate, et_start

CASE 1 OF 
   et_start LE 1.3664166e+08: darkrate = 18.3288
   et_start LE 1.3932006e+08: darkrate = 18.5772
   et_start LE 1.4986086e+08: darkrate = 18.4428
   et_start LE 1.6558566e+08: darkrate = 18.8404
   et_start LE 1.7344806e+08: darkrate = 22.3169
   et_start LE 1.7612646e+08: darkrate = 22.2305
   et_start LE 2.1820327e+08: BEGIN
      CASE 1 OF 
         hvsetc LE -3900 AND hvsetc GT -4000: darkrate = 27.0671
         hvsetc LE -3800 AND hvsetc GT -3900: darkrate = 24.7518
;         ELSE: darkrate = 27.0671
     ENDCASE
   END 
   et_start LE 2.2088167e+08: darkrate = 19.6595
   et_start LE 2.3392807e+08: darkrate = 24.7518
   et_start LE 2.4446887e+08: darkrate = 30.0374
   et_start LE 2.4973927e+08: darkrate = 29.7291
   et_start LE 2.7082087e+08: darkrate = 30.7919 ; PC8
   et_start LE 2.7609127e+08: darkrate = 31.4184 ; Steins
   et_start LE 3.0762727e+08: darkrate = 33.8934 ; PC10
   et_start LE 3.1194727e+08: darkrate = 33.7288 ; ESB3
   et_start LE 3.2706727e+08: darkrate = 31.0127 ; PC12
   et_start LE 3.1194727e+08: darkrate = 31.733652 ; Lutetia
   ELSE: darkrate = 31.733652
ENDCASE

return, darkrate
END
