;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; GETSWAPPLOTDATA.PRO
;;;
;;; - Reads list of SWAP data file names from input list argument

function getswapplotdata, inplst

  spawn,'cat '+inplst,fns  ;;; trick to get files' lines into string array

  icoinhz=0L      ;;; these are indeices into the IEXTS array, which is
  ien=icoinhz+1L  ;;; an array that keeps track of which extension has
  itim=ien+1L     ;;; a given type of data in it
  ispice=itim+1L
  nexts=ispice+1

  for ifn=0L,n_elements(fns)-1L do begin    ;;; Loop through files

    fn0=fns[ifn]
    fn=fn0
    iexts = make_array(nexts,value=-1L)
    
    er=0L
    catch,er
    if er eq 0L then begin
      i=0L

      ;;; Loop through extensions looking for the onex we are interested in

      while min(iexts) lt 0L do begin       

        extname=fxpar(headfits(fn,ext=i,/silent,err=xxx),'extname')

        if strtrim(extname) eq 'COIN_SPECT_HZ' then iexts[icoinhz]=i
        if strtrim(extname) eq 'ENERGY_LABEL_SPECT' then iexts[ien]=i
        if strtrim(extname) eq 'TIME_LABEL_SPECT' then iexts[itim]=i
        if strtrim(extname) eq 'SPICE_ORBIT_ATTITUDE_CALC' then $
	  iexts[ispice]=i

        i=i+1
      endwhile
    endif
    catch,/cancel
    
    ;;; Read the coin Hz extension

    coinhz=readfits(fn,ext=iexts[icoinhz],/silent)
    
    ;;; Read the 64 energy bins

    for i=1,64 do begin
      ftab_ext,fn,'energy_bin_'+strtrim(i,2),vcol,ext=iexts[ien]
      vcol=transpose([vcol])
      if i eq 1 then ens=vcol else ens=[ens,vcol]
    endfor
    
    ;;; read various columns from tables using IDL Astro library routine
    ;;; FTAB_EXT.PRO

    ;;; - time

    ftab_ext,fn,'middle_et',midets,ext=iexts[itim]
    jdtdbs=cspice_j2000()+midets/cspice_spd()
    
    ;;; - Start ETs, theta sun, phi sun, XYZ
    
    ftab_ext,fn,'start_et_0,theta_sun_sc_0,phi_sun_sc_0' $
                 +',sc_iau_jup_x_0,sc_iau_jup_y_0,sc_iau_jup_z_0' $
               ,startEts,thetas,phis $
  	     , xs, ys, zs $
  	     ,ext=iexts[ispice]

    ;;; Scale the SCETS (s) to JDs

    startJds = (cspice_j2000()+startEts/cspice_spd() )


    rjs = sqrt( xs*xs + ys*ys + zs*zs) / 71492d0   ;;; Scale the ranges to Rj


    if ifn eq 0L then begin     ;;; start a new array for the first file ...
      coinhzarr=coinhz
      ensarr=ens
      jdtdbsarr=jdtdbs
      startJdsarr=startJds
      thetasarr=thetas
      phisarr=phis
      rjsarr=rjs
    endif else begin               ;;; or append the dat from the latter files
      coinhzarr=[coinhzarr,coinhz]
      ensarr=[[ensarr],[ens]]
      jdtdbsarr=[jdtdbsarr,jdtdbs]
      startJdsarr=[startJdsarr,startJds]
      thetasarr=[thetasarr,thetas]
      phisarr=[phisarr,phis]
      rjsarr=[rjsarr,rjs]
    endelse

  endfor

  jdtdbmin = min( jdtdbs)                  ;;; get minimum JD
  caldat,jdtdbmin,mo,day,yyyy,hr,min,s     ;;; Convert to Month, Day, Year, ...

  ;;; Get last day of previous year as JD; subtract this from all times
  ;;;   so all JDs can be converted to DOYs - this will also work when
  ;;;   data span end of year:  DOY will go beoynd 365 or 366

  jdtdb0=julday(12,31,yyyy-1,0,0,0d0)

  ;;; Return structure with arrays as its memebers

  return, { coin_hz: coinhzarr $
          , energies: ensarr $
          , doys: jdtdbsarr - jdtdb0 $         ;;; Mid times as DOYs
          , startDoys: startJdsarr - jdtdb0 $  ;;; Start times as DOYs
          , thetas: thetasarr $
          , phis: phisarr $
          , rjs: rjsarr $
          }
end
